/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2024-11-25 08:58:44 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `package` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=480 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=206 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=122 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("1", "1", "A WordPress Commenter", "wapuu@wordpress.example", "https://wordpress.org/", "", "2024-11-20 07:20:44", "2024-11-20 07:20:44", "Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://gravatar.com/\">Gravatar</a>.", "0", "1", "", "comment", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "20241125_puivaliotech", "3a1e30cbff16e2415867_20241125080231", "-1", "2024-11-25 08:02:40", "valioadmin", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-11-25 08:02:31\";s:7:\"Version\";s:8:\"1.5.11.2\";s:9:\"VersionWP\";s:5:\"6.7.1\";s:9:\"VersionDB\";s:6:\"8.0.16\";s:10:\"VersionPHP\";s:6:\"8.2.23\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";i:1;s:4:\"Name\";s:21:\"20241125_puivaliotech\";s:4:\"Hash\";s:35:\"3a1e30cbff16e2415867_20241125080231\";s:8:\"NameHash\";s:57:\"20241125_puivaliotech_3a1e30cbff16e2415867_20241125080231\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:67:\"20241125_puivaliotech_3a1e30cbff16e2415867_20241125080231_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"-1.0\";s:6:\"WPUser\";s:10:\"valioadmin\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:69:\"20241125_puivaliotech_3a1e30cbff16e2415867_20241125080231_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:49:\"/Users/admin/Local Sites/pui-valiotech/app/public\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:848;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:4854;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-11-25 08:02:31\";s:7:\"Version\";s:8:\"1.5.11.2\";s:9:\"VersionWP\";s:5:\"6.7.1\";s:9:\"VersionDB\";s:6:\"8.0.16\";s:10:\"VersionPHP\";s:6:\"8.2.23\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";N;s:4:\"Name\";s:21:\"20241125_puivaliotech\";s:4:\"Hash\";s:35:\"3a1e30cbff16e2415867_20241125080231\";s:8:\"NameHash\";s:57:\"20241125_puivaliotech_3a1e30cbff16e2415867_20241125080231\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:75:\"20241125_puivaliotech_3a1e30cbff16e2415867_20241125080231_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:63:\"/Users/admin/Local Sites/pui-valiotech/app/public/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:70:\"20241125_puivaliotech_3a1e30cbff16e2415867_20241125080231_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:152:\"/Users/admin/Local Sites/pui-valiotech/app/public/wp-content/backups-dup-lite/tmp/20241125_puivaliotech_3a1e30cbff16e2415867_20241125080231_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:58:\"/Users/admin/Local Sites/pui-valiotech/app/public/wp-admin\";i:1;s:61:\"/Users/admin/Local Sites/pui-valiotech/app/public/wp-includes\";i:2;s:70:\"/Users/admin/Local Sites/pui-valiotech/app/public/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:49:\"/Users/admin/Local Sites/pui-valiotech/app/public\";i:1;s:49:\"/Users/admin/Local Sites/pui-valiotech/app/public\";i:2;s:60:\"/Users/admin/Local Sites/pui-valiotech/app/public/wp-content\";i:3;s:68:\"/Users/admin/Local Sites/pui-valiotech/app/public/wp-content/uploads\";i:4;s:68:\"/Users/admin/Local Sites/pui-valiotech/app/public/wp-content/plugins\";i:5;s:71:\"/Users/admin/Local Sites/pui-valiotech/app/public/wp-content/mu-plugins\";i:6;s:67:\"/Users/admin/Local Sites/pui-valiotech/app/public/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:81:\"/Users/admin/Local Sites/pui-valiotech/app/public/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");
INSERT INTO `wp_duplicator_packages` VALUES("2", "20241125_puivaliotech", "53cba3018d2a1fea7157_20241125085838", "22", "2024-11-25 08:58:44", "valioadmin", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-11-25 08:58:38\";s:7:\"Version\";s:8:\"1.5.11.2\";s:9:\"VersionWP\";s:5:\"6.7.1\";s:9:\"VersionDB\";s:6:\"8.0.16\";s:10:\"VersionPHP\";s:6:\"8.2.23\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";i:2;s:4:\"Name\";s:21:\"20241125_puivaliotech\";s:4:\"Hash\";s:35:\"53cba3018d2a1fea7157_20241125085838\";s:8:\"NameHash\";s:57:\"20241125_puivaliotech_53cba3018d2a1fea7157_20241125085838\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:67:\"20241125_puivaliotech_53cba3018d2a1fea7157_20241125085838_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.5\";s:6:\"WPUser\";s:10:\"valioadmin\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:69:\"20241125_puivaliotech_53cba3018d2a1fea7157_20241125085838_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:49:\"/Users/admin/Local Sites/pui-valiotech/app/public\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:848;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:4854;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-11-25 08:58:38\";s:7:\"Version\";s:8:\"1.5.11.2\";s:9:\"VersionWP\";s:5:\"6.7.1\";s:9:\"VersionDB\";s:6:\"8.0.16\";s:10:\"VersionPHP\";s:6:\"8.2.23\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";N;s:4:\"Name\";s:21:\"20241125_puivaliotech\";s:4:\"Hash\";s:35:\"53cba3018d2a1fea7157_20241125085838\";s:8:\"NameHash\";s:57:\"20241125_puivaliotech_53cba3018d2a1fea7157_20241125085838\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:75:\"20241125_puivaliotech_53cba3018d2a1fea7157_20241125085838_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:63:\"/Users/admin/Local Sites/pui-valiotech/app/public/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:70:\"20241125_puivaliotech_53cba3018d2a1fea7157_20241125085838_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:152:\"/Users/admin/Local Sites/pui-valiotech/app/public/wp-content/backups-dup-lite/tmp/20241125_puivaliotech_53cba3018d2a1fea7157_20241125085838_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:58:\"/Users/admin/Local Sites/pui-valiotech/app/public/wp-admin\";i:1;s:61:\"/Users/admin/Local Sites/pui-valiotech/app/public/wp-includes\";i:2;s:70:\"/Users/admin/Local Sites/pui-valiotech/app/public/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:49:\"/Users/admin/Local Sites/pui-valiotech/app/public\";i:1;s:49:\"/Users/admin/Local Sites/pui-valiotech/app/public\";i:2;s:60:\"/Users/admin/Local Sites/pui-valiotech/app/public/wp-content\";i:3;s:68:\"/Users/admin/Local Sites/pui-valiotech/app/public/wp-content/uploads\";i:4;s:68:\"/Users/admin/Local Sites/pui-valiotech/app/public/wp-content/plugins\";i:5;s:71:\"/Users/admin/Local Sites/pui-valiotech/app/public/wp-content/mu-plugins\";i:6;s:67:\"/Users/admin/Local Sites/pui-valiotech/app/public/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:81:\"/Users/admin/Local Sites/pui-valiotech/app/public/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "cron", "a:13:{i:1732526444;a:1:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1732526447;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1732562504;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1732566044;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1732567844;a:1:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1732605647;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1732605704;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1732605710;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1732692207;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1732778447;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1733112186;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1733133600;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wp_options` VALUES("2", "siteurl", "http://pui-valiotech.local", "on");
INSERT INTO `wp_options` VALUES("3", "home", "http://pui-valiotech.local", "on");
INSERT INTO `wp_options` VALUES("4", "blogname", "PUI Valiotech", "on");
INSERT INTO `wp_options` VALUES("5", "blogdescription", "Sensibiliser, connecter, innover", "on");
INSERT INTO `wp_options` VALUES("6", "users_can_register", "0", "on");
INSERT INTO `wp_options` VALUES("7", "admin_email", "dev-email@wpengine.local", "on");
INSERT INTO `wp_options` VALUES("8", "start_of_week", "1", "on");
INSERT INTO `wp_options` VALUES("9", "use_balanceTags", "0", "on");
INSERT INTO `wp_options` VALUES("10", "use_smilies", "1", "on");
INSERT INTO `wp_options` VALUES("11", "require_name_email", "1", "on");
INSERT INTO `wp_options` VALUES("12", "comments_notify", "1", "on");
INSERT INTO `wp_options` VALUES("13", "posts_per_rss", "10", "on");
INSERT INTO `wp_options` VALUES("14", "rss_use_excerpt", "0", "on");
INSERT INTO `wp_options` VALUES("15", "mailserver_url", "mail.example.com", "on");
INSERT INTO `wp_options` VALUES("16", "mailserver_login", "login@example.com", "on");
INSERT INTO `wp_options` VALUES("17", "mailserver_pass", "", "on");
INSERT INTO `wp_options` VALUES("18", "mailserver_port", "110", "on");
INSERT INTO `wp_options` VALUES("19", "default_category", "1", "on");
INSERT INTO `wp_options` VALUES("20", "default_comment_status", "open", "on");
INSERT INTO `wp_options` VALUES("21", "default_ping_status", "open", "on");
INSERT INTO `wp_options` VALUES("22", "default_pingback_flag", "1", "on");
INSERT INTO `wp_options` VALUES("23", "posts_per_page", "10", "on");
INSERT INTO `wp_options` VALUES("24", "date_format", "j F Y", "on");
INSERT INTO `wp_options` VALUES("25", "time_format", "G\\hi", "on");
INSERT INTO `wp_options` VALUES("26", "links_updated_date_format", "F j, Y g:i a", "on");
INSERT INTO `wp_options` VALUES("27", "comment_moderation", "0", "on");
INSERT INTO `wp_options` VALUES("28", "moderation_notify", "1", "on");
INSERT INTO `wp_options` VALUES("29", "permalink_structure", "/%postname%/", "on");
INSERT INTO `wp_options` VALUES("30", "rewrite_rules", "a:141:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:8:\"event/?$\";s:25:\"index.php?post_type=event\";s:38:\"event/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=event&feed=$matches[1]\";s:33:\"event/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=event&feed=$matches[1]\";s:25:\"event/page/([0-9]{1,})/?$\";s:43:\"index.php?post_type=event&paged=$matches[1]\";s:10:\"partner/?$\";s:27:\"index.php?post_type=partner\";s:40:\"partner/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=partner&feed=$matches[1]\";s:35:\"partner/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=partner&feed=$matches[1]\";s:27:\"partner/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=partner&paged=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:33:\"event/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"event/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"event/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"event/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"event/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"event/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:22:\"event/([^/]+)/embed/?$\";s:38:\"index.php?event=$matches[1]&embed=true\";s:26:\"event/([^/]+)/trackback/?$\";s:32:\"index.php?event=$matches[1]&tb=1\";s:46:\"event/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?event=$matches[1]&feed=$matches[2]\";s:41:\"event/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?event=$matches[1]&feed=$matches[2]\";s:34:\"event/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?event=$matches[1]&paged=$matches[2]\";s:41:\"event/([^/]+)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?event=$matches[1]&cpage=$matches[2]\";s:30:\"event/([^/]+)(?:/([0-9]+))?/?$\";s:44:\"index.php?event=$matches[1]&page=$matches[2]\";s:22:\"event/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:32:\"event/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:52:\"event/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"event/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"event/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:28:\"event/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"partner/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"partner/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"partner/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"partner/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"partner/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"partner/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"partner/([^/]+)/embed/?$\";s:40:\"index.php?partner=$matches[1]&embed=true\";s:28:\"partner/([^/]+)/trackback/?$\";s:34:\"index.php?partner=$matches[1]&tb=1\";s:48:\"partner/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?partner=$matches[1]&feed=$matches[2]\";s:43:\"partner/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?partner=$matches[1]&feed=$matches[2]\";s:36:\"partner/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?partner=$matches[1]&paged=$matches[2]\";s:43:\"partner/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?partner=$matches[1]&cpage=$matches[2]\";s:32:\"partner/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?partner=$matches[1]&page=$matches[2]\";s:24:\"partner/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"partner/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"partner/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"partner/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"partner/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"partner/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:24:\"index.php??sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:38:\"index.php?&page_id=2&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "on");
INSERT INTO `wp_options` VALUES("31", "hack_file", "0", "on");
INSERT INTO `wp_options` VALUES("32", "blog_charset", "UTF-8", "on");
INSERT INTO `wp_options` VALUES("33", "moderation_keys", "", "off");
INSERT INTO `wp_options` VALUES("34", "active_plugins", "a:1:{i:0;s:25:\"duplicator/duplicator.php\";}", "on");
INSERT INTO `wp_options` VALUES("35", "category_base", "", "on");
INSERT INTO `wp_options` VALUES("36", "ping_sites", "http://rpc.pingomatic.com/", "on");
INSERT INTO `wp_options` VALUES("37", "comment_max_links", "2", "on");
INSERT INTO `wp_options` VALUES("38", "gmt_offset", "4", "on");
INSERT INTO `wp_options` VALUES("39", "default_email_category", "1", "on");
INSERT INTO `wp_options` VALUES("40", "recently_edited", "", "off");
INSERT INTO `wp_options` VALUES("41", "template", "valio-theme", "on");
INSERT INTO `wp_options` VALUES("42", "stylesheet", "valio-theme", "on");
INSERT INTO `wp_options` VALUES("43", "comment_registration", "0", "on");
INSERT INTO `wp_options` VALUES("44", "html_type", "text/html", "on");
INSERT INTO `wp_options` VALUES("45", "use_trackback", "0", "on");
INSERT INTO `wp_options` VALUES("46", "default_role", "subscriber", "on");
INSERT INTO `wp_options` VALUES("47", "db_version", "58975", "on");
INSERT INTO `wp_options` VALUES("48", "uploads_use_yearmonth_folders", "1", "on");
INSERT INTO `wp_options` VALUES("49", "upload_path", "", "on");
INSERT INTO `wp_options` VALUES("50", "blog_public", "1", "on");
INSERT INTO `wp_options` VALUES("51", "default_link_category", "2", "on");
INSERT INTO `wp_options` VALUES("52", "show_on_front", "page", "on");
INSERT INTO `wp_options` VALUES("53", "tag_base", "", "on");
INSERT INTO `wp_options` VALUES("54", "show_avatars", "1", "on");
INSERT INTO `wp_options` VALUES("55", "avatar_rating", "G", "on");
INSERT INTO `wp_options` VALUES("56", "upload_url_path", "", "on");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_w", "150", "on");
INSERT INTO `wp_options` VALUES("58", "thumbnail_size_h", "150", "on");
INSERT INTO `wp_options` VALUES("59", "thumbnail_crop", "1", "on");
INSERT INTO `wp_options` VALUES("60", "medium_size_w", "300", "on");
INSERT INTO `wp_options` VALUES("61", "medium_size_h", "300", "on");
INSERT INTO `wp_options` VALUES("62", "avatar_default", "mystery", "on");
INSERT INTO `wp_options` VALUES("63", "large_size_w", "1024", "on");
INSERT INTO `wp_options` VALUES("64", "large_size_h", "1024", "on");
INSERT INTO `wp_options` VALUES("65", "image_default_link_type", "none", "on");
INSERT INTO `wp_options` VALUES("66", "image_default_size", "", "on");
INSERT INTO `wp_options` VALUES("67", "image_default_align", "", "on");
INSERT INTO `wp_options` VALUES("68", "close_comments_for_old_posts", "0", "on");
INSERT INTO `wp_options` VALUES("69", "close_comments_days_old", "14", "on");
INSERT INTO `wp_options` VALUES("70", "thread_comments", "1", "on");
INSERT INTO `wp_options` VALUES("71", "thread_comments_depth", "5", "on");
INSERT INTO `wp_options` VALUES("72", "page_comments", "0", "on");
INSERT INTO `wp_options` VALUES("73", "comments_per_page", "50", "on");
INSERT INTO `wp_options` VALUES("74", "default_comments_page", "newest", "on");
INSERT INTO `wp_options` VALUES("75", "comment_order", "asc", "on");
INSERT INTO `wp_options` VALUES("76", "sticky_posts", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("77", "widget_categories", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("78", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("79", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("80", "uninstall_plugins", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("81", "timezone_string", "", "on");
INSERT INTO `wp_options` VALUES("82", "page_for_posts", "0", "on");
INSERT INTO `wp_options` VALUES("83", "page_on_front", "2", "on");
INSERT INTO `wp_options` VALUES("84", "default_post_format", "0", "on");
INSERT INTO `wp_options` VALUES("85", "link_manager_enabled", "0", "on");
INSERT INTO `wp_options` VALUES("86", "finished_splitting_shared_terms", "1", "on");
INSERT INTO `wp_options` VALUES("87", "site_icon", "44", "on");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_w", "768", "on");
INSERT INTO `wp_options` VALUES("89", "medium_large_size_h", "0", "on");
INSERT INTO `wp_options` VALUES("90", "wp_page_for_privacy_policy", "3", "on");
INSERT INTO `wp_options` VALUES("91", "show_comments_cookies_opt_in", "1", "on");
INSERT INTO `wp_options` VALUES("92", "admin_email_lifespan", "1747639244", "on");
INSERT INTO `wp_options` VALUES("93", "disallowed_keys", "", "off");
INSERT INTO `wp_options` VALUES("94", "comment_previously_approved", "1", "on");
INSERT INTO `wp_options` VALUES("95", "auto_plugin_theme_update_emails", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_dev", "enabled", "on");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_minor", "enabled", "on");
INSERT INTO `wp_options` VALUES("98", "auto_update_core_major", "enabled", "on");
INSERT INTO `wp_options` VALUES("99", "wp_force_deactivated_plugins", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("100", "wp_attachment_pages_enabled", "0", "on");
INSERT INTO `wp_options` VALUES("101", "initial_db_version", "58975", "on");
INSERT INTO `wp_options` VALUES("102", "wp_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:61:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "on");
INSERT INTO `wp_options` VALUES("103", "fresh_site", "0", "off");
INSERT INTO `wp_options` VALUES("104", "user_count", "1", "off");
INSERT INTO `wp_options` VALUES("105", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("106", "sidebars_widgets", "a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:13:\"array_version\";i:3;}", "auto");
INSERT INTO `wp_options` VALUES("107", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("108", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("109", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("110", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("111", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("112", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("113", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("114", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("115", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("116", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("117", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("118", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("119", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("120", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("121", "_transient_wp_core_block_css_files", "a:2:{s:7:\"version\";s:3:\"6.7\";s:5:\"files\";a:540:{i:0;s:23:\"archives/editor-rtl.css\";i:1;s:27:\"archives/editor-rtl.min.css\";i:2;s:19:\"archives/editor.css\";i:3;s:23:\"archives/editor.min.css\";i:4;s:22:\"archives/style-rtl.css\";i:5;s:26:\"archives/style-rtl.min.css\";i:6;s:18:\"archives/style.css\";i:7;s:22:\"archives/style.min.css\";i:8;s:20:\"audio/editor-rtl.css\";i:9;s:24:\"audio/editor-rtl.min.css\";i:10;s:16:\"audio/editor.css\";i:11;s:20:\"audio/editor.min.css\";i:12;s:19:\"audio/style-rtl.css\";i:13;s:23:\"audio/style-rtl.min.css\";i:14;s:15:\"audio/style.css\";i:15;s:19:\"audio/style.min.css\";i:16;s:19:\"audio/theme-rtl.css\";i:17;s:23:\"audio/theme-rtl.min.css\";i:18;s:15:\"audio/theme.css\";i:19;s:19:\"audio/theme.min.css\";i:20;s:21:\"avatar/editor-rtl.css\";i:21;s:25:\"avatar/editor-rtl.min.css\";i:22;s:17:\"avatar/editor.css\";i:23;s:21:\"avatar/editor.min.css\";i:24;s:20:\"avatar/style-rtl.css\";i:25;s:24:\"avatar/style-rtl.min.css\";i:26;s:16:\"avatar/style.css\";i:27;s:20:\"avatar/style.min.css\";i:28;s:21:\"button/editor-rtl.css\";i:29;s:25:\"button/editor-rtl.min.css\";i:30;s:17:\"button/editor.css\";i:31;s:21:\"button/editor.min.css\";i:32;s:20:\"button/style-rtl.css\";i:33;s:24:\"button/style-rtl.min.css\";i:34;s:16:\"button/style.css\";i:35;s:20:\"button/style.min.css\";i:36;s:22:\"buttons/editor-rtl.css\";i:37;s:26:\"buttons/editor-rtl.min.css\";i:38;s:18:\"buttons/editor.css\";i:39;s:22:\"buttons/editor.min.css\";i:40;s:21:\"buttons/style-rtl.css\";i:41;s:25:\"buttons/style-rtl.min.css\";i:42;s:17:\"buttons/style.css\";i:43;s:21:\"buttons/style.min.css\";i:44;s:22:\"calendar/style-rtl.css\";i:45;s:26:\"calendar/style-rtl.min.css\";i:46;s:18:\"calendar/style.css\";i:47;s:22:\"calendar/style.min.css\";i:48;s:25:\"categories/editor-rtl.css\";i:49;s:29:\"categories/editor-rtl.min.css\";i:50;s:21:\"categories/editor.css\";i:51;s:25:\"categories/editor.min.css\";i:52;s:24:\"categories/style-rtl.css\";i:53;s:28:\"categories/style-rtl.min.css\";i:54;s:20:\"categories/style.css\";i:55;s:24:\"categories/style.min.css\";i:56;s:19:\"code/editor-rtl.css\";i:57;s:23:\"code/editor-rtl.min.css\";i:58;s:15:\"code/editor.css\";i:59;s:19:\"code/editor.min.css\";i:60;s:18:\"code/style-rtl.css\";i:61;s:22:\"code/style-rtl.min.css\";i:62;s:14:\"code/style.css\";i:63;s:18:\"code/style.min.css\";i:64;s:18:\"code/theme-rtl.css\";i:65;s:22:\"code/theme-rtl.min.css\";i:66;s:14:\"code/theme.css\";i:67;s:18:\"code/theme.min.css\";i:68;s:22:\"columns/editor-rtl.css\";i:69;s:26:\"columns/editor-rtl.min.css\";i:70;s:18:\"columns/editor.css\";i:71;s:22:\"columns/editor.min.css\";i:72;s:21:\"columns/style-rtl.css\";i:73;s:25:\"columns/style-rtl.min.css\";i:74;s:17:\"columns/style.css\";i:75;s:21:\"columns/style.min.css\";i:76;s:33:\"comment-author-name/style-rtl.css\";i:77;s:37:\"comment-author-name/style-rtl.min.css\";i:78;s:29:\"comment-author-name/style.css\";i:79;s:33:\"comment-author-name/style.min.css\";i:80;s:29:\"comment-content/style-rtl.css\";i:81;s:33:\"comment-content/style-rtl.min.css\";i:82;s:25:\"comment-content/style.css\";i:83;s:29:\"comment-content/style.min.css\";i:84;s:26:\"comment-date/style-rtl.css\";i:85;s:30:\"comment-date/style-rtl.min.css\";i:86;s:22:\"comment-date/style.css\";i:87;s:26:\"comment-date/style.min.css\";i:88;s:31:\"comment-edit-link/style-rtl.css\";i:89;s:35:\"comment-edit-link/style-rtl.min.css\";i:90;s:27:\"comment-edit-link/style.css\";i:91;s:31:\"comment-edit-link/style.min.css\";i:92;s:32:\"comment-reply-link/style-rtl.css\";i:93;s:36:\"comment-reply-link/style-rtl.min.css\";i:94;s:28:\"comment-reply-link/style.css\";i:95;s:32:\"comment-reply-link/style.min.css\";i:96;s:30:\"comment-template/style-rtl.css\";i:97;s:34:\"comment-template/style-rtl.min.css\";i:98;s:26:\"comment-template/style.css\";i:99;s:30:\"comment-template/style.min.css\";i:100;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:101;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:102;s:38:\"comments-pagination-numbers/editor.css\";i:103;s:42:\"comments-pagination-numbers/editor.min.css\";i:104;s:34:\"comments-pagination/editor-rtl.css\";i:105;s:38:\"comments-pagination/editor-rtl.min.css\";i:106;s:30:\"comments-pagination/editor.css\";i:107;s:34:\"comments-pagination/editor.min.css\";i:108;s:33:\"comments-pagination/style-rtl.css\";i:109;s:37:\"comments-pagination/style-rtl.min.css\";i:110;s:29:\"comments-pagination/style.css\";i:111;s:33:\"comments-pagination/style.min.css\";i:112;s:29:\"comments-title/editor-rtl.css\";i:113;s:33:\"comments-title/editor-rtl.min.css\";i:114;s:25:\"comments-title/editor.css\";i:115;s:29:\"comments-title/editor.min.css\";i:116;s:23:\"comments/editor-rtl.css\";i:117;s:27:\"comments/editor-rtl.min.css\";i:118;s:19:\"comments/editor.css\";i:119;s:23:\"comments/editor.min.css\";i:120;s:22:\"comments/style-rtl.css\";i:121;s:26:\"comments/style-rtl.min.css\";i:122;s:18:\"comments/style.css\";i:123;s:22:\"comments/style.min.css\";i:124;s:20:\"cover/editor-rtl.css\";i:125;s:24:\"cover/editor-rtl.min.css\";i:126;s:16:\"cover/editor.css\";i:127;s:20:\"cover/editor.min.css\";i:128;s:19:\"cover/style-rtl.css\";i:129;s:23:\"cover/style-rtl.min.css\";i:130;s:15:\"cover/style.css\";i:131;s:19:\"cover/style.min.css\";i:132;s:22:\"details/editor-rtl.css\";i:133;s:26:\"details/editor-rtl.min.css\";i:134;s:18:\"details/editor.css\";i:135;s:22:\"details/editor.min.css\";i:136;s:21:\"details/style-rtl.css\";i:137;s:25:\"details/style-rtl.min.css\";i:138;s:17:\"details/style.css\";i:139;s:21:\"details/style.min.css\";i:140;s:20:\"embed/editor-rtl.css\";i:141;s:24:\"embed/editor-rtl.min.css\";i:142;s:16:\"embed/editor.css\";i:143;s:20:\"embed/editor.min.css\";i:144;s:19:\"embed/style-rtl.css\";i:145;s:23:\"embed/style-rtl.min.css\";i:146;s:15:\"embed/style.css\";i:147;s:19:\"embed/style.min.css\";i:148;s:19:\"embed/theme-rtl.css\";i:149;s:23:\"embed/theme-rtl.min.css\";i:150;s:15:\"embed/theme.css\";i:151;s:19:\"embed/theme.min.css\";i:152;s:19:\"file/editor-rtl.css\";i:153;s:23:\"file/editor-rtl.min.css\";i:154;s:15:\"file/editor.css\";i:155;s:19:\"file/editor.min.css\";i:156;s:18:\"file/style-rtl.css\";i:157;s:22:\"file/style-rtl.min.css\";i:158;s:14:\"file/style.css\";i:159;s:18:\"file/style.min.css\";i:160;s:23:\"footnotes/style-rtl.css\";i:161;s:27:\"footnotes/style-rtl.min.css\";i:162;s:19:\"footnotes/style.css\";i:163;s:23:\"footnotes/style.min.css\";i:164;s:23:\"freeform/editor-rtl.css\";i:165;s:27:\"freeform/editor-rtl.min.css\";i:166;s:19:\"freeform/editor.css\";i:167;s:23:\"freeform/editor.min.css\";i:168;s:22:\"gallery/editor-rtl.css\";i:169;s:26:\"gallery/editor-rtl.min.css\";i:170;s:18:\"gallery/editor.css\";i:171;s:22:\"gallery/editor.min.css\";i:172;s:21:\"gallery/style-rtl.css\";i:173;s:25:\"gallery/style-rtl.min.css\";i:174;s:17:\"gallery/style.css\";i:175;s:21:\"gallery/style.min.css\";i:176;s:21:\"gallery/theme-rtl.css\";i:177;s:25:\"gallery/theme-rtl.min.css\";i:178;s:17:\"gallery/theme.css\";i:179;s:21:\"gallery/theme.min.css\";i:180;s:20:\"group/editor-rtl.css\";i:181;s:24:\"group/editor-rtl.min.css\";i:182;s:16:\"group/editor.css\";i:183;s:20:\"group/editor.min.css\";i:184;s:19:\"group/style-rtl.css\";i:185;s:23:\"group/style-rtl.min.css\";i:186;s:15:\"group/style.css\";i:187;s:19:\"group/style.min.css\";i:188;s:19:\"group/theme-rtl.css\";i:189;s:23:\"group/theme-rtl.min.css\";i:190;s:15:\"group/theme.css\";i:191;s:19:\"group/theme.min.css\";i:192;s:21:\"heading/style-rtl.css\";i:193;s:25:\"heading/style-rtl.min.css\";i:194;s:17:\"heading/style.css\";i:195;s:21:\"heading/style.min.css\";i:196;s:19:\"html/editor-rtl.css\";i:197;s:23:\"html/editor-rtl.min.css\";i:198;s:15:\"html/editor.css\";i:199;s:19:\"html/editor.min.css\";i:200;s:20:\"image/editor-rtl.css\";i:201;s:24:\"image/editor-rtl.min.css\";i:202;s:16:\"image/editor.css\";i:203;s:20:\"image/editor.min.css\";i:204;s:19:\"image/style-rtl.css\";i:205;s:23:\"image/style-rtl.min.css\";i:206;s:15:\"image/style.css\";i:207;s:19:\"image/style.min.css\";i:208;s:19:\"image/theme-rtl.css\";i:209;s:23:\"image/theme-rtl.min.css\";i:210;s:15:\"image/theme.css\";i:211;s:19:\"image/theme.min.css\";i:212;s:29:\"latest-comments/style-rtl.css\";i:213;s:33:\"latest-comments/style-rtl.min.css\";i:214;s:25:\"latest-comments/style.css\";i:215;s:29:\"latest-comments/style.min.css\";i:216;s:27:\"latest-posts/editor-rtl.css\";i:217;s:31:\"latest-posts/editor-rtl.min.css\";i:218;s:23:\"latest-posts/editor.css\";i:219;s:27:\"latest-posts/editor.min.css\";i:220;s:26:\"latest-posts/style-rtl.css\";i:221;s:30:\"latest-posts/style-rtl.min.css\";i:222;s:22:\"latest-posts/style.css\";i:223;s:26:\"latest-posts/style.min.css\";i:224;s:18:\"list/style-rtl.css\";i:225;s:22:\"list/style-rtl.min.css\";i:226;s:14:\"list/style.css\";i:227;s:18:\"list/style.min.css\";i:228;s:22:\"loginout/style-rtl.css\";i:229;s:26:\"loginout/style-rtl.min.css\";i:230;s:18:\"loginout/style.css\";i:231;s:22:\"loginout/style.min.css\";i:232;s:25:\"media-text/editor-rtl.css\";i:233;s:29:\"media-text/editor-rtl.min.css\";i:234;s:21:\"media-text/editor.css\";i:235;s:25:\"media-text/editor.min.css\";i:236;s:24:\"media-text/style-rtl.css\";i:237;s:28:\"media-text/style-rtl.min.css\";i:238;s:20:\"media-text/style.css\";i:239;s:24:\"media-text/style.min.css\";i:240;s:19:\"more/editor-rtl.css\";i:241;s:23:\"more/editor-rtl.min.css\";i:242;s:15:\"more/editor.css\";i:243;s:19:\"more/editor.min.css\";i:244;s:30:\"navigation-link/editor-rtl.css\";i:245;s:34:\"navigation-link/editor-rtl.min.css\";i:246;s:26:\"navigation-link/editor.css\";i:247;s:30:\"navigation-link/editor.min.css\";i:248;s:29:\"navigation-link/style-rtl.css\";i:249;s:33:\"navigation-link/style-rtl.min.css\";i:250;s:25:\"navigation-link/style.css\";i:251;s:29:\"navigation-link/style.min.css\";i:252;s:33:\"navigation-submenu/editor-rtl.css\";i:253;s:37:\"navigation-submenu/editor-rtl.min.css\";i:254;s:29:\"navigation-submenu/editor.css\";i:255;s:33:\"navigation-submenu/editor.min.css\";i:256;s:25:\"navigation/editor-rtl.css\";i:257;s:29:\"navigation/editor-rtl.min.css\";i:258;s:21:\"navigation/editor.css\";i:259;s:25:\"navigation/editor.min.css\";i:260;s:24:\"navigation/style-rtl.css\";i:261;s:28:\"navigation/style-rtl.min.css\";i:262;s:20:\"navigation/style.css\";i:263;s:24:\"navigation/style.min.css\";i:264;s:23:\"nextpage/editor-rtl.css\";i:265;s:27:\"nextpage/editor-rtl.min.css\";i:266;s:19:\"nextpage/editor.css\";i:267;s:23:\"nextpage/editor.min.css\";i:268;s:24:\"page-list/editor-rtl.css\";i:269;s:28:\"page-list/editor-rtl.min.css\";i:270;s:20:\"page-list/editor.css\";i:271;s:24:\"page-list/editor.min.css\";i:272;s:23:\"page-list/style-rtl.css\";i:273;s:27:\"page-list/style-rtl.min.css\";i:274;s:19:\"page-list/style.css\";i:275;s:23:\"page-list/style.min.css\";i:276;s:24:\"paragraph/editor-rtl.css\";i:277;s:28:\"paragraph/editor-rtl.min.css\";i:278;s:20:\"paragraph/editor.css\";i:279;s:24:\"paragraph/editor.min.css\";i:280;s:23:\"paragraph/style-rtl.css\";i:281;s:27:\"paragraph/style-rtl.min.css\";i:282;s:19:\"paragraph/style.css\";i:283;s:23:\"paragraph/style.min.css\";i:284;s:35:\"post-author-biography/style-rtl.css\";i:285;s:39:\"post-author-biography/style-rtl.min.css\";i:286;s:31:\"post-author-biography/style.css\";i:287;s:35:\"post-author-biography/style.min.css\";i:288;s:30:\"post-author-name/style-rtl.css\";i:289;s:34:\"post-author-name/style-rtl.min.css\";i:290;s:26:\"post-author-name/style.css\";i:291;s:30:\"post-author-name/style.min.css\";i:292;s:26:\"post-author/editor-rtl.css\";i:293;s:30:\"post-author/editor-rtl.min.css\";i:294;s:22:\"post-author/editor.css\";i:295;s:26:\"post-author/editor.min.css\";i:296;s:25:\"post-author/style-rtl.css\";i:297;s:29:\"post-author/style-rtl.min.css\";i:298;s:21:\"post-author/style.css\";i:299;s:25:\"post-author/style.min.css\";i:300;s:33:\"post-comments-form/editor-rtl.css\";i:301;s:37:\"post-comments-form/editor-rtl.min.css\";i:302;s:29:\"post-comments-form/editor.css\";i:303;s:33:\"post-comments-form/editor.min.css\";i:304;s:32:\"post-comments-form/style-rtl.css\";i:305;s:36:\"post-comments-form/style-rtl.min.css\";i:306;s:28:\"post-comments-form/style.css\";i:307;s:32:\"post-comments-form/style.min.css\";i:308;s:27:\"post-content/editor-rtl.css\";i:309;s:31:\"post-content/editor-rtl.min.css\";i:310;s:23:\"post-content/editor.css\";i:311;s:27:\"post-content/editor.min.css\";i:312;s:26:\"post-content/style-rtl.css\";i:313;s:30:\"post-content/style-rtl.min.css\";i:314;s:22:\"post-content/style.css\";i:315;s:26:\"post-content/style.min.css\";i:316;s:23:\"post-date/style-rtl.css\";i:317;s:27:\"post-date/style-rtl.min.css\";i:318;s:19:\"post-date/style.css\";i:319;s:23:\"post-date/style.min.css\";i:320;s:27:\"post-excerpt/editor-rtl.css\";i:321;s:31:\"post-excerpt/editor-rtl.min.css\";i:322;s:23:\"post-excerpt/editor.css\";i:323;s:27:\"post-excerpt/editor.min.css\";i:324;s:26:\"post-excerpt/style-rtl.css\";i:325;s:30:\"post-excerpt/style-rtl.min.css\";i:326;s:22:\"post-excerpt/style.css\";i:327;s:26:\"post-excerpt/style.min.css\";i:328;s:34:\"post-featured-image/editor-rtl.css\";i:329;s:38:\"post-featured-image/editor-rtl.min.css\";i:330;s:30:\"post-featured-image/editor.css\";i:331;s:34:\"post-featured-image/editor.min.css\";i:332;s:33:\"post-featured-image/style-rtl.css\";i:333;s:37:\"post-featured-image/style-rtl.min.css\";i:334;s:29:\"post-featured-image/style.css\";i:335;s:33:\"post-featured-image/style.min.css\";i:336;s:34:\"post-navigation-link/style-rtl.css\";i:337;s:38:\"post-navigation-link/style-rtl.min.css\";i:338;s:30:\"post-navigation-link/style.css\";i:339;s:34:\"post-navigation-link/style.min.css\";i:340;s:28:\"post-template/editor-rtl.css\";i:341;s:32:\"post-template/editor-rtl.min.css\";i:342;s:24:\"post-template/editor.css\";i:343;s:28:\"post-template/editor.min.css\";i:344;s:27:\"post-template/style-rtl.css\";i:345;s:31:\"post-template/style-rtl.min.css\";i:346;s:23:\"post-template/style.css\";i:347;s:27:\"post-template/style.min.css\";i:348;s:24:\"post-terms/style-rtl.css\";i:349;s:28:\"post-terms/style-rtl.min.css\";i:350;s:20:\"post-terms/style.css\";i:351;s:24:\"post-terms/style.min.css\";i:352;s:24:\"post-title/style-rtl.css\";i:353;s:28:\"post-title/style-rtl.min.css\";i:354;s:20:\"post-title/style.css\";i:355;s:24:\"post-title/style.min.css\";i:356;s:26:\"preformatted/style-rtl.css\";i:357;s:30:\"preformatted/style-rtl.min.css\";i:358;s:22:\"preformatted/style.css\";i:359;s:26:\"preformatted/style.min.css\";i:360;s:24:\"pullquote/editor-rtl.css\";i:361;s:28:\"pullquote/editor-rtl.min.css\";i:362;s:20:\"pullquote/editor.css\";i:363;s:24:\"pullquote/editor.min.css\";i:364;s:23:\"pullquote/style-rtl.css\";i:365;s:27:\"pullquote/style-rtl.min.css\";i:366;s:19:\"pullquote/style.css\";i:367;s:23:\"pullquote/style.min.css\";i:368;s:23:\"pullquote/theme-rtl.css\";i:369;s:27:\"pullquote/theme-rtl.min.css\";i:370;s:19:\"pullquote/theme.css\";i:371;s:23:\"pullquote/theme.min.css\";i:372;s:39:\"query-pagination-numbers/editor-rtl.css\";i:373;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:374;s:35:\"query-pagination-numbers/editor.css\";i:375;s:39:\"query-pagination-numbers/editor.min.css\";i:376;s:31:\"query-pagination/editor-rtl.css\";i:377;s:35:\"query-pagination/editor-rtl.min.css\";i:378;s:27:\"query-pagination/editor.css\";i:379;s:31:\"query-pagination/editor.min.css\";i:380;s:30:\"query-pagination/style-rtl.css\";i:381;s:34:\"query-pagination/style-rtl.min.css\";i:382;s:26:\"query-pagination/style.css\";i:383;s:30:\"query-pagination/style.min.css\";i:384;s:25:\"query-title/style-rtl.css\";i:385;s:29:\"query-title/style-rtl.min.css\";i:386;s:21:\"query-title/style.css\";i:387;s:25:\"query-title/style.min.css\";i:388;s:20:\"query/editor-rtl.css\";i:389;s:24:\"query/editor-rtl.min.css\";i:390;s:16:\"query/editor.css\";i:391;s:20:\"query/editor.min.css\";i:392;s:19:\"quote/style-rtl.css\";i:393;s:23:\"quote/style-rtl.min.css\";i:394;s:15:\"quote/style.css\";i:395;s:19:\"quote/style.min.css\";i:396;s:19:\"quote/theme-rtl.css\";i:397;s:23:\"quote/theme-rtl.min.css\";i:398;s:15:\"quote/theme.css\";i:399;s:19:\"quote/theme.min.css\";i:400;s:23:\"read-more/style-rtl.css\";i:401;s:27:\"read-more/style-rtl.min.css\";i:402;s:19:\"read-more/style.css\";i:403;s:23:\"read-more/style.min.css\";i:404;s:18:\"rss/editor-rtl.css\";i:405;s:22:\"rss/editor-rtl.min.css\";i:406;s:14:\"rss/editor.css\";i:407;s:18:\"rss/editor.min.css\";i:408;s:17:\"rss/style-rtl.css\";i:409;s:21:\"rss/style-rtl.min.css\";i:410;s:13:\"rss/style.css\";i:411;s:17:\"rss/style.min.css\";i:412;s:21:\"search/editor-rtl.css\";i:413;s:25:\"search/editor-rtl.min.css\";i:414;s:17:\"search/editor.css\";i:415;s:21:\"search/editor.min.css\";i:416;s:20:\"search/style-rtl.css\";i:417;s:24:\"search/style-rtl.min.css\";i:418;s:16:\"search/style.css\";i:419;s:20:\"search/style.min.css\";i:420;s:20:\"search/theme-rtl.css\";i:421;s:24:\"search/theme-rtl.min.css\";i:422;s:16:\"search/theme.css\";i:423;s:20:\"search/theme.min.css\";i:424;s:24:\"separator/editor-rtl.css\";i:425;s:28:\"separator/editor-rtl.min.css\";i:426;s:20:\"separator/editor.css\";i:427;s:24:\"separator/editor.min.css\";i:428;s:23:\"separator/style-rtl.css\";i:429;s:27:\"separator/style-rtl.min.css\";i:430;s:19:\"separator/style.css\";i:431;s:23:\"separator/style.min.css\";i:432;s:23:\"separator/theme-rtl.css\";i:433;s:27:\"separator/theme-rtl.min.css\";i:434;s:19:\"separator/theme.css\";i:435;s:23:\"separator/theme.min.css\";i:436;s:24:\"shortcode/editor-rtl.css\";i:437;s:28:\"shortcode/editor-rtl.min.css\";i:438;s:20:\"shortcode/editor.css\";i:439;s:24:\"shortcode/editor.min.css\";i:440;s:24:\"site-logo/editor-rtl.css\";i:441;s:28:\"site-logo/editor-rtl.min.css\";i:442;s:20:\"site-logo/editor.css\";i:443;s:24:\"site-logo/editor.min.css\";i:444;s:23:\"site-logo/style-rtl.css\";i:445;s:27:\"site-logo/style-rtl.min.css\";i:446;s:19:\"site-logo/style.css\";i:447;s:23:\"site-logo/style.min.css\";i:448;s:27:\"site-tagline/editor-rtl.css\";i:449;s:31:\"site-tagline/editor-rtl.min.css\";i:450;s:23:\"site-tagline/editor.css\";i:451;s:27:\"site-tagline/editor.min.css\";i:452;s:26:\"site-tagline/style-rtl.css\";i:453;s:30:\"site-tagline/style-rtl.min.css\";i:454;s:22:\"site-tagline/style.css\";i:455;s:26:\"site-tagline/style.min.css\";i:456;s:25:\"site-title/editor-rtl.css\";i:457;s:29:\"site-title/editor-rtl.min.css\";i:458;s:21:\"site-title/editor.css\";i:459;s:25:\"site-title/editor.min.css\";i:460;s:24:\"site-title/style-rtl.css\";i:461;s:28:\"site-title/style-rtl.min.css\";i:462;s:20:\"site-title/style.css\";i:463;s:24:\"site-title/style.min.css\";i:464;s:26:\"social-link/editor-rtl.css\";i:465;s:30:\"social-link/editor-rtl.min.css\";i:466;s:22:\"social-link/editor.css\";i:467;s:26:\"social-link/editor.min.css\";i:468;s:27:\"social-links/editor-rtl.css\";i:469;s:31:\"social-links/editor-rtl.min.css\";i:470;s:23:\"social-links/editor.css\";i:471;s:27:\"social-links/editor.min.css\";i:472;s:26:\"social-links/style-rtl.css\";i:473;s:30:\"social-links/style-rtl.min.css\";i:474;s:22:\"social-links/style.css\";i:475;s:26:\"social-links/style.min.css\";i:476;s:21:\"spacer/editor-rtl.css\";i:477;s:25:\"spacer/editor-rtl.min.css\";i:478;s:17:\"spacer/editor.css\";i:479;s:21:\"spacer/editor.min.css\";i:480;s:20:\"spacer/style-rtl.css\";i:481;s:24:\"spacer/style-rtl.min.css\";i:482;s:16:\"spacer/style.css\";i:483;s:20:\"spacer/style.min.css\";i:484;s:20:\"table/editor-rtl.css\";i:485;s:24:\"table/editor-rtl.min.css\";i:486;s:16:\"table/editor.css\";i:487;s:20:\"table/editor.min.css\";i:488;s:19:\"table/style-rtl.css\";i:489;s:23:\"table/style-rtl.min.css\";i:490;s:15:\"table/style.css\";i:491;s:19:\"table/style.min.css\";i:492;s:19:\"table/theme-rtl.css\";i:493;s:23:\"table/theme-rtl.min.css\";i:494;s:15:\"table/theme.css\";i:495;s:19:\"table/theme.min.css\";i:496;s:24:\"tag-cloud/editor-rtl.css\";i:497;s:28:\"tag-cloud/editor-rtl.min.css\";i:498;s:20:\"tag-cloud/editor.css\";i:499;s:24:\"tag-cloud/editor.min.css\";i:500;s:23:\"tag-cloud/style-rtl.css\";i:501;s:27:\"tag-cloud/style-rtl.min.css\";i:502;s:19:\"tag-cloud/style.css\";i:503;s:23:\"tag-cloud/style.min.css\";i:504;s:28:\"template-part/editor-rtl.css\";i:505;s:32:\"template-part/editor-rtl.min.css\";i:506;s:24:\"template-part/editor.css\";i:507;s:28:\"template-part/editor.min.css\";i:508;s:27:\"template-part/theme-rtl.css\";i:509;s:31:\"template-part/theme-rtl.min.css\";i:510;s:23:\"template-part/theme.css\";i:511;s:27:\"template-part/theme.min.css\";i:512;s:30:\"term-description/style-rtl.css\";i:513;s:34:\"term-description/style-rtl.min.css\";i:514;s:26:\"term-description/style.css\";i:515;s:30:\"term-description/style.min.css\";i:516;s:27:\"text-columns/editor-rtl.css\";i:517;s:31:\"text-columns/editor-rtl.min.css\";i:518;s:23:\"text-columns/editor.css\";i:519;s:27:\"text-columns/editor.min.css\";i:520;s:26:\"text-columns/style-rtl.css\";i:521;s:30:\"text-columns/style-rtl.min.css\";i:522;s:22:\"text-columns/style.css\";i:523;s:26:\"text-columns/style.min.css\";i:524;s:19:\"verse/style-rtl.css\";i:525;s:23:\"verse/style-rtl.min.css\";i:526;s:15:\"verse/style.css\";i:527;s:19:\"verse/style.min.css\";i:528;s:20:\"video/editor-rtl.css\";i:529;s:24:\"video/editor-rtl.min.css\";i:530;s:16:\"video/editor.css\";i:531;s:20:\"video/editor.min.css\";i:532;s:19:\"video/style-rtl.css\";i:533;s:23:\"video/style-rtl.min.css\";i:534;s:15:\"video/style.css\";i:535;s:19:\"video/style.min.css\";i:536;s:19:\"video/theme-rtl.css\";i:537;s:23:\"video/theme-rtl.min.css\";i:538;s:15:\"video/theme.css\";i:539;s:19:\"video/theme.min.css\";}}", "on");
INSERT INTO `wp_options` VALUES("125", "recovery_keys", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("127", "theme_mods_twentytwentyfive", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1732089294;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "off");
INSERT INTO `wp_options` VALUES("128", "_transient_wp_styles_for_blocks", "a:2:{s:4:\"hash\";s:32:\"fa6b99f8356a5d3ff509a3d5797be097\";s:6:\"blocks\";a:5:{s:11:\"core/button\";s:0:\"\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:120:\":where(.wp-block-post-template.is-layout-flex){gap: 1.25em;}:where(.wp-block-post-template.is-layout-grid){gap: 1.25em;}\";s:12:\"core/columns\";s:102:\":where(.wp-block-columns.is-layout-flex){gap: 2em;}:where(.wp-block-columns.is-layout-grid){gap: 2em;}\";s:14:\"core/pullquote\";s:69:\":root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}\";}}", "on");
INSERT INTO `wp_options` VALUES("133", "_site_transient_timeout_browser_a455ebc67d0b5007e2a055414dd14d78", "1732692109", "off");
INSERT INTO `wp_options` VALUES("134", "_site_transient_browser_a455ebc67d0b5007e2a055414dd14d78", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"130.0.0.0\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "off");
INSERT INTO `wp_options` VALUES("135", "_site_transient_timeout_php_check_a34f4a08303dd29cee70e79d780daa9d", "1732692110", "off");
INSERT INTO `wp_options` VALUES("136", "_site_transient_php_check_a34f4a08303dd29cee70e79d780daa9d", "a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:6:\"7.2.24\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "off");
INSERT INTO `wp_options` VALUES("140", "can_compress_scripts", "0", "on");
INSERT INTO `wp_options` VALUES("153", "finished_updating_comment_type", "1", "auto");
INSERT INTO `wp_options` VALUES("158", "WPLANG", "fr_FR", "auto");
INSERT INTO `wp_options` VALUES("159", "new_admin_email", "dev-email@wpengine.local", "auto");
INSERT INTO `wp_options` VALUES("176", "current_theme", "Valio-thème", "auto");
INSERT INTO `wp_options` VALUES("177", "theme_mods_valio-theme", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:9:\"main-menu\";i:0;s:10:\"legal-menu\";i:0;}s:18:\"custom_css_post_id\";i:-1;s:11:\"custom_logo\";i:48;}", "on");
INSERT INTO `wp_options` VALUES("178", "theme_switched", "", "auto");
INSERT INTO `wp_options` VALUES("179", "recovery_mode_email_last_sent", "1732273052", "auto");
INSERT INTO `wp_options` VALUES("213", "wp_calendar_block_has_published_posts", "1", "auto");
INSERT INTO `wp_options` VALUES("264", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("267", "site_logo", "48", "auto");
INSERT INTO `wp_options` VALUES("271", "_transient_health-check-site-status-result", "{\"good\":18,\"recommended\":2,\"critical\":0}", "on");
INSERT INTO `wp_options` VALUES("337", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:24:\"dev-email@wpengine.local\";s:7:\"version\";s:5:\"6.7.1\";s:9:\"timestamp\";i:1732225751;}", "off");
INSERT INTO `wp_options` VALUES("421", "category_children", "a:1:{i:5;a:4:{i:0;i:7;i:1;i:8;i:2;i:9;i:3;i:10;}}", "auto");
INSERT INTO `wp_options` VALUES("438", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/fr_FR/wordpress-6.7.1.zip\";s:6:\"locale\";s:5:\"fr_FR\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/fr_FR/wordpress-6.7.1.zip\";s:10:\"no_content\";s:0:\"\";s:11:\"new_bundled\";s:0:\"\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.7.1\";s:7:\"version\";s:5:\"6.7.1\";s:11:\"php_version\";s:6:\"7.2.24\";s:13:\"mysql_version\";s:5:\"5.5.5\";s:11:\"new_bundled\";s:3:\"6.7\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1732525065;s:15:\"version_checked\";s:5:\"6.7.1\";s:12:\"translations\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("439", "_site_transient_update_themes", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1732521718;s:7:\"checked\";a:5:{s:16:\"twentytwentyfive\";s:3:\"1.0\";s:16:\"twentytwentyfour\";s:3:\"1.3\";s:17:\"twentytwentythree\";s:3:\"1.6\";s:16:\"valio-theme copy\";s:3:\"1.0\";s:11:\"valio-theme\";s:3:\"1.0\";}s:8:\"response\";a:0:{}s:9:\"no_update\";a:3:{s:16:\"twentytwentyfive\";a:6:{s:5:\"theme\";s:16:\"twentytwentyfive\";s:11:\"new_version\";s:3:\"1.0\";s:3:\"url\";s:46:\"https://wordpress.org/themes/twentytwentyfive/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/theme/twentytwentyfive.1.0.zip\";s:8:\"requires\";s:3:\"6.7\";s:12:\"requires_php\";s:3:\"7.2\";}s:16:\"twentytwentyfour\";a:6:{s:5:\"theme\";s:16:\"twentytwentyfour\";s:11:\"new_version\";s:3:\"1.3\";s:3:\"url\";s:46:\"https://wordpress.org/themes/twentytwentyfour/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/theme/twentytwentyfour.1.3.zip\";s:8:\"requires\";s:3:\"6.4\";s:12:\"requires_php\";s:3:\"7.0\";}s:17:\"twentytwentythree\";a:6:{s:5:\"theme\";s:17:\"twentytwentythree\";s:11:\"new_version\";s:3:\"1.6\";s:3:\"url\";s:47:\"https://wordpress.org/themes/twentytwentythree/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/theme/twentytwentythree.1.6.zip\";s:8:\"requires\";s:3:\"6.1\";s:12:\"requires_php\";s:3:\"5.6\";}}s:12:\"translations\";a:1:{i:0;a:7:{s:4:\"type\";s:5:\"theme\";s:4:\"slug\";s:16:\"twentytwentyfive\";s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:3:\"1.0\";s:7:\"updated\";s:19:\"2024-11-24 13:32:29\";s:7:\"package\";s:80:\"https://downloads.wordpress.org/translation/theme/twentytwentyfive/1.0/fr_FR.zip\";s:10:\"autoupdate\";b:1;}}}", "off");
INSERT INTO `wp_options` VALUES("444", "_site_transient_timeout_available_translations", "1732531857", "off");
INSERT INTO `wp_options` VALUES("445", "_site_transient_available_translations", "a:131:{s:2:\"af\";a:8:{s:8:\"language\";s:2:\"af\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-05-13 15:59:22\";s:12:\"english_name\";s:9:\"Afrikaans\";s:11:\"native_name\";s:9:\"Afrikaans\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/af.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"af\";i:2;s:3:\"afr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Gaan voort\";}}s:2:\"am\";a:8:{s:8:\"language\";s:2:\"am\";s:7:\"version\";s:5:\"6.0.9\";s:7:\"updated\";s:19:\"2022-09-29 20:43:49\";s:12:\"english_name\";s:7:\"Amharic\";s:11:\"native_name\";s:12:\"አማርኛ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.9/am.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"am\";i:2;s:3:\"amh\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"ቀጥል\";}}s:3:\"arg\";a:8:{s:8:\"language\";s:3:\"arg\";s:7:\"version\";s:8:\"6.2-beta\";s:7:\"updated\";s:19:\"2022-09-22 16:46:56\";s:12:\"english_name\";s:9:\"Aragonese\";s:11:\"native_name\";s:9:\"Aragonés\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.2-beta/arg.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"an\";i:2;s:3:\"arg\";i:3;s:3:\"arg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continar\";}}s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2024-02-13 12:49:38\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.5/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"متابعة\";}}s:3:\"ary\";a:8:{s:8:\"language\";s:3:\"ary\";s:7:\"version\";s:6:\"4.8.25\";s:7:\"updated\";s:19:\"2017-01-26 15:42:35\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"العربية المغربية\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.25/ary.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"as\";a:8:{s:8:\"language\";s:2:\"as\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-01 09:05:28\";s:12:\"english_name\";s:8:\"Assamese\";s:11:\"native_name\";s:21:\"অসমীয়া\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/as.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"as\";i:2;s:3:\"asm\";i:3;s:3:\"asm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:3:\"azb\";a:8:{s:8:\"language\";s:3:\"azb\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2024-01-19 08:58:31\";s:12:\"english_name\";s:17:\"South Azerbaijani\";s:11:\"native_name\";s:29:\"گؤنئی آذربایجان\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.4.5/azb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:3;s:3:\"azb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-06 00:09:27\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:3:\"bel\";a:8:{s:8:\"language\";s:3:\"bel\";s:7:\"version\";s:6:\"4.9.26\";s:7:\"updated\";s:19:\"2019-10-29 07:54:22\";s:12:\"english_name\";s:10:\"Belarusian\";s:11:\"native_name\";s:29:\"Беларуская мова\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.9.26/bel.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"be\";i:2;s:3:\"bel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Працягнуць\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-23 13:50:30\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Напред\";}}s:5:\"bn_BD\";a:8:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-11 11:12:13\";s:12:\"english_name\";s:20:\"Bengali (Bangladesh)\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/bn_BD.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:28:\"চালিয়ে যান\";}}s:2:\"bo\";a:8:{s:8:\"language\";s:2:\"bo\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2020-10-30 03:24:38\";s:12:\"english_name\";s:7:\"Tibetan\";s:11:\"native_name\";s:21:\"བོད་ཡིག\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/bo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bo\";i:2;s:3:\"tib\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:33:\"མུ་མཐུད་དུ།\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2023-02-22 20:45:53\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.6/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-22 12:21:36\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:3:\"ceb\";a:8:{s:8:\"language\";s:3:\"ceb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-02 17:25:51\";s:12:\"english_name\";s:7:\"Cebuano\";s:11:\"native_name\";s:7:\"Cebuano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/ceb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"ceb\";i:3;s:3:\"ceb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Padayun\";}}s:5:\"cs_CZ\";a:8:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:5:\"6.6.2\";s:7:\"updated\";s:19:\"2024-07-23 09:49:04\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.2/cs_CZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cs\";i:2;s:3:\"ces\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Pokračovat\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-22 10:31:12\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-09-27 09:32:19\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsæt\";}}s:14:\"de_CH_informal\";a:8:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-05 18:08:14\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/translation/core/6.7.1/de_CH_informal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_AT\";a:8:{s:8:\"language\";s:5:\"de_AT\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-07 15:43:21\";s:12:\"english_name\";s:16:\"German (Austria)\";s:11:\"native_name\";s:21:\"Deutsch (Österreich)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/de_AT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-25 01:53:14\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:12:\"de_DE_formal\";a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-25 01:52:48\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.7.1/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-05 18:11:40\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:3:\"dsb\";a:8:{s:8:\"language\";s:3:\"dsb\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2022-07-16 12:13:09\";s:12:\"english_name\";s:13:\"Lower Sorbian\";s:11:\"native_name\";s:16:\"Dolnoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.6/dsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"dsb\";i:3;s:3:\"dsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Dalej\";}}s:3:\"dzo\";a:8:{s:8:\"language\";s:3:\"dzo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-06-29 08:59:03\";s:12:\"english_name\";s:8:\"Dzongkha\";s:11:\"native_name\";s:18:\"རྫོང་ཁ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/dzo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"dz\";i:2;s:3:\"dzo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-22 01:55:00\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_NZ\";a:8:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-12 00:03:39\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-04 22:51:08\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-09 02:33:22\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-14 20:17:10\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_ZA\";a:8:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-08 19:43:34\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-19 14:30:41\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_CO\";a:8:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-21 04:23:19\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/es_CO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-21 17:51:13\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/es_MX.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-20 15:25:26\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/es_ES.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CR\";a:8:{s:8:\"language\";s:5:\"es_CR\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-01 13:40:20\";s:12:\"english_name\";s:20:\"Spanish (Costa Rica)\";s:11:\"native_name\";s:22:\"Español de Costa Rica\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/es_CR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-10-16 21:04:12\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/es_PE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_AR\";a:8:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-21 03:48:07\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/es_AR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-12 19:39:57\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/es_CL.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_VE\";a:8:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2023-10-16 16:00:04\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.5/es_VE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_EC\";a:8:{s:8:\"language\";s:5:\"es_EC\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2023-04-21 13:32:10\";s:12:\"english_name\";s:17:\"Spanish (Ecuador)\";s:11:\"native_name\";s:19:\"Español de Ecuador\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.6/es_EC.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_DO\";a:8:{s:8:\"language\";s:5:\"es_DO\";s:7:\"version\";s:6:\"5.8.10\";s:7:\"updated\";s:19:\"2021-10-08 14:32:50\";s:12:\"english_name\";s:28:\"Spanish (Dominican Republic)\";s:11:\"native_name\";s:33:\"Español de República Dominicana\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.8.10/es_DO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_UY\";a:8:{s:8:\"language\";s:5:\"es_UY\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-31 18:33:26\";s:12:\"english_name\";s:17:\"Spanish (Uruguay)\";s:11:\"native_name\";s:19:\"Español de Uruguay\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/es_UY.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PR\";a:8:{s:8:\"language\";s:5:\"es_PR\";s:7:\"version\";s:6:\"5.4.16\";s:7:\"updated\";s:19:\"2020-04-29 15:36:59\";s:12:\"english_name\";s:21:\"Spanish (Puerto Rico)\";s:11:\"native_name\";s:23:\"Español de Puerto Rico\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.4.16/es_PR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_GT\";a:8:{s:8:\"language\";s:5:\"es_GT\";s:7:\"version\";s:6:\"5.2.21\";s:7:\"updated\";s:19:\"2019-03-02 06:35:01\";s:12:\"english_name\";s:19:\"Spanish (Guatemala)\";s:11:\"native_name\";s:21:\"Español de Guatemala\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.2.21/es_GT.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2024-06-06 09:50:37\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.5.5/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-10-10 00:15:35\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-22 00:15:08\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"fa_AF\";a:8:{s:8:\"language\";s:5:\"fa_AF\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-06-20 17:15:28\";s:12:\"english_name\";s:21:\"Persian (Afghanistan)\";s:11:\"native_name\";s:31:\"(فارسی (افغانستان\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/fa_AF.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-22 05:44:18\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-20 17:18:27\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_CA\";a:8:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-09-30 11:36:50\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/fr_CA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_BE\";a:8:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2024-02-01 23:56:53\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.5.5/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:3:\"fur\";a:8:{s:8:\"language\";s:3:\"fur\";s:7:\"version\";s:6:\"4.8.25\";s:7:\"updated\";s:19:\"2023-04-30 13:56:46\";s:12:\"english_name\";s:8:\"Friulian\";s:11:\"native_name\";s:8:\"Friulian\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.25/fur.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"fur\";i:3;s:3:\"fur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"fy\";a:8:{s:8:\"language\";s:2:\"fy\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2022-12-25 12:53:23\";s:12:\"english_name\";s:7:\"Frisian\";s:11:\"native_name\";s:5:\"Frysk\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.2.6/fy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fy\";i:2;s:3:\"fry\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Trochgean\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-08-23 17:41:37\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-23 12:36:07\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"gu\";a:8:{s:8:\"language\";s:2:\"gu\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-12 11:31:44\";s:12:\"english_name\";s:8:\"Gujarati\";s:11:\"native_name\";s:21:\"ગુજરાતી\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/gu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gu\";i:2;s:3:\"guj\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ચાલુ રાખો\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:6:\"4.4.33\";s:7:\"updated\";s:19:\"2015-12-05 00:59:09\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.4.33/haz.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2024-05-04 18:39:24\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.6/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"המשך\";}}s:5:\"hi_IN\";a:8:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2024-02-25 08:05:38\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.5/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"जारी रखें\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-11 08:43:38\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:3:\"hsb\";a:8:{s:8:\"language\";s:3:\"hsb\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2023-02-22 17:37:32\";s:12:\"english_name\";s:13:\"Upper Sorbian\";s:11:\"native_name\";s:17:\"Hornjoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.6/hsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"hsb\";i:3;s:3:\"hsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:4:\"Dale\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-14 09:49:05\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Folytatás\";}}s:2:\"hy\";a:8:{s:8:\"language\";s:2:\"hy\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-03 16:21:10\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/hy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Շարունակել\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-14 03:56:14\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:6:\"4.9.26\";s:7:\"updated\";s:19:\"2018-12-11 10:40:02\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.26/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-21 17:43:13\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-24 14:00:08\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"次へ\";}}s:5:\"jv_ID\";a:8:{s:8:\"language\";s:5:\"jv_ID\";s:7:\"version\";s:6:\"4.9.26\";s:7:\"updated\";s:19:\"2019-02-16 23:58:56\";s:12:\"english_name\";s:8:\"Javanese\";s:11:\"native_name\";s:9:\"Basa Jawa\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.26/jv_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"jv\";i:2;s:3:\"jav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Nerusaké\";}}s:5:\"ka_GE\";a:8:{s:8:\"language\";s:5:\"ka_GE\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-08 06:38:31\";s:12:\"english_name\";s:8:\"Georgian\";s:11:\"native_name\";s:21:\"ქართული\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/ka_GE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ka\";i:2;s:3:\"kat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"გაგრძელება\";}}s:3:\"kab\";a:8:{s:8:\"language\";s:3:\"kab\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2023-07-05 11:40:39\";s:12:\"english_name\";s:6:\"Kabyle\";s:11:\"native_name\";s:9:\"Taqbaylit\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.6/kab.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"kab\";i:3;s:3:\"kab\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Kemmel\";}}s:2:\"kk\";a:8:{s:8:\"language\";s:2:\"kk\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-07-18 02:49:24\";s:12:\"english_name\";s:6:\"Kazakh\";s:11:\"native_name\";s:19:\"Қазақ тілі\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/kk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kk\";i:2;s:3:\"kaz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Жалғастыру\";}}s:2:\"km\";a:8:{s:8:\"language\";s:2:\"km\";s:7:\"version\";s:6:\"5.2.21\";s:7:\"updated\";s:19:\"2019-06-10 16:18:28\";s:12:\"english_name\";s:5:\"Khmer\";s:11:\"native_name\";s:27:\"ភាសាខ្មែរ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.2.21/km.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"km\";i:2;s:3:\"khm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"បន្ត\";}}s:2:\"kn\";a:8:{s:8:\"language\";s:2:\"kn\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-12 23:54:38\";s:12:\"english_name\";s:7:\"Kannada\";s:11:\"native_name\";s:15:\"ಕನ್ನಡ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/kn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kn\";i:2;s:3:\"kan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"ಮುಂದುವರಿಸು\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-21 02:38:23\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:3:\"ckb\";a:8:{s:8:\"language\";s:3:\"ckb\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-22 17:58:12\";s:12:\"english_name\";s:16:\"Kurdish (Sorani)\";s:11:\"native_name\";s:13:\"كوردی‎\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.7.1/ckb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ku\";i:3;s:3:\"ckb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"به‌رده‌وام به‌\";}}s:3:\"kir\";a:8:{s:8:\"language\";s:3:\"kir\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-23 15:58:26\";s:12:\"english_name\";s:6:\"Kyrgyz\";s:11:\"native_name\";s:16:\"Кыргызча\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.7.1/kir.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ky\";i:2;s:3:\"kir\";i:3;s:3:\"kir\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Улантуу\";}}s:2:\"lo\";a:8:{s:8:\"language\";s:2:\"lo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 09:59:23\";s:12:\"english_name\";s:3:\"Lao\";s:11:\"native_name\";s:21:\"ພາສາລາວ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/lo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lo\";i:2;s:3:\"lao\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"ຕໍ່​ໄປ\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2024-06-13 13:11:03\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.5.5/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:2:\"lv\";a:8:{s:8:\"language\";s:2:\"lv\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-05 21:35:49\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:16:\"Latviešu valoda\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/lv.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lv\";i:2;s:3:\"lav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Turpināt\";}}s:5:\"mk_MK\";a:8:{s:8:\"language\";s:5:\"mk_MK\";s:7:\"version\";s:5:\"6.0.9\";s:7:\"updated\";s:19:\"2022-10-01 09:23:52\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:31:\"Македонски јазик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.9/mk_MK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mk\";i:2;s:3:\"mkd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Продолжи\";}}s:5:\"ml_IN\";a:8:{s:8:\"language\";s:5:\"ml_IN\";s:7:\"version\";s:5:\"6.6.2\";s:7:\"updated\";s:19:\"2024-10-05 15:57:37\";s:12:\"english_name\";s:9:\"Malayalam\";s:11:\"native_name\";s:18:\"മലയാളം\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.2/ml_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ml\";i:2;s:3:\"mal\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"തുടരുക\";}}s:2:\"mn\";a:8:{s:8:\"language\";s:2:\"mn\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2024-06-20 17:22:06\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:12:\"Монгол\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.5.5/mn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mn\";i:2;s:3:\"mon\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"mr\";a:8:{s:8:\"language\";s:2:\"mr\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-01 08:11:24\";s:12:\"english_name\";s:7:\"Marathi\";s:11:\"native_name\";s:15:\"मराठी\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/mr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mr\";i:2;s:3:\"mar\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"सुरु ठेवा\";}}s:5:\"ms_MY\";a:8:{s:8:\"language\";s:5:\"ms_MY\";s:7:\"version\";s:6:\"5.5.15\";s:7:\"updated\";s:19:\"2022-03-11 13:52:22\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:13:\"Bahasa Melayu\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.5.15/ms_MY.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ms\";i:2;s:3:\"msa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Teruskan\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:6:\"4.2.38\";s:7:\"updated\";s:19:\"2017-12-26 11:57:10\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.38/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ဆောင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-12 22:03:40\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"ne_NP\";a:8:{s:8:\"language\";s:5:\"ne_NP\";s:7:\"version\";s:5:\"6.6.2\";s:7:\"updated\";s:19:\"2024-08-30 11:32:23\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:18:\"नेपाली\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.2/ne_NP.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ne\";i:2;s:3:\"nep\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:43:\"जारी राख्नुहोस्\";}}s:12:\"nl_NL_formal\";a:8:{s:8:\"language\";s:12:\"nl_NL_formal\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-24 18:46:54\";s:12:\"english_name\";s:14:\"Dutch (Formal)\";s:11:\"native_name\";s:20:\"Nederlands (Formeel)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.7.1/nl_NL_formal.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-24 21:06:25\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_BE\";a:8:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-23 21:43:18\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/nl_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-18 10:59:16\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:3:\"oci\";a:8:{s:8:\"language\";s:3:\"oci\";s:7:\"version\";s:6:\"4.8.25\";s:7:\"updated\";s:19:\"2017-08-25 10:03:08\";s:12:\"english_name\";s:7:\"Occitan\";s:11:\"native_name\";s:7:\"Occitan\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.25/oci.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"oc\";i:2;s:3:\"oci\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Contunhar\";}}s:5:\"pa_IN\";a:8:{s:8:\"language\";s:5:\"pa_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-16 05:19:43\";s:12:\"english_name\";s:15:\"Panjabi (India)\";s:11:\"native_name\";s:18:\"ਪੰਜਾਬੀ\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/pa_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pa\";i:2;s:3:\"pan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ਜਾਰੀ ਰੱਖੋ\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-22 07:35:19\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:6:\"4.3.34\";s:7:\"updated\";s:19:\"2015-12-02 21:41:29\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.3.34/ps.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ps\";i:2;s:3:\"pus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"دوام ورکړه\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-21 13:50:09\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_AO\";a:8:{s:8:\"language\";s:5:\"pt_AO\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2023-08-21 12:15:00\";s:12:\"english_name\";s:19:\"Portuguese (Angola)\";s:11:\"native_name\";s:20:\"Português de Angola\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.5/pt_AO.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-22 09:42:15\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:10:\"pt_PT_ao90\";a:8:{s:8:\"language\";s:10:\"pt_PT_ao90\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-22 09:42:36\";s:12:\"english_name\";s:27:\"Portuguese (Portugal, AO90)\";s:11:\"native_name\";s:17:\"Português (AO90)\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/core/6.7.1/pt_PT_ao90.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"rhg\";a:8:{s:8:\"language\";s:3:\"rhg\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-16 13:03:18\";s:12:\"english_name\";s:8:\"Rohingya\";s:11:\"native_name\";s:8:\"Ruáinga\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/rhg.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"rhg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-23 07:42:17\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-20 15:32:31\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:3:\"sah\";a:8:{s:8:\"language\";s:3:\"sah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-21 02:06:41\";s:12:\"english_name\";s:5:\"Sakha\";s:11:\"native_name\";s:14:\"Сахалыы\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/sah.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"sah\";i:3;s:3:\"sah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Салҕаа\";}}s:3:\"snd\";a:8:{s:8:\"language\";s:3:\"snd\";s:7:\"version\";s:6:\"5.4.16\";s:7:\"updated\";s:19:\"2020-07-07 01:53:37\";s:12:\"english_name\";s:6:\"Sindhi\";s:11:\"native_name\";s:8:\"سنڌي\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/5.4.16/snd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"sd\";i:2;s:3:\"snd\";i:3;s:3:\"snd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"اڳتي هلو\";}}s:5:\"si_LK\";a:8:{s:8:\"language\";s:5:\"si_LK\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 06:00:52\";s:12:\"english_name\";s:7:\"Sinhala\";s:11:\"native_name\";s:15:\"සිංහල\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/si_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"si\";i:2;s:3:\"sin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:44:\"දිගටම කරගෙන යන්න\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-18 04:48:42\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:3:\"skr\";a:8:{s:8:\"language\";s:3:\"skr\";s:7:\"version\";s:5:\"6.6.2\";s:7:\"updated\";s:19:\"2024-09-21 09:44:08\";s:12:\"english_name\";s:7:\"Saraiki\";s:11:\"native_name\";s:14:\"سرائیکی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.6.2/skr.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"skr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"جاری رکھو\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-08-30 07:14:35\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Nadaljuj\";}}s:2:\"sq\";a:8:{s:8:\"language\";s:2:\"sq\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-03 08:29:01\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/sq.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-09-20 22:15:56\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-21 05:08:10\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:2:\"sw\";a:8:{s:8:\"language\";s:2:\"sw\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-06 16:56:18\";s:12:\"english_name\";s:7:\"Swahili\";s:11:\"native_name\";s:9:\"Kiswahili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/sw.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sw\";i:2;s:3:\"swa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Endelea\";}}s:3:\"szl\";a:8:{s:8:\"language\";s:3:\"szl\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-24 19:58:14\";s:12:\"english_name\";s:8:\"Silesian\";s:11:\"native_name\";s:17:\"Ślōnskŏ gŏdka\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/szl.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"szl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:13:\"Kōntynuować\";}}s:5:\"ta_IN\";a:8:{s:8:\"language\";s:5:\"ta_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:22:47\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ta_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"தொடரவும்\";}}s:5:\"ta_LK\";a:8:{s:8:\"language\";s:5:\"ta_LK\";s:7:\"version\";s:6:\"4.2.38\";s:7:\"updated\";s:19:\"2015-12-03 01:07:44\";s:12:\"english_name\";s:17:\"Tamil (Sri Lanka)\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.38/ta_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"தொடர்க\";}}s:2:\"te\";a:8:{s:8:\"language\";s:2:\"te\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:47:39\";s:12:\"english_name\";s:6:\"Telugu\";s:11:\"native_name\";s:18:\"తెలుగు\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/te.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"te\";i:2;s:3:\"tel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"కొనసాగించు\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:6:\"5.8.10\";s:7:\"updated\";s:19:\"2022-06-08 04:30:30\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.8.10/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:2:\"tl\";a:8:{s:8:\"language\";s:2:\"tl\";s:7:\"version\";s:6:\"4.8.25\";s:7:\"updated\";s:19:\"2017-09-30 09:04:29\";s:12:\"english_name\";s:7:\"Tagalog\";s:11:\"native_name\";s:7:\"Tagalog\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.8.25/tl.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tl\";i:2;s:3:\"tgl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Magpatuloy\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-14 07:22:59\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"tt_RU\";a:8:{s:8:\"language\";s:5:\"tt_RU\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-20 20:20:50\";s:12:\"english_name\";s:5:\"Tatar\";s:11:\"native_name\";s:19:\"Татар теле\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/tt_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tt\";i:2;s:3:\"tat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"дәвам итү\";}}s:3:\"tah\";a:8:{s:8:\"language\";s:3:\"tah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-06 18:39:39\";s:12:\"english_name\";s:8:\"Tahitian\";s:11:\"native_name\";s:10:\"Reo Tahiti\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/tah.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ty\";i:2;s:3:\"tah\";i:3;s:3:\"tah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-18 17:37:18\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:16:\"ئۇيغۇرچە\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2024-03-06 18:52:07\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.5/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:2:\"ur\";a:8:{s:8:\"language\";s:2:\"ur\";s:7:\"version\";s:6:\"5.4.16\";s:7:\"updated\";s:19:\"2020-04-09 11:17:33\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:8:\"اردو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.4.16/ur.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ur\";i:2;s:3:\"urd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"جاری رکھیں\";}}s:5:\"uz_UZ\";a:8:{s:8:\"language\";s:5:\"uz_UZ\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-02-28 12:02:22\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:11:\"O‘zbekcha\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/uz_UZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uz\";i:2;s:3:\"uzb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Davom etish\";}}s:2:\"vi\";a:8:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-20 13:04:32\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/vi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Tiếp tục\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-21 08:38:08\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-24 10:26:45\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}s:5:\"zh_HK\";a:8:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2022-07-15 15:25:03\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:12:\"香港中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.6/zh_HK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}}", "off");
INSERT INTO `wp_options` VALUES("446", "_site_transient_timeout_community-events-d41d8cd98f00b204e9800998ecf8427e", "1732564797", "off");
INSERT INTO `wp_options` VALUES("447", "_site_transient_community-events-d41d8cd98f00b204e9800998ecf8427e", "a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";b:0;}s:6:\"events\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("448", "_transient_timeout_feed_0d2db5fea5a8633b56992c916819b198", "1732564799", "off");
INSERT INTO `wp_options` VALUES("449", "_transient_feed_0d2db5fea5a8633b56992c916819b198", "a:6:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:52:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"Actualités – WordPress.org Français\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://fr.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 12 Nov 2024 23:39:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"fr-FR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=6.8-alpha-59456\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://s.w.org/favicon.ico?2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"Actualités – WordPress.org Français\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://fr.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"WordPress 6.7 « Rollins »\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://fr.wordpress.org/2024/11/12/wordpress-6-7-rollins/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 12 Nov 2024 23:14:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3255\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:377:\"Chaque version de WordPress célèbre un ou une artiste ayant posé son empreinte sur le monde la musique. WordPress 6.7 « Rollins » rend hommage au saxophoniste de jazz Sonny Rollins. Connu comme l’un des plus grands improvisateurs du jazz, Rollins a influencé des générations de musiciens avec sa technique, son esprit d&#8217;innovation et son approche de [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:69260:\"\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2024/11/Release-Edition-Featured-Image-1024x535.png\" alt=\"\" class=\"wp-image-18085\" /></figure>\n\n\n\n<p>Chaque version de WordPress célèbre un ou une artiste ayant posé son empreinte sur le monde la musique. WordPress 6.7 « Rollins » rend hommage au saxophoniste de jazz Sonny Rollins. Connu comme l’un des plus grands improvisateurs du jazz, Rollins a influencé des générations de musiciens avec sa technique, son esprit d&rsquo;innovation et son approche de l&rsquo;expression musicale.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Bienvenue sur WordPress&nbsp;6.7&nbsp;!</h2>\n\n\n\n<p>WordPress 6.7 introduit le nouveau thème <bdo lang=\"en\" dir=\"ltr\"><em>Twenty Twenty-Five</em></bdo>, qui offre une flexibilité de conception ultime pour tous les sites et blogs. Vous pourrez gérer la typographie de votre site comme jamais auparavant. Les nouvelles fonctionnalités de zoom arrière vous permettront de concevoir votre site avec une vue macroscopique pour prendre du recul sur les détails de votre projet.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://fr.wordpress.org/latest-fr_FR.zip\" target=\"_blank\" rel=\"noreferrer noopener\">Télécharger WordPress 6.7 «&nbsp;Rollins&nbsp;» en français (ZIP – 19,1 Mo)</a></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Présentation du nouveau thème <bdo lang=\"en\" dir=\"ltr\">Twenty Twenty-Five</bdo></h2>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Une infinité de possibilités sans complexité</p>\n</blockquote>\n\n\n\n<p><bdo lang=\"en\" dir=\"ltr\">Twenty Twenty-Five</bdo> est un thème polyvalent, axé sur le design, qui vous permet de créer des sites époustouflants en toute simplicité. Personnalisez votre esthétisme grâce à un éventail d‘options de style, de compositions de blocs et de palettes de couleurs. Réduit à l‘essentiel, c‘est un thème qui peut vraiment évoluer avec vous.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.7/feature-tt5-2.webp\" alt=\"\" style=\"object-fit:cover\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Obtenez une vue d’ensemble en dézoomant</h3>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Explorez votre contenu sous un nouvel angle</p>\n</blockquote>\n\n\n\n<p>Modifiez et organisez des sections entières de votre contenu comme jamais auparavant. Une vue plus large de votre site vous permet d‘ajouter, de modifier, de mélanger ou de supprimer des compositions à votre guise. Laissez s‘exprimer l‘architecte qui est en vous.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.7/feature-zoom-2.webp\" alt=\"\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Connectez des blocs et des champs personnalisés sans souci (et sans coder)</h3>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Une manière simplifiée de créer du contenu dynamique</p>\n</blockquote>\n\n\n\n<p>Cette fonctionnalité introduit une nouvelle interface pour connecter des blocs à des champs personnalisés. Cela vous donne le contrôle d’éléments dynamiques directement dans l’éditeur. Vous pouvez relier des blocs à des champs en quelques clics, ce qui améliore la flexibilité et l’efficacité de ces actions. Vos clients vont adorer ça.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.7/feature-block-bindings-2.webp\" alt=\"\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Laissez s’exprimer votre passion pour la typographie</h3>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Nouvelle section de styles, nouvelles possibilités</p>\n</blockquote>\n\n\n\n<p>Créez, modifiez, retirez et appliquez des préréglages de taille de police avec le dernier apport à l’interface des Styles. Surchargez le thème par défaut ou créez votre propre taille de police personnalisée, avec une typographie dynamique pour un redimensionnement responsive des polices. Prenez soin des détails&nbsp;!</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.7/feature-font-presets-2.png\" alt=\"\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Améliorations des performances</h3>\n\n\n\n<p>WordPress 6.7 propose d’importantes mises à jour en matière de performances, notamment un chargement plus rapide des compositions, des aperçus optimisés pour le composant des vues de données, une meilleure prise en charge de PHP 8 et plus, la suppression du code obsolète, des tailles automatiques pour les images en chargement différé, ainsi qu’un traitement plus efficace des balises dans l’API HTML.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Améliorations de l’accessibilité</h3>\n\n\n\n<p>Plus de 65 correctifs et améliorations d’accessibilité focalisées sur les aspects fondamentaux de l’expérience de WordPress, de l’amélioration des composants d’interface d’administration à la navigation clavier dans l’éditeur, en passant par des niveaux de titres plus accessibles dans les écrans de connexion et de meilleurs libellés.</p>\n\n\n\n<h2 class=\"wp-block-heading\">En savoir plus sur WordPress 6.7</h2>\n\n\n\n<p><a href=\"https://learn.wordpress.org/\"><em>Learn WordPress</em></a>&nbsp;est une ressource gratuite pour les personnes qui utilisent WordPress, qu’elles soient débutantes ou expérimentées.&nbsp;<em>Learn</em>&nbsp;contient des vidéos pratiques sur l’utilisation de diverses fonctionnalités de WordPress, des&nbsp;<a href=\"https://learn.wordpress.org/online-workshops/\">évènements interactifs</a>&nbsp;pour explorer des sujets en profondeur, et des plans de cours pour approfondir des domaines spécifiques de WordPress.</p>\n\n\n\n<p>Lisez les <a href=\"https://wordpress.org/support/wordpress-version/version-6-7/\">notes de version de WordPress 6.7</a> pour obtenir des informations sur l’installation, les améliorations, les problèmes corrigés, les contributeurs et contributrices de la version, les ressources d’apprentissage et la liste des modifications apportées aux fichiers.</p>\n\n\n\n<p>Explorez le <a href=\"https://fr.wordpress.org/2024/10/28/guide-des-changements-techniques-de-wordpress-6-7/\">guide des changements techniques de WordPress 6.7</a>. Découvrez les changements de cette version avec les notes détaillées des développeurs et développeuses qui vous permettent de construire votre site avec WordPress.</p>\n\n\n\n<h2 class=\"wp-block-heading\">L’équipe de direction de WordPress&nbsp;6.7</h2>\n\n\n\n<p>Voici l’équipe qui a coordonné le développement et la sortie de cette nouvelle version de WordPress&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Direction générale&nbsp;: <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a></li>\n\n\n\n<li>Coordination de la version&nbsp;: <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a></li>\n\n\n\n<li>Direction technique&nbsp;cœur&nbsp;: <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>,&nbsp;<a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a></li>\n\n\n\n<li>Direction technique côté Gutenberg&nbsp;: <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a>,&nbsp;<a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a>,&nbsp;<a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a></li>\n\n\n\n<li>Gestion de projet côté cœur&nbsp;: <a href=\"https://profiles.wordpress.org/stoyangeorgiev/\">Stoyan Georgiev</a>, <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Kabir Chaion</a></li>\n\n\n\n<li>Gestion de projet côté Gutenberg&nbsp;: <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a>,&nbsp;<a href=\"https://wordpress.org/support/users/colorful-tones/\">Damon Cook</a></li>\n\n\n\n<li>Direction de la documentation&nbsp;: <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a>,&nbsp;<a href=\"https://profiles.wordpress.org/faguni22/\">Mumtahina Faguni</a></li>\n\n\n\n<li>Direction des tests&nbsp;: <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K. Gupta</a></li>\n\n\n\n<li>Direction artistique&nbsp;: <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a></li>\n\n\n\n<li>Direction des performances&nbsp;: <a href=\"https://profiles.wordpress.org/adamsilverstein/\"></a><a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a></li>\n\n\n\n<li>Direction du design du nouveau thème&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a></li>\n\n\n\n<li>Direction du développement du nouveau thème&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a>,&nbsp;<a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Merci aux contributeurs et contributrices</h2>\n\n\n\n<p>WordPress 6.7 n’aurait pas pu sortir sans la contribution passionnée de plus de&nbsp;<strong>780 personnes provenant de tous les pays du monde</strong>.</p>\n\n\n\n<p>Un remerciement tout spécial pour les plus de 230 personnes qui ont contribué au cœur de WordPress pour la première fois avec WP&nbsp;6.7 <img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\n\n\n<p class=\"is-style-wporg-props-long alignfull is-style-short-text has-lemon-3-background-color has-background\" style=\"font-size:12px\"><a href=\"https://profiles.wordpress.org/benniledl/\">!Benni</a> · <a href=\"https://profiles.wordpress.org/75thtrombone/\">75thtrombone</a> · <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> · <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a> · <a href=\"https://profiles.wordpress.org/aware/\">Aaron Ware</a> · <a href=\"https://profiles.wordpress.org/aatanasov/\">aatanasov</a> · <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a> · <a href=\"https://profiles.wordpress.org/abhi3315/\">abhi3315</a> · <a href=\"https://profiles.wordpress.org/fitehal/\">Abhishek Deshpande</a> · <a href=\"https://profiles.wordpress.org/ababir/\">Abir</a> · <a href=\"https://profiles.wordpress.org/acafourek/\">acafourek</a> · <a href=\"https://profiles.wordpress.org/adamkheckler/\">Adam Heckler</a> · <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> · <a href=\"https://profiles.wordpress.org/adamwood/\">Adam Wood</a> · <a href=\"https://profiles.wordpress.org/zieladam/\">Adam Zieliński</a> · <a href=\"https://profiles.wordpress.org/adarshposimyth/\">Adarsh Akshat</a> · <a href=\"https://profiles.wordpress.org/adrian2k7/\">Adrian</a> · <a href=\"https://profiles.wordpress.org/aduth/\">aduth</a> · <a href=\"https://profiles.wordpress.org/ah72king/\">ah72king</a> · <a href=\"https://profiles.wordpress.org/ahmarzaidi/\">Ahmar Zaidi</a> · <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Kabir Chaion</a> · <a href=\"https://profiles.wordpress.org/engahmeds3ed/\">Ahmed Saeed</a> · <a href=\"https://profiles.wordpress.org/ajitbohra/\">Ajit Bohra</a> · <a href=\"https://profiles.wordpress.org/akashdhawade/\">Akash Dhawade</a> · <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> · <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a> · <a href=\"https://profiles.wordpress.org/akshat2802/\">Akshat Kakkad</a> · <a href=\"https://profiles.wordpress.org/alaminfirdows/\">Al-Amin Firdows</a> · <a href=\"https://profiles.wordpress.org/alanfuller/\">Alan Fuller</a> · <a href=\"https://profiles.wordpress.org/aljullu/\">Albert Juhé Lluveras</a> · <a href=\"https://profiles.wordpress.org/alessandrotesoro/\">Alessandro Tesoro</a> · <a href=\"https://profiles.wordpress.org/ralessio/\">Alessio</a> · <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a> · <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a> · <a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a> · <a href=\"https://profiles.wordpress.org/alex27/\">alex27</a> · <a href=\"https://profiles.wordpress.org/digitalex11/\">Alexander Frank</a> · <a href=\"https://profiles.wordpress.org/alexandrebuffet/\">Alexandre Buffet</a> · <a href=\"https://profiles.wordpress.org/harlet7/\">Alexandru Horeanu</a> · <a href=\"https://profiles.wordpress.org/alexcu21/\">alexcu21</a> · <a href=\"https://profiles.wordpress.org/ali7ali/\">Ali Ali</a> · <a href=\"https://profiles.wordpress.org/aliaghdam/\">aliaghdam</a> · <a href=\"https://profiles.wordpress.org/firewatch/\">allilevine</a> · <a href=\"https://profiles.wordpress.org/mrfoxtalbot/\">Alvaro Gómez</a> · <a href=\"https://profiles.wordpress.org/alvitazwar052/\">Alvi Tazwar</a> · <a href=\"https://profiles.wordpress.org/amincharoliya/\">Amin Charoliya</a> · <a href=\"https://profiles.wordpress.org/amirthepiper/\">Amir Abbas</a> · <a href=\"https://profiles.wordpress.org/amitraj2203/\">Amit Raj</a> · <a href=\"https://profiles.wordpress.org/amjadr360/\">Amjad Ali</a> · <a href=\"https://profiles.wordpress.org/anthakkar08/\">Anand Thakkar</a> · <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a> · <a href=\"https://profiles.wordpress.org/awetz583/\">Andrea Roenning</a> · <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a> · <a href=\"https://profiles.wordpress.org/euthelup/\">Andrei Lupu</a> · <a href=\"https://profiles.wordpress.org/andreiglingeanu/\">andreiglingeanu</a> · <a href=\"https://profiles.wordpress.org/andrewhayward/\">Andrew Hayward</a> · <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> · <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a> · <a href=\"https://profiles.wordpress.org/rarst/\">Andrey “Rarst” Savchenko</a> · <a href=\"https://profiles.wordpress.org/oandregal/\">André Maneiro</a> · <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a> · <a href=\"https://profiles.wordpress.org/la-geek/\">Angelika Reisiger</a> · <a href=\"https://profiles.wordpress.org/aniketpatel/\">Aniket Patel</a> · <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a> · <a href=\"https://profiles.wordpress.org/ankit k gupta/\">Ankit K. Gupta</a> · <a href=\"https://profiles.wordpress.org/ankitkumarshah/\">Ankit Kumar Shah</a> · <a href=\"https://profiles.wordpress.org/the-ank/\">Ankur Vishwakarma</a> · <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a> · <a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a> · <a href=\"https://profiles.wordpress.org/ahortin/\">Anthony Hortin</a> · <a href=\"https://profiles.wordpress.org/ant1busted/\">Antoine</a> · <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a> · <a href=\"https://profiles.wordpress.org/antoniosejas/\">Antonio Sejas</a> · <a href=\"https://profiles.wordpress.org/apmeyer/\">apmeyer</a> · <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a> · <a href=\"https://profiles.wordpress.org/perezcarreno/\">Armando J. Perez Carreno</a> · <a href=\"https://profiles.wordpress.org/armandsdz/\">Armands</a> · <a href=\"https://profiles.wordpress.org/arnaudbroes/\">arnaudbroes</a> · <a href=\"https://profiles.wordpress.org/ambrosiawt/\">Art Smith</a> · <a href=\"https://profiles.wordpress.org/artemiosans/\">Artemio Morales</a> · <a href=\"https://profiles.wordpress.org/arthur791004/\">Arthur Chu</a> · <a href=\"https://profiles.wordpress.org/arypneta/\">arypneta</a> · <a href=\"https://profiles.wordpress.org/asafm7/\">asafm7</a> · <a href=\"https://profiles.wordpress.org/aslamdoctor/\">Aslam Doctor</a> · <a href=\"https://profiles.wordpress.org/nmutua/\">Autumn</a> · <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a> · <a href=\"https://profiles.wordpress.org/bjerke-johannessen/\">Bård Bjerke Johannessen</a> · <a href=\"https://profiles.wordpress.org/beryldlg/\">Béryl de La Grandière</a> · <a href=\"https://profiles.wordpress.org/balub/\">Balu B</a> · <a href=\"https://profiles.wordpress.org/barryceelen/\">Barry Ceelen</a> · <a href=\"https://profiles.wordpress.org/bartkalisz/\">Bart Kalisz</a> · <a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a> · <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a> · <a href=\"https://profiles.wordpress.org/rainbowgeek/\">Benjamin Denis</a> · <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a> · <a href=\"https://profiles.wordpress.org/benoitchantre/\">Benoit Chantre</a> · <a href=\"https://profiles.wordpress.org/kau-boy/\">Bernhard Kau</a> · <a href=\"https://profiles.wordpress.org/bernhard reiter/\">Bernhard Reiter</a> · <a href=\"https://profiles.wordpress.org/neoxx/\">Bernhard Riedl</a> · <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">bernhard-reiter</a> · <a href=\"https://profiles.wordpress.org/berubenic/\">berubenic</a> · <a href=\"https://profiles.wordpress.org/bhaveshdesai13/\">Bhavesh</a> · <a href=\"https://profiles.wordpress.org/bijit027/\">bijit027</a> · <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a> · <a href=\"https://profiles.wordpress.org/blindmikey/\">blindmikey</a> · <a href=\"https://profiles.wordpress.org/bobbyleenoblestudios/\">bobbyleenoblestudios</a> · <a href=\"https://profiles.wordpress.org/bogdannikolic/\">Bogdan Nikolic</a> · <a href=\"https://profiles.wordpress.org/veryard/\">Brad</a> · <a href=\"https://profiles.wordpress.org/bradley2083/\">brad hogan</a> · <a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a> · <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a> · <a href=\"https://profiles.wordpress.org/brentjettgmailcom/\">Brent Jett</a> · <a href=\"https://profiles.wordpress.org/brettshumaker/\">Brett Shumaker</a> · <a href=\"https://profiles.wordpress.org/ironprogrammer/\">Brian Alexander</a> · <a href=\"https://profiles.wordpress.org/bacoords/\">Brian Coords</a> · <a href=\"https://profiles.wordpress.org/bgardner/\">Brian Gardner</a> · <a href=\"https://profiles.wordpress.org/bgosnell/\">Brian Gosnell</a> · <a href=\"https://profiles.wordpress.org/brianhenryie/\">Brian Henry</a> · <a href=\"https://profiles.wordpress.org/bridgetwes/\">bridgetwes</a> · <a href=\"https://profiles.wordpress.org/brobken/\">brobken</a> · <a href=\"https://profiles.wordpress.org/freibergergarcia/\">Bruno Freiberger Garcia</a> · <a href=\"https://profiles.wordpress.org/cambabutonono/\">Cambabutonono</a> · <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> · <a href=\"https://profiles.wordpress.org/carlosgprim/\">Carlos G. P.</a> · <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> · <a href=\"https://profiles.wordpress.org/carstenbach/\">Carsten Bach</a> · <a href=\"https://profiles.wordpress.org/cbirdsong/\">cbirdsong</a> · <a href=\"https://profiles.wordpress.org/mchirag2002/\">Chirag Mathur</a> · <a href=\"https://profiles.wordpress.org/chrico/\">ChriCo</a> · <a href=\"https://profiles.wordpress.org/jazzs3quence/\">Chris Reynolds</a> · <a href=\"https://profiles.wordpress.org/eclare/\">Chris Trynkiewicz (Sukces Strony)</a> · <a href=\"https://profiles.wordpress.org/apermo/\">Christoph Daum</a> · <a href=\"https://profiles.wordpress.org/cfinke/\">Christopher Finke</a> · <a href=\"https://profiles.wordpress.org/ckanitz/\">Christopher Kanitz</a> · <a href=\"https://profiles.wordpress.org/nyiriland/\">Christy Nyiri</a> · <a href=\"https://profiles.wordpress.org/butterflymedia/\">Ciprian</a> · <a href=\"https://profiles.wordpress.org/codersantosh/\">codersantosh</a> · <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a> · <a href=\"https://profiles.wordpress.org/coreyw/\">Corey Worrell</a> · <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Robertson</a> · <a href=\"https://profiles.wordpress.org/craynor/\">craynor</a> · <a href=\"https://profiles.wordpress.org/creativethemeshq/\">creativethemeshq</a> · <a href=\"https://profiles.wordpress.org/cwhitmore/\">Cullen Whitmore</a> · <a href=\"https://profiles.wordpress.org/cu121/\">Cupid Chakma</a> · <a href=\"https://profiles.wordpress.org/cweiske/\">cweiske</a> · <a href=\"https://profiles.wordpress.org/coquardcyr/\">Cyrille</a> · <a href=\"https://profiles.wordpress.org/da5f656f/\">da5f656f</a> · <a href=\"https://profiles.wordpress.org/xendo/\">Dademaru</a> · <a href=\"https://profiles.wordpress.org/daleharrison/\">daleharrison</a> · <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/colorful tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/daniguardiola/\">Dani Guardiola</a> · <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a> · <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a> · <a href=\"https://profiles.wordpress.org/itsdanny/\">Danny</a> · <a href=\"https://profiles.wordpress.org/dannyreaktiv/\">dannyreaktiv</a> · <a href=\"https://profiles.wordpress.org/darerodz/\">darerodz</a> · <a href=\"https://profiles.wordpress.org/d-signed/\">Dareth NHANG</a> · <a href=\"https://profiles.wordpress.org/nerrad/\">Darren Ethier (nerrad)</a> · <a href=\"https://profiles.wordpress.org/darshitrajyaguru97/\">Darshit Rajyaguru</a> · <a href=\"https://profiles.wordpress.org/daveagp/\">daveagp</a> · <a href=\"https://profiles.wordpress.org/fac3less/\">David</a> · <a href=\"https://profiles.wordpress.org/dballari/\">David Ballarin Prunera</a> · <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> · <a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a> · <a href=\"https://profiles.wordpress.org/davidabowman/\">David Bowman</a> · <a href=\"https://profiles.wordpress.org/davidhbrown/\">David Brown</a> · <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a> · <a href=\"https://profiles.wordpress.org/davidgodleman10up/\">David Godleman</a> · <a href=\"https://profiles.wordpress.org/dhenriet/\">David Henriet</a> · <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> · <a href=\"https://profiles.wordpress.org/justlevine/\">David Levine</a> · <a href=\"https://profiles.wordpress.org/daviedr/\">David Rozando</a> · <a href=\"https://profiles.wordpress.org/dshanske/\">David Shanske</a> · <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> · <a href=\"https://profiles.wordpress.org/ddewan/\">ddewan</a> · <a href=\"https://profiles.wordpress.org/dsas/\">Dean Sas</a> · <a href=\"https://profiles.wordpress.org/debarghyabanerjee/\">DEBARGHYA BANERJEE</a> · <a href=\"https://profiles.wordpress.org/deepakrohilla/\">Deepak Rohilla</a> · <a href=\"https://profiles.wordpress.org/deepakvijayan/\">Deepak Vijayan</a> · <a href=\"https://profiles.wordpress.org/dekadinious/\">Dekadinious</a> · <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a> · <a href=\"https://profiles.wordpress.org/dsmart/\">Derek Smart</a> · <a href=\"https://profiles.wordpress.org/deryck/\">Deryck</a> · <a href=\"https://profiles.wordpress.org/designsimply/\">designsimply</a> · <a href=\"https://profiles.wordpress.org/devansh2002/\">Devansh Chaudhary</a> · <a href=\"https://profiles.wordpress.org/devspace/\">devspace</a> · <a href=\"https://profiles.wordpress.org/dhananjaykuber/\">Dhananjay Kuber</a> · <a href=\"https://profiles.wordpress.org/dharm1025/\">Dharmesh Patel</a> · <a href=\"https://profiles.wordpress.org/dhrumilk/\">Dhrumil Kumbhani</a> · <a href=\"https://profiles.wordpress.org/dhruval04/\">Dhruval Shah</a> · <a href=\"https://profiles.wordpress.org/dhruvang21/\">Dhruvang21</a> · <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> · <a href=\"https://profiles.wordpress.org/dilip2615/\">Dilip Modhavadiya</a> · <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a> · <a href=\"https://profiles.wordpress.org/divibanks/\">Divi Banks</a> · <a href=\"https://profiles.wordpress.org/djcowan/\">dj.cowan</a> · <a href=\"https://profiles.wordpress.org/djennez/\">djennez</a> · <a href=\"https://profiles.wordpress.org/cyberorca/\">Doni Kuntoro</a> · <a href=\"https://profiles.wordpress.org/dorzki/\">Dor Zuberi</a> · <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a> · <a href=\"https://profiles.wordpress.org/drivingralle/\">Drivingralle</a> · <a href=\"https://profiles.wordpress.org/drzraf/\">drzraf</a> · <a href=\"https://profiles.wordpress.org/elrae/\">Earle Davies</a> · <a href=\"https://profiles.wordpress.org/eballeste/\">eballeste</a> · <a href=\"https://profiles.wordpress.org/eclev91/\">eclev91</a> · <a href=\"https://profiles.wordpress.org/beckej/\">Ed Beck</a> · <a href=\"https://profiles.wordpress.org/ejnwebmaster/\">ejnwebmaster</a> · <a href=\"https://profiles.wordpress.org/elfu98/\">elfu98</a> · <a href=\"https://profiles.wordpress.org/eliorivero/\">Elio Rivero</a> · <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van&nbsp;Durpe</a> · <a href=\"https://profiles.wordpress.org/erichmond/\">Elliott Richmond</a> · <a href=\"https://profiles.wordpress.org/eatse/\">Emmanue ATSÉ</a> · <a href=\"https://profiles.wordpress.org/manooweb/\">Emmanuel Hesry</a> · <a href=\"https://profiles.wordpress.org/emmanuel78/\">emmanuel78</a> · <a href=\"https://profiles.wordpress.org/lopo/\">Enrico Battocchi</a> · <a href=\"https://profiles.wordpress.org/nrqsnchz/\">Enrique Sánchez</a> · <a href=\"https://profiles.wordpress.org/ericdye/\">Eric Dye</a> · <a href=\"https://profiles.wordpress.org/kebbet/\">Erik</a> · <a href=\"https://profiles.wordpress.org/erikiva/\">erikiva</a> · <a href=\"https://profiles.wordpress.org/erikyo/\">erikyo</a> · <a href=\"https://profiles.wordpress.org/eherman24/\">Evan Herman</a> · <a href=\"https://profiles.wordpress.org/circlecube/\">Evan Mullins</a> · <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a> · <a href=\"https://profiles.wordpress.org/fabiorubioglio/\">Fabio Rubioglio</a> · <a href=\"https://profiles.wordpress.org/fahimmurshed/\">FahimMurshed</a> · <a href=\"https://profiles.wordpress.org/faisalahammad/\">Faisal Ahammad</a> · <a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a> · <a href=\"https://profiles.wordpress.org/fazyshah/\">Faizan Nabi</a> · <a href=\"https://profiles.wordpress.org/iamfarhan09/\">Farhan Ahmed</a> · <a href=\"https://profiles.wordpress.org/fayyazfayzi/\">Fayyaz</a> · <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> · <a href=\"https://profiles.wordpress.org/ffffelix/\">Felix Renicks</a> · <a href=\"https://profiles.wordpress.org/fjorgemota/\">Fernando Jorge Mota (a11n)</a> · <a href=\"https://profiles.wordpress.org/firoz2456/\">Firoz Sabaliya</a> · <a href=\"https://profiles.wordpress.org/fcoveram/\">Francisco</a> · <a href=\"https://profiles.wordpress.org/franz00/\">Fransisca H</a> · <a href=\"https://profiles.wordpress.org/fullworks/\">fullworks</a> · <a href=\"https://profiles.wordpress.org/gwallace87/\">Gale Wallace</a> · <a href=\"https://profiles.wordpress.org/gansbrest/\">gansbrest</a> · <a href=\"https://profiles.wordpress.org/garethelwell/\">Gareth Elwell</a> · <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a> · <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a> · <a href=\"https://profiles.wordpress.org/gauravtiwari/\">Gaurav Tiwari</a> · <a href=\"https://profiles.wordpress.org/gauravsingh7/\">gauravsingh7</a> · <a href=\"https://profiles.wordpress.org/georgwordpress/\">Georg</a> · <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> · <a href=\"https://profiles.wordpress.org/geriux/\">Gerardo Pacheco</a> · <a href=\"https://profiles.wordpress.org/germanfrelo/\">Germán Freixinós</a> · <a href=\"https://profiles.wordpress.org/gmariani405/\">gmariani405</a> · <a href=\"https://profiles.wordpress.org/graemef/\">GraemeF</a> · <a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a> · <a href=\"https://profiles.wordpress.org/greentreefrog/\">greentreefrog</a> · <a href=\"https://profiles.wordpress.org/greenworld/\">GreenWorld</a> · <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a> · <a href=\"https://profiles.wordpress.org/wido/\">Guido Scialfa</a> · <a href=\"https://profiles.wordpress.org/gyurmey/\">Gyurmey</a> · <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> · <a href=\"https://profiles.wordpress.org/halilesen/\">Halil ESEN</a> · <a href=\"https://profiles.wordpress.org/hanneslsm/\">hanneslsm</a> · <a href=\"https://profiles.wordpress.org/hage/\">Hans-Gerd Gerhards</a> · <a href=\"https://profiles.wordpress.org/hardipparmar/\">Hardip Parmar</a> · <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh S</a> · <a href=\"https://profiles.wordpress.org/plaidharper/\">Harper Holsinger</a> · <a href=\"https://profiles.wordpress.org/harshgajipara/\">Harsh Gajipara</a> · <a href=\"https://profiles.wordpress.org/harshvaishnav/\">harshvaishnav</a> · <a href=\"https://profiles.wordpress.org/hazdiego/\">Haz</a> · <a href=\"https://profiles.wordpress.org/hectorjarquin/\">hectorjarquin</a> · <a href=\"https://profiles.wordpress.org/hedgefield/\">hedgefield</a> · <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a> · <a href=\"https://profiles.wordpress.org/iamarinoh/\">Henrique Iamarino</a> · <a href=\"https://profiles.wordpress.org/abcd95/\">Himanshu Pathak</a> · <a href=\"https://profiles.wordpress.org/hirschferkel/\">hirschferkel</a> · <a href=\"https://profiles.wordpress.org/hbhalodia/\">Hit Bhalodia</a> · <a href=\"https://profiles.wordpress.org/h71/\">Hossein</a> · <a href=\"https://profiles.wordpress.org/htmgarcia/\">htmgarcia</a> · <a href=\"https://profiles.wordpress.org/huubl/\">huubl</a> · <a href=\"https://profiles.wordpress.org/huzaifaalmesbah/\">Huzaifa Al Mesbah</a> · <a href=\"https://profiles.wordpress.org/kardi420/\">Ibrahim</a> · <a href=\"https://profiles.wordpress.org/ibrahimriaz/\">Ibrahim Riaz</a> · <a href=\"https://profiles.wordpress.org/imranh920/\">Imran Hossain (a11n)</a> · <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> · <a href=\"https://profiles.wordpress.org/itpathsolutions/\">IT Path Solutions</a> · <a href=\"https://profiles.wordpress.org/itapress/\">itapress</a> · <a href=\"https://profiles.wordpress.org/ivanottinger/\">Ivan Ottinger</a> · <a href=\"https://profiles.wordpress.org/jpstevens/\">Jack Stevens</a> · <a href=\"https://profiles.wordpress.org/jacobcassidy/\">Jacob Cassidy</a> · <a href=\"https://profiles.wordpress.org/smithjw1/\">Jacob Smith</a> · <a href=\"https://profiles.wordpress.org/jagirbahesh/\">jagirbahesh</a> · <a href=\"https://profiles.wordpress.org/jainil07/\">Jainil Shah</a> · <a href=\"https://profiles.wordpress.org/jtgreyd/\">Jakob Trost</a> · <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a> · <a href=\"https://profiles.wordpress.org/jamesosborne/\">James Osborne</a> · <a href=\"https://profiles.wordpress.org/jamesros161/\">James Rosado</a> · <a href=\"https://profiles.wordpress.org/jwgoedert/\">James Wesley Goedert</a> · <a href=\"https://profiles.wordpress.org/janpfeil/\">Jan Pfeil</a> · <a href=\"https://profiles.wordpress.org/janak007/\">janak Kaneriya</a> · <a href=\"https://profiles.wordpress.org/jsnajdr/\">Jarda Snajdr</a> · <a href=\"https://profiles.wordpress.org/jarekmorawski/\">jarekmorawski</a> · <a href=\"https://profiles.wordpress.org/ipajen/\">Jarko Piironen</a> · <a href=\"https://profiles.wordpress.org/jasonbahl/\">Jason Bahl</a> · <a href=\"https://profiles.wordpress.org/madtownlems/\">Jason LeMahieu (MadtownLems)</a> · <a href=\"https://profiles.wordpress.org/javad2000/\">javad2000</a> · <a href=\"https://profiles.wordpress.org/javiarce/\">Javier Arce</a> · <a href=\"https://profiles.wordpress.org/jawadwp/\">Jawad Malik</a> · <a href=\"https://profiles.wordpress.org/topdownjimmy/\">Jay</a> · <a href=\"https://profiles.wordpress.org/jayadevankbh/\">Jayadevan k</a> · <a href=\"https://profiles.wordpress.org/drjosh07/\">jbrya029</a> · <a href=\"https://profiles.wordpress.org/jdahir0789/\">JD Ahir</a> · <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a> · <a href=\"https://profiles.wordpress.org/krokodok/\">Jeff Chi</a> · <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a> · <a href=\"https://profiles.wordpress.org/cheffheid/\">Jeffrey de Wit</a> · <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a> · <a href=\"https://profiles.wordpress.org/jenilk/\">Jenil Kanani</a> · <a href=\"https://profiles.wordpress.org/jennifarhat/\">Jennifer Farhat</a> · <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> · <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a> · <a href=\"https://profiles.wordpress.org/jeherve/\">Jeremy Herve</a> · <a href=\"https://profiles.wordpress.org/jeryj/\">Jerry Jones</a> · <a href=\"https://profiles.wordpress.org/skobe/\">Jesko Bendmann</a> · <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a> · <a href=\"https://profiles.wordpress.org/jetaldobariya1/\">jetaldobariya1</a> · <a href=\"https://profiles.wordpress.org/jigar9998/\">Jigar Panchal</a> · <a href=\"https://profiles.wordpress.org/jimmyh61/\">jimmyh61</a> · <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> · <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a> · <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> · <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a> · <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> · <a href=\"https://profiles.wordpress.org/johnillo/\">John Espiritu</a> · <a href=\"https://profiles.wordpress.org/johnny5/\">John Godley</a> · <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a> · <a href=\"https://profiles.wordpress.org/johnregan3/\">John Regan</a> · <a href=\"https://profiles.wordpress.org/lwangaman/\">JohnRDOrazio</a> · <a href=\"https://profiles.wordpress.org/jonsurrell/\">Jon Surrell</a> · <a href=\"https://profiles.wordpress.org/elbsegler/\">Jonas</a> · <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a> · <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> · <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a> · <a href=\"https://profiles.wordpress.org/jonnywatersbb/\">Jonny Waters</a> · <a href=\"https://profiles.wordpress.org/jordesign/\">jordesign</a> · <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> · <a href=\"https://profiles.wordpress.org/josklever/\">Jos Klever</a> · <a href=\"https://profiles.wordpress.org/josevarghese/\">Jose Varghese</a> · <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha</a> · <a href=\"https://profiles.wordpress.org/verygoode/\">Joshua Goode</a> · <a href=\"https://profiles.wordpress.org/jossnaz/\">Jossnaz</a> · <a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a> · <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a> · <a href=\"https://profiles.wordpress.org/julianoe/\">julianoe</a> · <a href=\"https://profiles.wordpress.org/juliemoynat/\">Julie Moynat</a> · <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a> · <a href=\"https://profiles.wordpress.org/junedsabaliya/\">Juned Sabaliya</a> · <a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a> · <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a> · <a href=\"https://profiles.wordpress.org/kaavyaiyer/\">Kaavya Iyer (woo-hc)</a> · <a href=\"https://profiles.wordpress.org/arkenon/\">Kadim Gültekin</a> · <a href=\"https://profiles.wordpress.org/kafleg/\">KafleG</a> · <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a> · <a href=\"https://profiles.wordpress.org/kajalgohel/\">Kajal Gohel</a> · <a href=\"https://profiles.wordpress.org/ikamal/\">Kamal Hosen</a> · <a href=\"https://profiles.wordpress.org/kamran8176/\">Kamran Hussen</a> · <a href=\"https://profiles.wordpress.org/karan4word/\">Karan Gupta</a> · <a href=\"https://profiles.wordpress.org/karolmanijak/\">Karol Manijak</a> · <a href=\"https://profiles.wordpress.org/thekt12/\">Karthik Thayyil</a> · <a href=\"https://profiles.wordpress.org/kartikmehta/\">Kartik Mehta</a> · <a href=\"https://profiles.wordpress.org/kartik-suthar/\">Kartik Suthar</a> · <a href=\"https://profiles.wordpress.org/kbrownkd/\">kbrownkd (a11n)</a> · <a href=\"https://profiles.wordpress.org/keffr3n/\">Keffr3n</a> · <a href=\"https://profiles.wordpress.org/kel-dc/\">Kel Santiago-Pilarski</a> · <a href=\"https://profiles.wordpress.org/kellenmace/\">Kellen Mace</a> · <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/keoshi/\">keoshi</a> · <a href=\"https://profiles.wordpress.org/kevinb/\">Kevin Behrens</a> · <a href=\"https://profiles.wordpress.org/ktaron/\">Kevin Taron</a> · <a href=\"https://profiles.wordpress.org/kevinswalsh/\">kevinswalsh</a> · <a href=\"https://profiles.wordpress.org/khokansardar/\">Khokan Sardar</a> · <a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a> · <a href=\"https://profiles.wordpress.org/kishanjasani/\">Kishan Jasani</a> · <a href=\"https://profiles.wordpress.org/kisquian/\">kisquian</a> · <a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a> · <a href=\"https://profiles.wordpress.org/kkmuffme/\">kkmuffme</a> · <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a> · <a href=\"https://profiles.wordpress.org/kowsar89/\">Kowsar Hossain</a> · <a href=\"https://profiles.wordpress.org/kracked888/\">kracked888</a> · <a href=\"https://profiles.wordpress.org/krishneup/\">Krishna Neupane</a> · <a href=\"https://profiles.wordpress.org/kristastevens/\">kristastevens</a> · <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a> · <a href=\"https://profiles.wordpress.org/krupalpanchal/\">Krupal Panchal</a> · <a href=\"https://profiles.wordpress.org/kmadhak/\">Kunal Madhak</a> · <a href=\"https://profiles.wordpress.org/gohelkunjan/\">Kunjan Gohel</a> · <a href=\"https://profiles.wordpress.org/kurtpayne/\">Kurt Payne</a> · <a href=\"https://profiles.wordpress.org/kushang78/\">Kushang Tailor</a> · <a href=\"https://profiles.wordpress.org/mlaetitia/\">Lae</a> · <a href=\"https://profiles.wordpress.org/notlaura/\">Lara Schenck</a> · <a href=\"https://profiles.wordpress.org/lastsplash/\">lastsplash (a11n)</a> · <a href=\"https://profiles.wordpress.org/newyorkerlaura/\">Laura Byrne</a> · <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a> · <a href=\"https://profiles.wordpress.org/oncecoupled/\">Lauren</a> · <a href=\"https://profiles.wordpress.org/laranz/\">Lawrence Joe</a> · <a href=\"https://profiles.wordpress.org/leemon/\">leemon</a> · <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> · <a href=\"https://profiles.wordpress.org/lgladdy/\">Liam Gladdy</a> · <a href=\"https://profiles.wordpress.org/lifelightweb/\">lifelightweb</a> · <a href=\"https://profiles.wordpress.org/rudlinkon/\">Linkon Miyan</a> · <a href=\"https://profiles.wordpress.org/linsoftware/\">Linnea Huxford</a> · <a href=\"https://profiles.wordpress.org/liviopv/\">liviopv</a> · <a href=\"https://profiles.wordpress.org/louiswol94/\">Louis Wolmarans</a> · <a href=\"https://profiles.wordpress.org/louwie17/\">Lourens</a> · <a href=\"https://profiles.wordpress.org/lovesoni1999/\">Love Soni</a> · <a href=\"https://profiles.wordpress.org/crixu/\">Lucas</a> · <a href=\"https://profiles.wordpress.org/gigitux/\">Luigi Teschio</a> · <a href=\"https://profiles.wordpress.org/zaguiini/\">Luis Felipe Zaguini</a> · <a href=\"https://profiles.wordpress.org/luisherranz/\">luisherranz</a> · <a href=\"https://profiles.wordpress.org/lukasbesch/\">lukasbesch</a> · <a href=\"https://profiles.wordpress.org/lukecarbis/\">Luke Carbis</a> · <a href=\"https://profiles.wordpress.org/madhudollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/madpeter/\">madpeter</a> · <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> · <a href=\"https://profiles.wordpress.org/nadimcse/\">Mahmudul Haque Nadim</a> · <a href=\"https://profiles.wordpress.org/mai21/\">Mai</a> · <a href=\"https://profiles.wordpress.org/mkrndmane/\">Makarand G. Mane</a> · <a href=\"https://profiles.wordpress.org/manbo/\">manbo</a> · <a href=\"https://profiles.wordpress.org/maneshtimilsina/\">Manesh Timilsina</a> · <a href=\"https://profiles.wordpress.org/targz-1/\">Manuel Schmalstieg</a> · <a href=\"https://profiles.wordpress.org/manzoorwanijk/\">Manzoor Wani (a11n)</a> · <a href=\"https://profiles.wordpress.org/marianguas/\">María Anguas</a> · <a href=\"https://profiles.wordpress.org/mdxfr/\">Marc</a> · <a href=\"https://profiles.wordpress.org/marc4/\">Marc Armengou</a> · <a href=\"https://profiles.wordpress.org/mardroid/\">Marcel Tannich</a> · <a href=\"https://profiles.wordpress.org/fullofcaffeine/\">Marcelo de Moraes Serpa</a> · <a href=\"https://profiles.wordpress.org/iworks/\">Marcin Pietrzak</a> · <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a> · <a href=\"https://profiles.wordpress.org/pereirinha/\">Marco Pereirinha</a> · <a href=\"https://profiles.wordpress.org/marcwieland95/\">marcwieland95</a> · <a href=\"https://profiles.wordpress.org/igreenie/\">Marek Železný</a> · <a href=\"https://profiles.wordpress.org/margolisj/\">margolisj</a> · <a href=\"https://profiles.wordpress.org/mariayohana/\">Maria Yohana</a> · <a href=\"https://profiles.wordpress.org/plari/\">Marie</a> · <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a> · <a href=\"https://profiles.wordpress.org/santosguillamot/\">Mario Santos</a> · <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a> · <a href=\"https://profiles.wordpress.org/marius84/\">mariushosting</a> · <a href=\"https://profiles.wordpress.org/markhowellsmead/\">Mark Howells-Mead</a> · <a href=\"https://profiles.wordpress.org/markparnell/\">Mark Parnell</a> · <a href=\"https://profiles.wordpress.org/mark-k/\">Mark-k</a> · <a href=\"https://profiles.wordpress.org/mhkuu/\">Martijn van der Klis</a> · <a href=\"https://profiles.wordpress.org/martinkrcho/\">martin.krcho</a> · <a href=\"https://profiles.wordpress.org/marybaum/\">marybaum</a> · <a href=\"https://profiles.wordpress.org/mat_/\">mat_</a> · <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">Matias Benedetto</a> · <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a> · <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> · <a href=\"https://profiles.wordpress.org/mattyrob/\">Matt Robinson</a> · <a href=\"https://profiles.wordpress.org/mattormeeple/\">Matt Sherman</a> · <a href=\"https://profiles.wordpress.org/matteoenna/\">Matteo Enna</a> · <a href=\"https://profiles.wordpress.org/mboynes/\">Matthew Boynes</a> · <a href=\"https://profiles.wordpress.org/lonelyvegan/\">Matthew Riley MacPherson</a> · <a href=\"https://profiles.wordpress.org/kittmedia/\">Matthias Kittsteiner</a> · <a href=\"https://profiles.wordpress.org/mattraines/\">mattraines</a> · <a href=\"https://profiles.wordpress.org/maurodf/\">maurodf</a> · <a href=\"https://profiles.wordpress.org/mayanktripathi32/\">Mayank Tripathi</a> · <a href=\"https://profiles.wordpress.org/mayur8991/\">Mayur Prajapati</a> · <a href=\"https://profiles.wordpress.org/mcrisp1972/\">mcrisp1972</a> · <a href=\"https://profiles.wordpress.org/hmbashar/\">Md Abul Bashar</a> · <a href=\"https://profiles.wordpress.org/mhshohel/\">Md Hossain Shohel</a> · <a href=\"https://profiles.wordpress.org/istiaqhossain/\">Md. Istiaq Hossain</a> · <a href=\"https://profiles.wordpress.org/mdviralsampat/\">mdviralsampat</a> · <a href=\"https://profiles.wordpress.org/megane9988/\">megane9988</a> · <a href=\"https://profiles.wordpress.org/iammehedi1/\">Mehedi Hassan</a> · <a href=\"https://profiles.wordpress.org/mehulkaklotar/\">Mehul Kaklotar</a> · <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/meteorlxy/\">meteorlxy</a> · <a href=\"https://profiles.wordpress.org/mfgmicha/\">Micha Krapp</a> · <a href=\"https://profiles.wordpress.org/tw2113/\">Michael Beckwith</a> · <a href=\"https://profiles.wordpress.org/michaelbourne/\">Michael Bourne</a> · <a href=\"https://profiles.wordpress.org/hrkhal/\">Michael James Ilett</a> · <a href=\"https://profiles.wordpress.org/michaelpick/\">michaelpick</a> · <a href=\"https://profiles.wordpress.org/michaelwp85/\">michaelwp85</a> · <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> · <a href=\"https://profiles.wordpress.org/mielbu/\">Michelle Bulloch</a> · <a href=\"https://profiles.wordpress.org/miguelaxcar/\">Miguel Axcar</a> · <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> · <a href=\"https://profiles.wordpress.org/migueluy/\">Miguel Lezama</a> · <a href=\"https://profiles.wordpress.org/simison/\">Mikael Korpela</a> · <a href=\"https://profiles.wordpress.org/mmcalister/\">Mike McAlister</a> · <a href=\"https://profiles.wordpress.org/ritterml/\">Mike Ritter</a> · <a href=\"https://profiles.wordpress.org/mikeb8s/\">mikeb8s</a> · <a href=\"https://profiles.wordpress.org/mikeybinns/\">Mikey Binns</a> · <a href=\"https://profiles.wordpress.org/milamj/\">milamj</a> · <a href=\"https://profiles.wordpress.org/milana_cap/\">Milana Cap</a> · <a href=\"https://profiles.wordpress.org/presstoke/\">Mitchell Austin</a> · <a href=\"https://profiles.wordpress.org/mklusak/\">mklusak</a> · <a href=\"https://profiles.wordpress.org/mleathem/\">mleathem</a> · <a href=\"https://profiles.wordpress.org/mlf20/\">mlf20</a> · <a href=\"https://profiles.wordpress.org/mobarak/\">Mobarak Ali</a> · <a href=\"https://profiles.wordpress.org/mohitdadhich10/\">Mohit Dadhich</a> · <a href=\"https://profiles.wordpress.org/morganestes/\">Morgan Estes</a> · <a href=\"https://profiles.wordpress.org/mosne/\">Mosne / Paolo Tesei</a> · <a href=\"https://profiles.wordpress.org/mossy2100/\">mossy2100</a> · <a href=\"https://profiles.wordpress.org/mreishus/\">mreishus</a> · <a href=\"https://profiles.wordpress.org/devmuhib/\">Muhibul Haque</a> · <a href=\"https://profiles.wordpress.org/mujuonly/\">mujuonly</a> · <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> · <a href=\"https://profiles.wordpress.org/faguni22/\">Mumtahina Faguni</a> · <a href=\"https://profiles.wordpress.org/assassinateur/\">Nadir Seghir a11n</a> · <a href=\"https://profiles.wordpress.org/naeemhaque/\">Naeem Haque</a> · <a href=\"https://profiles.wordpress.org/nagpai/\">Nagesh Pai</a> · <a href=\"https://profiles.wordpress.org/narenin/\">Narendra Sishodiya</a> · <a href=\"https://profiles.wordpress.org/nareshbheda/\">Naresh Bheda</a> · <a href=\"https://profiles.wordpress.org/n8finch/\">Nate Finch</a> · <a href=\"https://profiles.wordpress.org/nateinaction/\">Nate Gay</a> · <a href=\"https://profiles.wordpress.org/nhrrob/\">Nazmul Hasan Robin</a> · <a href=\"https://profiles.wordpress.org/nebojsajurcic/\">Nebojša Jurčić</a> · <a href=\"https://profiles.wordpress.org/nek285/\">nek285</a> · <a href=\"https://profiles.wordpress.org/nendeb55/\">nendeb</a> · <a href=\"https://profiles.wordpress.org/neo2k23/\">neo2k23</a> · <a href=\"https://profiles.wordpress.org/neotrope/\">neotrope</a> · <a href=\"https://profiles.wordpress.org/eidolonnight/\">Nicholas Garofalo</a> · <a href=\"https://profiles.wordpress.org/nickbohle/\">Nick Bohle</a> · <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> · <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a> · <a href=\"https://profiles.wordpress.org/nick_thegeek/\">Nick the Geek</a> · <a href=\"https://profiles.wordpress.org/nicolefurlan/\">Nicole Furlan</a> · <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a> · <a href=\"https://profiles.wordpress.org/nihar007/\">Nihar Ranjan Das</a> · <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> · <a href=\"https://profiles.wordpress.org/nikitasolanki1812/\">Nikita Solanki</a> · <a href=\"https://profiles.wordpress.org/nirajgirixd/\">Niraj Giri</a> · <a href=\"https://profiles.wordpress.org/niravsherasiya7707/\">Nirav Sherasiya</a> · <a href=\"https://profiles.wordpress.org/nithi22/\">Nithin John</a> · <a href=\"https://profiles.wordpress.org/nithins53/\">Nithin SreeRaj</a> · <a href=\"https://profiles.wordpress.org/noahtallen/\">Noah Allen</a> · <a href=\"https://profiles.wordpress.org/noruzzaman/\">Noruzzaman</a> · <a href=\"https://profiles.wordpress.org/nurielmeni/\">nurielmeni</a> · <a href=\"https://profiles.wordpress.org/obliviousharmony/\">obliviousharmony</a> · <a href=\"https://profiles.wordpress.org/finalwebsites/\">Olaf Lederer</a> · <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a> · <a href=\"https://profiles.wordpress.org/domainsupport/\">Oliver Campion</a> · <a href=\"https://profiles.wordpress.org/olivierlafleur/\">Olivier Lafleur</a> · <a href=\"https://profiles.wordpress.org/alshakero/\">Omar Alshaker</a> · <a href=\"https://profiles.wordpress.org/oscarhugopaz/\">Oscar Hugo Paz</a> · <a href=\"https://profiles.wordpress.org/prestonwordsworth/\">p15h</a> · <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a> · <a href=\"https://profiles.wordpress.org/otakupahp/\">Pablo Hernández</a> · <a href=\"https://profiles.wordpress.org/pablohoneyhoney/\">Pablo Honey</a> · <a href=\"https://profiles.wordpress.org/pamprn/\">Pamela Ribeiro</a> · <a href=\"https://profiles.wordpress.org/pander/\">pander</a> · <a href=\"https://profiles.wordpress.org/pls78/\">Paolo L. Scala</a> · <a href=\"https://profiles.wordpress.org/paragoninitiativeenterprises/\">Paragon Initiative Enterprises</a> · <a href=\"https://profiles.wordpress.org/parinpanjari/\">Parin Panjari</a> · <a href=\"https://profiles.wordpress.org/parthvataliya/\">Parth vataliya</a> · <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> · <a href=\"https://profiles.wordpress.org/obrienlabs/\">Pat O’Brien</a> · <a href=\"https://profiles.wordpress.org/patricia70/\">Patricia BT</a> · <a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a> · <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a> · <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a> · <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a> · <a href=\"https://profiles.wordpress.org/paulschreiber/\">Paul Schreiber</a> · <a href=\"https://profiles.wordpress.org/paulwilde/\">Paul Wilde</a> · <a href=\"https://profiles.wordpress.org/paulcline/\">paulcline</a> · <a href=\"https://profiles.wordpress.org/paulopmt1/\">Paulo Trentin</a> · <a href=\"https://profiles.wordpress.org/pavanpatil1/\">Pavan Patil</a> · <a href=\"https://profiles.wordpress.org/pcarvalho/\">pcarvalho</a> · <a href=\"https://profiles.wordpress.org/pedromendonca/\">Pedro Mendonça</a> · <a href=\"https://profiles.wordpress.org/perryrylance/\">perryrylance</a> · <a href=\"https://profiles.wordpress.org/provenself/\">Peter Rubin</a> · <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> · <a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a> · <a href=\"https://profiles.wordpress.org/pevogam/\">pevogam</a> · <a href=\"https://profiles.wordpress.org/mr2p/\">Phi Phan</a> · <a href=\"https://profiles.wordpress.org/johnstonphilip/\">Phil Johnston</a> · <a href=\"https://profiles.wordpress.org/tyrannous/\">Philipp Bammes</a> · <a href=\"https://profiles.wordpress.org/philwebs/\">philwebs</a> · <a href=\"https://profiles.wordpress.org/nekojonez/\">Pieterjan Deneys</a> · <a href=\"https://profiles.wordpress.org/boniu91/\">Piotrek Boniu</a> · <a href=\"https://profiles.wordpress.org/pitamdey/\">Pitam Dey</a> · <a href=\"https://profiles.wordpress.org/pgeorgiev/\">Plamen Georgiev</a> · <a href=\"https://profiles.wordpress.org/pooja1210/\">Pooja N Muchandikar</a> · <a href=\"https://profiles.wordpress.org/pooja9712/\">pooja9712</a> · <a href=\"https://profiles.wordpress.org/porg/\">porg</a> · <a href=\"https://profiles.wordpress.org/ppolo99/\">ppolo99</a> · <a href=\"https://profiles.wordpress.org/praful2111/\">Praful Patel</a> · <a href=\"https://profiles.wordpress.org/pranitdugad/\">Pranit Dugad</a> · <a href=\"https://profiles.wordpress.org/pratikkry/\">Pratik Kumar</a> · <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a> · <a href=\"https://profiles.wordpress.org/prettyboymp/\">prettyboymp</a> · <a href=\"https://profiles.wordpress.org/prionkor/\">prionkor</a> · <a href=\"https://profiles.wordpress.org/pwtyler/\">pwtyler</a> · <a href=\"https://profiles.wordpress.org/rachelbaker/\">Rachel Baker</a> · <a href=\"https://profiles.wordpress.org/spanglishwebs/\">Rachel Winspear</a> · <a href=\"https://profiles.wordpress.org/rfischmann/\">Rafael Fischmann</a> · <a href=\"https://profiles.wordpress.org/rafaelgalani/\">Rafael Gallani</a> · <a href=\"https://profiles.wordpress.org/rafiq91/\">Rafiqul Islam</a> · <a href=\"https://profiles.wordpress.org/rahmatgumilar/\">Rahmat Gumilar</a> · <a href=\"https://profiles.wordpress.org/rahulharpal/\">rahulharpal</a> · <a href=\"https://profiles.wordpress.org/imrraaj/\">Raj Patel</a> · <a href=\"https://profiles.wordpress.org/rajinsharwar/\">Rajin Sharwar</a> · <a href=\"https://profiles.wordpress.org/shashwatahalder01/\">rajkumar shashwata halder</a> · <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a> · <a href=\"https://profiles.wordpress.org/rcorrales/\">Ramon Corrales</a> · <a href=\"https://profiles.wordpress.org/ramon-fincken/\">ramon fincken</a> · <a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a> · <a href=\"https://profiles.wordpress.org/ramswarup/\">Ramswarup Rathod</a> · <a href=\"https://profiles.wordpress.org/xyulex/\">Raul Martinez</a> · <a href=\"https://profiles.wordpress.org/rcneil/\">rcneil</a> · <a href=\"https://profiles.wordpress.org/realthemes/\">realthemes</a> · <a href=\"https://profiles.wordpress.org/rejaulalomkhan/\">Rejaul Alom Khan</a> · <a href=\"https://profiles.wordpress.org/renathoc/\">Renatho (a11n)</a> · <a href=\"https://profiles.wordpress.org/reputeinfosystems/\">reputeinfosystems</a> · <a href=\"https://profiles.wordpress.org/retrofox/\">retrofox</a> · <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a> · <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> · <a href=\"https://profiles.wordpress.org/rhellewellgmailcom/\">Rick Hellewell</a> · <a href=\"https://profiles.wordpress.org/riddhipatel/\">Riddhi Patel</a> · <a href=\"https://profiles.wordpress.org/rcreators/\">Rishi Mehta</a> · <a href=\"https://profiles.wordpress.org/rishishah/\">Rishi Shah</a> · <a href=\"https://profiles.wordpress.org/rishit30g/\">Rishit Gupta</a> · <a href=\"https://profiles.wordpress.org/rithik56/\">rithik56</a> · <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> · <a href=\"https://profiles.wordpress.org/robert-biswas/\">Robert Biswas</a> · <a href=\"https://profiles.wordpress.org/robertghetau/\">Robert Ghetau</a> · <a href=\"https://profiles.wordpress.org/rocketworks/\">rocket.works – Dominik Friedrich</a> · <a href=\"https://profiles.wordpress.org/rodelgc/\">Rodel Calasagsag a11n</a> · <a href=\"https://profiles.wordpress.org/rghedin/\">Rodrigo</a> · <a href=\"https://profiles.wordpress.org/rodrigosprimo/\">Rodrigo Primo</a> · <a href=\"https://profiles.wordpress.org/geekofshire/\">Rohan Jha</a> · <a href=\"https://profiles.wordpress.org/rohitmathur7/\">rohitmathur7</a> · <a href=\"https://profiles.wordpress.org/costasovo/\">Rostislav Wolný</a> · <a href=\"https://profiles.wordpress.org/roytanck/\">Roy Tanck</a> · <a href=\"https://profiles.wordpress.org/roygbyte/\">roygbyte</a> · <a href=\"https://profiles.wordpress.org/royho/\">royho</a> · <a href=\"https://profiles.wordpress.org/rpf5573/\">rpf5573</a> · <a href=\"https://profiles.wordpress.org/rslee/\">rslee</a> · <a href=\"https://profiles.wordpress.org/ruchirj/\">Ruchir Goswami</a> · <a href=\"https://profiles.wordpress.org/rayhatron/\">Rufaro Madamombe</a> · <a href=\"https://profiles.wordpress.org/ryan/\">Ryan Boren</a> · <a href=\"https://profiles.wordpress.org/rleeson/\">Ryan Leeson</a> · <a href=\"https://profiles.wordpress.org/ryancurban/\">Ryan Urban</a> · <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> · <a href=\"https://profiles.wordpress.org/sppramodh/\">S P Pramodh</a> · <a href=\"https://profiles.wordpress.org/sebastienserre/\">Sébastien SERRE</a> · <a href=\"https://profiles.wordpress.org/sergiomdgomes/\">Sérgio Gomes</a> · <a href=\"https://profiles.wordpress.org/soean/\">Sören Wünsch</a> · <a href=\"https://profiles.wordpress.org/sadmansh/\">sadmansh</a> · <a href=\"https://profiles.wordpress.org/isaeedam/\">Saeed Piri</a> · <a href=\"https://profiles.wordpress.org/mi5t4n/\">Sagar Tamang</a> · <a href=\"https://profiles.wordpress.org/sahiladit/\">sahiladit</a> · <a href=\"https://profiles.wordpress.org/sainathpoojary/\">Sainath Poojary</a> · <a href=\"https://profiles.wordpress.org/sakibmd/\">Sakib Mohammed</a> · <a href=\"https://profiles.wordpress.org/samtoohey93/\">Sam Toohey</a> · <a href=\"https://profiles.wordpress.org/samiamnot/\">samiamnot</a> · <a href=\"https://profiles.wordpress.org/viralsampat/\">Sampat Viral</a> · <a href=\"https://profiles.wordpress.org/samuelsidler/\">Samuel Sidler</a> · <a href=\"https://profiles.wordpress.org/samuelsilvapt/\">Samuel Silva</a> · <a href=\"https://profiles.wordpress.org/sannevndrmeulen/\">Sanne van der Meulen</a> · <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a> · <a href=\"https://profiles.wordpress.org/sarahricker/\">sarahricker</a> · <a href=\"https://profiles.wordpress.org/sarthaknagoshe2002/\">Sarthak Nagoshe</a> · <a href=\"https://profiles.wordpress.org/sathyapulse/\">Sathiya Venkatesan</a> · <a href=\"https://profiles.wordpress.org/satishprajapati/\">Satish Prajapati</a> · <a href=\"https://profiles.wordpress.org/sfougnier/\">Saul Fougnier</a> · <a href=\"https://profiles.wordpress.org/sauliusv/\">Saulius Vikerta</a> · <a href=\"https://profiles.wordpress.org/saxonafletcher/\">Saxon Fletcher</a> · <a href=\"https://profiles.wordpress.org/sayedulsayem/\">Sayedul Sayem</a> · <a href=\"https://profiles.wordpress.org/scholdstrom/\">scholdstrom</a> · <a href=\"https://profiles.wordpress.org/swb1192/\">Scott Buscemi</a> · <a href=\"https://profiles.wordpress.org/sc0ttkclark/\">Scott Kingsley Clark</a> · <a href=\"https://profiles.wordpress.org/coffee2code/\">Scott Reilly</a> · <a href=\"https://profiles.wordpress.org/wonderboymusic/\">Scott Taylor</a> · <a href=\"https://profiles.wordpress.org/scottculverhouse/\">scottculverhouse</a> · <a href=\"https://profiles.wordpress.org/seanavers/\">seanavers</a> · <a href=\"https://profiles.wordpress.org/seifradwane/\">Seif Radwane</a> · <a href=\"https://profiles.wordpress.org/kuuuzya/\">Sergey</a> · <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> · <a href=\"https://profiles.wordpress.org/zahardoc/\">Serhiy Zakharchenko</a> · <a href=\"https://profiles.wordpress.org/smrubenstein/\">Seth Rubenstein</a> · <a href=\"https://profiles.wordpress.org/shailu25/\">Shail Mehta</a> · <a href=\"https://profiles.wordpress.org/sh4lin/\">Shalin Shah</a> · <a href=\"https://profiles.wordpress.org/sharonaustin/\">Sharon Austin</a> · <a href=\"https://profiles.wordpress.org/sheulyshila/\">sheulyshila</a> · <a href=\"https://profiles.wordpress.org/spdft/\">Shoe</a> · <a href=\"https://profiles.wordpress.org/showravhasan/\">Showrav Hasan</a> · <a href=\"https://profiles.wordpress.org/shreya0204/\">Shreya Agarwal</a> · <a href=\"https://profiles.wordpress.org/silaskoehler/\">Silas Köhler</a> · <a href=\"https://profiles.wordpress.org/siliconforks/\">siliconforks</a> · <a href=\"https://profiles.wordpress.org/simo_m/\">Simone Maranzana</a> · <a href=\"https://profiles.wordpress.org/siobhyb/\">Siobhan</a> · <a href=\"https://profiles.wordpress.org/smerriman/\">smerriman</a> · <a href=\"https://profiles.wordpress.org/snehapatil02/\">Sneha Patil</a> · <a href=\"https://profiles.wordpress.org/sophiegy/\">Sophie – a11n</a> · <a href=\"https://profiles.wordpress.org/souptik/\">Souptik Datta</a> · <a href=\"https://profiles.wordpress.org/sourabhjain/\">Sourabh Jain</a> · <a href=\"https://profiles.wordpress.org/sourav08/\">Sourav Pahwa</a> · <a href=\"https://profiles.wordpress.org/staurand/\">staurand</a> · <a href=\"https://profiles.wordpress.org/ryokuhi/\">Stefano Minoia</a> · <a href=\"https://profiles.wordpress.org/stein2nd/\">stein2nd</a> · <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> · <a href=\"https://profiles.wordpress.org/stevenlinx/\">Steven Lin</a> · <a href=\"https://profiles.wordpress.org/thompsonsj/\">Steven Thompson</a> · <a href=\"https://profiles.wordpress.org/stoyangeorgiev/\">Stoyan Georgiev</a> · <a href=\"https://profiles.wordpress.org/styleshit/\">styleshit</a> · <a href=\"https://profiles.wordpress.org/sudipatel007/\">Sudip Dadhaniya</a> · <a href=\"https://profiles.wordpress.org/sumitbagthariya16/\">Sumit Bagthariya</a> · <a href=\"https://profiles.wordpress.org/sumitsingh/\">Sumit Singh</a> · <a href=\"https://profiles.wordpress.org/sunil25393/\">Sunil Prajapati</a> · <a href=\"https://profiles.wordpress.org/quadthemes/\">Sunny</a> · <a href=\"https://profiles.wordpress.org/superchlorine/\">superchlorine</a> · <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a> · <a href=\"https://profiles.wordpress.org/jannathsyeda/\">Syeda Fahima Jannath</a> · <a href=\"https://profiles.wordpress.org/takahashi_fumiki/\">Takahashi Fumiki</a> · <a href=\"https://profiles.wordpress.org/iamtakashi/\">Takashi Irie</a> · <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a> · <a href=\"https://profiles.wordpress.org/devtanbir/\">Tanbir Ahmod</a> · <a href=\"https://profiles.wordpress.org/tanvirul/\">Tanvirul Haque</a> · <a href=\"https://profiles.wordpress.org/voboghure/\">Tapan Kumer Das</a> · <a href=\"https://profiles.wordpress.org/taylorgorman/\">Taylor Gorman</a> · <a href=\"https://profiles.wordpress.org/tdrayson/\">tdrayson</a> · <a href=\"https://profiles.wordpress.org/iamjaydip/\">thejaydip</a> · <a href=\"https://profiles.wordpress.org/thelmachido/\">thelmachido a11n</a> · <a href=\"https://profiles.wordpress.org/themes-1/\">them.es</a> · <a href=\"https://profiles.wordpress.org/kraftner/\">Thomas Kräftner</a> · <a href=\"https://profiles.wordpress.org/thrijith/\">Thrijith Thankachan</a> · <a href=\"https://profiles.wordpress.org/sippis/\">Timi Wahalahti</a> · <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> · <a href=\"https://profiles.wordpress.org/tirth03/\">Tirth Doshi</a> · <a href=\"https://profiles.wordpress.org/tmanoilov/\">tmanoilov</a> · <a href=\"https://profiles.wordpress.org/toastercookie/\">toastercookie</a> · <a href=\"https://profiles.wordpress.org/tobiasbg/\">TobiasBg</a> · <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn “Tobi” Fjellner)</a> · <a href=\"https://profiles.wordpress.org/tomjcafferkey/\">Tom Cafferkey</a> · <a href=\"https://profiles.wordpress.org/thomasdevisser/\">Tom de Visser</a> · <a href=\"https://profiles.wordpress.org/tjnowell/\">Tom J Nowell</a> · <a href=\"https://profiles.wordpress.org/tomhine/\">tomhine</a> · <a href=\"https://profiles.wordpress.org/tomllobet/\">tomllobet</a> · <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a> · <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a> · <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a> · <a href=\"https://profiles.wordpress.org/tropicalista/\">tropicalista</a> · <a href=\"https://profiles.wordpress.org/areziaal/\">Troy Chaplin</a> · <a href=\"https://profiles.wordpress.org/truptikanzariya/\">Trupti Kanzariya</a> · <a href=\"https://profiles.wordpress.org/tunetheweb/\">tunetheweb</a> · <a href=\"https://profiles.wordpress.org/twstokes/\">twstokes</a> · <a href=\"https://profiles.wordpress.org/ugyensupport/\">Ugyen Dorji</a> · <a href=\"https://profiles.wordpress.org/umesh84/\">Umesh Gupta</a> · <a href=\"https://profiles.wordpress.org/umeshsinghin/\">Umesh Singh</a> · <a href=\"https://profiles.wordpress.org/up1512001/\">up1512001</a> · <a href=\"https://profiles.wordpress.org/ukdrahul/\">Uttam Kumar Dash</a> · <a href=\"https://profiles.wordpress.org/valer1e/\">valer1e</a> · <a href=\"https://profiles.wordpress.org/vertisoft/\">vertisoft</a> · <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a> · <a href=\"https://profiles.wordpress.org/vijaysinh9094/\">Vijaysinh Zala</a> · <a href=\"https://profiles.wordpress.org/szepeviktor/\">Viktor Szépe</a> · <a href=\"https://profiles.wordpress.org/vineet2003/\">Vinit</a> · <a href=\"https://profiles.wordpress.org/ghorivipul97/\">Vipul Ghori</a> · <a href=\"https://profiles.wordpress.org/vipulgupta003/\">Vipul Gupta</a> · <a href=\"https://profiles.wordpress.org/vipulpatil/\">vipulpatil</a> · <a href=\"https://profiles.wordpress.org/vrajadas/\">Vraja Das</a> · <a href=\"https://profiles.wordpress.org/vrishabhsk/\">vrishabhsk</a> · <a href=\"https://profiles.wordpress.org/wbdv/\">wbdv</a> · <a href=\"https://profiles.wordpress.org/webmandesign/\">WebMan Design | Oliver Juhas</a> · <a href=\"https://profiles.wordpress.org/webwurm/\">webwurm</a> · <a href=\"https://profiles.wordpress.org/wesrapyd/\">wesrapyd</a> · <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a> · <a href=\"https://profiles.wordpress.org/skorasaurus/\">Will Skora</a> · <a href=\"https://profiles.wordpress.org/williamalexander/\">William Alexander</a> · <a href=\"https://profiles.wordpress.org/williampatton/\">williampatton</a> · <a href=\"https://profiles.wordpress.org/wongjn/\">wongjn</a> · <a href=\"https://profiles.wordpress.org/wpeople/\">WPeople</a> · <a href=\"https://profiles.wordpress.org/wpsoul/\">wpsoul</a> · <a href=\"https://profiles.wordpress.org/wzieba/\">wzieba</a> · <a href=\"https://profiles.wordpress.org/xipasduarte/\">xipasduarte</a> · <a href=\"https://profiles.wordpress.org/yaniiliev/\">Yani</a> · <a href=\"https://profiles.wordpress.org/collet/\">Yann</a> · <a href=\"https://profiles.wordpress.org/yguyon/\">Yannis Guyon</a> · <a href=\"https://profiles.wordpress.org/yogeshbhutkar/\">Yogesh Bhutkar</a> · <a href=\"https://profiles.wordpress.org/ytfeldrawkcab/\">ytfeLdrawkcaB</a> · <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a> · <a href=\"https://profiles.wordpress.org/yukinobu/\">Yukinobu Asakawa</a> · <a href=\"https://profiles.wordpress.org/yuvrajsinh2211/\">Yuvrajsinh Sisodiya</a> · <a href=\"https://profiles.wordpress.org/zackkrida/\">Zack Krida</a> · <a href=\"https://profiles.wordpress.org/zeelthakkar/\">zeelthakkar</a> · <a href=\"https://profiles.wordpress.org/zitaruksergij/\">zitaruksergij</a> · <a href=\"https://profiles.wordpress.org/zunaid321/\">Zunaid Amin</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">Merci aux personnes ayant contribué à traduire WordPress&nbsp;6.7 en français</h2>\n\n\n\n<p>WordPress est un projet international et la version 6.7 est déjà complètement disponible dans plus de 40 langues différentes.</p>\n\n\n\n<p>Nous souhaitons remercier ici les personnes ayant participé à la traduction de WordPress&nbsp;6.7 en français&nbsp;:</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/jdy68\">Jenny Dupuy</a>, <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/fxbenard\">fxbenard</a>, <a href=\"https://profiles.wordpress.org/xibe\">Xavier Borderie</a>, <a href=\"https://profiles.wordpress.org/amebref\">amebref</a>, <a href=\"https://profiles.wordpress.org/beryldlg\">Béryl de La Grandière</a>, <a href=\"https://profiles.wordpress.org/chris-kns\">chris-kns</a>, <a href=\"https://profiles.wordpress.org/clementpolito\">Clément Polito</a>, <a href=\"https://profiles.wordpress.org/dfi42\">dfi42</a>, <a href=\"https://profiles.wordpress.org/eddystile\">Eddy</a>, <a href=\"https://profiles.wordpress.org/emlebrun\">Emilie LEBRUN</a>, <a href=\"https://profiles.wordpress.org/florientinneo\">Florient DELAFOY</a>, <a href=\"https://profiles.wordpress.org/karine-wendling\">karine wendling</a>, <a href=\"https://profiles.wordpress.org/laeti972\">Laetitia de Perthuis</a>, <a href=\"https://profiles.wordpress.org/wplmillet\">Laurent MILLET</a>, <a href=\"https://profiles.wordpress.org/marineevain\">Marine EVAIN</a>, <a href=\"https://profiles.wordpress.org/lymx\">Maxime LEROY</a>, <a href=\"https://profiles.wordpress.org/firestar300\">Milan Ricoul</a>, <a href=\"https://profiles.wordpress.org/momo-fr\">momo-fr</a>, <a href=\"https://profiles.wordpress.org/pasglop\">pasglop</a>, <a href=\"https://profiles.wordpress.org/phoenix13\">phoenix13</a>, <a href=\"https://profiles.wordpress.org/pierrelannoy\">Pierre Lannoy</a>, <a href=\"https://profiles.wordpress.org/sebastienserre\">Sébastien SERRE</a>, et <a href=\"https://profiles.wordpress.org/spaceshipone\">Timothée Brosille</a>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-small-font-size\">Article traduit par <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>. Merci à <a href=\"https://profiles.wordpress.org/laboiteare/\">Renaud Pacouil</a> pour sa relecture.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3255\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"Guide des changements techniques de WordPress 6.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://fr.wordpress.org/2024/10/28/guide-des-changements-techniques-de-wordpress-6-7/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 28 Oct 2024 10:49:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:5:\"Guide\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3243\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:436:\"WordPress 6.7 comprend la résolution de plus de&#160;300 tickets sur Trac, dont&#160;87 améliorations et nouvelles fonctionnalités, plus de 200 corrections de bogues. cette version comprend&#160;23 tickets focalisés sur les performances,&#160;21 sur l’accessibilité et&#160;12 sur la modernisation du code et la conformité aux standards de code. Les modifications de 6.7 s’étalent sur&#160;38 composants du cœur du [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:28124:\"\n<figure class=\"wp-block-image alignfull size-large is-style-serif wp-elements-f590cfee42cfa860d05ec74ddea8b4ef\" style=\"background:linear-gradient(135deg,rgb(7,125,194) 0%,rgb(134,54,209) 100%)\"><a href=\"https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques.png\"><img fetchpriority=\"high\" decoding=\"async\" width=\"1024\" height=\"515\" src=\"https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques-1024x515.png\" alt=\"\" class=\"wp-image-3244\" srcset=\"https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques-1024x515.png 1024w, https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques-300x151.png 300w, https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques-768x386.png 768w, https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques-1536x772.png 1536w, https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques-2048x1029.png 2048w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p>WordPress 6.7 comprend la résolution de plus de&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=status&amp;col=owner&amp;col=type&amp;col=priority&amp;col=milestone&amp;order=priority\">300 tickets sur Trac</a>, dont&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=enhancement&amp;type=feature+request&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">87 améliorations et nouvelles fonctionnalités</a>, <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=defect+(bug)&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">plus de 200 corrections de bogues</a>. cette version comprend&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~performance&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">23 tickets focalisés sur les performances</a>,&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~accessibility&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">21 sur l’accessibilité</a> et&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~coding-standards&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">12 sur la modernisation du code et la conformité aux standards de code</a>. Les modifications de 6.7 s’étalent sur&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.7&amp;group=component&amp;max=9999&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">38 composants du cœur du CMS</a>.</p>\n\n\n\n<p>Cette version comprend aussi <a href=\"https://github.com/WordPress/gutenberg/issues?q=label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.6%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.7%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.8%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.9%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.0%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.1%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.2%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.3%22%20\">445 améliorations</a>,&nbsp;<a href=\"https://github.com/WordPress/gutenberg/issues?q=label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.6%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.7%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.8%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.9%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.0%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.1%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.2%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.3%22%20\">464 corrections de bogues</a> et&nbsp;<a href=\"https://github.com/WordPress/gutenberg/issues?q=label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.6%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.7%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.8%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.9%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.0%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.1%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.2%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.3%22%20\">55 améliorations d’accessibilité</a>&nbsp;sur l’éditeur (projet Gutenberg).</p>\n\n\n\n<p class=\"is-style-serif has-white-color has-text-color has-background has-link-color wp-elements-ca39a6cbb68f24eb2fca5cc30331b23f\" style=\"background:linear-gradient(135deg,rgb(7,125,194) 0%,rgb(134,54,209) 100%)\">Ce guide décrit les principaux changements techniques que vous trouverez sur WordPress&nbsp;6.7, dont la sortie est prévue le 12 novembre 2024.</p>\n\n\n\n<p>Tous les liens de cet article pointent vers des notes de développement rédigées en anglais. L’objectif est de fournir un panorama général des changements techniques apportés par cette version, en français, puis de diriger les personnes qui souhaitent en savoir plus vers les notes de développement en anglais.</p>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/6-7/\">Pour en savoir plus sur la feuille de route et le calendrier de sortie de WP&nbsp;6.7, consultez cette page.</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h2 class=\"wp-block-heading\" id=\"Block-Editor\">Changements concernant l’éditeur et le projet Gutenberg</h2>\n\n\n\n<p>WordPress 6.7 implémente 8 versions de Gutenberg &#8211; <a href=\"https://make.wordpress.org/core/2024/06/20/whats-new-in-gutenberg-18-6/\">18.6</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2024/07/04/whats-new-in-gutenberg-18-7-03-july/\">18.7</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2024/07/17/whats-new-in-gutenberg-18-8-17-july/\">18.8</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2024/07/31/whats-new-in-gutenberg-18-9-31-july/#:~:text=In%20a%20recurring%20effort%20to,Links%2C%20and%20Term%20Description%20blocks.\">18.9</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2024/08/14/whats-new-in-gutenberg-19-0-14-august/\">19.0</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2024/08/28/whats-new-in-gutenberg-19-1-28-august/\">19.1</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2024/09/12/what-is-new-in-gutenberg-19-2-11-september/\">19.2</a> et&nbsp;<a href=\"https://make.wordpress.org/core/2024/09/25/whats-new-in-gutenberg-19-3-25-september/\">19.3</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Changements techniques</h3>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"uMdKNlBoCL\"><a href=\"https://make.wordpress.org/core/2024/10/18/post-editor-iframing-with-meta-boxes-in-wordpress-6-7/\">Post Editor iframing with meta boxes in WordPress 6.7</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Post Editor iframing with meta boxes in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/18/post-editor-iframing-with-meta-boxes-in-wordpress-6-7/embed/#?secret=qmaY5pXzTl#?secret=uMdKNlBoCL\" data-secret=\"uMdKNlBoCL\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"WgyaZOCHrA\"><a href=\"https://make.wordpress.org/core/2024/10/21/block-bindings-improvements-to-the-editor-experience-in-6-7/\">Block Bindings: Improvements to the Editor Experience in 6.7</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Block Bindings: Improvements to the Editor Experience in 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/21/block-bindings-improvements-to-the-editor-experience-in-6-7/embed/#?secret=vZmeFCPHik#?secret=WgyaZOCHrA\" data-secret=\"WgyaZOCHrA\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"eMYoPzBbo4\"><a href=\"https://make.wordpress.org/core/2024/10/21/updates-to-block-hooks-in-wordpress-6-7/\">Updates to Block Hooks in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to Block Hooks in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/21/updates-to-block-hooks-in-wordpress-6-7/embed/#?secret=GWcYXO1duD#?secret=eMYoPzBbo4\" data-secret=\"eMYoPzBbo4\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"NPZA5TJPdn\"><a href=\"https://make.wordpress.org/core/2024/10/18/editor-components-updates-in-wordpress-6-7/\">Updates to user-interface components in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to user-interface components in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/18/editor-components-updates-in-wordpress-6-7/embed/#?secret=7xhnb18OOq#?secret=NPZA5TJPdn\" data-secret=\"NPZA5TJPdn\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"react\">Changements concernant les outils de design dans l’éditeur</h3>\n\n\n\n<p>Nous avons poursuivi l’effort de consolidation des outils de design et plusieurs blocs prennent désormais en charge davantage de fonctionnalités de mise en page et de mise en forme.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"KJzsYABs6e\"><a href=\"https://make.wordpress.org/core/2024/10/17/roster-of-design-tools-per-block-wordpress-6-6-edition-2/\">Roster of design tools per block (WordPress 6.7 edition)</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Roster of design tools per block (WordPress 6.7 edition)&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/17/roster-of-design-tools-per-block-wordpress-6-6-edition-2/embed/#?secret=bU509N5zTq#?secret=KJzsYABs6e\" data-secret=\"KJzsYABs6e\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<p></p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"miscellaneous-block-editor-changes\">Autres modifications concernant l’éditeur</h3>\n\n\n\n<p>D&rsquo;autres modifications diverses ont été listées dans des notes de développement dédiées&nbsp;:</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"cgYDsB9BeF\"><a href=\"https://make.wordpress.org/core/2024/10/18/extending-the-preview-dropdown-menu-in-wordpress-6-7/\">Extending the Preview Dropdown Menu in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Extending the Preview Dropdown Menu in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/18/extending-the-preview-dropdown-menu-in-wordpress-6-7/embed/#?secret=ahd0C4rIgD#?secret=cgYDsB9BeF\" data-secret=\"cgYDsB9BeF\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"7mDUijDFk2\"><a href=\"https://make.wordpress.org/core/2024/10/20/miscellaneous-block-editor-changes-in-wordpress-6-7/\">Miscellaneous Block Editor Changes in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Miscellaneous Block Editor Changes in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/20/miscellaneous-block-editor-changes-in-wordpress-6-7/embed/#?secret=AVDYRuiEbq#?secret=7mDUijDFk2\" data-secret=\"7mDUijDFk2\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\">API de gestion des interactions et modules de script</h2>\n\n\n\n<p>WordPress 6.7 comprend des mises à jour de l’API <code>Interactivity</code>, comme par exemple une nouvelle façon d’interagir avec les changements d’état côté serveur dans la navigation côté client. Les mises à jour des modules <code>Script</code>s comprennent des améliorations du chargement des scripts existants en tant que dépendances.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"mwSy0wULCz\"><a href=\"https://make.wordpress.org/core/2024/10/15/subscribe-to-changes-in-the-interactivity-api-state-and-context-on-client-side-navigation-in-6-7/\">Subscribe to changes in the Interactivity API state and context on client-side navigation in 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Subscribe to changes in the Interactivity API state and context on client-side navigation in 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/15/subscribe-to-changes-in-the-interactivity-api-state-and-context-on-client-side-navigation-in-6-7/embed/#?secret=3hQMOVXqfJ#?secret=mwSy0wULCz\" data-secret=\"mwSy0wULCz\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"5G0bvIkW0h\"><a href=\"https://make.wordpress.org/core/2024/10/14/updates-to-script-modules-in-6-7/\">Updates to Script Modules in 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to Script Modules in 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/14/updates-to-script-modules-in-6-7/embed/#?secret=1xRq1veJ2v#?secret=5G0bvIkW0h\" data-secret=\"5G0bvIkW0h\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"html-api\">API HTML</h2>\n\n\n\n<p>WordPress 6.7 comprend plusieurs mises à jour de l&rsquo;API <code>HTML</code>. Plusieurs fonctionnalités majeures sont sorties ainsi qu&rsquo;un amélioration conséquente de l&rsquo;utilisabilité du processeur HTML.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"NYzaXUkHI3\"><a href=\"https://make.wordpress.org/core/2024/10/17/updates-to-the-html-api-in-6-7/\">Updates to the HTML API in 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to the HTML API in 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/17/updates-to-the-html-api-in-6-7/embed/#?secret=iEwkK7OKSw#?secret=NYzaXUkHI3\" data-secret=\"NYzaXUkHI3\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"i18n\">Internationalisation</h2>\n\n\n\n<p><a href=\"https://core.trac.wordpress.org/query?component=I18N&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=status&amp;col=priority&amp;order=priority\">Diverses améliorations de l&rsquo;internationalisation</a> sont disponibles avec WordPress 6.7&nbsp;:</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"DP8l0CiCdI\"><a href=\"https://make.wordpress.org/core/2024/10/21/i18n-improvements-6-7/\">Internationalization improvements in 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Internationalization improvements in 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/21/i18n-improvements-6-7/embed/#?secret=MCSsLcKVNl#?secret=DP8l0CiCdI\" data-secret=\"DP8l0CiCdI\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"performance\">Performances</h2>\n\n\n\n<p>WordPress 6.7 apporte aussi plusieurs améliorations focalisées sur les performances, telles qu&rsquo;une nouvelle façon de déclarer les blocs utilisant des fichiers PHP générés pour contrecarrer les goulots d&rsquo;étranglement liés au chargement et au parcours des fichiers JSON.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"LiMcRNquOr\"><a href=\"https://make.wordpress.org/core/2024/10/17/new-block-type-registration-apis-to-improve-performance-in-wordpress-6-7/\">New block type registration APIs to improve performance in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;New block type registration APIs to improve performance in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/17/new-block-type-registration-apis-to-improve-performance-in-wordpress-6-7/embed/#?secret=2au4COS7ru#?secret=LiMcRNquOr\" data-secret=\"LiMcRNquOr\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"741P7G7pRI\"><a href=\"https://make.wordpress.org/core/2024/10/18/auto-sizes-for-lazy-loaded-images-in-wordpress-6-7/\">Auto Sizes for Lazy Loaded Images in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Auto Sizes for Lazy Loaded Images in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/18/auto-sizes-for-lazy-loaded-images-in-wordpress-6-7/embed/#?secret=jrG82zsmtK#?secret=741P7G7pRI\" data-secret=\"741P7G7pRI\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"miscellaneous-developer-changes\">Autres changements techniques</h2>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"jPhUPBY0Od\"><a href=\"https://make.wordpress.org/core/2024/10/20/new-plugin-template-registration-api-in-wordpress-6-7/\">New Plugin Template Registration API in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;New Plugin Template Registration API in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/20/new-plugin-template-registration-api-in-wordpress-6-7/embed/#?secret=yPPthJgGpb#?secret=jPhUPBY0Od\" data-secret=\"jPhUPBY0Od\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"IH9C1mVH4S\"><a href=\"https://make.wordpress.org/core/2024/08/15/automatic-conversion-of-heic-images-to-jpeg-in-wordpress-6-7/\">Automatic conversion of HEIC images to JPEG in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Automatic conversion of HEIC images to JPEG in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/08/15/automatic-conversion-of-heic-images-to-jpeg-in-wordpress-6-7/embed/#?secret=EpH55CK7AE#?secret=IH9C1mVH4S\" data-secret=\"IH9C1mVH4S\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"other-updates\">Nouvelles fonctions, crochets, filtres, classes et méthodes</h2>\n\n\n\n<p>Pour obtenir la liste de toutes les nouvelles fonctions, crochets, filtres, classes et méthodes, vous pourrez vous rendre – une fois que WP 6.7 sera sortie – sur cette page&nbsp;: <a href=\"https://developer.wordpress.org/reference/since/6.7.0/\">https://developer.wordpress.org/reference/since/6.7.0/</a>.</p>\n\n\n\n<div class=\"wp-block-group alignfull is-layout-flow wp-block-group-is-layout-flow\">\n<p class=\"is-style-serif has-white-color has-text-color has-background has-link-color wp-elements-87f312e26bd4a386f9cdeec66ae58d52\" style=\"background:linear-gradient(135deg,rgb(7,125,194) 0%,rgb(134,54,209) 100%)\">Que vous développiez des thèmes ou des extensions, pensez à tester et retester votre code pour vous assurer de sa compatibilité avec ces changements.<br><br>Vous pouvez utiliser <a href=\"https://fr.wordpress.org/plugins/wordpress-beta-tester/\" target=\"_blank\" rel=\"noreferrer noopener\">l’extension « <em><bdo lang=\"en\" dir=\"ltr\">Beta Tester</bdo></em> »</a> sur un site de test pour vérifier la compatibilité de vos développements avec la <a href=\"https://wordpress.org/news/2024/10/wordpress-6-7-release-candidate-1/\">version <em><bdo lang=\"en\" dir=\"ltr\">release candidate</bdo></em> de WordPress 6.7</a>. <br>Vous pouvez aussi tester cette nouvelle version directement dans votre navigateur en utilisant <em><a href=\"https://playground.wordpress.net/#%7B%20%22preferredVersions%22:%20%7B%20%22php%22:%20%228.0%22,%20%22wp%22:%20%22beta%22%20%7D,%20%22features%22:%20%7B%20%22networking%22:%20true%20%7D,%20%22steps%22:%20[%20%7B%20%22step%22:%20%22login%22,%20%22username%22:%20%22admin%22,%20%22password%22:%20%22password%22%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/wpaccessibility/a11y-theme-unit-test/master/a11y-theme-unit-test-data.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/WordPress/theme-test-data/master/themeunittestdata.wordpress.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22query-monitor%22%20%7D,%20%22options%22:%20%7B%20%22activate%22:%20false%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22create-block-theme%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22debug-bar%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22health-check%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22test-reports%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22user-switching%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D%20]%20%7D\"><bdo lang=\"en\" dir=\"ltr\">WordPress Playground</bdo></a></em>.<br><br>Nous comptons sur vous pour vérifier que votre code fonctionne correctement avec le cœur du CMS, pour le bien des millions d’utilisateurs et utilisatrices de WordPress <img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n</div>\n\n\n\n<p class=\"has-small-font-size\">Ce guide a été traduit et réadapté à partir du <a href=\"https://make.wordpress.org/core/2024/10/23/wordpress-6-7-field-guide/\">Field Guide de WP 6.7 (en anglais)</a> par <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>.<br>Merci à <a href=\"https://profiles.wordpress.org/fxbenard/\">FX Benard</a> et <a href=\"https://profiles.wordpress.org/beryldlg/\">Béryl de La Grandière</a> pour leur relecture.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3243\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:66:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"Nouveau programme de mentorat pour la contribution à WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"https://fr.wordpress.org/2024/08/21/nouveau-programme-de-mentorat-pour-la-contribution-a-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 21 Aug 2024 09:34:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:10:\"Contribuer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:13:\"Documentation\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:10:\"Traduction\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:18:\"mentorship program\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3204\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:389:\"Le 7 octobre 2024, un nouveau programme de mentorat pour la contribution à WordPress ou « WordPress Contributor Mentorship » va débuter pour une durée de 6 semaines, il s’achèvera donc avec la sortie de la version 6.7 mi-novembre. Mais c’est quoi exactement ce programme&#160;? Il s’agit du troisième programme organisé par l’équipe Community afin de faciliter [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Jenny Dupuy\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6506:\"\n<p>Le 7 octobre 2024, un nouveau programme de mentorat pour la contribution à WordPress ou « WordPress Contributor Mentorship » va débuter pour une durée de 6 semaines, il s’achèvera donc avec la sortie de la version 6.7 mi-novembre.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Mais c’est quoi exactement ce programme&nbsp;?</h2>\n\n\n\n<p>Il s’agit du troisième programme organisé par l’équipe <a href=\"https://make.wordpress.org/community/\">Community</a> afin de faciliter l’intégration de nouvelles personnes aux <a href=\"https://make.wordpress.org/\">diverses équipe de contribution</a>.</p>\n\n\n\n<p>Ce programme met en place de petites équipes avec un mentor et des mentoré·e·s qui travaillent ensemble sur un projet proposé par le mentor lors de sa candidature.</p>\n\n\n\n<p>Les organisateurs répartissent donc les contributeurs/contributrices selon les souhaits qu&rsquo;ils/elles ont définis lors de leur candidature.</p>\n\n\n\n<p>Tout au long du programme, le/la mentor prend en charge l&rsquo;équipe de mentoré·e·s pour avancer le projet qu&rsquo;il/elle a proposé, et quelques réunions en visio sont proposées par les organisateurs.</p>\n\n\n\n<p>Si vous souhaitez débuter la contribution à WordPress mais ne savez pas comment, ni par où commencer, alors ce programme est parfait pour vous en tant que mentoré·e.&nbsp; Vous serez guidé·e tout au long du programme par des mentors et pourrez ainsi obtenir toutes les informations nécessaires à une contribution efficace.<br>Et si vous contribuez déjà et souhaitez transmettre vos connaissances à d’autres personnes alors participez au programme en tant que mentor ! Ce sera l’occasion d’accueillir de nouvelles personnes dans vos équipes respectives.</p>\n\n\n\n<p>Cette cohorte est synchronisée avec la sortie de la version 6.7 afin de permettre aux participants, qui rejoignent l’équipe Core ou celle du développement du thème Twenty Twenty-Five, de contribuer spécifiquement à cette version de WordPress. Mais, la contribution à WordPress ne se résumant pas à son code, vous avez aussi l’opportunité de rejoindre des équipes de contribution non liées au code telles que Communauté (organisation d’évènements et encadrement des équipes), Design, Documentation, Formation, etc.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Qui peut candidater ?</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Pour les mentoré·e·s : toute personne souhaitant débuter la contribution à WordPress, ou encore contribuer à d’autres équipes que celle(s) où il/elle contribue déjà.</li>\n\n\n\n<li>Pour les mentors : toute personne ayant déjà un peu d’expérience dans la contribution WordPress.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Comment rejoindre le programme ?</h2>\n\n\n\n<p>Pour rejoindre le programme, il faut remplir un petit formulaire :</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://docs.google.com/forms/d/e/1FAIpQLSd6faivlMZzyiq1sx_78fvnw7-JOshZMZcIO6BTp-B7TuM2ww/viewform\" target=\"_blank\" rel=\"noreferrer noopener\">Candidater en tant que mentoré·e</a></div>\n\n\n\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://docs.google.com/forms/d/e/1FAIpQLSfDzRRrIDJcQcVF0m3I16-RfwrjmXBHboxCC5Rx0OHatK_EBQ/viewform\" target=\"_blank\" rel=\"noreferrer noopener\">Candidater en tant que mentor</a></div>\n</div>\n\n\n\n<p>Mais <strong>attention date limite des candidatures</strong> : </p>\n\n\n\n<p class=\"has-text-align-center has-light-grey-2-color has-vivid-red-background-color has-text-color has-background has-link-color wp-elements-18846e5805f4ed69ba3dc19961036bd1\" style=\"margin-top:var(--wp--preset--spacing--10);margin-right:var(--wp--preset--spacing--10);margin-bottom:var(--wp--preset--spacing--10);margin-left:var(--wp--preset--spacing--10);padding-top:var(--wp--preset--spacing--10);padding-right:var(--wp--preset--spacing--10);padding-bottom:var(--wp--preset--spacing--10);padding-left:var(--wp--preset--spacing--10)\">le 26 août 2024</p>\n\n\n\n<p>Vous serez ensuite recontacté·e.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Contribuer dans votre langue</h2>\n\n\n\n<p>Ce 3<sup>e</sup> programme propose une nouveauté : selon le projet auquel vous participerez, vous aurez peut être l’opportunité de contribuer en français, puisque des équipes par locale vont être constituées.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Plus d&rsquo;informations</h2>\n\n\n\n<p>Retrouvez plus d&rsquo;informations sur le programme dans cet article (en anglais) :</p>\n\n\n\n<figure class=\"wp-block-embed aligncenter is-type-wp-embed is-provider-wordpress-org-project wp-block-embed-wordpress-org-project\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"TOusFk6YKX\"><a href=\"https://make.wordpress.org/project/2024/08/16/wordpress-contributor-mentorship-program-cohort-3-2024-q4-call-for-mentees-mentors/\">WordPress Contributor Mentorship Program Cohort #3 (2024 Q4): Call for Mentees &amp; Mentors</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;WordPress Contributor Mentorship Program Cohort #3 (2024 Q4): Call for Mentees &amp; Mentors&#8221; &#8212; WordPress.org Project\" src=\"https://make.wordpress.org/project/2024/08/16/wordpress-contributor-mentorship-program-cohort-3-2024-q4-call-for-mentees-mentors/embed/#?secret=93CdKWMRfW#?secret=TOusFk6YKX\" data-secret=\"TOusFk6YKX\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<p class=\"has-text-align-center has-light-grey-2-color has-purple-2-background-color has-text-color has-background has-link-color has-extra-large-font-size wp-elements-ce3e97f8976a3a3f44d47b605fc66a4f\" style=\"margin-top:var(--wp--preset--spacing--30);margin-right:var(--wp--preset--spacing--30);margin-bottom:var(--wp--preset--spacing--30);margin-left:var(--wp--preset--spacing--30);padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)\">On compte sur vous pour vous inscrire nombreux et nombreuses à ce programme !<br>Si vous n’avez jamais contribué c’est l’occasion rêvée de commencer, si vous contribuez déjà et souhaitez rejoindre de nouvelles équipes ce programme est fait pour vous !</p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3204\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"WordPress 6.6 « Dorsey »\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://fr.wordpress.org/2024/07/16/wordpress-6-6-dorsey/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 16 Jul 2024 17:40:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3181\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:408:\"Nous avons le plaisir de vous présenter WordPress&#160;6.6 «&#160;Dorsey&#160;», version nommée en l&#8217;honneur du légendaire leader de big band américain Tommy Dorsey. Reconnu pour son timbre de trombone et pour ses compositions, la musique de Dorsey envoûte son audience grâce à sa profondeur émotionnelle et son énergie. Écoutez la musique du Dorsey’s Big Band tandis que vous [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:68929:\"\n<figure class=\"wp-block-image size-large\"><a href=\"https://fr.wordpress.org/files/2024/07/dorsey.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"680\" src=\"https://fr.wordpress.org/files/2024/07/dorsey-1024x680.png\" alt=\"\" class=\"wp-image-3199\" srcset=\"https://fr.wordpress.org/files/2024/07/dorsey-1024x680.png 1024w, https://fr.wordpress.org/files/2024/07/dorsey-300x199.png 300w, https://fr.wordpress.org/files/2024/07/dorsey-768x510.png 768w, https://fr.wordpress.org/files/2024/07/dorsey-1536x1021.png 1536w, https://fr.wordpress.org/files/2024/07/dorsey-2048x1361.png 2048w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p>Nous avons le plaisir de vous présenter WordPress&nbsp;6.6 «&nbsp;Dorsey&nbsp;», version nommée en l&rsquo;honneur du légendaire <bdo lang=\"en\" dir=\"ltr\">leader</bdo> de <bdo lang=\"en\" dir=\"ltr\">big band</bdo> américain Tommy Dorsey. Reconnu pour son timbre de trombone et pour ses compositions, la musique de Dorsey envoûte son audience grâce à sa profondeur émotionnelle et son énergie.</p>\n\n\n\n<p>Écoutez la musique du <a href=\"https://open.spotify.com/playlist/37i9dQZF1DZ06evO2TT3Ge?si=d9872e46371c4ed7\" target=\"_blank\" rel=\"noreferrer noopener\"><bdo lang=\"en\" dir=\"ltr\">Dorsey’s Big Band</bdo></a> tandis que vous découvrirez les nouvelles fonctionnalités et les améliorations de WordPress 6.6.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Bienvenue à 6.6&nbsp;!</h2>\n\n\n\n<p>WordPress 6.6 répond à la promesse d’un web meilleur en ajoutant de nouveaux outils pour améliorer le quotidien des créateurs de contenus, des sites les plus complexes aux sites «&nbsp;<bdo lang=\"en\" dir=\"ltr\">one page</bdo>&nbsp;». Sans jamais mettre de côté la sécurité, la stabilité ou les performances, WordPress 6.6 apporte de nouveaux outils et améliore les flux de rédaction déjà en place.</p>\n\n\n\n<p>Une nouvelle fonctionnalité de restauration pour les mises à jour automatiques des extensions vous offre quant à elle sécurité, flexibilité et sérénité.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://fr.wordpress.org/download/\">Téléchargez WordPress 6.6 «&nbsp;Dorsey&nbsp;»</a></div>\n</div>\n\n\n\n<h3 class=\"wp-block-heading\">Palettes de couleurs et ensembles de polices</h3>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-1 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:33.33%\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.6/color-palettes.webp\" alt=\"\" /></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-vertically-aligned-center is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:66.66%\">\n<p><strong>Ajout de davantage d’options de conception aux thèmes basés sur des blocs.</strong>&nbsp;Les auteur·ices de thèmes basés sur les blocs peuvent créer un nombre illimité de palettes de couleurs ou de polices personnalisées pour offrir des options graphiques plus spécifiques au sein du même thème. Ces palettes offrent des possibilités graphiques plus harmonisées, permettant une personnalisation sans modifier le style global du site, au-delà des paramètres de couleur ou de typographie.</p>\n</div>\n</div>\n\n\n\n<h3 class=\"wp-block-heading\">Aperçu rapide des pages</h3>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-2 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:33.33%\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.6/page-previews.webp\" alt=\"\" /></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-vertically-aligned-center is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:66.66%\">\n<p><strong>Simplifiez votre flux de travail avec une nouvelle mise en page conçue pour les pages.</strong>&nbsp;Découvrez toutes vos pages et un aperçu de n’importe quelle page sélectionnée avant de la modifier via une nouvelle mise en page dans l’éditeur de site.</p>\n</div>\n</div>\n\n\n\n<h3 class=\"wp-block-heading\">Retour en arrière pour les mises à jour automatiques d’extensions</h3>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-3 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:33.33%\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.6/feature-rollbacks.webp\" alt=\"\" /></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-vertically-aligned-center is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:66.66%\">\n<p><strong>Mettez à jour vos extensions en toute tranquillité.</strong>&nbsp;Bénéficiez de la facilité des mises à jour automatiques des extensions avec la possibilité de restauration en cas de problème, améliorant ainsi la sécurité de votre site tout en minimisant les risques d’indisponibilité potentielle de celui-ci.</p>\n</div>\n</div>\n\n\n\n<h3 class=\"wp-block-heading\">Surcharges</h3>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-4 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:33.33%\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.6/overrides.webp\" alt=\"\" /></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-vertically-aligned-center is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:66.66%\">\n<p><strong>Ajout de la possibilité de personnaliser les contenus dans les compositions synchronisées.</strong>&nbsp;Autoriser la personnalisation des éléments de contenu spécifiques dans chaque apparition d’une composition synchronisée tout en conservant un style uniformisé pour toutes les apparitions, simplifiant ainsi les futures mises à jour. Actuellement, vous pouvez définir des surcharges pour les blocs Titre, Paragraphe, Bouton et Image.</p>\n</div>\n</div>\n\n\n\n<h3 class=\"wp-block-heading\">Améliorations des performances</h3>\n\n\n\n<p>WordPress 6.6 comprend des mises à jour importantes comme le retrait d&rsquo;appels redondants vers <code>WP_Theme_JSON</code>, la désactivation du chargement automatique pour les options les plus volumétriques, la suppression de dépendances inutiles, le chargement différé des contenus embarqués, la nouvelle directive <code>data-wp-on-async</code> et une réduction de 33 % du chargement des modèles dans l&rsquo;éditeur.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Améliorations de l’accessibilité</h3>\n\n\n\n<p>Plus de 55 correctifs d’accessibilité et améliorations se concentrent sur des aspects fondamentaux de l’expérience WordPress, en particulier le composant de vue de données qui alimente la nouvelle expérience de modification de site et des domaines comme l’outil d’insertion qui fournit un moyen-clé d’interagir avec les blocs et les compositions.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Et bien plus encore</h3>\n\n\n\n<p>Pour une vision complète de toutes les nouvelles fonctionnalités et améliorations de WordPress 6.6, vous pouvez consulter le site de démonstration des fonctionnalités.</p>\n\n\n\n<p><a href=\"https://fr.wordpress.org/download/releases/6-6/\">Découvrez toutes les nouveautés</a></p>\n\n\n\n<h3 class=\"wp-block-heading\">En savoir plus sur WordPress 6.6</h3>\n\n\n\n<p><a href=\"https://learn.wordpress.org/\"><em>Learn WordPress</em></a>&nbsp;est une ressource gratuite pour les personnes qui utilisent WordPress, qu’elles soient débutantes ou expérimentées.&nbsp;<em>Learn</em>&nbsp;contient des vidéos pratiques sur l’utilisation de diverses fonctionnalités de WordPress, des&nbsp;<a href=\"https://learn.wordpress.org/online-workshops/\">évènements interactifs</a>&nbsp;pour explorer des sujets en profondeur, et des plans de cours pour approfondir des domaines spécifiques de WordPress.</p>\n\n\n\n<p>Explorez le&nbsp;<a href=\"https://fr.wordpress.org/2024/06/27/guide-des-changements-techniques-de-wordpress-6-6/\">Guide des changements techniques de WordPress 6.6</a>. Découvrez les changements de cette version avec les notes détaillées des développeurs et développeuses qui vous aident à construire avec WordPress.</p>\n\n\n\n<p><a href=\"https://wordpress.org/support/wordpress-version/version-6-6/\">Lisez les notes de version de WordPress 6.6</a>&nbsp;pour obtenir des informations sur l’installation, les améliorations, les problèmes corrigés, les contributeurs et contributrices de la version, les ressources d’apprentissage et la liste des modifications apportées aux fichiers.</p>\n\n\n\n<h2 class=\"wp-block-heading\">L’équipe de direction de WordPress&nbsp;6.6</h2>\n\n\n\n<p>Voici l’équipe qui a coordonné le développement et la sortie de cette nouvelle version de WordPress&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Direction générale&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a></li>\n\n\n\n<li>Coordination générale&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/meher/\">Meher Bala</a></li>\n\n\n\n<li>Direction technique côté Cœur&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a></li>\n\n\n\n<li>Direction technique côté Gutenberg&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van Durpe</a>,&nbsp;<a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a></li>\n\n\n\n<li>Gestion de projet technique côté Cœur&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a>,&nbsp;<a href=\"https://profiles.wordpress.org/nhrrob/\">Nazmul Hasan Robin</a></li>\n\n\n\n<li>Gestion de projet technique côté Gutenberg&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a>,&nbsp;<a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a>&nbsp;</li>\n\n\n\n<li>Responsables de la documentation&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a>,&nbsp;<a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a>,&nbsp;<a href=\"https://profiles.wordpress.org/josepmoran/\">Josep Morán</a></li>\n\n\n\n<li>Direction marketing et communication&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a></li>\n\n\n\n<li>Direction artistique : <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a></li>\n\n\n\n<li>Responsable des performances&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a></li>\n\n\n\n<li>Responsables des tests&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a>,&nbsp;<a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a>&nbsp;et&nbsp;<a href=\"https://profiles.wordpress.org/vipuljnext/\">Vipul Ghori</a></li>\n\n\n\n<li>Responsable des thèmes natifs&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Merci aux contributeurs et contributrices</h2>\n\n\n\n<p>WordPress 6.6 n’aurait pas pu sortir sans la contribution passionnée de plus de&nbsp;<strong>630 personnes provenant d’au moins 50 pays différents</strong>.</p>\n\n\n\n<p>Un remerciement tout spécial pour les plus de 150 personnes qui ont contribué au cœur de WordPress pour la première fois avec WP&nbsp;6.6 <img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\n\n\n<p style=\"font-size:10px\"><a href=\"https://profiles.wordpress.org/benniledl/\">!Benni</a> · <a href=\"https://profiles.wordpress.org/_ck_/\">_ck_</a> · <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> · <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a> · <a href=\"https://profiles.wordpress.org/abmamun007/\">Abdullah Mamun</a> · <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a> · <a href=\"https://profiles.wordpress.org/fitehal/\">Abhishek Deshpande</a> · <a href=\"https://profiles.wordpress.org/abletec/\">abletec</a> · <a href=\"https://profiles.wordpress.org/acosmin/\">acosmin</a> · <a href=\"https://profiles.wordpress.org/adampickering/\">Adam Pickering</a> · <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> · <a href=\"https://profiles.wordpress.org/adarshposimyth/\">Adarsh Akshat</a> · <a href=\"https://profiles.wordpress.org/ajmcfadyen/\">admcfajn</a> · <a href=\"https://profiles.wordpress.org/adrianduffell/\">adrianduffell</a> · <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Chaion</a> · <a href=\"https://profiles.wordpress.org/engahmeds3ed/\">Ahmed Saeed</a> · <a href=\"https://profiles.wordpress.org/ajithrn/\">Ajith R N</a> · <a href=\"https://profiles.wordpress.org/skyakash12/\">Akash Muchandikar</a> · <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> · <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a> · <a href=\"https://profiles.wordpress.org/akmelias/\">akmelias</a> · <a href=\"https://profiles.wordpress.org/wpfy/\">Akramul Hasan</a> · <a href=\"https://profiles.wordpress.org/akshayar/\">Akshaya Rane</a> · <a href=\"https://profiles.wordpress.org/schlessera/\">Alain Schlesser</a> · <a href=\"https://profiles.wordpress.org/alanfuller/\">Alan Fuller</a> · <a href=\"https://profiles.wordpress.org/ahoereth/\">Alex</a> · <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a> · <a href=\"https://profiles.wordpress.org/alexkingorg/\">Alex King</a> · <a href=\"https://profiles.wordpress.org/akirk/\">Alex Kirk</a> · <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a> · <a href=\"https://profiles.wordpress.org/viper007bond/\">Alex Mills</a> · <a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a> · <a href=\"https://profiles.wordpress.org/alexandrebuffet/\">Alexandre Buffet</a> · <a href=\"https://profiles.wordpress.org/alexanderkoledov/\">AlexKole</a> · <a href=\"https://profiles.wordpress.org/alh0319/\">Amber Hinds</a> · <a href=\"https://profiles.wordpress.org/sabreuse/\">Amy Hendrix (sabreuse)</a> · <a href=\"https://profiles.wordpress.org/amykamala/\">Amy Kamala</a> · <a href=\"https://profiles.wordpress.org/anandau14/\">Anand Upadhyay</a> · <a href=\"https://profiles.wordpress.org/anlino/\">Anders Norén</a> · <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a> · <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a> · <a href=\"https://profiles.wordpress.org/euthelup/\">Andrei Lupu</a> · <a href=\"https://profiles.wordpress.org/andrewhayward/\">Andrew Hayward</a> · <a href=\"https://profiles.wordpress.org/l1nuxjedi/\">Andrew Hutchings</a> · <a href=\"https://profiles.wordpress.org/nacin/\">Andrew Nacin</a> · <a href=\"https://profiles.wordpress.org/norcross/\">Andrew Norcross</a> · <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> · <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a> · <a href=\"https://profiles.wordpress.org/andrewleap/\">andrewleap</a> · <a href=\"https://profiles.wordpress.org/andbalashov/\">Andrii Balashov</a> · <a href=\"https://profiles.wordpress.org/oandregal/\">André Maneiro</a> · <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a> · <a href=\"https://profiles.wordpress.org/apeatling/\">Andy Peatling</a> · <a href=\"https://profiles.wordpress.org/aneeshd16/\">Aneesh Devasthale</a> · <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a> · <a href=\"https://profiles.wordpress.org/ankitmaru/\">Ankit Panchal</a> · <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a> · <a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a> · <a href=\"https://profiles.wordpress.org/ant1busted/\">Antoine</a> · <a href=\"https://profiles.wordpress.org/antonlukin/\">Anton Lukin</a> · <a href=\"https://profiles.wordpress.org/atimmer/\">Anton Timmermans</a> · <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a> · <a href=\"https://profiles.wordpress.org/lighthouse79/\">Antonella</a> · <a href=\"https://profiles.wordpress.org/colomet/\">Antonio D.</a> · <a href=\"https://profiles.wordpress.org/antonisme/\">Antonis Lilis</a> · <a href=\"https://profiles.wordpress.org/arena94/\">arena94</a> · <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a> · <a href=\"https://profiles.wordpress.org/passoniate/\">Arslan Kalwar</a> · <a href=\"https://profiles.wordpress.org/artemiosans/\">Artemio Morales</a> · <a href=\"https://profiles.wordpress.org/arthur791004/\">Arthur Chu</a> · <a href=\"https://profiles.wordpress.org/iamarunchaitanyajami/\">Arun Chaitanya Jami</a> · <a href=\"https://profiles.wordpress.org/dextorlobo/\">Arun Sharma</a> · <a href=\"https://profiles.wordpress.org/ideag/\">Arunas Liuiza</a> · <a href=\"https://profiles.wordpress.org/iamasadpolash/\">Asad Polash</a> · <a href=\"https://profiles.wordpress.org/ashfame/\">Ashish Kumar (Ashfame)</a> · <a href=\"https://profiles.wordpress.org/mohonchandra/\">Asish Chandra Mohon</a> · <a href=\"https://profiles.wordpress.org/aslamdoctor/\">Aslam Doctor</a> · <a href=\"https://profiles.wordpress.org/audunmb/\">audunmb</a> · <a href=\"https://profiles.wordpress.org/aurooba/\">Aurooba Ahmed</a> · <a href=\"https://profiles.wordpress.org/filosofo/\">Austin Matzko</a> · <a href=\"https://profiles.wordpress.org/axwax/\">axwax</a> · <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a> · <a href=\"https://profiles.wordpress.org/beryldlg/\">Béryl de La Grandière</a> · <a href=\"https://profiles.wordpress.org/bahia0019/\">bahia0019</a> · <a href=\"https://profiles.wordpress.org/balub/\">Balu B</a> · <a href=\"https://profiles.wordpress.org/bangank36/\">bangank36</a> · <a href=\"https://profiles.wordpress.org/barry/\">Barry</a> · <a href=\"https://profiles.wordpress.org/barryhughes-1/\">Barry</a> · <a href=\"https://profiles.wordpress.org/bartkalisz/\">Bart Kalisz</a> · <a href=\"https://profiles.wordpress.org/bartkleinreesink/\">bartkleinreesink</a> · <a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a> · <a href=\"https://profiles.wordpress.org/beaulebens/\">Beau Lebens</a> · <a href=\"https://profiles.wordpress.org/bedas/\">Beda</a> · <a href=\"https://profiles.wordpress.org/benharri/\">ben</a> · <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a> · <a href=\"https://profiles.wordpress.org/ubernaut/\">Ben Hansen</a> · <a href=\"https://profiles.wordpress.org/husobj/\">Ben Huson</a> · <a href=\"https://profiles.wordpress.org/benlk/\">Ben Keith</a> · <a href=\"https://profiles.wordpress.org/blobaugh/\">Ben Lobaugh (blobaugh)</a> · <a href=\"https://profiles.wordpress.org/britner/\">Ben Ritner – Kadence WP</a> · <a href=\"https://profiles.wordpress.org/retlehs/\">Ben Word</a> · <a href=\"https://profiles.wordpress.org/benjamingosset/\">Benjamin Gosset</a> · <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a> · <a href=\"https://profiles.wordpress.org/benjaminknox/\">benjaminknox</a> · <a href=\"https://profiles.wordpress.org/benoitchantre/\">Benoit Chantre</a> · <a href=\"https://profiles.wordpress.org/benoitfouc/\">benoitfouc</a> · <a href=\"https://profiles.wordpress.org/bernhard reiter/\">Bernhard Reiter</a> · <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">bernhard-reiter</a> · <a href=\"https://profiles.wordpress.org/billseymour/\">billseymour</a> · <a href=\"https://profiles.wordpress.org/bplv/\">Biplav</a> · <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a> · <a href=\"https://profiles.wordpress.org/bobbingwide/\">bobbingwide</a> · <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a> · <a href=\"https://profiles.wordpress.org/born2webdesign/\">born2webdesign</a> · <a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a> · <a href=\"https://profiles.wordpress.org/bradparbs/\">Brad Parbs</a> · <a href=\"https://profiles.wordpress.org/williamsba1/\">Brad Williams</a> · <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a> · <a href=\"https://profiles.wordpress.org/drrobotnik/\">Brandon Lavigne</a> · <a href=\"https://profiles.wordpress.org/ironprogrammer/\">Brian Alexander</a> · <a href=\"https://profiles.wordpress.org/bacoords/\">Brian Coords</a> · <a href=\"https://profiles.wordpress.org/fischfood/\">Brian Fischer</a> · <a href=\"https://profiles.wordpress.org/bgardner/\">Brian Gardner</a> · <a href=\"https://profiles.wordpress.org/masteradhoc/\">Brian Haas</a> · <a href=\"https://profiles.wordpress.org/brianhenryie/\">Brian Henry</a> · <a href=\"https://profiles.wordpress.org/brookemk/\">Brooke</a> · <a href=\"https://profiles.wordpress.org/burnuser/\">burnuser</a> · <a href=\"https://profiles.wordpress.org/icaleb/\">Caleb Burks</a> · <a href=\"https://profiles.wordpress.org/ecc/\">camya</a> · <a href=\"https://profiles.wordpress.org/karl94/\">Carlo Cannas</a> · <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> · <a href=\"https://profiles.wordpress.org/carlosgprim/\">Carlos G. P.</a> · <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> · <a href=\"https://profiles.wordpress.org/cbirdsong/\">cbirdsong</a> · <a href=\"https://profiles.wordpress.org/cenkdemir/\">cenkdemir</a> · <a href=\"https://profiles.wordpress.org/cfinnberg/\">cfinnberg</a> · <a href=\"https://profiles.wordpress.org/shireling/\">Chad Chadbourne</a> · <a href=\"https://profiles.wordpress.org/chasedsiedu/\">chased@si.edu</a> · <a href=\"https://profiles.wordpress.org/mel_cha/\">chiilog (Chiaki Okamoto)</a> · <a href=\"https://profiles.wordpress.org/chouby/\">Chouby</a> · <a href=\"https://profiles.wordpress.org/chrisdavidmiles/\">Chris David Miles</a> · <a href=\"https://profiles.wordpress.org/jazzs3quence/\">Chris Reynolds</a> · <a href=\"https://profiles.wordpress.org/chriscct7/\">chriscct7</a> · <a href=\"https://profiles.wordpress.org/itschristiandale/\">christian-dale</a> · <a href=\"https://profiles.wordpress.org/christopherplus/\">Christopher</a> · <a href=\"https://profiles.wordpress.org/chrystl/\">Chrystl</a> · <a href=\"https://profiles.wordpress.org/codepo8/\">codepo8</a> · <a href=\"https://profiles.wordpress.org/cdevroe/\">Colin Devroe</a> · <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a> · <a href=\"https://profiles.wordpress.org/colind/\">ColinD</a> · <a href=\"https://profiles.wordpress.org/cookiesfordevo/\">CookiesForDevo</a> · <a href=\"https://profiles.wordpress.org/coreyw/\">Corey Worrell</a> · <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Robertson</a> · <a href=\"https://profiles.wordpress.org/creativeslice/\">Creative Slice</a> · <a href=\"https://profiles.wordpress.org/crstauf/\">crstauf</a> · <a href=\"https://profiles.wordpress.org/cwhitmore/\">Cullen Whitmore</a> · <a href=\"https://profiles.wordpress.org/cu121/\">Cupid Chakma</a> · <a href=\"https://profiles.wordpress.org/cvorko/\">cvorko</a> · <a href=\"https://profiles.wordpress.org/didierjm/\">cybeardjm</a> · <a href=\"https://profiles.wordpress.org/cyberchicken/\">Cyberchicken</a> · <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/dansoschin/\">Dan Soschin</a> · <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a> · <a href=\"https://profiles.wordpress.org/mzaweb/\">Daniel Dvorkin</a> · <a href=\"https://profiles.wordpress.org/mapumba/\">Daniel Käfer</a> · <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a> · <a href=\"https://profiles.wordpress.org/schutzsmith/\">Daniel Schutzsmith</a> · <a href=\"https://profiles.wordpress.org/danieldudzic/\">danieldudzic</a> · <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a> · <a href=\"https://profiles.wordpress.org/danieltj/\">danieltj</a> · <a href=\"https://profiles.wordpress.org/nerrad/\">Darren Ethier (nerrad)</a> · <a href=\"https://profiles.wordpress.org/darshitrajyaguru97/\">Darshit Rajyaguru</a> · <a href=\"https://profiles.wordpress.org/darssen/\">darssen</a> · <a href=\"https://profiles.wordpress.org/davecpage/\">Dave Page</a> · <a href=\"https://profiles.wordpress.org/darerodz/\">David Arenas</a> · <a href=\"https://profiles.wordpress.org/dartiss/\">David Artiss</a> · <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> · <a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a> · <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a> · <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> · <a href=\"https://profiles.wordpress.org/justlevine/\">David Levine</a> · <a href=\"https://profiles.wordpress.org/dglingren/\">David Lingren</a> · <a href=\"https://profiles.wordpress.org/davidperez/\">David Perez</a> · <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> · <a href=\"https://profiles.wordpress.org/dsas/\">Dean Sas</a> · <a href=\"https://profiles.wordpress.org/denis-de-bernardy/\">Denis de Bernardy</a> · <a href=\"https://profiles.wordpress.org/dingo_d/\">Denis Žoljom</a> · <a href=\"https://profiles.wordpress.org/dionysous/\">Dennis Hipp</a> · <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a> · <a href=\"https://profiles.wordpress.org/dennysdionigi/\">Dennys Dionigi</a> · <a href=\"https://profiles.wordpress.org/derekblank/\">Derek Blank</a> · <a href=\"https://profiles.wordpress.org/valendesigns/\">Derek Herman</a> · <a href=\"https://profiles.wordpress.org/derekspringer/\">Derek Springer</a> · <a href=\"https://profiles.wordpress.org/designsimply/\">designsimply</a> · <a href=\"https://profiles.wordpress.org/desrosjbot/\">Desrosj Bot</a> · <a href=\"https://profiles.wordpress.org/dernin/\">Devin Curtis</a> · <a href=\"https://profiles.wordpress.org/dlocc/\">Devin Walker</a> · <a href=\"https://profiles.wordpress.org/dharm1025/\">Dharmesh Patel</a> · <a href=\"https://profiles.wordpress.org/dhrumilk/\">Dhrumil Kumbhani</a> · <a href=\"https://profiles.wordpress.org/dhruvishah2203/\">Dhruvi Shah</a> · <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> · <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a> · <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a> · <a href=\"https://profiles.wordpress.org/dougal/\">Dougal Campbell</a> · <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a> · <a href=\"https://profiles.wordpress.org/lots0logs/\">Dustin Falgout</a> · <a href=\"https://profiles.wordpress.org/elrae/\">Earle Davies</a> · <a href=\"https://profiles.wordpress.org/ehtis/\">Ehtisham Siddiqui</a> · <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van&nbsp;Durpe</a> · <a href=\"https://profiles.wordpress.org/codex-m/\">Emerson Maningo</a> · <a href=\"https://profiles.wordpress.org/emirpprime/\">emirpprime</a> · <a href=\"https://profiles.wordpress.org/manooweb/\">Emmanuel Hesry</a> · <a href=\"https://profiles.wordpress.org/endymion00/\">Endymion00</a> · <a href=\"https://profiles.wordpress.org/lopo/\">Enrico Battocchi</a> · <a href=\"https://profiles.wordpress.org/enwikuna/\">Enwikuna</a> · <a href=\"https://profiles.wordpress.org/ericlewis/\">Eric Andrew Lewis</a> · <a href=\"https://profiles.wordpress.org/ethitter/\">Erick Hitter</a> · <a href=\"https://profiles.wordpress.org/kebbet/\">Erik</a> · <a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a> · <a href=\"https://profiles.wordpress.org/evanltd/\">evanltd</a> · <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a> · <a href=\"https://profiles.wordpress.org/gaambo/\">Fabian Todt</a> · <a href=\"https://profiles.wordpress.org/fabiorubioglio/\">Fabio Rubioglio</a> · <a href=\"https://profiles.wordpress.org/faisalahammad/\">Faisal Ahammad</a> · <a href=\"https://profiles.wordpress.org/faisalahmed29/\">Faisal Ahmed</a> · <a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a> · <a href=\"https://profiles.wordpress.org/fanly/\">Fanly</a> · <a href=\"https://profiles.wordpress.org/feastdesignco/\">Feast Design Co.</a> · <a href=\"https://profiles.wordpress.org/felipeelia/\">Felipe Elia</a> · <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> · <a href=\"https://profiles.wordpress.org/flhz/\">Florent Hernandez</a> · <a href=\"https://profiles.wordpress.org/fgiannar/\">Foteini Giannaropoulou (a11n)</a> · <a href=\"https://profiles.wordpress.org/francina/\">Francesca Marano</a> · <a href=\"https://profiles.wordpress.org/francescocarlucci/\">FrancescoCarlucci</a> · <a href=\"https://profiles.wordpress.org/fotodrachen/\">Frank Jäger</a> · <a href=\"https://profiles.wordpress.org/nexflaszlo/\">Frank Laszlo</a> · <a href=\"https://profiles.wordpress.org/wazeter/\">Frank Wazeter</a> · <a href=\"https://profiles.wordpress.org/fushar/\">fushar</a> · <a href=\"https://profiles.wordpress.org/gajendrasingh/\">Gajendra Singh</a> · <a href=\"https://profiles.wordpress.org/ecgan/\">Gan Eng Chin</a> · <a href=\"https://profiles.wordpress.org/garibiza/\">Garbiñe</a> · <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a> · <a href=\"https://profiles.wordpress.org/gavande1/\">gavande1</a> · <a href=\"https://profiles.wordpress.org/soulseekah/\">Gennady Kovshenin</a> · <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> · <a href=\"https://profiles.wordpress.org/georgestephanis/\">George Stephanis</a> · <a href=\"https://profiles.wordpress.org/gerardreches/\">Gerard Reches</a> · <a href=\"https://profiles.wordpress.org/geriux/\">Gerardo Pacheco</a> · <a href=\"https://profiles.wordpress.org/girishpanchal/\">Girish Panchal</a> · <a href=\"https://profiles.wordpress.org/giuseppemazzapica-1/\">Giuseppe Mazzapica</a> · <a href=\"https://profiles.wordpress.org/glendaviesnz/\">Glen Davies</a> · <a href=\"https://profiles.wordpress.org/goldenapples/\">goldenapples</a> · <a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a> · <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a> · <a href=\"https://profiles.wordpress.org/gregbenz/\">gregbenz</a> · <a href=\"https://profiles.wordpress.org/wido/\">Guido Scialfa</a> · <a href=\"https://profiles.wordpress.org/poran766/\">H.M. Mushfiqur Rahman</a> · <a href=\"https://profiles.wordpress.org/hanneslsm/\">hanneslsm</a> · <a href=\"https://profiles.wordpress.org/hztyfoon/\">Hanzala Taifun</a> · <a href=\"https://profiles.wordpress.org/hardik2221/\">Hardik Raval</a> · <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh S</a> · <a href=\"https://profiles.wordpress.org/harshgajipara/\">Harsh Gajipara</a> · <a href=\"https://profiles.wordpress.org/harsh175/\">Harsh Patel</a> · <a href=\"https://profiles.wordpress.org/hasanuzzamanshamim/\">Hasanuzzaman Shamim</a> · <a href=\"https://profiles.wordpress.org/halounsbury/\">Heather Wilkins</a> · <a href=\"https://profiles.wordpress.org/muhme/\">Heiko Lübbe</a> · <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a> · <a href=\"https://profiles.wordpress.org/helgatheviking/\">HelgaTheViking</a> · <a href=\"https://profiles.wordpress.org/tejwanihemant/\">Hemant Tejwani</a> · <a href=\"https://profiles.wordpress.org/kurudrive/\">Hidekazu Ishikawa</a> · <a href=\"https://profiles.wordpress.org/panchalhimani711/\">Himani Panchal</a> · <a href=\"https://profiles.wordpress.org/hbhalodia/\">Hit Bhalodia</a> · <a href=\"https://profiles.wordpress.org/hiteshtalpada/\">Hitesh Talpada</a> · <a href=\"https://profiles.wordpress.org/h71/\">Hossein</a> · <a href=\"https://profiles.wordpress.org/howdy_mcgee/\">Howdy_McGee</a> · <a href=\"https://profiles.wordpress.org/hrrarya/\">Hridoy Mozumder</a> · <a href=\"https://profiles.wordpress.org/hrithikd/\">Hrithik Dalal</a> · <a href=\"https://profiles.wordpress.org/hlashbrooke/\">Hugh Lashbrooke</a> · <a href=\"https://profiles.wordpress.org/ganon/\">Hugo Chinchilla</a> · <a href=\"https://profiles.wordpress.org/hugod/\">hugod</a> · <a href=\"https://profiles.wordpress.org/huubl/\">huubl</a> · <a href=\"https://profiles.wordpress.org/huzaifaalmesbah/\">Huzaifa Al Mesbah</a> · <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> · <a href=\"https://profiles.wordpress.org/ianbelanger/\">Ian Belanger</a> · <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a> · <a href=\"https://profiles.wordpress.org/idad5/\">idad5</a> · <a href=\"https://profiles.wordpress.org/igmoweb/\">Ignacio Cruz Moreno</a> · <a href=\"https://profiles.wordpress.org/ignatiusjeroe/\">ignatiusjeroe</a> · <a href=\"https://profiles.wordpress.org/shaampk1/\">Ihtisham Zahoor</a> · <a href=\"https://profiles.wordpress.org/fnpen/\">Ilya Zolotov</a> · <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> · <a href=\"https://profiles.wordpress.org/iseulde/\">iseulde</a> · <a href=\"https://profiles.wordpress.org/itpathsolutions/\">IT Path Solutions</a> · <a href=\"https://profiles.wordpress.org/itecrs/\">itecrs</a> · <a href=\"https://profiles.wordpress.org/ivanzhuck/\">Ivan Zhuck</a> · <a href=\"https://profiles.wordpress.org/jacobcassidy/\">Jacob Cassidy</a> · <a href=\"https://profiles.wordpress.org/jadpm/\">jadpm</a> · <a href=\"https://profiles.wordpress.org/jamescollins/\">James Collins</a> · <a href=\"https://profiles.wordpress.org/macmanx/\">James Huff</a> · <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a> · <a href=\"https://profiles.wordpress.org/james roberts/\">James Roberts</a> · <a href=\"https://profiles.wordpress.org/jamieblomerus/\">Jamie Blomerus</a> · <a href=\"https://profiles.wordpress.org/perrelet/\">Jamie Perrelet</a> · <a href=\"https://profiles.wordpress.org/jane/\">jane</a> · <a href=\"https://profiles.wordpress.org/whiteshadow/\">Janis Elsts</a> · <a href=\"https://profiles.wordpress.org/jsandtro/\">jansan</a> · <a href=\"https://profiles.wordpress.org/janthiel/\">janthiel</a> · <a href=\"https://profiles.wordpress.org/japh/\">Japh</a> · <a href=\"https://profiles.wordpress.org/jsnajdr/\">Jarda Snajdr</a> · <a href=\"https://profiles.wordpress.org/jarednova/\">jarednova</a> · <a href=\"https://profiles.wordpress.org/jason_the_adams/\">Jason Adams</a> · <a href=\"https://profiles.wordpress.org/boogah/\">Jason Cosper</a> · <a href=\"https://profiles.wordpress.org/pbking/\">Jason Crist</a> · <a href=\"https://profiles.wordpress.org/coolmann/\">Jason Crouse</a> · <a href=\"https://profiles.wordpress.org/jsnjohnston/\">Jason Johnston</a> · <a href=\"https://profiles.wordpress.org/madtownlems/\">Jason LeMahieu (MadtownLems)</a> · <a href=\"https://profiles.wordpress.org/javiercasares/\">Javier Casares</a> · <a href=\"https://profiles.wordpress.org/jayadevankbh/\">Jayadevan k</a> · <a href=\"https://profiles.wordpress.org/jbobich/\">jbobich</a> · <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a> · <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a> · <a href=\"https://profiles.wordpress.org/cheffheid/\">Jeffrey de Wit</a> · <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a> · <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> · <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a> · <a href=\"https://profiles.wordpress.org/jeherve/\">Jeremy Herve</a> · <a href=\"https://profiles.wordpress.org/jeryj/\">jeryj</a> · <a href=\"https://profiles.wordpress.org/amieiro/\">Jesús Amieiro</a> · <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a> · <a href=\"https://profiles.wordpress.org/jghazally/\">jghazally</a> · <a href=\"https://profiles.wordpress.org/jipmoors/\">Jip Moors</a> · <a href=\"https://profiles.wordpress.org/jivygraphics/\">jivygraphics</a> · <a href=\"https://profiles.wordpress.org/jltallon/\">jltallon</a> · <a href=\"https://profiles.wordpress.org/joanrodas/\">Joan</a> · <a href=\"https://profiles.wordpress.org/morehawes/\">Joe</a> · <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> · <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a> · <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> · <a href=\"https://profiles.wordpress.org/joelcj91/\">Joel James</a> · <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a> · <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> · <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a> · <a href=\"https://profiles.wordpress.org/johnciacia/\">johnciacia</a> · <a href=\"https://profiles.wordpress.org/jb510/\">Jon Brown</a> · <a href=\"https://profiles.wordpress.org/duck_/\">Jon Cave</a> · <a href=\"https://profiles.wordpress.org/jonsurrell/\">Jon Surrell</a> · <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a> · <a href=\"https://profiles.wordpress.org/jbrinley/\">Jonathan Brinley</a> · <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> · <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a> · <a href=\"https://profiles.wordpress.org/joppuyo/\">joppuyo</a> · <a href=\"https://profiles.wordpress.org/jordesign/\">jordesign</a> · <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> · <a href=\"https://profiles.wordpress.org/jorgevilchez/\">Jorge Vilchez</a> · <a href=\"https://profiles.wordpress.org/jornp/\">jornp</a> · <a href=\"https://profiles.wordpress.org/joefusco/\">Joseph Fusco</a> · <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha</a> · <a href=\"https://profiles.wordpress.org/joshcanhelp/\">joshcanhelp</a> · <a href=\"https://profiles.wordpress.org/verygoode/\">Joshua Goode</a> · <a href=\"https://profiles.wordpress.org/joshuatf/\">joshuatf</a> · <a href=\"https://profiles.wordpress.org/joyously/\">Joy</a> · <a href=\"https://profiles.wordpress.org/jrtashjian/\">JR Tashjian</a> · <a href=\"https://profiles.wordpress.org/jsmoriss/\">JS Morisset</a> · <a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a> · <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a> · <a href=\"https://profiles.wordpress.org/juhise/\">Juhi Saxena</a> · <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a> · <a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a> · <a href=\"https://profiles.wordpress.org/ashikur698/\">K M Ashikur Rahman</a> · <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a> · <a href=\"https://profiles.wordpress.org/kafleg/\">KafleG</a> · <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a> · <a href=\"https://profiles.wordpress.org/bosskhj/\">Kamrul Hasan</a> · <a href=\"https://profiles.wordpress.org/karinclimber/\">Kari Anderson</a> · <a href=\"https://profiles.wordpress.org/karlijnbk/\">Karlijn Bok</a> · <a href=\"https://profiles.wordpress.org/karolmanijak/\">Karol Manijak</a> · <a href=\"https://profiles.wordpress.org/thekt12/\">Karthik Thayyil</a> · <a href=\"https://profiles.wordpress.org/tadamarketing/\">Katka</a> · <a href=\"https://profiles.wordpress.org/kawsaralameven/\">kawsaralameven</a> · <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/kbat82/\">Kevin Batdorf</a> · <a href=\"https://profiles.wordpress.org/kevincoleman/\">Kevin Coleman</a> · <a href=\"https://profiles.wordpress.org/kevinwhoffman/\">Kevin Hoffman</a> · <a href=\"https://profiles.wordpress.org/ktaron/\">Kevin Taron</a> · <a href=\"https://profiles.wordpress.org/kharisblank/\">Kharis Sulistiyono</a> · <a href=\"https://profiles.wordpress.org/khokansardar/\">Khokan Sardar</a> · <a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a> · <a href=\"https://profiles.wordpress.org/kishanjasani/\">Kishan Jasani</a> · <a href=\"https://profiles.wordpress.org/kitchin/\">kitchin</a> · <a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a> · <a href=\"https://profiles.wordpress.org/kkmuffme/\">kkmuffme</a> · <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a> · <a href=\"https://profiles.wordpress.org/koen12344/\">Koen Reus</a> · <a href=\"https://profiles.wordpress.org/koesper/\">Koesper</a> · <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a> · <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a> · <a href=\"https://profiles.wordpress.org/krupalpanchal/\">Krupal Panchal</a> · <a href=\"https://profiles.wordpress.org/kurtpayne/\">Kurt Payne</a> · <a href=\"https://profiles.wordpress.org/kushang78/\">Kushang Tailor</a> · <a href=\"https://profiles.wordpress.org/kdowns/\">Kylen Downs</a> · <a href=\"https://profiles.wordpress.org/laumindproductscomau/\">lau@mindproducts.com.au</a> · <a href=\"https://profiles.wordpress.org/lada7042/\">Laura Adamonis</a> · <a href=\"https://profiles.wordpress.org/laurlittle/\">Lauren Stein</a> · <a href=\"https://profiles.wordpress.org/wplmillet/\">Laurent MILLET</a> · <a href=\"https://profiles.wordpress.org/lakshmananphp/\">Lax Mariappan</a> · <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> · <a href=\"https://profiles.wordpress.org/munizleo/\">Leo Muniz</a> · <a href=\"https://profiles.wordpress.org/leonnugraha/\">Leonardus Nugraha</a> · <a href=\"https://profiles.wordpress.org/lgladdy/\">Liam Gladdy</a> · <a href=\"https://profiles.wordpress.org/liammcarthur/\">LiamMcArthur</a> · <a href=\"https://profiles.wordpress.org/rudlinkon/\">Linkon Miyan</a> · <a href=\"https://profiles.wordpress.org/liviopv/\">liviopv</a> · <a href=\"https://profiles.wordpress.org/lkraav/\">lkraav</a> · <a href=\"https://profiles.wordpress.org/logikal16/\">logikal16</a> · <a href=\"https://profiles.wordpress.org/louiswol94/\">Louis Wolmarans</a> · <a href=\"https://profiles.wordpress.org/thelovekesh/\">Lovekesh Kumar</a> · <a href=\"https://profiles.wordpress.org/luboslives/\">luboslives</a> · <a href=\"https://profiles.wordpress.org/lucasbustamante/\">lucasbustamante</a> · <a href=\"https://profiles.wordpress.org/zaguiini/\">Luis Felipe Zaguini</a> · <a href=\"https://profiles.wordpress.org/luisherranz/\">Luis Herranz</a> · <a href=\"https://profiles.wordpress.org/lpawlik/\">Lukas Pawlik</a> · <a href=\"https://profiles.wordpress.org/wpfed/\">Lukasz</a> · <a href=\"https://profiles.wordpress.org/lukefiretoss/\">Luke Cavanagh</a> · <a href=\"https://profiles.wordpress.org/maartenbelmans/\">Maarten</a> · <a href=\"https://profiles.wordpress.org/madhudollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/mrdollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> · <a href=\"https://profiles.wordpress.org/mhimon/\">Mahbub Hasan Imon</a> · <a href=\"https://profiles.wordpress.org/mahnewr/\">mahnewr</a> · <a href=\"https://profiles.wordpress.org/maahrokh/\">Mahrokh</a> · <a href=\"https://profiles.wordpress.org/malae/\">Malae</a> · <a href=\"https://profiles.wordpress.org/manfcarlo/\">manfcarlo</a> · <a href=\"https://profiles.wordpress.org/manyourisms/\">manyourisms</a> · <a href=\"https://profiles.wordpress.org/marc_j/\">Marc_J</a> · <a href=\"https://profiles.wordpress.org/fullofcaffeine/\">Marcelo de Moraes Serpa</a> · <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a> · <a href=\"https://profiles.wordpress.org/marcoevich/\">Marcoevich</a> · <a href=\"https://profiles.wordpress.org/margolisj/\">margolisj</a> · <a href=\"https://profiles.wordpress.org/chaton666/\">Marie Comet</a> · <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a> · <a href=\"https://profiles.wordpress.org/santosguillamot/\">Mario Santos</a> · <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a> · <a href=\"https://profiles.wordpress.org/markhowellsmead/\">Mark Howells-Mead</a> · <a href=\"https://profiles.wordpress.org/markjaquith/\">Mark Jaquith</a> · <a href=\"https://profiles.wordpress.org/markoheijnen/\">Marko Heijnen</a> · <a href=\"https://profiles.wordpress.org/markoserb/\">Marko Ivanovic</a> · <a href=\"https://profiles.wordpress.org/flootr/\">Markus</a> · <a href=\"https://profiles.wordpress.org/martinkrcho/\">martin.krcho</a> · <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a> · <a href=\"https://profiles.wordpress.org/mathewemoore/\">mathewemoore</a> · <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">Matias Benedetto</a> · <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a> · <a href=\"https://profiles.wordpress.org/matiasrecondo77/\">matiasrecondo77</a> · <a href=\"https://profiles.wordpress.org/webdevmattcrom/\">Matt Cromwell</a> · <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> · <a href=\"https://profiles.wordpress.org/matteoenna/\">Matteo Enna</a> · <a href=\"https://profiles.wordpress.org/cadic/\">Max Lyuchin</a> · <a href=\"https://profiles.wordpress.org/maxpertici/\">Maxime Pertici</a> · <a href=\"https://profiles.wordpress.org/mayur8991/\">Mayur Prajapati</a> · <a href=\"https://profiles.wordpress.org/hmbashar/\">Md Abul Bashar</a> · <a href=\"https://profiles.wordpress.org/mhshohel/\">Md Hossain Shohel</a> · <a href=\"https://profiles.wordpress.org/hrshahin/\">Md HR Shahin</a> · <a href=\"https://profiles.wordpress.org/devsahadat/\">Md Sahadat Husain</a> · <a href=\"https://profiles.wordpress.org/megphillips91/\">Meg Phillips</a> · <a href=\"https://profiles.wordpress.org/megane9988/\">megane9988</a> · <a href=\"https://profiles.wordpress.org/meher/\">Meher Bala</a> · <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/melcarthus/\">melcarthus</a> · <a href=\"https://profiles.wordpress.org/meta4/\">meta4</a> · <a href=\"https://profiles.wordpress.org/metropolis_john/\">metropolis_john</a> · <a href=\"https://profiles.wordpress.org/254volkan/\">mevolkan</a> · <a href=\"https://profiles.wordpress.org/wpscholar/\">Micah Wood</a> · <a href=\"https://profiles.wordpress.org/mshowes/\">Michael Showes</a> · <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> · <a href=\"https://profiles.wordpress.org/michalooki/\">Michalooki</a> · <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> · <a href=\"https://profiles.wordpress.org/miguelsansegundo/\">miguelsansegundo</a> · <a href=\"https://profiles.wordpress.org/miikkamakela/\">Miikka</a> · <a href=\"https://profiles.wordpress.org/mbijon/\">Mike Bijon</a> · <a href=\"https://profiles.wordpress.org/mikejolley/\">Mike Jolley (a11n)</a> · <a href=\"https://profiles.wordpress.org/mikeschinkel/\">Mike Schinkel</a> · <a href=\"https://profiles.wordpress.org/mikeschroder/\">Mike Schroder</a> · <a href=\"https://profiles.wordpress.org/mikinc860/\">Mikin Chauhan</a> · <a href=\"https://profiles.wordpress.org/gonzomir/\">Milen Petrinski – Gonzo</a> · <a href=\"https://profiles.wordpress.org/mimitips/\">mimi</a> · <a href=\"https://profiles.wordpress.org/illuminea/\">Miriam Schwab</a> · <a href=\"https://profiles.wordpress.org/mkismy/\">mkismy</a> · <a href=\"https://profiles.wordpress.org/mnydigital/\">mnydigital</a> · <a href=\"https://profiles.wordpress.org/batmoo/\">Mohammad Jangda</a> · <a href=\"https://profiles.wordpress.org/boemedia/\">Monique Dubbelman</a> · <a href=\"https://profiles.wordpress.org/monzuralam/\">Monzur Alam</a> · <a href=\"https://profiles.wordpress.org/man4toman/\">Morteza Geransayeh</a> · <a href=\"https://profiles.wordpress.org/mreishus/\">mreishus</a> · <a href=\"https://profiles.wordpress.org/mrwweb/\">mrwweb</a> · <a href=\"https://profiles.wordpress.org/seusmaniqbal/\">Muhammad Usman Iqbal</a> · <a href=\"https://profiles.wordpress.org/devmuhib/\">Muhibul Haque</a> · <a href=\"https://profiles.wordpress.org/mujuonly/\">mujuonly</a> · <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> · <a href=\"https://profiles.wordpress.org/faguni22/\">Mumtahina Faguni</a> · <a href=\"https://profiles.wordpress.org/tanjimtc71/\">Musarrat Anjum Chowdhury</a> · <a href=\"https://profiles.wordpress.org/nahidkhanseo/\">Nahid Khan</a> · <a href=\"https://profiles.wordpress.org/naoki0h/\">Naoki Ohashi</a> · <a href=\"https://profiles.wordpress.org/narenin/\">Narendra Sishodiya</a> · <a href=\"https://profiles.wordpress.org/nareshbheda/\">Naresh Bheda</a> · <a href=\"https://profiles.wordpress.org/nateallen/\">Nate Allen</a> · <a href=\"https://profiles.wordpress.org/navjotjsingh/\">Navjot Singh</a> · <a href=\"https://profiles.wordpress.org/nhrrob/\">Nazmul Hasan Robin</a> · <a href=\"https://profiles.wordpress.org/neffff/\">neffff</a> · <a href=\"https://profiles.wordpress.org/neilorangepeel/\">Neil Hainsworth</a> · <a href=\"https://profiles.wordpress.org/nendeb55/\">nendeb</a> · <a href=\"https://profiles.wordpress.org/nerdpressteam/\">NerdPress</a> · <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> · <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a> · <a href=\"https://profiles.wordpress.org/sessioncookiemonster/\">Nick Martianov</a> · <a href=\"https://profiles.wordpress.org/nickpagz/\">nickpagz</a> · <a href=\"https://profiles.wordpress.org/nico23/\">Nico</a> · <a href=\"https://profiles.wordpress.org/nicolefurlan/\">Nicole Furlan</a> · <a href=\"https://profiles.wordpress.org/bgnicolepaschen/\">Nicole Paschen Caylor</a> · <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a> · <a href=\"https://profiles.wordpress.org/nielslange/\">Niels Lange</a> · <a href=\"https://profiles.wordpress.org/nihar007/\">Nihar Ranjan Das</a> · <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> · <a href=\"https://profiles.wordpress.org/nko/\">Nikita</a> · <a href=\"https://profiles.wordpress.org/nikmeyer/\">nikmeyer</a> · <a href=\"https://profiles.wordpress.org/rabmalin/\">Nilambar Sharma</a> · <a href=\"https://profiles.wordpress.org/nilovelez/\">Nilo Velez</a> · <a href=\"https://profiles.wordpress.org/dhrupo/\">Niluthpal Purkayastha</a> · <a href=\"https://profiles.wordpress.org/niravsherasiya7707/\">Nirav Sherasiya</a> · <a href=\"https://profiles.wordpress.org/nithi22/\">Nithin John</a> · <a href=\"https://profiles.wordpress.org/nithins53/\">Nithin SreeRaj</a> · <a href=\"https://profiles.wordpress.org/noahtallen/\">Noah Allen</a> · <a href=\"https://profiles.wordpress.org/nosilver4u/\">nosilver4u</a> · <a href=\"https://profiles.wordpress.org/nvwd/\">Nowell VanHoesen</a> · <a href=\"https://profiles.wordpress.org/nudge/\">Nudge Themes</a> · <a href=\"https://profiles.wordpress.org/nwjames/\">nwjames</a> · <a href=\"https://profiles.wordpress.org/obliviousharmony/\">obliviousharmony</a> · <a href=\"https://profiles.wordpress.org/ockham/\">ockham</a> · <a href=\"https://profiles.wordpress.org/oguzkocer/\">oguzkocer</a> · <a href=\"https://profiles.wordpress.org/okat/\">okat</a> · <a href=\"https://profiles.wordpress.org/dargus/\">Old account</a> · <a href=\"https://profiles.wordpress.org/olegfuture/\">olegfuture</a> · <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a> · <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a> · <a href=\"https://profiles.wordpress.org/pablohoneyhoney/\">Pablo Honey</a> · <a href=\"https://profiles.wordpress.org/pacicio/\">Pacicio</a> · <a href=\"https://profiles.wordpress.org/pannelars/\">pannelars</a> · <a href=\"https://profiles.wordpress.org/partyfrikadelle/\">partyfrikadelle</a> · <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> · <a href=\"https://profiles.wordpress.org/patricia70/\">Patricia BT</a> · <a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a> · <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a> · <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a> · <a href=\"https://profiles.wordpress.org/pauldewouters/\">Paul de Wouters</a> · <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a> · <a href=\"https://profiles.wordpress.org/djpaul/\">Paul Wong-Gibbs</a> · <a href=\"https://profiles.wordpress.org/pavelevap/\">pavelevap</a> · <a href=\"https://profiles.wordpress.org/pbaylies/\">Peter Baylies</a> · <a href=\"https://profiles.wordpress.org/provenself/\">Peter Rubin</a> · <a href=\"https://profiles.wordpress.org/westi/\">Peter Westwood</a> · <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> · <a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a> · <a href=\"https://profiles.wordpress.org/tyrannous/\">Philipp Bammes</a> · <a href=\"https://profiles.wordpress.org/philipp15b/\">Philipp15b</a> · <a href=\"https://profiles.wordpress.org/phillsav/\">Phill</a> · <a href=\"https://profiles.wordpress.org/nekojonez/\">Pieterjan Deneys</a> · <a href=\"https://profiles.wordpress.org/mordauk/\">Pippin Williamson</a> · <a href=\"https://profiles.wordpress.org/pitamdey/\">Pitam Dey</a> · <a href=\"https://profiles.wordpress.org/pmeenan/\">pmeenan</a> · <a href=\"https://profiles.wordpress.org/webtechpooja/\">Pooja Derashri</a> · <a href=\"https://profiles.wordpress.org/pooja1210/\">Pooja N Muchandikar</a> · <a href=\"https://profiles.wordpress.org/pooja9712/\">pooja9712</a> · <a href=\"https://profiles.wordpress.org/pouicpouic/\">pouicpouic</a> · <a href=\"https://profiles.wordpress.org/pmbaldha/\">Prashant Baldha</a> · <a href=\"https://profiles.wordpress.org/pratikthink/\">Pratik Kumar</a> · <a href=\"https://profiles.wordpress.org/pratiklondhe/\">Pratik Londhe</a> · <a href=\"https://profiles.wordpress.org/freewebmentor/\">Prem Tiwari</a> · <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a> · <a href=\"https://profiles.wordpress.org/presstoke/\">presstoke</a> · <a href=\"https://profiles.wordpress.org/prionkor/\">prionkor</a> · <a href=\"https://profiles.wordpress.org/rafiq91/\">Rafiq</a> · <a href=\"https://profiles.wordpress.org/rajinsharwar/\">Rajin Sharwar</a> · <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a> · <a href=\"https://profiles.wordpress.org/rcorrales/\">Ramon Corrales</a> · <a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a> · <a href=\"https://profiles.wordpress.org/rashiguptaa/\">Rashi Gupta</a> · <a href=\"https://profiles.wordpress.org/ratneshsonar/\">Ratnesh Sonar</a> · <a href=\"https://profiles.wordpress.org/rawrly/\">rawrly</a> · <a href=\"https://profiles.wordpress.org/rcain/\">rcain</a> · <a href=\"https://profiles.wordpress.org/rebasaurus/\">rebasaurus</a> · <a href=\"https://profiles.wordpress.org/tabrisrp/\">Remy Perona</a> · <a href=\"https://profiles.wordpress.org/renathoc/\">Renatho (a11n)</a> · <a href=\"https://profiles.wordpress.org/renehermi/\">Rene Hermenau</a> · <a href=\"https://profiles.wordpress.org/retrofox/\">retrofox</a> · <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a> · <a href=\"https://profiles.wordpress.org/rdcoll/\">Rich Collier</a> · <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> · <a href=\"https://profiles.wordpress.org/rcreators/\">Rishi Mehta</a> · <a href=\"https://profiles.wordpress.org/rishishah/\">Rishi Shah</a> · <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> · <a href=\"https://profiles.wordpress.org/ravanh/\">Rolf Allard van Hagen</a> · <a href=\"https://profiles.wordpress.org/room34/\">room34</a> · <a href=\"https://profiles.wordpress.org/roytanck/\">Roy Tanck</a> · <a href=\"https://profiles.wordpress.org/ryan/\">Ryan Boren</a> · <a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a> · <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> · <a href=\"https://profiles.wordpress.org/pogidude/\">Ryann Micua</a> · <a href=\"https://profiles.wordpress.org/looswebstudio/\">Ryo</a> · <a href=\"https://profiles.wordpress.org/sereedmedia/\">Sé Reed</a> · <a href=\"https://profiles.wordpress.org/sebastienserre/\">Sébastien SERRE</a> · <a href=\"https://profiles.wordpress.org/soean/\">Sören Wünsch</a> · <a href=\"https://profiles.wordpress.org/sabbirshouvo/\">Sabbir Hasan</a> · <a href=\"https://profiles.wordpress.org/sachyya-sachet/\">Sachyya</a> · <a href=\"https://profiles.wordpress.org/sadizaman/\">Sadi Mohammad Zaman</a> · <a href=\"https://profiles.wordpress.org/sadpencil/\">sadpencil</a> · <a href=\"https://profiles.wordpress.org/introvertedbot/\">Sahil</a> · <a href=\"https://profiles.wordpress.org/tohincoderex/\">Saiduzzaman Tohin</a> · <a href=\"https://profiles.wordpress.org/sakibsnaz/\">Sakib MD Nazmush</a> · <a href=\"https://profiles.wordpress.org/salcode/\">Sal Ferrarello</a> · <a href=\"https://profiles.wordpress.org/xronn/\">Sam Berry</a> · <a href=\"https://profiles.wordpress.org/samba45/\">samba45</a> · <a href=\"https://profiles.wordpress.org/viralsampat/\">Sampat Viral</a> · <a href=\"https://profiles.wordpress.org/kim88/\">Samuel Rüegger</a> · <a href=\"https://profiles.wordpress.org/samuelsidler/\">Samuel Sidler</a> · <a href=\"https://profiles.wordpress.org/otto42/\">Samuel Wood (Otto)</a> · <a href=\"https://profiles.wordpress.org/sacerro/\">Santiago Cerro López</a> · <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a> · <a href=\"https://profiles.wordpress.org/sarathar/\">Sarath AR</a> · <a href=\"https://profiles.wordpress.org/satishprajapati/\">Satish Prajapati</a> · <a href=\"https://profiles.wordpress.org/hellosatya/\">Satyam Vishwakarma (Satya)</a> · <a href=\"https://profiles.wordpress.org/saxonafletcher/\">Saxon Fletcher</a> · <a href=\"https://profiles.wordpress.org/saxonfletcher/\">Saxon Fletcher</a> · <a href=\"https://profiles.wordpress.org/sayful/\">Sayful Islam</a> · <a href=\"https://profiles.wordpress.org/sc0ttkclark/\">Scott Kingsley Clark</a> · <a href=\"https://profiles.wordpress.org/coffee2code/\">Scott Reilly</a> · <a href=\"https://profiles.wordpress.org/wonderboymusic/\">Scott Taylor</a> · <a href=\"https://profiles.wordpress.org/scribu/\">scribu</a> · <a href=\"https://profiles.wordpress.org/sean212/\">Sean Fisher</a> · <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> · <a href=\"https://profiles.wordpress.org/sgr33n/\">Sergio De Falco</a> · <a href=\"https://profiles.wordpress.org/smrubenstein/\">Seth Rubenstein</a> · <a href=\"https://profiles.wordpress.org/shahariaazam/\">Shaharia Azam</a> · <a href=\"https://profiles.wordpress.org/shailu25/\">Shail Mehta</a> · <a href=\"https://profiles.wordpress.org/shanef/\">ShaneF</a> · <a href=\"https://profiles.wordpress.org/cafenoirdesign/\">Shannon Smith</a> · <a href=\"https://profiles.wordpress.org/shaunandrews/\">shaunandrews</a> · <a href=\"https://profiles.wordpress.org/shooper/\">Shawn Hooper</a> · <a href=\"https://profiles.wordpress.org/shidouhikari/\">shidouhikari</a> · <a href=\"https://profiles.wordpress.org/shiponkarmakar/\">Shipon Karmakar</a> · <a href=\"https://profiles.wordpress.org/shreyash3087/\">Shreyash Srivastava</a> · <a href=\"https://profiles.wordpress.org/shubhamsedani/\">Shubham Sedani</a> · <a href=\"https://profiles.wordpress.org/rsiddharth/\">siddharth ravikumar</a> · <a href=\"https://profiles.wordpress.org/siobhyb/\">Siobhan</a> · <a href=\"https://profiles.wordpress.org/sirajummahdi/\">Sirajum Mahdi</a> · <a href=\"https://profiles.wordpress.org/sjregan/\">sjregan</a> · <a href=\"https://profiles.wordpress.org/virtality-marketing-solutions/\">SourceView</a> · <a href=\"https://profiles.wordpress.org/sruthi89/\">sruthi89</a> · <a href=\"https://profiles.wordpress.org/stacimc/\">stacimc</a> · <a href=\"https://profiles.wordpress.org/ryokuhi/\">Stefano Minoia</a> · <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> · <a href=\"https://profiles.wordpress.org/stephencronin/\">Stephen Cronin</a> · <a href=\"https://profiles.wordpress.org/netweb/\">Stephen Edgar</a> · <a href=\"https://profiles.wordpress.org/stephenh1988/\">Stephen Harris</a> · <a href=\"https://profiles.wordpress.org/stevejonesdev/\">Steve Jones</a> · <a href=\"https://profiles.wordpress.org/stevenlinx/\">Steven Lin</a> · <a href=\"https://profiles.wordpress.org/strarsis/\">strarsis</a> · <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a> · <a href=\"https://profiles.wordpress.org/sumisubedi/\">Sumi Subedi</a> · <a href=\"https://profiles.wordpress.org/sumitbagthariya16/\">Sumit Bagthariya</a> · <a href=\"https://profiles.wordpress.org/sumitsingh/\">Sumit Singh</a> · <a href=\"https://profiles.wordpress.org/sunil25393/\">SunilPrajapati</a> · <a href=\"https://profiles.wordpress.org/svitlana41319/\">Svitlana Sukhoveiko</a> · <a href=\"https://profiles.wordpress.org/syamraj24/\">syamraj24</a> · <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a> · <a href=\"https://profiles.wordpress.org/smub/\">Syed Balkhi</a> · <a href=\"https://profiles.wordpress.org/nuhel/\">Syed Nuhel</a> · <a href=\"https://profiles.wordpress.org/synchro/\">Synchro</a> · <a href=\"https://profiles.wordpress.org/iamtakashi/\">Takashi Irie</a> · <a href=\"https://profiles.wordpress.org/inc2734/\">Takashi Kitajima</a> · <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a> · <a href=\"https://profiles.wordpress.org/voboghure/\">Tapan Kumer Das</a> · <a href=\"https://profiles.wordpress.org/sparklingrobots/\">Tara King</a> · <a href=\"https://profiles.wordpress.org/buley/\">Taylor</a> · <a href=\"https://profiles.wordpress.org/taylorde/\">Taylor Dewey</a> · <a href=\"https://profiles.wordpress.org/taylorgorman/\">Taylor Gorman</a> · <a href=\"https://profiles.wordpress.org/tazotodua/\">tazotodua</a> · <a href=\"https://profiles.wordpress.org/tykoted/\">Teddy Patriarca</a> · <a href=\"https://profiles.wordpress.org/tellyworth/\">Tellyworth</a> · <a href=\"https://profiles.wordpress.org/thakordarshil/\">Thakor Darshil</a> · <a href=\"https://profiles.wordpress.org/themes-1/\">them.es</a> · <a href=\"https://profiles.wordpress.org/thinkluke/\">thinkluke</a> · <a href=\"https://profiles.wordpress.org/griffinjt/\">Thomas Griffin</a> · <a href=\"https://profiles.wordpress.org/kraftner/\">Thomas Kräftner</a> · <a href=\"https://profiles.wordpress.org/threadi/\">threadi</a> · <a href=\"https://profiles.wordpress.org/tnolte/\">Tim Nolte</a> · <a href=\"https://profiles.wordpress.org/timbroddin/\">timbroddin</a> · <a href=\"https://profiles.wordpress.org/spaceshipone/\">Timothée Brosille</a> · <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> · <a href=\"https://profiles.wordpress.org/tmatsuur/\">tmatsuur</a> · <a href=\"https://profiles.wordpress.org/tobiasbg/\">TobiasBg</a> · <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn Fjellner)</a> · <a href=\"https://profiles.wordpress.org/tomybyte/\">Tom</a> · <a href=\"https://profiles.wordpress.org/tomjcafferkey/\">Tom Cafferkey</a> · <a href=\"https://profiles.wordpress.org/hifidesign/\">Tom Finley</a> · <a href=\"https://profiles.wordpress.org/tjnowell/\">Tom J Nowell</a> · <a href=\"https://profiles.wordpress.org/tomluckies/\">tomluckies</a> · <a href=\"https://profiles.wordpress.org/shimotomoki/\">Tomoki Shimomura</a> · <a href=\"https://profiles.wordpress.org/tomsommer/\">tomsommer</a> · <a href=\"https://profiles.wordpress.org/tomxygen/\">tomxygen</a> · <a href=\"https://profiles.wordpress.org/skithund/\">Toni Viemerö</a> · <a href=\"https://profiles.wordpress.org/starbuck/\">Tony G</a> · <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a> · <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a> · <a href=\"https://profiles.wordpress.org/torres126/\">torres126</a> · <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a> · <a href=\"https://profiles.wordpress.org/toru/\">Toru Miki</a> · <a href=\"https://profiles.wordpress.org/toscho/\">toscho</a> · <a href=\"https://profiles.wordpress.org/wpsmith/\">Travis Smith</a> · <a href=\"https://profiles.wordpress.org/tropicalista/\">tropicalista</a> · <a href=\"https://profiles.wordpress.org/truptikanzariya/\">Trupti Kanzariya</a> · <a href=\"https://profiles.wordpress.org/ugyensupport/\">Ugyen Dorji</a> · <a href=\"https://profiles.wordpress.org/up1512001/\">up1512001</a> · <a href=\"https://profiles.wordpress.org/upadalavipul/\">upadalavipul</a> · <a href=\"https://profiles.wordpress.org/utsav72640/\">Utsav tilava</a> · <a href=\"https://profiles.wordpress.org/ukdrahul/\">Uttam Kumar Dash</a> · <a href=\"https://profiles.wordpress.org/eboxnet/\">Vagelis</a> · <a href=\"https://profiles.wordpress.org/valerogarte/\">valerogarte</a> · <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a> · <a href=\"https://profiles.wordpress.org/gvgvgvijayan/\">Vijayan</a> · <a href=\"https://profiles.wordpress.org/vikram6/\">vikram6</a> · <a href=\"https://profiles.wordpress.org/viliamkopecky/\">viliamkopecky</a> · <a href=\"https://profiles.wordpress.org/vipuljnext/\">Vipul Ghori</a> · <a href=\"https://profiles.wordpress.org/vivekawsm/\">vivekawsm</a> · <a href=\"https://profiles.wordpress.org/vladimiraus/\">vladimiraus</a> · <a href=\"https://profiles.wordpress.org/vortfu/\">vortfu</a> · <a href=\"https://profiles.wordpress.org/vrajadas/\">Vraja Das</a> · <a href=\"https://profiles.wordpress.org/wasiur195/\">Wasiur Rahman</a> · <a href=\"https://profiles.wordpress.org/welaunchio/\">welaunchio</a> · <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a> · <a href=\"https://profiles.wordpress.org/whsajid/\">WHSajid</a> · <a href=\"https://profiles.wordpress.org/nestea29950/\">WilliamG</a> · <a href=\"https://profiles.wordpress.org/wpcorner/\">WP Corner</a> · <a href=\"https://profiles.wordpress.org/xlthlx/\">xlthlx</a> · <a href=\"https://profiles.wordpress.org/yansern/\">Yan Sern</a> · <a href=\"https://profiles.wordpress.org/yguyon/\">Yannis Guyon</a> · <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a> · <a href=\"https://profiles.wordpress.org/yuliyan/\">Yuliyan Slavchev</a> · <a href=\"https://profiles.wordpress.org/yuvrajsinh2211/\">Yuvrajsinh Sisodiya</a> · <a href=\"https://profiles.wordpress.org/tollmanz/\">Zack Tollman</a> · <a href=\"https://profiles.wordpress.org/zanematthew/\">Zane Matthew</a> · <a href=\"https://profiles.wordpress.org/zebaafiashama/\">Zeba Afia Shama</a> · <a href=\"https://profiles.wordpress.org/zieladam/\">zieladam</a> · <a href=\"https://profiles.wordpress.org/zunaid321/\">Zunaid Amin</a> · <a href=\"https://profiles.wordpress.org/chesio/\">Česlav Przywara</a></p>\n\n\n\n<h1 class=\"wp-block-heading\">Merci aux personnes ayant contribué à traduire WordPress 6.6 en français</h1>\n\n\n\n<p>WordPress est un projet international et la version 6.6 est déjà complètement disponible dans plus de 70 langues différentes.</p>\n\n\n\n<p>Nous souhaitons remercier ici les personnes ayant participé à la traduction de WordPress 6.6 en français :</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/jdy68\">Jenny Dupuy</a>, <a href=\"https://profiles.wordpress.org/wolforg\">Didier Demory</a>, <a href=\"https://profiles.wordpress.org/fxbenard\">fxbenard</a>, <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/amebref\">amebref</a>, <a href=\"https://profiles.wordpress.org/beryldlg\">Béryl de La Grandière</a>, <a href=\"https://profiles.wordpress.org/bonaldi\">Bonaldi</a>, <a href=\"https://profiles.wordpress.org/chris-kns\">chris-kns</a>, <a href=\"https://profiles.wordpress.org/clementpolito\">Clément Polito</a>, <a href=\"https://profiles.wordpress.org/coralietixeront\">coralietixeront</a>, <a href=\"https://profiles.wordpress.org/eddystile\">Eddy</a>, <a href=\"https://profiles.wordpress.org/emlebrun\">Emilie LEBRUN</a>, <a href=\"https://profiles.wordpress.org/scoco\">Emilien M.</a>, <a href=\"https://profiles.wordpress.org/florientinneo\">Florient DELAFOY</a>, <a href=\"https://profiles.wordpress.org/gaeldenysiak\">Gael Denysiak</a>, <a href=\"https://profiles.wordpress.org/gaellebesson\">gaellebesson</a>, <a href=\"https://profiles.wordpress.org/karine-wendling\">karine wendling</a>, <a href=\"https://profiles.wordpress.org/laeti972\">laeti972</a>, <a href=\"https://profiles.wordpress.org/wplmillet\">Laurent MILLET</a>, <a href=\"https://profiles.wordpress.org/nuryko\">Marianna</a>, <a href=\"https://profiles.wordpress.org/marineevain\">Marine EVAIN</a>, <a href=\"https://profiles.wordpress.org/lymx\">Maxime LEROY</a>, <a href=\"https://profiles.wordpress.org/momo-fr\">momo-fr</a>, <a href=\"https://profiles.wordpress.org/nlangle\">Nicolas Langle</a>, <a href=\"https://profiles.wordpress.org/mrbalou06\">Pascal T</a>, <a href=\"https://profiles.wordpress.org/pierrelannoy\">Pierre Lannoy</a>, <a href=\"https://profiles.wordpress.org/nekojonez\">Pieterjan Deneys</a>, <a href=\"https://profiles.wordpress.org/larrach\">Rachel Peter</a>, <a href=\"https://profiles.wordpress.org/sebastienserre\">Sébastien SERRE</a>, <a href=\"https://profiles.wordpress.org/spaceshipone\">Timothée Brosille</a>, <a href=\"https://profiles.wordpress.org/valer1e\">Valérie Galassi</a>, <a href=\"https://profiles.wordpress.org/virgar\">Virginie Garnier</a>, et <a href=\"https://profiles.wordpress.org/whaze\">whaze</a>.</p>\n\n\n\n<p></p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3181\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"Comment contribuer aux « release parties » des nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"https://fr.wordpress.org/2024/07/15/comment-contribuer-aux-release-parties-des-nouvelles-versions-de-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 15 Jul 2024 13:28:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Contribuer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3159\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:383:\"Lors des phases de développement d’une nouvelle version de WordPress, il est possible d’aider à la livraison des versions bêta et release candidate de WP en participant aux « release parties », qui sont des événements planifiés à l’avance pour procéder à la construction d’une version bêta ou release candidate, ou d&#8217;une version finale, et à sa [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:7155:\"\n<p>Lors des phases de développement d’une nouvelle version de WordPress, il est possible d’aider à la livraison des versions bêta et <em><bdo lang=\"en\" dir=\"ltr\">release candidate</bdo></em> de WP en participant aux <em><bdo lang=\"en\" dir=\"ltr\">« release parties »</bdo></em>, qui sont des événements planifiés à l’avance pour procéder à la construction d’une version bêta ou release candidate, ou d&rsquo;une version finale, et à sa livraison au public.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Prérequis</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Aucun niveau technique particulier n’est nécessaire à part savoir utiliser WordPress</li>\n\n\n\n<li>Avoir un site de test installé en local ou en ligne</li>\n\n\n\n<li>Installer l’extension <em><bdo lang=\"en\" dir=\"ltr\"><a href=\"https://fr.wordpress.org/plugins/wordpress-beta-tester/\">Beta Tester</a></bdo></em> et la paramétrer (dans <code>Outils &gt; Test Bêta</code>) de la façon suivante (ici nous sommes sur une installation en anglais, si vous êtes sur une installation en français, faites la correspondance des options)&nbsp;:</li>\n</ul>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fr.wordpress.org/files/2024/07/reglages-beta-tester.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"427\" src=\"https://fr.wordpress.org/files/2024/07/reglages-beta-tester-1024x427.png\" alt=\"\" class=\"wp-image-3160\" srcset=\"https://fr.wordpress.org/files/2024/07/reglages-beta-tester-1024x427.png 1024w, https://fr.wordpress.org/files/2024/07/reglages-beta-tester-300x125.png 300w, https://fr.wordpress.org/files/2024/07/reglages-beta-tester-768x320.png 768w, https://fr.wordpress.org/files/2024/07/reglages-beta-tester-1536x641.png 1536w, https://fr.wordpress.org/files/2024/07/reglages-beta-tester-2048x854.png 2048w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p><em><bdo lang=\"en\" dir=\"ltr\">Bleeding edge</bdo></em> : version en cours de développement. Cette version utilise le code en cours de développement (<em><bdo lang=\"en\" dir=\"ltr\">Bleeding edge nightlies</bdo></em>) qui peut parfois être instable. <em>Ne l’utilisez en production que si vous savez vraiment ce que vous faites</em>.</p>\n\n\n\n<p><em><bdo lang=\"en\" dir=\"ltr\">Bêta/RC only </bdo></em>: ceci concerne uniquement les versions bêta/RC du canal sélectionné.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Déroulement de la <em><bdo lang=\"en\" dir=\"ltr\">release party</bdo></em></h2>\n\n\n\n<p>Les <em><bdo lang=\"en\" dir=\"ltr\">release parties</bdo></em> se déroulent entièrement sur le Slack <a href=\"http://Make.WordPress.org\">Make.WordPress.org</a>, sur le canal #core. Pour le rejoindre utilisez votre nom de compte WordPress.org, ici : <a href=\"https://make.wordpress.org/chat/\">https://make.wordpress.org/chat/</a>.</p>\n\n\n\n<p>Généralement, il y en a pour 30-40 minutes si c’est une version beta/RC.</p>\n\n\n\n<p>Normalement les <em><bdo lang=\"en\" dir=\"ltr\">release parties</bdo></em> commencent à peu près à l’heure, souvent en fin d’après midi. Voici le déroulement :</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Message d’accueil de la personne qui dirige la <bdo lang=\"en\" dir=\"ltr\"><em>release party</em></bdo>, tout le monde fait coucou et ça permet de consigner le nombre de contributrices et contributeurs qui participent à la <em><bdo lang=\"en\" dir=\"ltr\">release</bdo></em></li>\n\n\n\n<li>Quelques<bdo lang=\"en\" dir=\"ltr\"> vérificatio</bdo>ns techniques entre le ou la <em><bdo lang=\"en\" dir=\"ltr\">lead</bdo></em>, la personne faisant office de <em><bdo lang=\"en\" dir=\"ltr\">committer</bdo></em> (qui va créer la version de WordPress concernée) et le contrôle de mission (<em><bdo lang=\"en\" dir=\"ltr\">mission control</bdo></em>, qui est chargé de construire le paquet ZIP de la version), ça peut prendre 10-15 minutes mais c’est souvent moins.</li>\n\n\n\n<li>Les checks de sécurité et les tests unitaires sont lancés par la personne chargée des <em><bdo lang=\"en\" dir=\"ltr\">commits</bdo></em> et le contrôle de mission</li>\n\n\n\n<li>Le ou la <em><bdo lang=\"en\" dir=\"ltr\">core committer</bdo></em> fait un premier <bdo lang=\"en\" dir=\"ltr\"><em>commit</em></bdo> de version</li>\n\n\n\n<li>Le contrôle de mission livre un premier ZIP de la version</li>\n\n\n\n<li>C’EST LÀ QUE VOUS INTERVENEZ ! Vous pouvez&nbsp;:\n<ul class=\"wp-block-list\">\n<li>(plus long) Récupérer le ZIP et l’installer en local</li>\n\n\n\n<li>(plus rapide mais plus technique) Installer la version via <em>WP-CLI</em></li>\n\n\n\n<li>(recommandé) Via Beta Tester :\n<ul class=\"wp-block-list\">\n<li>Aller sur une installation avec l’extension WP Beta Tester installée, paramétrée comme expliqué ci-dessus</li>\n\n\n\n<li>Normalement, au bout de quelques secondes après que le ZIP soit disponible, vous devriez voir un petit message sur l’écran d’accueil de l’admin indiquant qu’une nouvelle version est disponible pour test</li>\n\n\n\n<li>Pensez à noter le numéro de version de WP que vous aviez avant de mettre à jour !</li>\n\n\n\n<li>Cliquez sur le lien de mise à jour et installez la version</li>\n</ul>\n</li>\n</ul>\n</li>\n\n\n\n<li>Les choses que vous pouvez tester :\n<ul class=\"wp-block-list\">\n<li>Fonctionnement de quelques écrans de l’admin</li>\n\n\n\n<li>Bon fonctionnement de l’éditeur : insertion d’un bloc, enregistrement d’un article</li>\n\n\n\n<li>Bon fonctionnement de l’éditeur de site (navigation dans quelques écrans)</li>\n\n\n\n<li>Bon fonctionnement de quelques écrans du front</li>\n\n\n\n<li>Bon fonctionnement de l&rsquo;éditeur après installation d&rsquo;un thème classique</li>\n\n\n\n<li>Bon fonctionnement de l&rsquo;éditeur après installation de l&rsquo;extension <em><bdo lang=\"en\" dir=\"ltr\"><a href=\"https://fr.wordpress.org/plugins/classic-editor/\">Classic Editor</a></bdo></em></li>\n\n\n\n<li>Si vous disposez d&rsquo;une instance multisite, mentionnez-le</li>\n\n\n\n<li>Si vous avez les moyens de tester la mise à jour depuis une vieille version de WP (version 4.9 ou au dessus), c&rsquo;est très utile aussi. Mentionnez la version depuis laquelle vous avez fait la mise à jour</li>\n</ul>\n</li>\n\n\n\n<li>Une fois que vous avez testé, mettez un petit message dans le canal #core, en indiquant la version que vous aviez avant la <abbr title=\"Mise à jour\">MAJ</abbr> et la version vers laquelle vous avez mis à jour. Par exemple :</li>\n</ul>\n\n\n\n<figure class=\"wp-block-image size-full is-resized\"><a href=\"https://fr.wordpress.org/files/2024/07/Capture-decran-2024-03-05-a-10.42.10.png\"><img loading=\"lazy\" decoding=\"async\" width=\"706\" height=\"806\" src=\"https://fr.wordpress.org/files/2024/07/Capture-decran-2024-03-05-a-10.42.10.png\" alt=\"\" class=\"wp-image-3161\" style=\"width:400px\" srcset=\"https://fr.wordpress.org/files/2024/07/Capture-decran-2024-03-05-a-10.42.10.png 706w, https://fr.wordpress.org/files/2024/07/Capture-decran-2024-03-05-a-10.42.10-263x300.png 263w\" sizes=\"auto, (max-width: 706px) 100vw, 706px\" /></a></figure>\n\n\n\n<p>Vous pourrez ensuite suivre le reste de la <em><bdo lang=\"en\" dir=\"ltr\">release party</bdo></em> tranquillement.</p>\n\n\n\n<p>Et vous serez aussi crédité·es pour votre participation à cette version. Bravo&nbsp;!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3159\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"Guide des changements techniques de WordPress 6.6\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://fr.wordpress.org/2024/06/27/guide-des-changements-techniques-de-wordpress-6-6/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 27 Jun 2024 08:36:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:5:\"Guide\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3125\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:140:\"Ce guide décrit les principaux changements techniques que vous trouverez sur WordPress 6.6, dont la sortie est prévue le 16 juillet 2024.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:33232:\"\n<figure class=\"wp-block-image alignfull size-large\"><a href=\"https://fr.wordpress.org/files/2024/06/WP-66-guide-changements-techniques-min.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"548\" src=\"https://fr.wordpress.org/files/2024/06/WP-66-guide-changements-techniques-min-1024x548.png\" alt=\"\" class=\"wp-image-3134\" srcset=\"https://fr.wordpress.org/files/2024/06/WP-66-guide-changements-techniques-min-1024x548.png 1024w, https://fr.wordpress.org/files/2024/06/WP-66-guide-changements-techniques-min-300x160.png 300w, https://fr.wordpress.org/files/2024/06/WP-66-guide-changements-techniques-min-768x411.png 768w, https://fr.wordpress.org/files/2024/06/WP-66-guide-changements-techniques-min-1536x821.png 1536w, https://fr.wordpress.org/files/2024/06/WP-66-guide-changements-techniques-min-2048x1095.png 2048w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p class=\"is-style-serif has-blueberry-4-background-color has-background\">Ce guide décrit les principaux changements techniques que vous trouverez sur WordPress&nbsp;6.6, dont la sortie est prévue le 16 juillet 2024.</p>\n\n\n\n<p>WordPress 6.6 comprend au minimum la résolution de <a href=\"https://core.trac.wordpress.org/query?resolution=fixed&amp;milestone=6.6&amp;group=component&amp;col=id&amp;col=summary&amp;col=type&amp;order=type\" target=\"_blank\" rel=\"noreferrer noopener\">299 tickets Trac</a>, dont <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=enhancement&amp;type=feature+request&amp;milestone=6.6&amp;max=500&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">108 améliorations et nouvelles fonctionnalités</a>, <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=defect+(bug)&amp;milestone=6.5&amp;max=500&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">171 résolutions de bogues</a> et <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=task+(blessed)&amp;milestone=6.6&amp;max=500&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">10 autres tâches de maintenance</a>. Pour cette version, <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~performance&amp;milestone=6.6&amp;group=component&amp;col=id&amp;col=summary&amp;col=status&amp;col=focuses&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">16 tickets étaient centrés sur les performances</a>, <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~accessibility&amp;milestone=6.6&amp;group=component&amp;col=id&amp;col=summary&amp;col=status&amp;col=focuses&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">24 sur l&rsquo;accessibilité</a> et <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~coding-standards&amp;milestone=6.6&amp;group=component&amp;col=id&amp;col=summary&amp;col=status&amp;col=focuses&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">15 tickets portaient sur la modernisation du code source de notre CMS</a>. Les modifications de WP&nbsp;6.6 concernent <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.6&amp;group=component&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">40 composants du code source de WordPress</a>.</p>\n\n\n\n<p>Cette version comprend aussi 392 améliorations, 462 corrections de bogues et 46 améliorations de l&rsquo;accessibilité de <a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.6\">l&rsquo;éditeur de blocs</a> (Gutenberg).</p>\n\n\n\n<p>Tous les liens de cet article pointent vers des notes de développement rédigées en anglais. L’objectif est de fournir un panorama général des changements techniques apportés par cette version, en français, puis de diriger les personnes qui souhaitent en savoir plus vers les notes de développement en anglais.</p>\n\n\n\n<p>Pour en savoir plus sur la feuille de route et le calendrier de sortie de WP&nbsp;6.6, consultez cette page : <a href=\"https://make.wordpress.org/core/6-5/\">https://make.wordpress.org/core/6-5/</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h2 class=\"wp-block-heading\" id=\"Block-Editor\">Changements concernant l’éditeur et le projet Gutenberg</h2>\n\n\n\n<p>WordPress 6.6 implémente 8 versions de Gutenberg &#8211; <a href=\"https://make.wordpress.org/core/2024/02/28/whats-new-in-gutenberg-17-8-28-february/\">17.8</a>, <a href=\"https://make.wordpress.org/core/2024/03/13/whats-new-in-gutenberg-17-9-13-march/\">17.9</a>, <a href=\"https://make.wordpress.org/core/2024/03/27/whats-new-in-gutenberg-18-0-27-march/\">18.0</a>, <a href=\"https://make.wordpress.org/core/2024/04/10/whats-new-in-gutenberg-18-1-10-april/\">18.1</a>, <a href=\"https://make.wordpress.org/core/2024/04/24/whats-new-in-gutenberg-18-2-24-april/\">18.2</a>, <a href=\"https://make.wordpress.org/core/2024/05/08/whats-new-in-gutenberg-18-3-8-may/\">18.3</a>, <a href=\"https://make.wordpress.org/core/2024/05/23/whats-new-in-gutenberg-18-4-22-may/\">18.4</a> et <a href=\"https://make.wordpress.org/core/2024/06/09/what-is-new-in-gutenberg-18-5-05-jun/\">18.5</a>. L&rsquo;éditeur de blocs reçoit ainsi de nombreuses améliorations liées à la bibliothèque React, à l’API <code>Block</code>, à la gestion des thèmes, et bien plus encore.</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"react\">React</h3>\n\n\n\n<p>Une nouvelle version de React et la nouvelle <a href=\"https://legacy.reactjs.org/blog/2020/09/22/introducing-the-new-jsx-transform.html\">API JSX transform</a> font leur entrée dans WordPress&nbsp;6.6.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"dWLxJUI3h0\"><a href=\"https://make.wordpress.org/core/2024/06/06/jsx-in-wordpress-6-6/\">JSX in WordPress 6.6</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;JSX in WordPress 6.6&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/06/jsx-in-wordpress-6-6/embed/#?secret=XMglYBeDLC#?secret=dWLxJUI3h0\" data-secret=\"dWLxJUI3h0\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"52Rfu8yAtE\"><a href=\"https://make.wordpress.org/core/2024/06/07/preparation-for-react-19-upgrade/\">Preparation for React 19 Upgrade</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Preparation for React 19 Upgrade&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/07/preparation-for-react-19-upgrade/embed/#?secret=YV2Zkzjfyy#?secret=52Rfu8yAtE\" data-secret=\"52Rfu8yAtE\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"block-api\">API <code>Block</code></h3>\n\n\n\n<p>Des changements arrivent sur l&rsquo;API <code>Block</code>&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Unification des API d&rsquo;extensibilité entre les éditeurs de publications et du site</li>\n\n\n\n<li>Amélioration de la propriété <code>isActive</code> sur les variations de blocs</li>\n\n\n\n<li>Améliorations de plusieurs blocs proposés par le cœur de WordPress</li>\n</ul>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"FC595uD9El\"><a href=\"https://make.wordpress.org/core/2024/06/18/editor-unified-extensibility-apis-in-6-6/\">Editor: Unified Extensibility APIs in 6.6</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Editor: Unified Extensibility APIs in 6.6&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/18/editor-unified-extensibility-apis-in-6-6/embed/#?secret=d9wcTgYeLu#?secret=FC595uD9El\" data-secret=\"FC595uD9El\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"vsiCQ8RUpF\"><a href=\"https://make.wordpress.org/core/2024/06/18/improvements-to-active-block-variation-detection/\">Improvements to active block variation detection</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Improvements to active block variation detection&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/18/improvements-to-active-block-variation-detection/embed/#?secret=BlfgJ2v86t#?secret=vsiCQ8RUpF\" data-secret=\"vsiCQ8RUpF\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"fcUHSrfEG8\"><a href=\"https://make.wordpress.org/core/2024/06/19/social-links-block-changes-in-wordpress-6-6/\">Social Links block changes in WordPress 6.6</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Social Links block changes in WordPress 6.6&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/19/social-links-block-changes-in-wordpress-6-6/embed/#?secret=KTnVlZwICZ#?secret=fcUHSrfEG8\" data-secret=\"fcUHSrfEG8\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"themes-6-6\">Thèmes</h3>\n\n\n\n<p>WordPress 6.6 introduit plusieurs mises à jour liées aux thèmes, comprenant&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Une nouvelle version 3 du <code>theme.json</code></li>\n\n\n\n<li>L&rsquo;uniformisation de la spécificité CSS appliquée aux styles du cœur de WP</li>\n\n\n\n<li>Introduction de la section «&nbsp;styles&nbsp;» pour améliorer l&rsquo;efficacité de la personnalisation des blocs et de leurs éléments internes</li>\n\n\n\n<li>Fonctionnalités additionnelles de la mise en page en grille dans les blocs</li>\n\n\n\n<li>Capacité de définir des images d&rsquo;arrière-plan pour l&rsquo;ensemble du site via le <code>theme.json</code> et via l’éditeur de site</li>\n</ul>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"3qkQI6VB3V\"><a href=\"https://make.wordpress.org/core/2024/06/19/theme-json-version-3/\">Theme.json version 3</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Theme.json version 3&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/19/theme-json-version-3/embed/#?secret=qFVVO9yctD#?secret=3qkQI6VB3V\" data-secret=\"3qkQI6VB3V\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"WwNatJ4yuP\"><a href=\"https://make.wordpress.org/core/2024/06/24/section-styles/\">Section Styles</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Section Styles&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/24/section-styles/embed/#?secret=myss8Gv9Su#?secret=WwNatJ4yuP\" data-secret=\"WwNatJ4yuP\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"5tYWFN7C0m\"><a href=\"https://make.wordpress.org/core/2024/06/21/wordpress-6-6-css-specificity/\">WordPress 6.6 CSS Specificity</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;WordPress 6.6 CSS Specificity&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/21/wordpress-6-6-css-specificity/embed/#?secret=0Ak975GLQd#?secret=5tYWFN7C0m\" data-secret=\"5tYWFN7C0m\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"g0n7RPlGmY\"><a href=\"https://make.wordpress.org/core/2024/06/18/grid-layout-type/\">Grid layout type</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Grid layout type&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/18/grid-layout-type/embed/#?secret=c59OLorfmE#?secret=g0n7RPlGmY\" data-secret=\"g0n7RPlGmY\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"ZPfvPc14dl\"><a href=\"https://make.wordpress.org/core/2024/06/20/site-wide-background-images-in-wordpress-6-6/\">Site-wide background images in WordPress 6.6</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Site-wide background images in WordPress 6.6&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/20/site-wide-background-images-in-wordpress-6-6/embed/#?secret=GtFb16IOEz#?secret=ZPfvPc14dl\" data-secret=\"ZPfvPc14dl\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"miscellaneous-block-editor-changes\">Modifications diverses concernant l’éditeur</h3>\n\n\n\n<p>Plusieurs autres modifications de l’éditeur de bloc sont aussi incluses dans WordPress 6.6 :</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#Added-wp-block-list-class-to-the-list-block\">Ajout de la classe <code>wp-block-list</code>&nbsp;au bloc Liste</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#New-Interactivity-API-directives\">Nouvelles directives pour l&rsquo;API <code>Interactivity</code></a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#Allow-view-access-of-the-template-REST-API-endpoint-to-anyone-with-the-edit_post-capability\">Ajout de l’accès en lecture au point de terminaison <code>template</code> de l’API REST à toute personne disposant de la permission <code>edit_post</code></a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#Unified-split-logic-for-writing-flow\">Unification de la logique de séparation dans le flux de rédaction</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#BlockPopover-Component-is-now-public\">Le composant BlockPopover est maintenant public</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#Add-filter-to-modify-the-list-of-post-content-block-types\">Ajout d&rsquo;un filtre pour modifier la liste des types de blocs de contenu</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#Global-Styles-Filter-out-color-and-typography-variations\">Styles globaux&nbsp;: ajout de filtres pour les variations de couleur et de typographie</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#Add-custom-Aspect-Ratio-presets-through-theme-json\">Ajout de pré-réglages de proportions gérables via le fichier&nbsp;<code>theme.json</code></a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#root-padding-style-updates\">Mise à jour des styles de marge interne racine via <code>:root</code></a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#Added-Text-alignment-block-support\">Ajout de la prise en charge de l&rsquo;alignement de texte des blocs</a></li>\n</ul>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"zwjsgiLBc3\"><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/\">Miscellaneous Editor changes in WordPress 6.6</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Miscellaneous Editor changes in WordPress 6.6&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/embed/#?secret=ixOVYPSn2d#?secret=zwjsgiLBc3\" data-secret=\"zwjsgiLBc3\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<p>Un tableau des outils de conception supportés par chaque bloc sur WordPress&nbsp;6.6 a été publié en guise de référence.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"dIjJDZTSGY\"><a href=\"https://make.wordpress.org/core/2024/06/20/roster-of-design-tools-per-block-wordpress-6-6-edition/\">Roster of design tools per block (WordPress 6.6 edition)</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Roster of design tools per block (WordPress 6.6 edition)&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/20/roster-of-design-tools-per-block-wordpress-6-6-edition/embed/#?secret=xV9lWVls3h#?secret=dIjJDZTSGY\" data-secret=\"dIjJDZTSGY\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"html-api\">API HTML</h2>\n\n\n\n<p>WordPress 6.6 comprend une version de maintenance de l&rsquo;API HTML. Cela inclut quelques nouvelles fonctionnalités et une amélioration majeure de l&rsquo;utilisabilité du processeur HTML. Cela poursuit les travaux d&rsquo;amélioration continue engagés depuis WP 6.5.</p>\n\n\n\n<p>Une nouvelle structure de données vient aussi avec la version 6.6&nbsp;: il s&rsquo;agit de l&rsquo;API&nbsp;<code>WP_Token_Map</code>.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"wuD7UIc043\"><a href=\"https://make.wordpress.org/core/2024/06/24/updates-to-the-html-api-in-6-6/\">Updates to the HTML API in 6.6</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to the HTML API in 6.6&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/24/updates-to-the-html-api-in-6-6/embed/#?secret=jA5d2tI5LY#?secret=wuD7UIc043\" data-secret=\"wuD7UIc043\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"cLzvpODa71\"><a href=\"https://make.wordpress.org/core/2024/06/24/introducing-the-token-map/\">Introducing the Token Map</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Introducing the Token Map&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/24/introducing-the-token-map/embed/#?secret=96WcqwTl9C#?secret=cLzvpODa71\" data-secret=\"cLzvpODa71\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"options-api\">API <code>Options</code></h2>\n\n\n\n<p>Plusieurs modifications ont été faites sur l&rsquo;API <code>Options</code> pour prendre en charge une optimisation du comportement de chargement automatique et pour créer une façon d’appliquer les prochaines optimisations à venir.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"sY4OPd8z50\"><a href=\"https://make.wordpress.org/core/2024/06/18/options-api-disabling-autoload-for-large-options/\">Options API: Disabling autoload for large options</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Options API: Disabling autoload for large options&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/18/options-api-disabling-autoload-for-large-options/embed/#?secret=Fd1Vmk80wn#?secret=sY4OPd8z50\" data-secret=\"sY4OPd8z50\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"i18n\">Internationalisation</h2>\n\n\n\n<p><a href=\"https://core.trac.wordpress.org/query?component=I18N&amp;milestone=6.5&amp;&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=status&amp;col=priority&amp;order=priority\">Plusieurs améliorations de l&rsquo;internationalisation</a> ont été intégrées dans WP&nbsp;6.6&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/i18n-improvements-6-6#Enhanced-support-for-only-using-PHP-translation-files\">Amélioration de la prise en charge des fichiers de traduction PHP</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/i18n-improvements-6-6#New-lang_dir_for_domain-filter\">Nouveau filtre&nbsp;<code>lang_dir_for_domain</code></a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/i18n-improvements-6-6#Additional-context-for-the-load_translation_file-filter\">Ajout d&rsquo;un contexte pour le filtre <code>load_translation_file</code></a></li>\n</ul>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"MSrk50CwxF\"><a href=\"https://make.wordpress.org/core/2024/06/24/i18n-improvements-6-6/\">Internationalization improvements in 6.6</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Internationalization improvements in 6.6&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/24/i18n-improvements-6-6/embed/#?secret=3bBLcbcQOl#?secret=MSrk50CwxF\" data-secret=\"MSrk50CwxF\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"miscellaneous-developer-changes\">Autres changements techniques</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#allowed-disabling-autosave-support-for-individual-post-types\">Désactivation de la sauvegarde automatique indépendamment pour chaque type de publication</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#default-length-of-time-for-comment-author-cookies-has-changed\">Modification de la durée native de conservation des cookies de commentaires</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#site-editor-patterns-on-classic-themes\">Prise en charge des compositions de l’éditeur de site dans les thèmes classiques</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#fluid-typography\">Prise en charge des polices fluides</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#jquery-ui-library-update\">Mise à jour de la bibliothèque jQuery UI</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#new-array-arguments-for-wp-login-form\">Nouveaux paramètres pour la fonction for wp_login_form()</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#custom-ports-for-multisite-site-addresses\">Ports personnalisés pour les adresses des sites d&rsquo;un multisite</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#update-enabled-mime-types-for-new-multisite-installs\">Mise à jour des types MIME activés pour les nouvelles installations multisite</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#obsolete-polyfills-dependencies-have-been-removed\">Suppression des dépendances polyfill obsolètes</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#script-modules-can-now-be-used-in-the-wordpress-admin\">Les modules de Script peuvent maintenant être utilisés sur l&rsquo;administration</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#search-has-a-much-later-priority\">Mise en place d&rsquo;une priorité moins importante sur le composant de recherche de la barre d&rsquo;administration</a></li>\n</ul>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"q0i57KuxlF\"><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/\">Miscellaneous developer changes in WordPress 6.6</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Miscellaneous developer changes in WordPress 6.6&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/embed/#?secret=q70OxXcdsS#?secret=q0i57KuxlF\" data-secret=\"q0i57KuxlF\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"other-updates\">Nouvelles fonctions, crochets, filtres, classes et méthodes</h2>\n\n\n\n<p>Pour obtenir la liste de toutes les nouvelles fonctions, crochets, filtres, classes et méthodes, vous pourrez vous rendre – une fois que WP 6.6 sera sortie – sur cette page&nbsp;: <a href=\"https://developer.wordpress.org/reference/since/6.6.0/\">https://developer.wordpress.org/reference/since/6.6.0/</a>.</p>\n\n\n\n<div class=\"wp-block-group alignfull is-layout-flow wp-block-group-is-layout-flow\">\n<p class=\"is-style-serif has-white-color has-text-color has-background has-link-color wp-elements-9bd75783906267b91255ee59d7f76693\" style=\"background:linear-gradient(135deg,rgb(189,21,50) 0%,rgb(248,68,11) 100%)\">Que vous développiez des thèmes ou des extensions, pensez à tester et retester votre code pour vous assurer de sa compatibilité avec ces changements. Vous pouvez utiliser&nbsp;<a href=\"https://fr.wordpress.org/plugins/wordpress-beta-tester/\" target=\"_blank\" rel=\"noreferrer noopener\">l’extension «&nbsp;<em><bdo lang=\"en\" dir=\"ltr\">Beta Tester</bdo></em>&nbsp;»</a>&nbsp;sur un site de test pour vérifier la compatibilité de vos développements avec la <a href=\"https://wordpress.org/news/2024/06/wordpress-6-6-rc1/\">version <em><bdo lang=\"en\" dir=\"ltr\">release candidate</bdo></em>&nbsp;de WordPress 6.6</a>.&nbsp;<br>Vous pouvez aussi tester cette nouvelle version directement dans votre navigateur en utilisant <em><a href=\"https://playground.wordpress.net/#%7B%20%22preferredVersions%22:%20%7B%20%22php%22:%20%228.0%22,%20%22wp%22:%20%22beta%22%20%7D,%20%22features%22:%20%7B%20%22networking%22:%20true%20%7D,%20%22steps%22:%20[%20%7B%20%22step%22:%20%22login%22,%20%22username%22:%20%22admin%22,%20%22password%22:%20%22password%22%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/wpaccessibility/a11y-theme-unit-test/master/a11y-theme-unit-test-data.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/WordPress/theme-test-data/master/themeunittestdata.wordpress.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22query-monitor%22%20%7D,%20%22options%22:%20%7B%20%22activate%22:%20false%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22create-block-theme%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22debug-bar%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22health-check%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22test-reports%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22user-switching%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D%20]%20%7D\"><bdo lang=\"en\" dir=\"ltr\">WordPress Playground</bdo></a></em>.<br><br>Nous comptons sur vous pour vérifier que votre code fonctionne correctement avec le cœur du CMS, pour le bien des millions d’utilisateurs et utilisatrices de WordPress&nbsp;<img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n</div>\n\n\n\n<p class=\"has-small-font-size\">Ce guide a été traduit et réadapté à partir du <a href=\"https://make.wordpress.org/core/2024/06/25/wordpress-6-6-field-guide/\"><em><bdo lang=\"en\" dir=\"ltr\">Field Guide</bdo></em> de WP 6.6</a> par <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>.<br>Merci à <a href=\"https://profiles.wordpress.org/fxbenard/\">FX Bénard</a>, <a href=\"https://profiles.wordpress.org/beryldlg/\">Béryl</a>, <a href=\"https://profiles.wordpress.org/juliobox/\">Julio</a>, <a href=\"https://profiles.wordpress.org/jdy68\">Jenny</a>, <a href=\"https://profiles.wordpress.org/clementpolito/\">Clément</a> pour leur relecture.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3125\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:72:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"Le 28 juin 2024 : deuxième WordPress Translation Day FR !\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"https://fr.wordpress.org/2024/06/13/le-28-juin-2024-deuxieme-wordpress-translation-day-fr/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Jun 2024 08:08:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:6:{i:0;a:5:{s:4:\"data\";s:11:\"Évènement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:10:\"Contribuer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:10:\"Traduction\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"évènement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:10:\"traduction\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:4:\"wptd\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3070\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:391:\"Que vous soyez débutant·e ou aguerri·e à la traduction de WordPress et de son écosystème, rejoignez-nous en visio-conférence quand vous le souhaitez, entre 10 et 17 heures, en toute décontraction, pour rencontrer les membres de l&#8217;équipe de traduction de WordPress en français et pour traduire ensemble aussi bien WordPress lui-même, qu’une extension ou un thème [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Jenny Dupuy\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:10157:\"<figure class=\"wp-block-post-featured-image\"><img loading=\"lazy\" decoding=\"async\" width=\"1200\" height=\"800\" src=\"https://fr.wordpress.org/files/2024/06/WPTD-FR-2024.png\" class=\"attachment-post-thumbnail size-post-thumbnail wp-post-image\" alt=\"\" style=\"object-fit:cover;\" srcset=\"https://fr.wordpress.org/files/2024/06/WPTD-FR-2024.png 1200w, https://fr.wordpress.org/files/2024/06/WPTD-FR-2024-300x200.png 300w, https://fr.wordpress.org/files/2024/06/WPTD-FR-2024-1024x683.png 1024w, https://fr.wordpress.org/files/2024/06/WPTD-FR-2024-768x512.png 768w\" sizes=\"auto, (max-width: 1200px) 100vw, 1200px\" /></figure>\n\n\n<p>Que vous soyez <strong>débutant·e ou aguerri·e</strong> à la traduction de WordPress et de son écosystème, rejoignez-nous en visio-conférence quand vous le souhaitez, <strong>entre 10 et 17 heures</strong>, <em>en toute décontraction</em>, pour rencontrer les membres de l&rsquo;équipe de traduction de WordPress en français et pour traduire ensemble aussi bien WordPress lui-même, qu’une extension ou un thème qui vous tient à cœur, ou encore un des nombreux sites wordpress.org.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Le WordPress Translation Day FR, qu’est-ce que c’est&nbsp;?</h2>\n\n\n\n<p>Habituellement, un&nbsp;<em><strong>WordPress Translation Day</strong></em>, ce sont 24 heures pendant lesquelles les différentes équipes de traduction de chaque langue contribuent ensemble à la traduction de l’écosystème&nbsp;: cœur WordPress, extensions, thèmes, ainsi que tous les sites WordPress.org. Cela se déroule sur 24 heures et sur tous les fuseaux horaires, avec des conférences données en direct dans toutes les langues.</p>\n\n\n\n<p>Le 28 juin prochain, nous vous proposerons une version allégée d’un&nbsp;<em>WordPress Translation Day</em>&nbsp;mondial. Il s’agira de contribuer ensemble à la traduction de WordPress en français, au moment où vous le souhaitez, entre 10 et 17 heures, en visioconférence. Les membres de l’équipe traduction seront là pour vous guider et valider vos suggestions.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Comment participer&nbsp;?</h2>\n\n\n\n<p>Vous aurez besoin d’un compte wordpress.org pour vous inscrire et traduire le jour J.</p>\n\n\n\n<p>Si vous n’avez pas encore de compte, suivez ce <a href=\"https://fr.wordpress.org/team/handbook/polyglots/rejoindre-lequipe-de-traduction-de-wordpress/\">petit guide</a> pour le créer.</p>\n\n\n\n<p>L’évènement se déroulera en visioconférence sur le logiciel Zoom. Vous pouvez déjà vous y inscrire gratuitement&nbsp;:</p>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-4 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://translate.wordpress.org/events/2024/wordpress-translation-day-fr-du-28-juin-2024/\">S’inscrire au WPTD du 28 juin 2024<br></a></div>\n</div>\n\n\n\n<p>Grâce à cette inscription, toutes vos contributions du jour seront comptabilisées, ce qui nous permettra de mesurer facilement le travail accompli !</p>\n\n\n\n<div class=\"wp-block-columns are-vertically-aligned-center has-lemon-3-background-color has-background is-layout-flex wp-container-core-columns-is-layout-5 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-vertically-aligned-center is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:4%\">\n<p><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f4a1.png\" alt=\"💡\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n</div>\n\n\n\n<div class=\"wp-block-column is-vertically-aligned-center is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:96%\">\n<p>Si vous débutez dans la traduction, nous vous invitons à lire le guide de contribution dédié à la <a href=\"https://fr.wordpress.org/team/handbook/polyglots/\">Traduction de WordPress</a>, et en particulier la page <a href=\"https://fr.wordpress.org/team/handbook/polyglots/recommandations/\">Recommandations</a>.</p>\n</div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Le programme</h2>\n\n\n\n<p>La visio-conférence sera ouverte dès 10h et jusqu’à 17h, l&rsquo;équipe des GTE et GPTE vous accueillera au fil de vos arrivées et vous guidera dans vos traductions ou vos premières traductions, si vous débutez, et répondra bien évidemment à toutes vos questions. </p>\n\n\n\n<p>En parallèle, nous utiliserons le canal <strong><em>#évènements-translationday</em></strong> du <a href=\"https://join.slack.com/t/wordpressfr/shared_invite/zt-1rvk7csl3-M1jWYcn71tSRLsAluZ9CmQ\">slack WordPress-FR</a> pour diffuser des informations et nous coordonner.</p>\n\n\n\n<p>Normalement, les chaînes de la version 6.6 seront disponibles, aussi vous aurez l&rsquo;occasion de les traduire et d&rsquo;être ainsi mentionné·e dans les crédits de cette nouvelle version&nbsp;!</p>\n\n\n\n<h2 class=\"wp-block-heading\">Pourquoi participer à cet évènement</h2>\n\n\n\n<p>WordPress est un projet open source que nous sommes nombreuses et nombreux à utiliser. Qui dit open source dit contribution. Il y a différentes manières de contribuer au projet WordPress : entre autres, en améliorant le cœur du CMS, en organisant des évènements (meetups, WordCamps) mais aussi en traduisant WordPress lui-même, ses extensions, ses thèmes, ses tutoriaux et cours ou encore sa documentation. Alors vous aussi contribuez !</p>\n\n\n\n<p>Si vous souhaitez plus d’informations sur les équipes de contribution en français, consultez&nbsp;<a href=\"https://fr.wordpress.org/team\">le blog officiel</a> des équipes.</p>\n\n\n\n<p class=\"has-white-color has-blueberry-1-background-color has-text-color has-background has-link-color wp-elements-6e90a0661a60803691fd7425a3abb690\" style=\"margin-top:var(--wp--preset--spacing--10);margin-bottom:var(--wp--preset--spacing--10);padding-top:var(--wp--preset--spacing--20);padding-right:var(--wp--preset--spacing--20);padding-bottom:var(--wp--preset--spacing--20);padding-left:var(--wp--preset--spacing--20)\">N’hésitez pas à nous rejoindre le 28 juin 2024, l’équipe de traduction de WordPress en français sera ravie de vous accueillir tout au long de la journée.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Partagez l’info</h2>\n\n\n\n<p>Si vous souhaitez communiquer sur l’évènement, voici différents visuels prévus pour les réseaux sociaux&nbsp;:</p>\n\n\n\n<div class=\"wp-block-file\"><a id=\"wp-block-file--media-f60c68b6-141a-4190-831e-52e56cd44f29\" href=\"https://fr.wordpress.org/files/2024/06/Facebook-Event-image-1920x1005-1.png\">Facebook-Event-image-1920&#215;1005-1</a><a href=\"https://fr.wordpress.org/files/2024/06/Facebook-Event-image-1920x1005-1.png\" class=\"wp-block-file__button wp-element-button\" download aria-describedby=\"wp-block-file--media-f60c68b6-141a-4190-831e-52e56cd44f29\">Télécharger</a></div>\n\n\n\n<div class=\"wp-block-file\"><a id=\"wp-block-file--media-171ff8e2-9a21-4e00-87f4-ea0566ec87ec\" href=\"https://fr.wordpress.org/files/2024/06/Facebook-paysage.png\">Facebook-paysage</a><a href=\"https://fr.wordpress.org/files/2024/06/Facebook-paysage.png\" class=\"wp-block-file__button wp-element-button\" download aria-describedby=\"wp-block-file--media-171ff8e2-9a21-4e00-87f4-ea0566ec87ec\">Télécharger</a></div>\n\n\n\n<div class=\"wp-block-file\"><a id=\"wp-block-file--media-5ca45389-e759-4d1d-b05f-ec5222dddea2\" href=\"https://fr.wordpress.org/files/2024/06/FB-portrait.png\">FB-portrait</a><a href=\"https://fr.wordpress.org/files/2024/06/FB-portrait.png\" class=\"wp-block-file__button wp-element-button\" download aria-describedby=\"wp-block-file--media-5ca45389-e759-4d1d-b05f-ec5222dddea2\">Télécharger</a></div>\n\n\n\n<div class=\"wp-block-file\"><a id=\"wp-block-file--media-b592849b-c93d-4384-8198-16de351f2efc\" href=\"https://fr.wordpress.org/files/2024/06/IG-ou-Li-carousel.png\">IG-ou-Li-carousel</a><a href=\"https://fr.wordpress.org/files/2024/06/IG-ou-Li-carousel.png\" class=\"wp-block-file__button wp-element-button\" download aria-describedby=\"wp-block-file--media-b592849b-c93d-4384-8198-16de351f2efc\">Télécharger</a></div>\n\n\n\n<div class=\"wp-block-file\"><a id=\"wp-block-file--media-191d59ad-b451-4144-ad3b-cfc9206e1311\" href=\"https://fr.wordpress.org/files/2024/06/LinkedIn.png\">LinkedIn</a><a href=\"https://fr.wordpress.org/files/2024/06/LinkedIn.png\" class=\"wp-block-file__button wp-element-button\" download aria-describedby=\"wp-block-file--media-191d59ad-b451-4144-ad3b-cfc9206e1311\">Télécharger</a></div>\n\n\n\n<div class=\"wp-block-file\"><a id=\"wp-block-file--media-b0eb707c-9c03-4976-ad6e-52f596a0701c\" href=\"https://fr.wordpress.org/files/2024/06/Slide-4_3.png\">Slide-4_3</a><a href=\"https://fr.wordpress.org/files/2024/06/Slide-4_3.png\" class=\"wp-block-file__button wp-element-button\" download aria-describedby=\"wp-block-file--media-b0eb707c-9c03-4976-ad6e-52f596a0701c\">Télécharger</a></div>\n\n\n\n<div class=\"wp-block-file\"><a id=\"wp-block-file--media-b948ac87-b032-44c5-9454-9858890e6a94\" href=\"https://fr.wordpress.org/files/2024/06/Slide-16_9.png\">Slide-16_9</a><a href=\"https://fr.wordpress.org/files/2024/06/Slide-16_9.png\" class=\"wp-block-file__button wp-element-button\" download aria-describedby=\"wp-block-file--media-b948ac87-b032-44c5-9454-9858890e6a94\">Télécharger</a></div>\n\n\n\n<div class=\"wp-block-file\"><a id=\"wp-block-file--media-1393cca2-1c84-4e6d-afbe-c067f007a8ee\" href=\"https://fr.wordpress.org/files/2024/06/X-Twitter.png\">X-Twitter</a><a href=\"https://fr.wordpress.org/files/2024/06/X-Twitter.png\" class=\"wp-block-file__button wp-element-button\" download aria-describedby=\"wp-block-file--media-1393cca2-1c84-4e6d-afbe-c067f007a8ee\">Télécharger</a></div>\n\n\n\n<div class=\"wp-block-file\"><a id=\"wp-block-file--media-ca5d6b68-5aea-4207-aa36-af33bba9f158\" href=\"https://fr.wordpress.org/files/2024/06/post-WPTD-2024.png\">post-WPTD-2024</a><a href=\"https://fr.wordpress.org/files/2024/06/post-WPTD-2024.png\" class=\"wp-block-file__button wp-element-button\" download aria-describedby=\"wp-block-file--media-ca5d6b68-5aea-4207-aa36-af33bba9f158\">Télécharger</a></div>\n\n\n\n<p>Merci à Béryl de la Grandière (<a href=\"https://profiles.wordpress.org/beryldlg/\">@beryldlg</a>) pour ces visuels.</p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3070\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"WordPress 6.5 « Regina »\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://fr.wordpress.org/2024/04/02/wordpress-6-5-regina/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 02 Apr 2024 19:04:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3027\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:388:\"Souhaitons la bienvenue à WordPress&#160;6.5 «&#160;Regina&#160;». Le nom de cette version a été inspiré par le dynamisme de la violoniste de jazz reconnue Regina Carter. Cette artiste renommée et grande pédagogue a tiré profit de ses fondamentaux techniques classiques et de sa grande connaissance du jazz pour se forger la réputation de transcender les possibilités [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:70246:\"\n<figure class=\"wp-block-image size-large\"><a href=\"https://fr.wordpress.org/files/2024/04/Release-Edition-Inline-Image.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" src=\"https://fr.wordpress.org/files/2024/04/Release-Edition-Inline-Image-1024x683.png\" alt=\"\" class=\"wp-image-3041\" srcset=\"https://fr.wordpress.org/files/2024/04/Release-Edition-Inline-Image-1024x683.png 1024w, https://fr.wordpress.org/files/2024/04/Release-Edition-Inline-Image-300x200.png 300w, https://fr.wordpress.org/files/2024/04/Release-Edition-Inline-Image-768x512.png 768w, https://fr.wordpress.org/files/2024/04/Release-Edition-Inline-Image-1536x1024.png 1536w, https://fr.wordpress.org/files/2024/04/Release-Edition-Inline-Image-2048x1365.png 2048w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p>Souhaitons la bienvenue à WordPress&nbsp;6.5 «&nbsp;Regina&nbsp;». Le nom de cette version a été inspiré par le dynamisme de la violoniste de jazz reconnue <a href=\"https://fr.wikipedia.org/wiki/Regina_Carter\">Regina Carter</a>. Cette artiste renommée et grande pédagogue a tiré profit de ses fondamentaux techniques classiques et de sa grande connaissance du jazz pour se forger la réputation de transcender les possibilités du violon.</p>\n\n\n\n<p>N&rsquo;hésitez pas à <a href=\"https://open.spotify.com/playlist/37i9dQZF1DZ06evO1WEiVo?si=534335c984804713\">découvrir les sonorités du violon de Regina</a> pendant que vous jetterez un œil aux nouveautés de WordPress&nbsp;6.5 <img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f3bb.png\" alt=\"🎻\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> </p>\n\n\n\n<p>Cette dernière version de WordPress s&rsquo;est consacrée à l&rsquo;amélioration de nombreux détails de l’expérience d’administration et de personnalisation de votre site. De la bibliothèque de polices à la gestion des révisions au sein de l’éditeur de site, en passant par les nombreuses améliorations de performances, WordPress&nbsp;6.5 apportera beaucoup à votre site.</p>\n\n\n\n<p>&nbsp;«&nbsp;Regina&nbsp;» apporte également plusieurs outils de développement ayant pour objectif de transformer la façon dont les développeuses et développeurs interagissent avec l’éditeur afin d’étendre le système de blocs. L&rsquo;API de gestion des interactions ouvre un nouveau champ de possibilités tandis que l’API <em><bdo lang=\"en\" dir=\"ltr\">Block Bindings</bdo></em> permet de réaliser des connexions dynamiques entre les blocs et les champs personnalisés (ou tout autre type de donnée dynamique). Et ce ne sont que deux exemples des nombreuses évolutions techniques de cette version.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://fr.wordpress.org/download/\">Télécharger WordPress 6.5 «&nbsp;Regina&nbsp;»</a></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Les nouveautés de WordPress&nbsp;6.5</h2>\n\n\n\n<h3 class=\"wp-block-heading\">Gérez les polices d’écriture de votre site</h3>\n\n\n\n<p>La nouvelle bibliothèque de polices vous permet de contrôler la typographie de votre site sans avoir à mettre les mains dans le code. Installez, supprimez et activez sans effort vos polices locales ou les polices Google sur votre site, quel que soit votre thème actif. La possibilité d‘inclure des collections de polices personnalisées offre encore plus de choix aux personnes qui créent et administrent des sites WordPress.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2024/03/Font-Manager-1024x666.png\" alt=\"A stylized view of the font manager; part of the new Font Library feature in WordPress 6.5.\" class=\"wp-image-17147\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Davantage d’informations sur vos révisions de styles</h3>\n\n\n\n<p>Travaillez sur vos projets de création avec une vision plus complète de ce qui a été fait et de ce sur quoi vous pouvez vous appuyer. Obtenez des détails tels que l&rsquo;horodatage de chaque modification, des résumés rapides et une liste paginée avec toutes les révisions enregistrées. Consultez les révisions du guide de styles pour voir les changements effectués. Des révisions sont également désormais disponibles pour les modèles et les éléments de modèles.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2024/03/Revisions-1024x666.png\" alt=\"A closer look at some of the comprehensive details now available for revisions. \" class=\"wp-image-17149\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Des nouveaux contrôles de mise en page et de mise en forme</h3>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Contrôlez les options de taille, de répétition et de point de focalisation afin d’ajouter un intérêt visuel et créatif à vos mises en page.</li>\n\n\n\n<li>Réglez les proportions de taille d’image du bloc Bannière et ajoutez facilement des superpositions de couleurs se basant sur une couleur automatiquement extraite de l’image choisie.</li>\n\n\n\n<li>En activant le support des ombres portées, vous pouvez créer des mises en page avec une profondeur visuelle ou ajouter un peu de personnalité à votre design.</li>\n</ul>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2024/03/design-tools-1024x666.png\" alt=\"A stylized close up of setting a focal point on a minimalist background image featuring a pale blue sky and contrasting dark grey building. \" class=\"wp-image-17150\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Découvrez les nouvelles vues de données</h3>\n\n\n\n<p>Retrouvez et organisez vos données comme vous le souhaitez avec des vues de données pour les pages, les modèles de pages, les compositions et les éléments de modèles. Affichez-les sous forme de tableau ou de grille avec la possibilité d’afficher ou de masquer les champs et de faire des modifications groupées.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2024/03/Data-Views-1024x666.png\" alt=\"A snapshot of the UI that lets you choose your data view. \" class=\"wp-image-17151\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Un glisser-déposer plus fluide</h3>\n\n\n\n<p>Vous verrez la différence lorsque vous déplacerez des éléments, grâce à des indices visuels utiles tels que les objets immédiatement déplacés dans la vue liste ou le glissement fluide vers n’importe quel endroit de votre espace de travail.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2024/03/drag-and-drop-1024x666.png\" alt=\"\" class=\"wp-image-17152\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Amélioration des réglages des liens</h3>\n\n\n\n<p>Créez et gérez facilement les liens avec une expérience de gestion plus intuitive&nbsp;: une interface d’utilisation simplifiée et un raccourci pour copier les liens.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2024/03/ink-controls-1024x666.png\" alt=\"\" class=\"wp-image-17153\" /></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Quelques nouveautés pour le développement sur WP&nbsp;6.5</h2>\n\n\n\n<h3 class=\"wp-block-heading\">Ajoutez des interactions aux blocs avec l’API de gestion des interactions</h3>\n\n\n\n<p>L’API de gestion des interactions offre aux développeurs et développeuses une méthode normée pour construire des expériences d’interfaces interactives avec des blocs. Elle simplifie le processus en réduisant les dépendances à des outils externes, tout en conservant des performances optimales. Utilisez-la pour créer des expériences utilisateur mémorables, par exemple en récupérant instantanément les résultats de recherche ou en permettant aux internautes d’interagir avec le contenu en temps réel.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Connectez les blocs aux champs personnalisés ou autres contenus dynamiques</h3>\n\n\n\n<p>Liez les attributs des blocs de base aux champs personnalisés et utilisez la valeur des champs personnalisés sans créer de blocs personnalisés. Grâce à l’API «&nbsp;Block Bindings&nbsp;», les développeurs/développeuses peuvent étendre cette fonctionnalité en liant les blocs à n’importe quel contenu dynamique, même au-delà des champs personnalisés. Si des données sont stockées ailleurs, les blocs peuvent facilement pointer vers cette nouvelle source en quelques lignes de code seulement.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Ajoutez les outils de gestion de l’apparence aux thèmes classiques</h3>\n\n\n\n<p>Améliorez l‘expérience de conception des designers et créateurs utilisant des thèmes classiques. Optez pour cela pour l’activation du support des options d‘espacement, de bordure, de typographie et de couleur, même sans utiliser theme.json. Une fois le support activé, plus d‘outils seront automatiquement ajoutés au fur et à mesure de leur disponibilité.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Découvrez les améliorations de l’expérience de gestion des extensions</h3>\n\n\n\n<p>Il existe à présent un moyen plus simple de gérer les dépendances des extensions. Les auteurs et les autrices d’extensions peuvent fournir un nouvel en-tête&nbsp;<code>Requires Plugins</code>&nbsp;avec la liste des slugs, séparés par des virgules, des extensions nécessaires donnant aux utilisateurs et utilisatrices, des liens pour installer et activer ces extensions au préalable.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Améliorations des performances</h3>\n\n\n\n<p>Cette version comprend plus de 110 améliorations de performance, avec une augmentation impressionnante de la vitesse et de l’efficacité de l’éditeur de bloc et l’éditeur de site. Le chargement, la saisie et la navigation dans l’éditeur de site sont deux fois plus rapides que sur la version 6.4.</p>\n\n\n\n<p>Les sites traduits bénéficient d’une amélioration de 25% de leur temps de chargement sur cette version.</p>\n\n\n\n<p>Le support du format d’images AVIF a aussi été ajouté.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Améliorations de l’accessibilité</h3>\n\n\n\n<p>Cette version comprend plus de 65 améliorations en matière d‘accessibilité sur toute la plateforme, la rendant plus accessible que jamais. Cette mise à jour apporte des corrections aux réglages de contraste, à la focalisation du curseur, aux sous-menus et au positionnement des éléments, parmi bien d‘autres, qui aident à améliorer l‘expérience WordPress pour tout le monde.</p>\n\n\n\n<h2 class=\"wp-block-heading\">En savoir plus sur WordPress 6.5</h2>\n\n\n\n<p>Explorez le&nbsp;<a href=\"https://fr.wordpress.org/2024/03/16/guide-des-changements-techniques-de-wordpress-6-5/\">Guide des changements techniques de WordPress 6.5</a> pour découvrir les changements de cette version avec les notes détaillées des développeurs et développeuses qui vous aident à construire avec WordPress.</p>\n\n\n\n<p>Vous pouvez suivre le <a href=\"https://developer.wordpress.org/news/\">blog d’aide au développement avec WordPress (en anglais)</a> pour suivre l&rsquo;évolution technique de WordPress et consulter des tutoriels sur les fonctionnalités du CMS.</p>\n\n\n\n<p><a href=\"https://learn.wordpress.org/\"><em>Learn WordPress</em></a>&nbsp;est une ressource gratuite pour les personnes qui utilisent WordPress, qu’elles soient débutantes ou expérimentées.&nbsp;<em>Learn</em>&nbsp;contient des vidéos pratiques sur l’utilisation de diverses fonctionnalités de WordPress, des&nbsp;<a href=\"https://learn.wordpress.org/online-workshops/\">évènements interactifs</a>&nbsp;pour explorer des sujets en profondeur, et des plans de cours pour approfondir des domaines spécifiques de WordPress.</p>\n\n\n\n<p>Pour plus d’informations techniques sur WordPress 6.5 comme par exemple les fichiers modifiés, les mises à jour de paquets ou les bugs corrigés consultez la <a href=\"https://wordpress.org/documentation/wordpress-version/version-6-5/\">notice technique de WP&nbsp;6.5 (en anglais)</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">L’équipe de direction de WordPress&nbsp;6.5</h2>\n\n\n\n<p>Voici l’équipe qui a coordonné le développement et la sortie de cette nouvelle version de WordPress&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Direction générale&nbsp;: <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a></li>\n\n\n\n<li>Coordination générale&nbsp;: <a href=\"https://profiles.wordpress.org/akshayar/\">Akshaya Rane</a>, <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> et <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a></li>\n\n\n\n<li>Direction technique côté Cœur&nbsp;: <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> et <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a></li>\n\n\n\n<li>Direction technique côté Gutenberg&nbsp;: <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> et <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a></li>\n\n\n\n<li>Gestion de projet technique côté Cœur&nbsp;: <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Kabir Chaion</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a> et <a href=\"https://profiles.wordpress.org/rajinsharwar/\">Rajin Sharwar</a></li>\n\n\n\n<li>Gestion de projet technique côté Gutenberg&nbsp;: <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a> et <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a></li>\n\n\n\n<li>Direction du design&nbsp;: <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a> et <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a></li>\n\n\n\n<li>Direction marketing et communication&nbsp;: <a href=\"https://profiles.wordpress.org/dansoschin/\">Dan Soschin</a> et <a href=\"https://profiles.wordpress.org/laurlittle/\">Lauren Stein</a></li>\n\n\n\n<li>Responsable de la documentation&nbsp;: <a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a>, <a href=\"https://profiles.wordpress.org/leonnugraha/\">Leonardus Nugraha</a> et <a href=\"https://profiles.wordpress.org/stevenlinx/\">Steven Lin</a></li>\n\n\n\n<li>Responsables des performances&nbsp;: <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> et <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a></li>\n\n\n\n<li>Responsables des tests&nbsp;: <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a>, <a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a> et <a href=\"https://profiles.wordpress.org/vipuljnext/\">Vipul Ghori</a></li>\n\n\n\n<li>Responsable des thèmes natifs&nbsp;: <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Merci aux contributeurs et contributrices</h2>\n\n\n\n<p>WordPress 6.5 n’aurait pas pu sortir sans la contribution passionnée de <strong>702 personnes provenant d’au moins 57 pays différents</strong> et de <strong>plus de 200 entreprises</strong>.</p>\n\n\n\n<p>Un remerciement tout spécial pour les 702 personnes qui ont contribué au cœur de WordPress pour la première fois avec WP&nbsp;6.5 <img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\n\n\n<p class=\"is-style-wporg-props-long alignfull has-black-color has-text-color has-background has-link-color has-extra-small-font-size wp-elements-0d70530c06fde7a1042490da172d9e21\" style=\"background:linear-gradient(150deg,rgb(207,202,190) 0%,rgb(234,233,231) 100%)\"><a href=\"https://profiles.wordpress.org/benniledl/\">!Benni</a> · <a href=\"https://profiles.wordpress.org/_ck_/\">_ck_</a> · <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> · <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a> · <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a> · <a href=\"https://profiles.wordpress.org/abletec/\">abletec</a> · <a href=\"https://profiles.wordpress.org/acosmin/\">acosmin</a> · <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> · <a href=\"https://profiles.wordpress.org/adarshposimyth/\">Adarsh Akshat</a> · <a href=\"https://profiles.wordpress.org/ajmcfadyen/\">admcfajn</a> · <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Chaion</a> · <a href=\"https://profiles.wordpress.org/engahmeds3ed/\">Ahmed Saeed</a> · <a href=\"https://profiles.wordpress.org/skyakash12/\">Akash Muchandikar</a> · <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> · <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a> · <a href=\"https://profiles.wordpress.org/akmelias/\">akmelias</a> · <a href=\"https://profiles.wordpress.org/wpfy/\">Akramul Hasan</a> · <a href=\"https://profiles.wordpress.org/akshayar/\">Akshaya Rane</a> · <a href=\"https://profiles.wordpress.org/schlessera/\">Alain Schlesser</a> · <a href=\"https://profiles.wordpress.org/alanfuller/\">Alan Fuller</a> · <a href=\"https://profiles.wordpress.org/ahoereth/\">Alex</a> · <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a> · <a href=\"https://profiles.wordpress.org/alexkingorg/\">Alex King</a> · <a href=\"https://profiles.wordpress.org/akirk/\">Alex Kirk</a> · <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a> · <a href=\"https://profiles.wordpress.org/viper007bond/\">Alex Mills</a> · <a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a> · <a href=\"https://profiles.wordpress.org/alexanderkoledov/\">Alexander</a> · <a href=\"https://profiles.wordpress.org/alexandrebuffet/\">Alexandre Buffet</a> · <a href=\"https://profiles.wordpress.org/alh0319/\">Amber Hinds</a> · <a href=\"https://profiles.wordpress.org/sabreuse/\">Amy Hendrix (sabreuse)</a> · <a href=\"https://profiles.wordpress.org/amykamala/\">Amy Kamala</a> · <a href=\"https://profiles.wordpress.org/anandau14/\">Anand Upadhyay</a> · <a href=\"https://profiles.wordpress.org/anlino/\">Anders Norén</a> · <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a> · <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a> · <a href=\"https://profiles.wordpress.org/euthelup/\">Andrei Lupu</a> · <a href=\"https://profiles.wordpress.org/andrewhayward/\">Andrew Hayward</a> · <a href=\"https://profiles.wordpress.org/l1nuxjedi/\">Andrew Hutchings</a> · <a href=\"https://profiles.wordpress.org/nacin/\">Andrew Nacin</a> · <a href=\"https://profiles.wordpress.org/norcross/\">Andrew Norcross</a> · <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> · <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a> · <a href=\"https://profiles.wordpress.org/andrewleap/\">andrewleap</a> · <a href=\"https://profiles.wordpress.org/andbalashov/\">Andrii Balashov</a> · <a href=\"https://profiles.wordpress.org/oandregal/\">André Maneiro</a> · <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a> · <a href=\"https://profiles.wordpress.org/apeatling/\">Andy Peatling</a> · <a href=\"https://profiles.wordpress.org/aneeshd16/\">Aneesh Devasthale</a> · <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a> · <a href=\"https://profiles.wordpress.org/ankitmaru/\">Ankit Panchal</a> · <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a> · <a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a> · <a href=\"https://profiles.wordpress.org/ant1busted/\">Antoine</a> · <a href=\"https://profiles.wordpress.org/antonlukin/\">Anton Lukin</a> · <a href=\"https://profiles.wordpress.org/atimmer/\">Anton Timmermans</a> · <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a> · <a href=\"https://profiles.wordpress.org/lighthouse79/\">Antonella</a> · <a href=\"https://profiles.wordpress.org/colomet/\">Antonio D.</a> · <a href=\"https://profiles.wordpress.org/antonisme/\">Antonis Lilis</a> · <a href=\"https://profiles.wordpress.org/arena94/\">arena94</a> · <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a> · <a href=\"https://profiles.wordpress.org/passoniate/\">Arslan Kalwar</a> · <a href=\"https://profiles.wordpress.org/artemiosans/\">Artemio Morales</a> · <a href=\"https://profiles.wordpress.org/arthur791004/\">Arthur Chu</a> · <a href=\"https://profiles.wordpress.org/iamarunchaitanyajami/\">Arun Chaitanya Jami</a> · <a href=\"https://profiles.wordpress.org/dextorlobo/\">Arun Sharma</a> · <a href=\"https://profiles.wordpress.org/ideag/\">Arunas Liuiza</a> · <a href=\"https://profiles.wordpress.org/iamasadpolash/\">Asad Polash</a> · <a href=\"https://profiles.wordpress.org/ashfame/\">Ashish Kumar (Ashfame)</a> · <a href=\"https://profiles.wordpress.org/mohonchandra/\">Asish Chandra Mohon</a> · <a href=\"https://profiles.wordpress.org/audunmb/\">audunmb</a> · <a href=\"https://profiles.wordpress.org/aurooba/\">Aurooba Ahmed</a> · <a href=\"https://profiles.wordpress.org/filosofo/\">Austin Matzko</a> · <a href=\"https://profiles.wordpress.org/axwax/\">axwax</a> · <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a> · <a href=\"https://profiles.wordpress.org/beryldlg/\">Béryl de La Grandière</a> · <a href=\"https://profiles.wordpress.org/bahia0019/\">bahia0019</a> · <a href=\"https://profiles.wordpress.org/balub/\">Balu B</a> · <a href=\"https://profiles.wordpress.org/bangank36/\">bangank36</a> · <a href=\"https://profiles.wordpress.org/barryhughes-1/\">Barry</a> · <a href=\"https://profiles.wordpress.org/barry/\">Barry</a> · <a href=\"https://profiles.wordpress.org/bartkalisz/\">Bart Kalisz</a> · <a href=\"https://profiles.wordpress.org/bartkleinreesink/\">bartkleinreesink</a> · <a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a> · <a href=\"https://profiles.wordpress.org/beaulebens/\">Beau Lebens</a> · <a href=\"https://profiles.wordpress.org/bedas/\">Beda</a> · <a href=\"https://profiles.wordpress.org/benharri/\">ben</a> · <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a> · <a href=\"https://profiles.wordpress.org/ubernaut/\">Ben Hansen</a> · <a href=\"https://profiles.wordpress.org/husobj/\">Ben Huson</a> · <a href=\"https://profiles.wordpress.org/blobaugh/\">Ben Lobaugh (blobaugh)</a> · <a href=\"https://profiles.wordpress.org/britner/\">Ben Ritner – Kadence WP</a> · <a href=\"https://profiles.wordpress.org/retlehs/\">Ben Word</a> · <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a> · <a href=\"https://profiles.wordpress.org/benjaminknox/\">benjaminknox</a> · <a href=\"https://profiles.wordpress.org/benoitchantre/\">Benoit Chantre</a> · <a href=\"https://profiles.wordpress.org/bernhard reiter/\">Bernhard Reiter</a> · <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">bernhard-reiter</a> · <a href=\"https://profiles.wordpress.org/billseymour/\">billseymour</a> · <a href=\"https://profiles.wordpress.org/bplv/\">Biplav</a> · <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a> · <a href=\"https://profiles.wordpress.org/bobbingwide/\">bobbingwide</a> · <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a> · <a href=\"https://profiles.wordpress.org/born2webdesign/\">born2webdesign</a> · <a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a> · <a href=\"https://profiles.wordpress.org/bradparbs/\">Brad Parbs</a> · <a href=\"https://profiles.wordpress.org/williamsba1/\">Brad Williams</a> · <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a> · <a href=\"https://profiles.wordpress.org/drrobotnik/\">Brandon Lavigne</a> · <a href=\"https://profiles.wordpress.org/bacoords/\">Brian Coords</a> · <a href=\"https://profiles.wordpress.org/fischfood/\">Brian Fischer</a> · <a href=\"https://profiles.wordpress.org/bgardner/\">Brian Gardner</a> · <a href=\"https://profiles.wordpress.org/masteradhoc/\">Brian Haas</a> · <a href=\"https://profiles.wordpress.org/brianhenryie/\">Brian Henry</a> · <a href=\"https://profiles.wordpress.org/brookemk/\">Brooke</a> · <a href=\"https://profiles.wordpress.org/burnuser/\">burnuser</a> · <a href=\"https://profiles.wordpress.org/ecc/\">camya</a> · <a href=\"https://profiles.wordpress.org/karl94/\">Carlo Cannas</a> · <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> · <a href=\"https://profiles.wordpress.org/carlosgprim/\">Carlos G. P.</a> · <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> · <a href=\"https://profiles.wordpress.org/cenkdemir/\">cenkdemir</a> · <a href=\"https://profiles.wordpress.org/cfinnberg/\">cfinnberg</a> · <a href=\"https://profiles.wordpress.org/shireling/\">Chad Chadbourne</a> · <a href=\"https://profiles.wordpress.org/chasedsiedu/\">chased@si.edu</a> · <a href=\"https://profiles.wordpress.org/mel_cha/\">chiilog (Chiaki Okamoto)</a> · <a href=\"https://profiles.wordpress.org/chouby/\">Chouby</a> · <a href=\"https://profiles.wordpress.org/chrisdavidmiles/\">Chris David Miles</a> · <a href=\"https://profiles.wordpress.org/jazzs3quence/\">Chris Reynolds</a> · <a href=\"https://profiles.wordpress.org/chriscct7/\">chriscct7</a> · <a href=\"https://profiles.wordpress.org/itschristiandale/\">christian-dale</a> · <a href=\"https://profiles.wordpress.org/christopherplus/\">Christopher</a> · <a href=\"https://profiles.wordpress.org/chrystl/\">Chrystl</a> · <a href=\"https://profiles.wordpress.org/codepo8/\">codepo8</a> · <a href=\"https://profiles.wordpress.org/cdevroe/\">Colin Devroe</a> · <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a> · <a href=\"https://profiles.wordpress.org/coreyw/\">Corey Worrell</a> · <a href=\"https://profiles.wordpress.org/cbirdsong/\">Cory Birdsong</a> · <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Robertson</a> · <a href=\"https://profiles.wordpress.org/creativeslice/\">Creative Slice</a> · <a href=\"https://profiles.wordpress.org/crstauf/\">crstauf</a> · <a href=\"https://profiles.wordpress.org/cwhitmore/\">Cullen Whitmore</a> · <a href=\"https://profiles.wordpress.org/cu121/\">Cupid Chakma</a> · <a href=\"https://profiles.wordpress.org/cvorko/\">cvorko</a> · <a href=\"https://profiles.wordpress.org/didierjm/\">cybeardjm</a> · <a href=\"https://profiles.wordpress.org/cyberchicken/\">Cyberchicken</a> · <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/dansoschin/\">Dan Soschin</a> · <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a> · <a href=\"https://profiles.wordpress.org/mzaweb/\">Daniel Dvorkin</a> · <a href=\"https://profiles.wordpress.org/mapumba/\">Daniel Käfer</a> · <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a> · <a href=\"https://profiles.wordpress.org/schutzsmith/\">Daniel Schutzsmith</a> · <a href=\"https://profiles.wordpress.org/danieldudzic/\">danieldudzic</a> · <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a> · <a href=\"https://profiles.wordpress.org/danieltj/\">danieltj</a> · <a href=\"https://profiles.wordpress.org/darerodz/\">darerodz</a> · <a href=\"https://profiles.wordpress.org/nerrad/\">Darren Ethier (nerrad)</a> · <a href=\"https://profiles.wordpress.org/darshitrajyaguru97/\">Darshit Rajyaguru</a> · <a href=\"https://profiles.wordpress.org/darssen/\">darssen</a> · <a href=\"https://profiles.wordpress.org/dartiss/\">David Artiss</a> · <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> · <a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a> · <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a> · <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> · <a href=\"https://profiles.wordpress.org/justlevine/\">David Levine</a> · <a href=\"https://profiles.wordpress.org/dglingren/\">David Lingren</a> · <a href=\"https://profiles.wordpress.org/davidperez/\">David Perez</a> · <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> · <a href=\"https://profiles.wordpress.org/dsas/\">Dean Sas</a> · <a href=\"https://profiles.wordpress.org/denis-de-bernardy/\">Denis de Bernardy</a> · <a href=\"https://profiles.wordpress.org/dingo_d/\">Denis Žoljom</a> · <a href=\"https://profiles.wordpress.org/dionysous/\">Dennis Hipp</a> · <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a> · <a href=\"https://profiles.wordpress.org/dennysdionigi/\">Dennys Dionigi</a> · <a href=\"https://profiles.wordpress.org/derekblank/\">Derek Blank</a> · <a href=\"https://profiles.wordpress.org/valendesigns/\">Derek Herman</a> · <a href=\"https://profiles.wordpress.org/derekspringer/\">Derek Springer</a> · <a href=\"https://profiles.wordpress.org/designsimply/\">designsimply</a> · <a href=\"https://profiles.wordpress.org/desrosjbot/\">Desrosj Bot</a> · <a href=\"https://profiles.wordpress.org/dernin/\">Devin Curtis</a> · <a href=\"https://profiles.wordpress.org/dlocc/\">Devin Walker</a> · <a href=\"https://profiles.wordpress.org/dharm1025/\">Dharmesh Patel</a> · <a href=\"https://profiles.wordpress.org/dhrumilk/\">Dhrumil Kumbhani</a> · <a href=\"https://profiles.wordpress.org/dhruvishah2203/\">Dhruvi Shah</a> · <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> · <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a> · <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a> · <a href=\"https://profiles.wordpress.org/dougal/\">Dougal Campbell</a> · <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a> · <a href=\"https://profiles.wordpress.org/lots0logs/\">Dustin Falgout</a> · <a href=\"https://profiles.wordpress.org/elrae/\">Earle Davies</a> · <a href=\"https://profiles.wordpress.org/ehtis/\">Ehtisham Siddiqui</a> · <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van&nbsp;Durpe</a> · <a href=\"https://profiles.wordpress.org/codex-m/\">Emerson Maningo</a> · <a href=\"https://profiles.wordpress.org/emirpprime/\">emirpprime</a> · <a href=\"https://profiles.wordpress.org/manooweb/\">Emmanuel Hesry</a> · <a href=\"https://profiles.wordpress.org/endymion00/\">Endymion00</a> · <a href=\"https://profiles.wordpress.org/ericlewis/\">Eric Andrew Lewis</a> · <a href=\"https://profiles.wordpress.org/ethitter/\">Erick Hitter</a> · <a href=\"https://profiles.wordpress.org/kebbet/\">Erik</a> · <a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a> · <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a> · <a href=\"https://profiles.wordpress.org/gaambo/\">Fabian Todt</a> · <a href=\"https://profiles.wordpress.org/fabiorubioglio/\">Fabio Rubioglio</a> · <a href=\"https://profiles.wordpress.org/faisalahammad/\">Faisal Ahammad</a> · <a href=\"https://profiles.wordpress.org/faisalahmed29/\">Faisal Ahmed</a> · <a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a> · <a href=\"https://profiles.wordpress.org/fanly/\">Fanly</a> · <a href=\"https://profiles.wordpress.org/feastdesignco/\">Feast Design Co.</a> · <a href=\"https://profiles.wordpress.org/felipeelia/\">Felipe Elia</a> · <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> · <a href=\"https://profiles.wordpress.org/fgiannar/\">fgiannar</a> · <a href=\"https://profiles.wordpress.org/flhz/\">Florent Hernandez</a> · <a href=\"https://profiles.wordpress.org/francina/\">Francesca Marano</a> · <a href=\"https://profiles.wordpress.org/francescocarlucci/\">FrancescoCarlucci</a> · <a href=\"https://profiles.wordpress.org/fotodrachen/\">Frank Jäger</a> · <a href=\"https://profiles.wordpress.org/nexflaszlo/\">Frank Laszlo</a> · <a href=\"https://profiles.wordpress.org/wazeter/\">Frank Wazeter</a> · <a href=\"https://profiles.wordpress.org/fushar/\">fushar</a> · <a href=\"https://profiles.wordpress.org/gajendrasingh/\">Gajendra Singh</a> · <a href=\"https://profiles.wordpress.org/ecgan/\">Gan Eng Chin</a> · <a href=\"https://profiles.wordpress.org/garibiza/\">Garbiñe</a> · <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a> · <a href=\"https://profiles.wordpress.org/gavande1/\">gavande1</a> · <a href=\"https://profiles.wordpress.org/soulseekah/\">Gennady Kovshenin</a> · <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> · <a href=\"https://profiles.wordpress.org/georgestephanis/\">George Stephanis</a> · <a href=\"https://profiles.wordpress.org/gerardreches/\">Gerard Reches</a> · <a href=\"https://profiles.wordpress.org/geriux/\">Gerardo Pacheco</a> · <a href=\"https://profiles.wordpress.org/girishpanchal/\">Girish Panchal</a> · <a href=\"https://profiles.wordpress.org/giuseppemazzapica-1/\">Giuseppe Mazzapica</a> · <a href=\"https://profiles.wordpress.org/glendaviesnz/\">Glen Davies</a> · <a href=\"https://profiles.wordpress.org/goldenapples/\">goldenapples</a> · <a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a> · <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a> · <a href=\"https://profiles.wordpress.org/gregbenz/\">gregbenz</a> · <a href=\"https://profiles.wordpress.org/wido/\">Guido Scialfa</a> · <a href=\"https://profiles.wordpress.org/gvgvgvijayan/\">gvgvgvijayan</a> · <a href=\"https://profiles.wordpress.org/poran766/\">H.M. Mushfiqur Rahman</a> · <a href=\"https://profiles.wordpress.org/hanneslsm/\">hanneslsm</a> · <a href=\"https://profiles.wordpress.org/hardik2221/\">Hardik Raval</a> · <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh S</a> · <a href=\"https://profiles.wordpress.org/harshgajipara/\">Harsh Gajipara</a> · <a href=\"https://profiles.wordpress.org/harsh175/\">Harsh Patel</a> · <a href=\"https://profiles.wordpress.org/hasanuzzamanshamim/\">Hasanuzzaman Shamim</a> · <a href=\"https://profiles.wordpress.org/halounsbury/\">Heather Lounsbury</a> · <a href=\"https://profiles.wordpress.org/muhme/\">Heiko Lübbe</a> · <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a> · <a href=\"https://profiles.wordpress.org/helgatheviking/\">HelgaTheViking</a> · <a href=\"https://profiles.wordpress.org/tejwanihemant/\">Hemant Tejwani</a> · <a href=\"https://profiles.wordpress.org/kurudrive/\">Hidekazu Ishikawa</a> · <a href=\"https://profiles.wordpress.org/panchalhimani711/\">Himani Panchal</a> · <a href=\"https://profiles.wordpress.org/hbhalodia/\">Hit Bhalodia</a> · <a href=\"https://profiles.wordpress.org/hiteshtalpada/\">Hitesh Talpada</a> · <a href=\"https://profiles.wordpress.org/h71/\">Hossein</a> · <a href=\"https://profiles.wordpress.org/howdy_mcgee/\">Howdy_McGee</a> · <a href=\"https://profiles.wordpress.org/hrrarya/\">Hridoy Mozumder</a> · <a href=\"https://profiles.wordpress.org/hrithikd/\">Hrithik Dalal</a> · <a href=\"https://profiles.wordpress.org/hlashbrooke/\">Hugh Lashbrooke</a> · <a href=\"https://profiles.wordpress.org/ganon/\">Hugo Chinchilla</a> · <a href=\"https://profiles.wordpress.org/hugod/\">hugod</a> · <a href=\"https://profiles.wordpress.org/huubl/\">huubl</a> · <a href=\"https://profiles.wordpress.org/huzaifaalmesbah/\">Huzaifa Al Mesbah</a> · <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> · <a href=\"https://profiles.wordpress.org/ianbelanger/\">Ian Belanger</a> · <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a> · <a href=\"https://profiles.wordpress.org/idad5/\">idad5</a> · <a href=\"https://profiles.wordpress.org/igmoweb/\">Ignacio Cruz Moreno</a> · <a href=\"https://profiles.wordpress.org/ignatiusjeroe/\">ignatiusjeroe</a> · <a href=\"https://profiles.wordpress.org/shaampk1/\">Ihtisham Zahoor</a> · <a href=\"https://profiles.wordpress.org/fnpen/\">Ilya Zolotov</a> · <a href=\"https://profiles.wordpress.org/ironprogrammer/\">ironprogrammer</a> · <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> · <a href=\"https://profiles.wordpress.org/iseulde/\">iseulde</a> · <a href=\"https://profiles.wordpress.org/itpathsolutions/\">IT Path Solutions</a> · <a href=\"https://profiles.wordpress.org/itecrs/\">itecrs</a> · <a href=\"https://profiles.wordpress.org/ivanzhuck/\">Ivan Zhuck</a> · <a href=\"https://profiles.wordpress.org/jacobcassidy/\">Jacob Cassidy</a> · <a href=\"https://profiles.wordpress.org/jadpm/\">jadpm</a> · <a href=\"https://profiles.wordpress.org/jamescollins/\">James Collins</a> · <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a> · <a href=\"https://profiles.wordpress.org/james roberts/\">James Roberts</a> · <a href=\"https://profiles.wordpress.org/jamieblomerus/\">Jamie Blomerus</a> · <a href=\"https://profiles.wordpress.org/perrelet/\">Jamie Perrelet</a> · <a href=\"https://profiles.wordpress.org/janthiel/\">Jan Thiel</a> · <a href=\"https://profiles.wordpress.org/jane/\">jane</a> · <a href=\"https://profiles.wordpress.org/whiteshadow/\">Janis Elsts</a> · <a href=\"https://profiles.wordpress.org/jsandtro/\">jansan</a> · <a href=\"https://profiles.wordpress.org/japh/\">Japh</a> · <a href=\"https://profiles.wordpress.org/jsnajdr/\">Jarda Snajdr</a> · <a href=\"https://profiles.wordpress.org/jarednova/\">jarednova</a> · <a href=\"https://profiles.wordpress.org/jason_the_adams/\">Jason Adams</a> · <a href=\"https://profiles.wordpress.org/pbking/\">Jason Crist</a> · <a href=\"https://profiles.wordpress.org/coolmann/\">Jason Crouse</a> · <a href=\"https://profiles.wordpress.org/jsnjohnston/\">Jason Johnston</a> · <a href=\"https://profiles.wordpress.org/madtownlems/\">Jason LeMahieu (MadtownLems)</a> · <a href=\"https://profiles.wordpress.org/javiercasares/\">Javier Casares</a> · <a href=\"https://profiles.wordpress.org/jayadevankbh/\">Jayadevan k</a> · <a href=\"https://profiles.wordpress.org/jbobich/\">jbobich</a> · <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a> · <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a> · <a href=\"https://profiles.wordpress.org/cheffheid/\">Jeffrey de Wit</a> · <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a> · <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> · <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a> · <a href=\"https://profiles.wordpress.org/jeherve/\">Jeremy Herve</a> · <a href=\"https://profiles.wordpress.org/jeryj/\">jeryj</a> · <a href=\"https://profiles.wordpress.org/amieiro/\">Jesús Amieiro</a> · <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a> · <a href=\"https://profiles.wordpress.org/jghazally/\">jghazally</a> · <a href=\"https://profiles.wordpress.org/jipmoors/\">Jip Moors</a> · <a href=\"https://profiles.wordpress.org/jivygraphics/\">jivygraphics</a> · <a href=\"https://profiles.wordpress.org/jltallon/\">jltallon</a> · <a href=\"https://profiles.wordpress.org/joanrodas/\">Joan</a> · <a href=\"https://profiles.wordpress.org/morehawes/\">Joe</a> · <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> · <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a> · <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> · <a href=\"https://profiles.wordpress.org/joelcj91/\">Joel James</a> · <a href=\"https://profiles.wordpress.org/joen/\">Joen A.</a> · <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> · <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a> · <a href=\"https://profiles.wordpress.org/johnciacia/\">johnciacia</a> · <a href=\"https://profiles.wordpress.org/jb510/\">Jon Brown</a> · <a href=\"https://profiles.wordpress.org/duck_/\">Jon Cave</a> · <a href=\"https://profiles.wordpress.org/jonsurrell/\">Jon Surrell</a> · <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a> · <a href=\"https://profiles.wordpress.org/jbrinley/\">Jonathan Brinley</a> · <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> · <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a> · <a href=\"https://profiles.wordpress.org/joppuyo/\">joppuyo</a> · <a href=\"https://profiles.wordpress.org/jordesign/\">jordesign</a> · <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> · <a href=\"https://profiles.wordpress.org/jorgevilchez/\">Jorge Vilchez</a> · <a href=\"https://profiles.wordpress.org/jornp/\">jornp</a> · <a href=\"https://profiles.wordpress.org/joefusco/\">Joseph Fusco</a> · <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha</a> · <a href=\"https://profiles.wordpress.org/joshcanhelp/\">joshcanhelp</a> · <a href=\"https://profiles.wordpress.org/joshuatf/\">joshuatf</a> · <a href=\"https://profiles.wordpress.org/joyously/\">Joy</a> · <a href=\"https://profiles.wordpress.org/jrtashjian/\">JR Tashjian</a> · <a href=\"https://profiles.wordpress.org/jsmoriss/\">JS Morisset</a> · <a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a> · <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a> · <a href=\"https://profiles.wordpress.org/juhise/\">Juhi Saxena</a> · <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a> · <a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a> · <a href=\"https://profiles.wordpress.org/ashikur698/\">K M Ashikur Rahman</a> · <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a> · <a href=\"https://profiles.wordpress.org/kafleg/\">KafleG</a> · <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a> · <a href=\"https://profiles.wordpress.org/bosskhj/\">Kamrul Hasan</a> · <a href=\"https://profiles.wordpress.org/karinclimber/\">Kari Anderson</a> · <a href=\"https://profiles.wordpress.org/karlijnbk/\">Karlijn Bok</a> · <a href=\"https://profiles.wordpress.org/karolmanijak/\">Karol Manijak</a> · <a href=\"https://profiles.wordpress.org/thekt12/\">Karthik Thayyil</a> · <a href=\"https://profiles.wordpress.org/tadamarketing/\">Katka</a> · <a href=\"https://profiles.wordpress.org/kawsaralameven/\">kawsaralameven</a> · <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/kbat82/\">Kevin Batdorf</a> · <a href=\"https://profiles.wordpress.org/kevincoleman/\">Kevin Coleman</a> · <a href=\"https://profiles.wordpress.org/ktaron/\">Kevin Taron</a> · <a href=\"https://profiles.wordpress.org/kharisblank/\">Kharis Sulistiyono</a> · <a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a> · <a href=\"https://profiles.wordpress.org/kishanjasani/\">Kishan Jasani</a> · <a href=\"https://profiles.wordpress.org/kitchin/\">kitchin</a> · <a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a> · <a href=\"https://profiles.wordpress.org/kkmuffme/\">kkmuffme</a> · <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a> · <a href=\"https://profiles.wordpress.org/koen12344/\">Koen Reus</a> · <a href=\"https://profiles.wordpress.org/koesper/\">Koesper</a> · <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a> · <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a> · <a href=\"https://profiles.wordpress.org/krupalpanchal/\">Krupal Panchal</a> · <a href=\"https://profiles.wordpress.org/kurtpayne/\">Kurt Payne</a> · <a href=\"https://profiles.wordpress.org/kushang78/\">Kushang Tailor</a> · <a href=\"https://profiles.wordpress.org/kdowns/\">Kylen Downs</a> · <a href=\"https://profiles.wordpress.org/laumindproductscomau/\">lau@mindproducts.com.au</a> · <a href=\"https://profiles.wordpress.org/lada7042/\">Laura Adamonis</a> · <a href=\"https://profiles.wordpress.org/laurlittle/\">Lauren Stein</a> · <a href=\"https://profiles.wordpress.org/wplmillet/\">Laurent MILLET</a> · <a href=\"https://profiles.wordpress.org/lakshmananphp/\">Lax Mariappan</a> · <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> · <a href=\"https://profiles.wordpress.org/munizleo/\">Leo Muniz</a> · <a href=\"https://profiles.wordpress.org/leonnugraha/\">Leonardus Nugraha</a> · <a href=\"https://profiles.wordpress.org/lgladdy/\">Liam Gladdy</a> · <a href=\"https://profiles.wordpress.org/liammcarthur/\">LiamMcArthur</a> · <a href=\"https://profiles.wordpress.org/rudlinkon/\">Linkon Miyan</a> · <a href=\"https://profiles.wordpress.org/liviopv/\">liviopv</a> · <a href=\"https://profiles.wordpress.org/lkraav/\">lkraav</a> · <a href=\"https://profiles.wordpress.org/logikal16/\">logikal16</a> · <a href=\"https://profiles.wordpress.org/thelovekesh/\">Lovekesh Kumar</a> · <a href=\"https://profiles.wordpress.org/luboslives/\">luboslives</a> · <a href=\"https://profiles.wordpress.org/lucasbustamante/\">lucasbustamante</a> · <a href=\"https://profiles.wordpress.org/zaguiini/\">Luis Felipe Zaguini</a> · <a href=\"https://profiles.wordpress.org/luisherranz/\">Luis Herranz</a> · <a href=\"https://profiles.wordpress.org/lpawlik/\">Lukas Pawlik</a> · <a href=\"https://profiles.wordpress.org/wpfed/\">Lukasz</a> · <a href=\"https://profiles.wordpress.org/lukefiretoss/\">Luke Cavanagh</a> · <a href=\"https://profiles.wordpress.org/maartenbelmans/\">Maarten</a> · <a href=\"https://profiles.wordpress.org/mrdollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/madhudollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> · <a href=\"https://profiles.wordpress.org/mhimon/\">Mahbub Hasan Imon</a> · <a href=\"https://profiles.wordpress.org/mahnewr/\">mahnewr</a> · <a href=\"https://profiles.wordpress.org/maahrokh/\">Mahrokh</a> · <a href=\"https://profiles.wordpress.org/malae/\">Malae</a> · <a href=\"https://profiles.wordpress.org/manfcarlo/\">manfcarlo</a> · <a href=\"https://profiles.wordpress.org/manyourisms/\">manyourisms</a> · <a href=\"https://profiles.wordpress.org/marc_j/\">Marc_J</a> · <a href=\"https://profiles.wordpress.org/fullofcaffeine/\">Marcelo de Moraes Serpa</a> · <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a> · <a href=\"https://profiles.wordpress.org/marcoevich/\">Marcoevich</a> · <a href=\"https://profiles.wordpress.org/margolisj/\">margolisj</a> · <a href=\"https://profiles.wordpress.org/chaton666/\">Marie Comet</a> · <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a> · <a href=\"https://profiles.wordpress.org/santosguillamot/\">Mario Santos</a> · <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a> · <a href=\"https://profiles.wordpress.org/markhowellsmead/\">Mark Howells-Mead</a> · <a href=\"https://profiles.wordpress.org/markjaquith/\">Mark Jaquith</a> · <a href=\"https://profiles.wordpress.org/markoheijnen/\">Marko Heijnen</a> · <a href=\"https://profiles.wordpress.org/flootr/\">Markus</a> · <a href=\"https://profiles.wordpress.org/martinkrcho/\">martin.krcho</a> · <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a> · <a href=\"https://profiles.wordpress.org/mathewemoore/\">mathewemoore</a> · <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">Matias Benedetto</a> · <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a> · <a href=\"https://profiles.wordpress.org/matiasrecondo77/\">matiasrecondo77</a> · <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> · <a href=\"https://profiles.wordpress.org/matteoenna/\">Matteo Enna</a> · <a href=\"https://profiles.wordpress.org/cadic/\">Max Lyuchin</a> · <a href=\"https://profiles.wordpress.org/maxpertici/\">Maxime Pertici</a> · <a href=\"https://profiles.wordpress.org/mayur8991/\">Mayur Prajapati</a> · <a href=\"https://profiles.wordpress.org/mhshohel/\">Md Hossain Shohel</a> · <a href=\"https://profiles.wordpress.org/hrshahin/\">Md HR Shahin</a> · <a href=\"https://profiles.wordpress.org/megphillips91/\">Meg Phillips</a> · <a href=\"https://profiles.wordpress.org/megane9988/\">megane9988</a> · <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/melcarthus/\">melcarthus</a> · <a href=\"https://profiles.wordpress.org/meta4/\">meta4</a> · <a href=\"https://profiles.wordpress.org/metropolis_john/\">metropolis_john</a> · <a href=\"https://profiles.wordpress.org/254volkan/\">mevolkan</a> · <a href=\"https://profiles.wordpress.org/wpscholar/\">Micah Wood</a> · <a href=\"https://profiles.wordpress.org/mshowes/\">Michael Showes</a> · <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> · <a href=\"https://profiles.wordpress.org/michalooki/\">Michalooki</a> · <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> · <a href=\"https://profiles.wordpress.org/miguelsansegundo/\">miguelsansegundo</a> · <a href=\"https://profiles.wordpress.org/miikkamakela/\">Miikka</a> · <a href=\"https://profiles.wordpress.org/mbijon/\">Mike Bijon</a> · <a href=\"https://profiles.wordpress.org/mikejolley/\">Mike Jolley (a11n)</a> · <a href=\"https://profiles.wordpress.org/mikeschinkel/\">Mike Schinkel</a> · <a href=\"https://profiles.wordpress.org/mikeschroder/\">Mike Schroder</a> · <a href=\"https://profiles.wordpress.org/mikinc860/\">Mikin Chauhan</a> · <a href=\"https://profiles.wordpress.org/gonzomir/\">Milen Petrinski – Gonzo</a> · <a href=\"https://profiles.wordpress.org/mimitips/\">mimi</a> · <a href=\"https://profiles.wordpress.org/mkismy/\">mkismy</a> · <a href=\"https://profiles.wordpress.org/mnydigital/\">mnydigital</a> · <a href=\"https://profiles.wordpress.org/batmoo/\">Mohammad Jangda</a> · <a href=\"https://profiles.wordpress.org/boemedia/\">Monique Dubbelman</a> · <a href=\"https://profiles.wordpress.org/monzuralam/\">Monzur Alam</a> · <a href=\"https://profiles.wordpress.org/man4toman/\">Morteza Geransayeh</a> · <a href=\"https://profiles.wordpress.org/mreishus/\">mreishus</a> · <a href=\"https://profiles.wordpress.org/mrwweb/\">mrwweb</a> · <a href=\"https://profiles.wordpress.org/seusmaniqbal/\">Muhammad Usman Iqbal</a> · <a href=\"https://profiles.wordpress.org/devmuhib/\">Muhibul Haque</a> · <a href=\"https://profiles.wordpress.org/mujuonly/\">mujuonly</a> · <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> · <a href=\"https://profiles.wordpress.org/faguni22/\">Mumtahina Faguni</a> · <a href=\"https://profiles.wordpress.org/tanjimtc71/\">Musarrat Anjum Chowdhury</a> · <a href=\"https://profiles.wordpress.org/naoki0h/\">Naoki Ohashi</a> · <a href=\"https://profiles.wordpress.org/nareshbheda/\">Naresh Bheda</a> · <a href=\"https://profiles.wordpress.org/nateallen/\">Nate Allen</a> · <a href=\"https://profiles.wordpress.org/navjotjsingh/\">Navjot Singh</a> · <a href=\"https://profiles.wordpress.org/neffff/\">neffff</a> · <a href=\"https://profiles.wordpress.org/neilorangepeel/\">Neil Hainsworth</a> · <a href=\"https://profiles.wordpress.org/nendeb55/\">nendeb</a> · <a href=\"https://profiles.wordpress.org/nerdpressteam/\">NerdPress</a> · <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> · <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a> · <a href=\"https://profiles.wordpress.org/sessioncookiemonster/\">Nick Martianov</a> · <a href=\"https://profiles.wordpress.org/nickpagz/\">nickpagz</a> · <a href=\"https://profiles.wordpress.org/nico23/\">Nico</a> · <a href=\"https://profiles.wordpress.org/nicolefurlan/\">Nicole Furlan</a> · <a href=\"https://profiles.wordpress.org/bgnicolepaschen/\">Nicole Paschen Caylor</a> · <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a> · <a href=\"https://profiles.wordpress.org/nielslange/\">Niels Lange</a> · <a href=\"https://profiles.wordpress.org/nihar007/\">Nihar Ranjan Das</a> · <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> · <a href=\"https://profiles.wordpress.org/nko/\">Nikita</a> · <a href=\"https://profiles.wordpress.org/nikmeyer/\">nikmeyer</a> · <a href=\"https://profiles.wordpress.org/rabmalin/\">Nilambar Sharma</a> · <a href=\"https://profiles.wordpress.org/nilovelez/\">Nilo Velez</a> · <a href=\"https://profiles.wordpress.org/dhrupo/\">Niluthpal Purkayastha</a> · <a href=\"https://profiles.wordpress.org/niravsherasiya7707/\">niravsherasiya7707</a> · <a href=\"https://profiles.wordpress.org/nithi22/\">Nithin John</a> · <a href=\"https://profiles.wordpress.org/nithins53/\">Nithin SreeRaj</a> · <a href=\"https://profiles.wordpress.org/noahtallen/\">Noah Allen</a> · <a href=\"https://profiles.wordpress.org/nosilver4u/\">nosilver4u</a> · <a href=\"https://profiles.wordpress.org/nvwd/\">Nowell VanHoesen</a> · <a href=\"https://profiles.wordpress.org/nudge/\">Nudge Themes</a> · <a href=\"https://profiles.wordpress.org/nwjames/\">nwjames</a> · <a href=\"https://profiles.wordpress.org/obliviousharmony/\">obliviousharmony</a> · <a href=\"https://profiles.wordpress.org/ockham/\">ockham</a> · <a href=\"https://profiles.wordpress.org/oguzkocer/\">oguzkocer</a> · <a href=\"https://profiles.wordpress.org/okat/\">okat</a> · <a href=\"https://profiles.wordpress.org/dargus/\">Old account</a> · <a href=\"https://profiles.wordpress.org/olegfuture/\">olegfuture</a> · <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a> · <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a> · <a href=\"https://profiles.wordpress.org/pacicio/\">Pacicio</a> · <a href=\"https://profiles.wordpress.org/pannelars/\">pannelars</a> · <a href=\"https://profiles.wordpress.org/partyfrikadelle/\">partyfrikadelle</a> · <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> · <a href=\"https://profiles.wordpress.org/patricia70/\">Patricia BT</a> · <a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a> · <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a> · <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a> · <a href=\"https://profiles.wordpress.org/pauldewouters/\">Paul de Wouters</a> · <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a> · <a href=\"https://profiles.wordpress.org/djpaul/\">Paul Wong-Gibbs</a> · <a href=\"https://profiles.wordpress.org/pavelevap/\">pavelevap</a> · <a href=\"https://profiles.wordpress.org/pbaylies/\">Peter Baylies</a> · <a href=\"https://profiles.wordpress.org/provenself/\">Peter Rubin</a> · <a href=\"https://profiles.wordpress.org/westi/\">Peter Westwood</a> · <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> · <a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a> · <a href=\"https://profiles.wordpress.org/tyrannous/\">Philipp Bammes</a> · <a href=\"https://profiles.wordpress.org/philipp15b/\">Philipp15b</a> · <a href=\"https://profiles.wordpress.org/phillsav/\">Phill</a> · <a href=\"https://profiles.wordpress.org/nekojonez/\">Pieterjan Deneys</a> · <a href=\"https://profiles.wordpress.org/mordauk/\">Pippin Williamson</a> · <a href=\"https://profiles.wordpress.org/pitamdey/\">Pitam Dey</a> · <a href=\"https://profiles.wordpress.org/pmeenan/\">pmeenan</a> · <a href=\"https://profiles.wordpress.org/webtechpooja/\">Pooja Derashri</a> · <a href=\"https://profiles.wordpress.org/pooja1210/\">Pooja N Muchandikar</a> · <a href=\"https://profiles.wordpress.org/pooja9712/\">pooja9712</a> · <a href=\"https://profiles.wordpress.org/pouicpouic/\">pouicpouic</a> · <a href=\"https://profiles.wordpress.org/pmbaldha/\">Prashant Baldha</a> · <a href=\"https://profiles.wordpress.org/pratikthink/\">Pratik Kumar</a> · <a href=\"https://profiles.wordpress.org/freewebmentor/\">Prem Tiwari</a> · <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a> · <a href=\"https://profiles.wordpress.org/presstoke/\">presstoke</a> · <a href=\"https://profiles.wordpress.org/prionkor/\">prionkor</a> · <a href=\"https://profiles.wordpress.org/rafiq91/\">Rafiq</a> · <a href=\"https://profiles.wordpress.org/rajinsharwar/\">Rajin Sharwar</a> · <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a> · <a href=\"https://profiles.wordpress.org/rcorrales/\">Ramon Corrales</a> · <a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a> · <a href=\"https://profiles.wordpress.org/rashiguptaa/\">Rashi Gupta</a> · <a href=\"https://profiles.wordpress.org/rawrly/\">rawrly</a> · <a href=\"https://profiles.wordpress.org/rcain/\">rcain</a> · <a href=\"https://profiles.wordpress.org/rebasaurus/\">rebasaurus</a> · <a href=\"https://profiles.wordpress.org/tabrisrp/\">Remy Perona</a> · <a href=\"https://profiles.wordpress.org/renathoc/\">Renatho (a11n)</a> · <a href=\"https://profiles.wordpress.org/renehermi/\">Rene Hermenau</a> · <a href=\"https://profiles.wordpress.org/retrofox/\">retrofox</a> · <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a> · <a href=\"https://profiles.wordpress.org/rdcoll/\">Rich Collier</a> · <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> · <a href=\"https://profiles.wordpress.org/rcreators/\">Rishi Mehta</a> · <a href=\"https://profiles.wordpress.org/rishishah/\">Rishi Shah</a> · <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> · <a href=\"https://profiles.wordpress.org/ravanh/\">Rolf Allard van Hagen</a> · <a href=\"https://profiles.wordpress.org/room34/\">room34</a> · <a href=\"https://profiles.wordpress.org/ryan/\">Ryan Boren</a> · <a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a> · <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> · <a href=\"https://profiles.wordpress.org/pogidude/\">Ryann Micua</a> · <a href=\"https://profiles.wordpress.org/looswebstudio/\">Ryo</a> · <a href=\"https://profiles.wordpress.org/sereedmedia/\">Sé Reed</a> · <a href=\"https://profiles.wordpress.org/sebastienserre/\">Sébastien SERRE</a> · <a href=\"https://profiles.wordpress.org/sabbirshouvo/\">Sabbir Hasan</a> · <a href=\"https://profiles.wordpress.org/sachyya-sachet/\">Sachyya</a> · <a href=\"https://profiles.wordpress.org/sadizaman/\">Sadi Mohammad Zaman</a> · <a href=\"https://profiles.wordpress.org/sadpencil/\">sadpencil</a> · <a href=\"https://profiles.wordpress.org/introvertedbot/\">Sahil</a> · <a href=\"https://profiles.wordpress.org/tohincoderex/\">Saiduzzaman Tohin</a> · <a href=\"https://profiles.wordpress.org/sakibsnaz/\">Sakib MD Nazmush</a> · <a href=\"https://profiles.wordpress.org/salcode/\">Sal Ferrarello</a> · <a href=\"https://profiles.wordpress.org/samba45/\">samba45</a> · <a href=\"https://profiles.wordpress.org/viralsampat/\">Sampat Viral</a> · <a href=\"https://profiles.wordpress.org/kim88/\">Samuel Rüegger</a> · <a href=\"https://profiles.wordpress.org/samuelsidler/\">Samuel Sidler</a> · <a href=\"https://profiles.wordpress.org/otto42/\">Samuel Wood (Otto)</a> · <a href=\"https://profiles.wordpress.org/sacerro/\">Santiago Cerro López</a> · <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a> · <a href=\"https://profiles.wordpress.org/sarathar/\">Sarath AR</a> · <a href=\"https://profiles.wordpress.org/hellosatya/\">Satyam Vishwakarma (Satya)</a> · <a href=\"https://profiles.wordpress.org/saxonafletcher/\">Saxon Fletcher</a> · <a href=\"https://profiles.wordpress.org/sayful/\">Sayful Islam</a> · <a href=\"https://profiles.wordpress.org/sc0ttkclark/\">Scott Kingsley Clark</a> · <a href=\"https://profiles.wordpress.org/wonderboymusic/\">Scott Taylor</a> · <a href=\"https://profiles.wordpress.org/scribu/\">scribu</a> · <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> · <a href=\"https://profiles.wordpress.org/sgr33n/\">Sergio de Falco</a> · <a href=\"https://profiles.wordpress.org/smrubenstein/\">Seth Rubenstein</a> · <a href=\"https://profiles.wordpress.org/shahariaazam/\">Shaharia Azam</a> · <a href=\"https://profiles.wordpress.org/shailu25/\">Shail Mehta</a> · <a href=\"https://profiles.wordpress.org/shanef/\">ShaneF</a> · <a href=\"https://profiles.wordpress.org/cafenoirdesign/\">Shannon Smith</a> · <a href=\"https://profiles.wordpress.org/shaunandrews/\">shaunandrews</a> · <a href=\"https://profiles.wordpress.org/shooper/\">Shawn Hooper</a> · <a href=\"https://profiles.wordpress.org/shidouhikari/\">shidouhikari</a> · <a href=\"https://profiles.wordpress.org/shiponkarmakar/\">Shipon Karmakar</a> · <a href=\"https://profiles.wordpress.org/shreyash3087/\">Shreyash Srivastava</a> · <a href=\"https://profiles.wordpress.org/shubhamsedani/\">Shubham Sedani</a> · <a href=\"https://profiles.wordpress.org/rsiddharth/\">siddharth ravikumar</a> · <a href=\"https://profiles.wordpress.org/siobhyb/\">Siobhan</a> · <a href=\"https://profiles.wordpress.org/sirajummahdi/\">Sirajum Mahdi</a> · <a href=\"https://profiles.wordpress.org/sjregan/\">sjregan</a> · <a href=\"https://profiles.wordpress.org/soean/\">Soren Wrede</a> · <a href=\"https://profiles.wordpress.org/virtality-marketing-solutions/\">SourceView</a> · <a href=\"https://profiles.wordpress.org/sruthi89/\">sruthi89</a> · <a href=\"https://profiles.wordpress.org/stacimc/\">stacimc</a> · <a href=\"https://profiles.wordpress.org/ryokuhi/\">Stefano Minoia</a> · <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> · <a href=\"https://profiles.wordpress.org/stephencronin/\">Stephen Cronin</a> · <a href=\"https://profiles.wordpress.org/netweb/\">Stephen Edgar</a> · <a href=\"https://profiles.wordpress.org/stephenh1988/\">Stephen Harris</a> · <a href=\"https://profiles.wordpress.org/stevenlinx/\">Steven Lin</a> · <a href=\"https://profiles.wordpress.org/strarsis/\">strarsis</a> · <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a> · <a href=\"https://profiles.wordpress.org/sumisubedi/\">Sumi Subedi</a> · <a href=\"https://profiles.wordpress.org/sumitbagthariya16/\">Sumit Bagthariya</a> · <a href=\"https://profiles.wordpress.org/sumitsingh/\">Sumit Singh</a> · <a href=\"https://profiles.wordpress.org/sunil25393/\">SunilPrajapati</a> · <a href=\"https://profiles.wordpress.org/svitlana41319/\">Svitlana Sukhoveiko</a> · <a href=\"https://profiles.wordpress.org/syamraj24/\">syamraj24</a> · <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a> · <a href=\"https://profiles.wordpress.org/smub/\">Syed Balkhi</a> · <a href=\"https://profiles.wordpress.org/nuhel/\">Syed Nuhel</a> · <a href=\"https://profiles.wordpress.org/synchro/\">Synchro</a> · <a href=\"https://profiles.wordpress.org/iamtakashi/\">Takashi Irie</a> · <a href=\"https://profiles.wordpress.org/inc2734/\">Takashi Kitajima</a> · <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a> · <a href=\"https://profiles.wordpress.org/voboghure/\">Tapan Kumer Das</a> · <a href=\"https://profiles.wordpress.org/sparklingrobots/\">Tara King</a> · <a href=\"https://profiles.wordpress.org/buley/\">Taylor</a> · <a href=\"https://profiles.wordpress.org/taylorde/\">Taylor Dewey</a> · <a href=\"https://profiles.wordpress.org/taylorgorman/\">Taylor Gorman</a> · <a href=\"https://profiles.wordpress.org/tazotodua/\">tazotodua</a> · <a href=\"https://profiles.wordpress.org/tykoted/\">Teddy Patriarca</a> · <a href=\"https://profiles.wordpress.org/tellyworth/\">Tellyworth</a> · <a href=\"https://profiles.wordpress.org/thakordarshil/\">Thakor Darshil</a> · <a href=\"https://profiles.wordpress.org/themes-1/\">them.es</a> · <a href=\"https://profiles.wordpress.org/thinkluke/\">thinkluke</a> · <a href=\"https://profiles.wordpress.org/griffinjt/\">Thomas Griffin</a> · <a href=\"https://profiles.wordpress.org/kraftner/\">Thomas Kräftner</a> · <a href=\"https://profiles.wordpress.org/threadi/\">threadi</a> · <a href=\"https://profiles.wordpress.org/tnolte/\">Tim Nolte</a> · <a href=\"https://profiles.wordpress.org/timbroddin/\">timbroddin</a> · <a href=\"https://profiles.wordpress.org/spaceshipone/\">Timothée Brosille</a> · <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> · <a href=\"https://profiles.wordpress.org/tmatsuur/\">tmatsuur</a> · <a href=\"https://profiles.wordpress.org/tobiasbg/\">TobiasBg</a> · <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn Fjellner)</a> · <a href=\"https://profiles.wordpress.org/tomybyte/\">Tom</a> · <a href=\"https://profiles.wordpress.org/tomjcafferkey/\">Tom Cafferkey</a> · <a href=\"https://profiles.wordpress.org/hifidesign/\">Tom Finley</a> · <a href=\"https://profiles.wordpress.org/tjnowell/\">Tom J Nowell</a> · <a href=\"https://profiles.wordpress.org/tomluckies/\">tomluckies</a> · <a href=\"https://profiles.wordpress.org/shimotomoki/\">Tomoki Shimomura</a> · <a href=\"https://profiles.wordpress.org/tomsommer/\">tomsommer</a> · <a href=\"https://profiles.wordpress.org/tomxygen/\">tomxygen</a> · <a href=\"https://profiles.wordpress.org/skithund/\">Toni Viemerö</a> · <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a> · <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a> · <a href=\"https://profiles.wordpress.org/torres126/\">torres126</a> · <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a> · <a href=\"https://profiles.wordpress.org/toru/\">Toru Miki</a> · <a href=\"https://profiles.wordpress.org/toscho/\">toscho</a> · <a href=\"https://profiles.wordpress.org/wpsmith/\">Travis Smith</a> · <a href=\"https://profiles.wordpress.org/tropicalista/\">tropicalista</a> · <a href=\"https://profiles.wordpress.org/truptikanzariya/\">Trupti Kanzariya</a> · <a href=\"https://profiles.wordpress.org/ugyensupport/\">Ugyen Dorji</a> · <a href=\"https://profiles.wordpress.org/upadalavipul/\">upadalavipul</a> · <a href=\"https://profiles.wordpress.org/up1512001/\">Utsav Patel</a> · <a href=\"https://profiles.wordpress.org/utsav72640/\">Utsav tilava</a> · <a href=\"https://profiles.wordpress.org/ukdrahul/\">Uttam Kumar Dash</a> · <a href=\"https://profiles.wordpress.org/valerogarte/\">valerogarte</a> · <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a> · <a href=\"https://profiles.wordpress.org/vikram6/\">vikram6</a> · <a href=\"https://profiles.wordpress.org/viliamkopecky/\">viliamkopecky</a> · <a href=\"https://profiles.wordpress.org/vipuljnext/\">Vipul Ghori</a> · <a href=\"https://profiles.wordpress.org/vivekawsm/\">vivekawsm</a> · <a href=\"https://profiles.wordpress.org/vladimiraus/\">vladimiraus</a> · <a href=\"https://profiles.wordpress.org/vortfu/\">vortfu</a> · <a href=\"https://profiles.wordpress.org/vrajadas/\">Vraja Das</a> · <a href=\"https://profiles.wordpress.org/wasiur195/\">Wasiur Rahman</a> · <a href=\"https://profiles.wordpress.org/welaunchio/\">welaunchio</a> · <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a> · <a href=\"https://profiles.wordpress.org/whsajid/\">WHSajid</a> · <a href=\"https://profiles.wordpress.org/wpcorner/\">WP Corner</a> · <a href=\"https://profiles.wordpress.org/xlthlx/\">xlthlx</a> · <a href=\"https://profiles.wordpress.org/yansern/\">Yan Sern</a> · <a href=\"https://profiles.wordpress.org/yguyon/\">Yannis Guyon</a> · <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a> · <a href=\"https://profiles.wordpress.org/yuliyan/\">Yuliyan Slavchev</a> · <a href=\"https://profiles.wordpress.org/yuvrajsinh2211/\">Yuvrajsinh Sisodiya</a> · <a href=\"https://profiles.wordpress.org/tollmanz/\">Zack Tollman</a> · <a href=\"https://profiles.wordpress.org/zanematthew/\">Zane Matthew</a> · <a href=\"https://profiles.wordpress.org/zieladam/\">zieladam</a> · <a href=\"https://profiles.wordpress.org/zunaid321/\">Zunaid Amin</a> · <a href=\"https://profiles.wordpress.org/chesio/\">Česlav Przywara</a></p>\n\n\n\n<h3 class=\"wp-block-heading\">Merci aux personnes ayant contribué à traduire WordPress&nbsp;6.5 en français</h3>\n\n\n\n<p>WordPress est un projet international et la version 6.5 est déjà complètement disponible dans plus de 70 langues différentes.</p>\n\n\n\n<p>Nous souhaitons remercier ici les personnes ayant participé à la traduction de WordPress 6.5 en français&nbsp;:</p>\n\n\n\n<p class=\"has-black-color has-text-color has-background has-link-color has-small-font-size wp-elements-82f462fa066a7b8c1ada5f06497f997d\" style=\"background:linear-gradient(150deg,rgb(207,202,190) 0%,rgb(234,233,231) 100%)\"><a href=\"https://profiles.wordpress.org/jdy68\">Jenny Dupuy</a>, <a href=\"https://profiles.wordpress.org/wolforg\">Didier Demory</a>, <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/fxbenard\">fxbenard</a>, <a href=\"https://profiles.wordpress.org/xibe\">Xavier Borderie</a>, <a href=\"https://profiles.wordpress.org/beryldlg\">Béryl de La Grandière</a>, <a href=\"https://profiles.wordpress.org/bonaldi\">Bonaldi</a>, <a href=\"https://profiles.wordpress.org/btpub\">Bruno Tritsch</a>, <a href=\"https://profiles.wordpress.org/cauzyolo\">cauzyolo</a>, <a href=\"https://profiles.wordpress.org/charlie67p\">charlie67p</a>, <a href=\"https://profiles.wordpress.org/clementpolito\">Clément Polito</a>, <a href=\"https://profiles.wordpress.org/coralietixeront\">coralietixeront</a>, <a href=\"https://profiles.wordpress.org/ebrockway\">EBrockway</a>, <a href=\"https://profiles.wordpress.org/milouze\">Emil1</a>, <a href=\"https://profiles.wordpress.org/emlebrun\">Emilie LEBRUN</a>, <a href=\"https://profiles.wordpress.org/scoco\">Emilien M.</a>, <a href=\"https://profiles.wordpress.org/frmo\">Frmo</a>, <a href=\"https://profiles.wordpress.org/gaeldenysiak\">Gael Denysiak</a>, <a href=\"https://profiles.wordpress.org/gaellebesson\">gaellebesson</a>, <a href=\"https://profiles.wordpress.org/wplmillet\">Laurent MILLET</a>, <a href=\"https://profiles.wordpress.org/webaxones\">Loïc Antignac</a>, <a href=\"https://profiles.wordpress.org/oellin\">Magali</a>, <a href=\"https://profiles.wordpress.org/nuryko\">Marianna</a>, <a href=\"https://profiles.wordpress.org/marineevain\">Marine EVAIN</a>, <a href=\"https://profiles.wordpress.org/maxpertici\">Maxime Pertici</a>, <a href=\"https://profiles.wordpress.org/nandow\">nandow</a>, <a href=\"https://profiles.wordpress.org/nicolasricher\">Nicolas Richer</a>, <a href=\"https://profiles.wordpress.org/mrbalou06\">Pascal T</a>, <a href=\"https://profiles.wordpress.org/nekojonez\">Pieterjan Deneys</a>, <a href=\"https://profiles.wordpress.org/larrach\">Rachel Peter</a>, <a href=\"https://profiles.wordpress.org/spaceshipone\">Timothée Brosille</a>, <a href=\"https://profiles.wordpress.org/tobifjellner\">tobifjellner (Tor-Bjorn Fjellner)</a>, <a href=\"https://profiles.wordpress.org/virgar\">Virginie Garnier</a> et <a href=\"https://profiles.wordpress.org/whaze\">whaze</a>.</p>\n\n\n\n<p>N’hésitez pas à&nbsp;<a href=\"https://fr.wordpress.org/team/handbook/\">rejoindre les équipes de contribution francophones&nbsp;!</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-small-font-size\">Article publié par&nbsp;<a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>. Merci à <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> pour sa relecture.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3027\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"Guide des changements techniques de WordPress 6.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://fr.wordpress.org/2024/03/16/guide-des-changements-techniques-de-wordpress-6-5/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 16 Mar 2024 00:04:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=2999\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:399:\"Ce guide décrit les principaux changements techniques que vous trouverez sur WordPress&#160;6.5, dont la sortie est prévue le 26 mars 2024. Sur Trac (l&#8217;outil de tickets utilisés par le cœur de WordPress, environ 344 tickets on été clôturés&#160;: 99 d&#8217;entre eux concernent des améliorations et des nouvelles fonctionnalités, 210 concernent des corrections de bugs, et [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:31860:\"\n<p class=\"has-very-light-gray-to-cyan-bluish-gray-gradient-background has-background\">Ce guide décrit les principaux changements techniques que vous trouverez sur WordPress&nbsp;6.5, dont la sortie est prévue le 26 mars 2024.</p>\n\n\n\n<p>Sur Trac (l&rsquo;outil de tickets utilisés par le cœur de WordPress, environ <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.5&amp;group=component&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">344 tickets</a> on été clôturés&nbsp;: <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=enhancement&amp;type=feature+request&amp;milestone=6.5&amp;max=500&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">99 d&rsquo;entre eux concernent des améliorations et des nouvelles fonctionnalités</a>, <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=defect+(bug)&amp;milestone=6.5&amp;max=500&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">210 concernent des corrections de bugs</a>, et <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=task+(blessed)&amp;milestone=6.5&amp;max=500&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">35 d&rsquo;autres tâches diverses et variées</a>. Cette fois, il y a eu <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~performance&amp;milestone=6.5&amp;group=component&amp;col=id&amp;col=summary&amp;col=status&amp;col=focuses&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">20 tickets qui se sont concentrés sur les performances</a>, <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~accessibility&amp;milestone=6.5&amp;group=component&amp;col=id&amp;col=summary&amp;col=status&amp;col=focuses&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">19 sur l&rsquo;accessibilité</a> et <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~coding-standards&amp;milestone=6.5&amp;group=component&amp;col=id&amp;col=summary&amp;col=status&amp;col=focuses&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">23 sur la modernisation du code source et sur l&rsquo;application des standards de programmation du CMS</a>.</p>\n\n\n\n<p>Les <a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.5\">versions du projet Gutenberg inclues dans WP 6.5</a> contiennent 373 évolutions, 515 corrections de bugs et 65 améliorations de l&rsquo;accessibilité.</p>\n\n\n\n<p>Les évolutions apportées sur la version 6.5 s&rsquo;étalent sur <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.5&amp;group=component&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">40 composants du cœur WP</a>. Vous trouverez dans cet article une liste des changements les plus importants.</p>\n\n\n\n<p>Tous les liens de cet article pointent vers des notes de développement rédigées en anglais. L’objectif est de fournir un panorama général des changements techniques apportés par cette version, en français, puis de diriger les personnes qui souhaitent en savoir plus vers les notes de développement en anglais.</p>\n\n\n\n<p>Pour en savoir plus sur la feuille de route et le calendrier de sortie de WP&nbsp;6.5, consultez cette page : <a href=\"https://make.wordpress.org/core/6-5/\">https://make.wordpress.org/core/6-5/</a></p>\n\n\n\n<h2 class=\"wp-block-heading has-black-color has-text-color has-link-color wp-elements-6df67768f7a11549211ad53b7e24c257\" id=\"high-impact-changes\">Prérequis techniques pour faire tourner WordPress&nbsp;6.5</h2>\n\n\n\n<p>La version minimale supportée de MySQL est passée de 5.0 à 5.5.5 (<a href=\"https://core.trac.wordpress.org/ticket/60036\">ticket #60036</a>).</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"tlSiCOHR47\"><a href=\"https://make.wordpress.org/core/2023/12/08/raising-the-minimum-version-of-mysql-required-in-wordpress-6-5/\">Raising the minimum version of MySQL required in WordPress 6.5</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Raising the minimum version of MySQL required in WordPress 6.5&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2023/12/08/raising-the-minimum-version-of-mysql-required-in-wordpress-6-5/embed/#?secret=RQN3EtHRSy#?secret=tlSiCOHR47\" data-secret=\"tlSiCOHR47\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"major-features-dev-notes\">Fonctionnalités majeures apportées par WP&nbsp;6.5</h2>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"block-editor\">Changements concernant l’éditeur</h3>\n\n\n\n<p>WordPress 6.5 implémente 10 versions de Gutenberg&nbsp;: <a href=\"https://make.wordpress.org/core/2023/10/11/whats-new-in-gutenberg-16-8-11-october/\">16.8</a>, <a href=\"https://make.wordpress.org/core/2023/10/25/whats-new-in-gutenberg-16-9-25-october-2/\">16.9</a>, <a href=\"https://make.wordpress.org/core/2023/11/10/whats-new-in-gutenberg-17-0-9-november/\">17.0</a>, <a href=\"https://make.wordpress.org/core/2023/11/22/whats-new-in-gutenberg-17-1-22-november/\">17.1</a>, <a href=\"https://make.wordpress.org/core/2023/12/06/whats-new-in-gutenberg-17-2-6-december/\">17.2</a>, <a href=\"https://make.wordpress.org/core/2023/12/20/whats-new-in-gutenberg-17-3-20-december/\">17.3</a>, <a href=\"https://make.wordpress.org/core/2024/01/04/whats-new-in-gutenberg-17-4-03-january/\">17.4</a>, <a href=\"https://make.wordpress.org/core/2024/01/17/whats-new-in-gutenberg-17-5-17-january-2024/\">17.5</a>, <a href=\"https://make.wordpress.org/core/2024/01/31/whats-new-in-gutenberg-17-6-31-january/\">17.6</a> et <a href=\"https://make.wordpress.org/core/2024/02/14/whats-new-in-gutenberg-17-7-14th-february/\">17.7</a>. Vous trouverez de nouvelles fonctionnalités, de nouvelles API et de nombreuses améliorations comme par exemple l&rsquo;API de gestion des interactions, la bibliothèque de polices ou l&rsquo;API <em><bdo lang=\"en\" dir=\"ltr\">Block Bindings</bdo></em> qui permet de charger dynamiquement du contenu dans les blocs.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"zTGJeIG79x\"><a href=\"https://make.wordpress.org/core/2024/03/04/interactivity-api-dev-note/\">Interactivity API in 6.5</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Interactivity API in 6.5&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/03/04/interactivity-api-dev-note/embed/#?secret=BP3bfBzPe0#?secret=zTGJeIG79x\" data-secret=\"zTGJeIG79x\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"aeHTn70nhm\"><a href=\"https://make.wordpress.org/core/2024/03/14/new-feature-font-library/\">New Feature: Font Library</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;New Feature: Font Library&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/03/14/new-feature-font-library/embed/#?secret=t8LR8aiZf0#?secret=aeHTn70nhm\" data-secret=\"aeHTn70nhm\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"wXhMjnlZWs\"><a href=\"https://make.wordpress.org/core/2024/03/06/new-feature-the-block-bindings-api/\">New Feature: The Block Bindings API</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;New Feature: The Block Bindings API&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/03/06/new-feature-the-block-bindings-api/embed/#?secret=9LDqQR1jOn#?secret=wXhMjnlZWs\" data-secret=\"wXhMjnlZWs\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"kSOEJXANFd\"><a href=\"https://make.wordpress.org/core/2024/03/04/block-metadata-viewscriptmodule-field-in-6-5/\">Block metadata viewScriptModule field in 6.5</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Block metadata viewScriptModule field in 6.5&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/03/04/block-metadata-viewscriptmodule-field-in-6-5/embed/#?secret=yRl8NrcZXE#?secret=kSOEJXANFd\" data-secret=\"kSOEJXANFd\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"fgr7Eh9WG0\"><a href=\"https://make.wordpress.org/core/2024/03/04/updates-to-block-hooks-in-6-5/\">Updates to Block Hooks in 6.5</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to Block Hooks in 6.5&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/03/04/updates-to-block-hooks-in-6-5/embed/#?secret=xqHNQnC5pX#?secret=fgr7Eh9WG0\" data-secret=\"fgr7Eh9WG0\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"i7jW1A2sTY\"><a href=\"https://make.wordpress.org/core/2024/02/29/performance-improvements-for-registering-block-variations-with-callbacks/\">Performance improvements for registering block variations with callbacks</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Performance improvements for registering block variations with callbacks&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/02/29/performance-improvements-for-registering-block-variations-with-callbacks/embed/#?secret=wBSi3tRFIE#?secret=i7jW1A2sTY\" data-secret=\"i7jW1A2sTY\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"7oIfaxmlW9\"><a href=\"https://make.wordpress.org/core/2024/03/05/unification-of-the-site-and-post-editors-in-6-5/\">Unification of the site and post editors in 6.5</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Unification of the site and post editors in 6.5&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/03/05/unification-of-the-site-and-post-editors-in-6-5/embed/#?secret=1EIvfu7nj1#?secret=7oIfaxmlW9\" data-secret=\"7oIfaxmlW9\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"6EIPP73tAr\"><a href=\"https://make.wordpress.org/core/2024/03/09/miscellaneous-editor-changes-in-wordpress-6-5/\">Miscellaneous Editor changes in WordPress 6.5</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Miscellaneous Editor changes in WordPress 6.5&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/03/09/miscellaneous-editor-changes-in-wordpress-6-5/embed/#?secret=WtvUY2vLJl#?secret=6EIPP73tAr\" data-secret=\"6EIPP73tAr\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"html-api\">API processeur HTML</h3>\n\n\n\n<p>WordPress 6.5 apporte des changements significatifs de l&rsquo;API HTML. Le processeur de balises a reçu une attention particulière et un plus grand nombre d&rsquo;éléments HTML sont maintenant supportés. Si vous utilisez la classe <code>WP_HTML_Tag_Processor</code>, alors il y a plusieurs changements dont vous devriez prendre connaissance.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"BN0e1F8yMe\"><a href=\"https://make.wordpress.org/core/2024/03/04/updates-to-the-html-api-in-6-5/\">Updates to the HTML API in 6.5</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to the HTML API in 6.5&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/03/04/updates-to-the-html-api-in-6-5/embed/#?secret=ln9KARtfky#?secret=BN0e1F8yMe\" data-secret=\"BN0e1F8yMe\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"i18n\">Internationalisation</h3>\n\n\n\n<p><a href=\"https://wordpress.org/plugins/performant-translations/\" target=\"_blank\" rel=\"noreferrer noopener\">L&rsquo;extension «&nbsp;<em><bdo lang=\"en\" dir=\"ltr\">Performant Translations</bdo></em> »</a> a été intégrée au cœur de WordPress. Ce nouveau système de gestion des traductions est bien plus rapide et bien moins gourmand en mémoire que l&rsquo;ancien, grâce au nouveau format <code>.l10n.php</code>. Tous les formats disponibles restent supportés&nbsp;: le nouveau format <code>.l10n.php</code>, mais aussi les formats classiques basés sur des fichiers <code>.mo</code> et <code>.po</code>. Deux nouveau filtres font leur entrée dans le cœur du CMS&nbsp;: <code>translation_file_format</code> et <code>load_translation_file</code>.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"KT4MEhfgP4\"><a href=\"https://make.wordpress.org/core/2024/02/27/i18n-improvements-6-5-performant-translations/\">I18N Improvements in 6.5 (Performant Translations)</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;I18N Improvements in 6.5 (Performant Translations)&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/02/27/i18n-improvements-6-5-performant-translations/embed/#?secret=fbxqrebUJq#?secret=KT4MEhfgP4\" data-secret=\"KT4MEhfgP4\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"media\">Gestion des médias</h3>\n\n\n\n<p>La prise en charge du format d&rsquo;image AVIF a été ajoutée dans WP 6.5. AVIF est un format moderne qui peut être jusqu&rsquo;à 50&nbsp;% moins lourd que JPEG, avec la même qualité d&rsquo;image. Vous pouvez maintenant téléverser, modifier, redimensionner et enregistrer ce format d&rsquo;image, s&rsquo;il est pris en charge par votre hébergement web. La façon de travailler avec des fichiers AVIF reste la même que pour les autres formats d&rsquo;images déjà supportés. En revanche si vous utilisez un réseau multisite il y a quelques spécificités à connaître. Nous vous conseillons dans ce cas de jeter un œil à la FAQ disponible sur cette note de développement.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"682RAd31H2\"><a href=\"https://make.wordpress.org/core/2024/02/23/wordpress-6-5-adds-avif-support/\">WordPress 6.5 adds AVIF support </a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;WordPress 6.5 adds AVIF support &#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/02/23/wordpress-6-5-adds-avif-support/embed/#?secret=dxdpDKfjp5#?secret=682RAd31H2\" data-secret=\"682RAd31H2\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"script-loader\">Chargement des ressources</h3>\n\n\n\n<p>L&rsquo;API de gestion des scripts apporte la prise en charge native des <em>Modules JavaScript</em> et fournit deux modules utilisables dans le cas de <a href=\"https://make.wordpress.org/core/2024/03/04/interactivity-api-dev-note/\">l&rsquo;API de gestion des interactions</a>.</p>\n\n\n\n<p>qu&rsquo;un</p>\n\n\n\n<p></p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"SDLOPVPvCc\"><a href=\"https://make.wordpress.org/core/2024/03/04/script-modules-in-6-5/\">Script Modules in 6.5</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Script Modules in 6.5&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/03/04/script-modules-in-6-5/embed/#?secret=vjQsNq4gMQ#?secret=SDLOPVPvCc\" data-secret=\"SDLOPVPvCc\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"upgrade-install\">Gestion des mises à jour</h3>\n\n\n\n<p><a href=\"https://wordpress.org/plugins/wp-plugin-dependencies/\">L&rsquo;extension « <em><bdo lang=\"en\" dir=\"ltr\">Plugin Dependencies</bdo></em> »</a> fait enfin son entrée dans le cœur du CMS. Elle permet de gérer les dépendances entre extensions, par exemple pour indiquer qu&rsquo;une extension dépend de l&rsquo;activation d&rsquo;une autre extension et d&rsquo;en informer les personnes chargées de l&rsquo;administration du site directement sur l&rsquo;interface d&rsquo;admin.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"4svgv5uY7m\"><a href=\"https://make.wordpress.org/core/2024/03/05/introducing-plugin-dependencies-in-wordpress-6-5/\">Introducing Plugin Dependencies in WordPress 6.5</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Introducing Plugin Dependencies in WordPress 6.5&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/03/05/introducing-plugin-dependencies-in-wordpress-6-5/embed/#?secret=tPhoOCr57d#?secret=4svgv5uY7m\" data-secret=\"4svgv5uY7m\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<details class=\"wp-block-details is-layout-flow wp-block-details-is-layout-flow\"><summary>Plus d&rsquo;informations sur la gestion des dépendances d&rsquo;extensions (cliquer pour déplier le contenu)</summary>\n<p>Les dépendances d&rsquo;une extension peuvent être déclarées en utilisant le nouvel entête <code>Requires Plugins</code> sur le fichier principal de l&rsquo;extension. L&rsquo;entête doit contenir une liste de slugs d&rsquo;extensions séparés par une virgule.</p>\n\n\n\n<p>Exemple&nbsp;:</p>\n\n\n\n<pre class=\"wp-block-code\"><code>/**<br> * Plugin Name: Ma super extension<br> * Requires Plugins: une-extension-cool, une-autre-extension<br> */</code></pre>\n\n\n\n<p>Conditions d&rsquo;utilisation&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Les extensions hébergées sur WordPress.org ne peuvent que déclarer des dépendances aussi hébergées sur WordPress.org</li>\n\n\n\n<li>Les extensions qui ne sont pas hébergées sur WordPress.org peuvent déclarer des dépendances hébergées sur WordPress.org ou n&rsquo;importe où ailleurs</li>\n</ul>\n\n\n\n<p>La déclaration de dépendances nécessite de respecter les prérequis suivants&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Pour les extensions déclarant une dépendance&nbsp;:\n<ul class=\"wp-block-list\">\n<li>Elles ne peuvent pas être installées avant que les dépendances ne soient installées</li>\n\n\n\n<li>Elles ne peuvent pas être activées avant que les dépendances ne soient activées</li>\n</ul>\n</li>\n\n\n\n<li>Pour les extensions qui sont des dépendances d&rsquo;autres extensions&nbsp;:\n<ul class=\"wp-block-list\">\n<li>Elles ne peuvent pas être désactivées avant que les extensions qui en dépendent ne soient désactivées</li>\n\n\n\n<li>Elles ne peuvent pas être supprimées tant que les extensions qui en dépendent sont toujours installées sur le site</li>\n</ul>\n</li>\n</ul>\n\n\n\n<p>Les fonctionnalités suivantes <strong>ne sont pas encore prises en charge</strong>&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Gestion des versions</li>\n\n\n\n<li>Déclaration des extensions indispensables («&nbsp;<em><bdo lang=\"en\" dir=\"ltr\">Must-Use</bdo></em>&nbsp;», ou «&nbsp;<em><bdo lang=\"en\" dir=\"ltr\">mu-plugins</bdo></em>&nbsp;») en tant que dépendances</li>\n\n\n\n<li>Thèmes nécessitant des extensions spécifiques</li>\n\n\n\n<li>Désactivation automatique des extensions dépendant d&rsquo;autres extensions qui ont été supprimées</li>\n</ul>\n\n\n\n<p>Un nouveau filtre <code>wp_plugin_dependencies_slug</code> a été introduit afin de permettre d&rsquo;altérer les slugs des dépendances.</p>\n\n\n\n<p>Une nouvelle classe PHP <code>WP_Plugin_Dependencies</code> a été introduite avec une API contenant plusieurs méthodes publiques.</p>\n\n\n\n<p>L&rsquo;interface de l&rsquo;écran de gestion des extensions a été modifiée afin d&rsquo;afficher les dépendances des extensions. L&rsquo;interface des fiches des extensions qui sont dépendantes d&rsquo;autres extensions a été modifiée pour afficher leurs dépendances, avec des liens vers des fenêtres modales pour les installer/activer en premier.</p>\n\n\n\n<p>La redirection automatique depuis l&rsquo;écran <strong>Extensions &gt; Ajouter</strong> n&rsquo;est plus disponible pour les développeuses et développeurs d&rsquo;extensions, qui ne pourront donc plus directement rediriger par exemple vers un écran de configuration après activation de leur extension depuis cet écran.</p>\n</details>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"additional-changes\">Autres changements</h2>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"external-libraries\">Bibliothèques tierces</h3>\n\n\n\n<p>Les bibliothèques tierces suivantes ont été mises à jour&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>getID3 a été mises à jour vers la version 1.9.23 (<a href=\"https://core.trac.wordpress.org/ticket/59683\">ticket #59683</a>)</li>\n\n\n\n<li>PHPMailer a été mise à jour vers la version 6.9.1 (<a href=\"https://core.trac.wordpress.org/ticket/59966\">ticket #59966</a>)</li>\n\n\n\n<li><code>@wordpress/scripts</code> en version 17 arrête le support des versions de Node.js non maintenues. La plus vieille version de Node.js encore supportée est la version 18 (cf. note de développement&nbsp;: <a href=\"https://make.wordpress.org/core/2024/03/09/miscellaneous-editor-changes-in-wordpress-6-5/\" data-type=\"link\" data-id=\"https://make.wordpress.org/core/2024/03/09/miscellaneous-editor-changes-in-wordpress-6-5/\" target=\"_blank\" rel=\"noreferrer noopener\"><bdo lang=\"en\" dir=\"ltr\">Misc Editor Dev Changes</bdo></a>)</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"themes\">Thèmes</h3>\n\n\n\n<p>Les thèmes classiques (non basés sur des blocs) peuvent maintenant proposer l&rsquo;accès aux outils d&rsquo;apparence (<a href=\"https://core.trac.wordpress.org/ticket/60118\">ticket #60118</a>).</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"media-1\">Bibliothèque de médias</h3>\n\n\n\n<p>La gestion des images JEPG progressives a été activée. Un nouveau filtre <code>image_save_progressive</code> a été ajouté, afin de contrôler si les tailles d&rsquo;images intermédiaires sont enregistrées en format progressif ou non (s&rsquo;il est disponible). Par défaut, le rendu progressif est désactivé, ce qui correspond au fonctionnement passé (<a href=\"https://core.trac.wordpress.org/ticket/21668\">ticket #21668</a>).</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"permalinks\">Permaliens</h3>\n\n\n\n<p>Prise en charge de la gestion des permaliens sur les serveurs <em>Caddy</em> (<a href=\"https://core.trac.wordpress.org/ticket/41877\">ticket #41877</a>).</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"rest-api\">API REST</h3>\n\n\n\n<p>Un champ <code>featured_media</code> pour les vignettes de publications a été ajouté au point de terminaison <code>wp/v2/media</code> de l’API REST (<a href=\"https://core.trac.wordpress.org/ticket/41692\">ticket #41692</a>).</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"site-health\">Santé du site</h3>\n\n\n\n<p>L&rsquo;identifiant du site courant a été ajouté aux informations de déboguage pour les installations multisite (<a href=\"https://core.trac.wordpress.org/ticket/60081\">ticket #60081</a>).</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"upgrade-install-1\">Gestion des mises à jours</h3>\n\n\n\n<p>Lors des mises à jour multiples, une vérification des mises à jour des thèmes est maintenant effectuée afin de vérifier que le thème est bien compatible avec la version de WordPress et de PHP utilisée. Cette vérification était déjà en place pour les extensions, mais pas encore pour les thèmes (<a href=\"https://core.trac.wordpress.org/ticket/59758\">ticket #59758</a>).</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"miscellaneous-developer-changes\">Autres modifications</h3>\n\n\n\n<p>Consultez la note de développement listant les autres modifications plus mineures sur WordPress&nbsp;6.5. Certaines modifications peuvent vous concerner.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"g7PUJV073d\"><a href=\"https://make.wordpress.org/core/2024/03/08/miscellaneous-developer-changes-in-wordpress-6-5/\">Miscellaneous developer changes in WordPress 6.5</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Miscellaneous developer changes in WordPress 6.5&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/03/08/miscellaneous-developer-changes-in-wordpress-6-5/embed/#?secret=Ho1X2giOH7#?secret=g7PUJV073d\" data-secret=\"g7PUJV073d\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"new-modified-hooks\">Nouveaux filtres et crochets d&rsquo;action, ou modifications sur les <bdo lang=\"en\" dir=\"ltr\"><em>hooks</em></bdo> existants</h2>\n\n\n\n<p>Pour une liste complète de tous les filtres et crochets d&rsquo;actions modifiés ou ajoutés sur WP 6.5, veuillez consulter le lien suivant (note : il ne sera disponible qu&rsquo;après la sortie de la version) : <a href=\"https://developer.wordpress.org/reference/since/6.5.0/\">https://developer.wordpress.org/reference/since/6.5.0/</a></p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"new-filter-hooks\">Nouveaux filtres</h3>\n\n\n\n<ul class=\"wp-block-list\">\n<li><code>new_admin_email_subject</code> (<a href=\"https://core.trac.wordpress.org/ticket/59250\">ticket #59250</a>)</li>\n\n\n\n<li><code>wp_is_rest_endpoint</code> (<a href=\"https://core.trac.wordpress.org/ticket/42061\">ticket #42061</a>)</li>\n\n\n\n<li><code>image_save_progressive</code> (<a href=\"https://core.trac.wordpress.org/ticket/21668\">ticket #21668</a>)</li>\n\n\n\n<li><code>wp_admin_canonical_url</code> (<a href=\"https://core.trac.wordpress.org/ticket/59545\">ticket #59545</a>)</li>\n\n\n\n<li><code>wp_plugin_dependencies_slug</code> (<a href=\"https://core.trac.wordpress.org/ticket/22316\">ticket #22316</a>)</li>\n\n\n\n<li><code>hooked_block</code> (<a href=\"https://core.trac.wordpress.org/ticket/59572\">ticket #59572</a>)</li>\n\n\n\n<li><code>hooked_block_{$block_type}</code> (<a href=\"https://core.trac.wordpress.org/ticket/59572\">ticket #59572</a>)</li>\n\n\n\n<li><code>get_block_type_variations</code> (<a href=\"https://core.trac.wordpress.org/ticket/59969\">ticket #59969</a>)</li>\n\n\n\n<li><code>translation_file_format</code> (<a href=\"https://core.trac.wordpress.org/ticket/59656\">ticket #59656</a>)</li>\n\n\n\n<li><code>load_translation_file</code> (<a href=\"https://core.trac.wordpress.org/ticket/59656\">ticket #59656</a>)</li>\n</ul>\n\n\n\n<p class=\"has-very-light-gray-to-cyan-bluish-gray-gradient-background has-background\">Que vous développiez des thèmes ou des extensions, pensez à tester et retester votre code pour vous assurer de sa compatibilité avec ces changements. Vous pouvez utiliser&nbsp;<a href=\"https://fr.wordpress.org/plugins/wordpress-beta-tester/\" target=\"_blank\" rel=\"noreferrer noopener\">l’extension «&nbsp;<em><bdo lang=\"en\" dir=\"ltr\">Beta Tester</bdo></em>&nbsp;»</a>&nbsp;sur un site de test pour vérifier la compatibilité de vos développements avec la version de test&nbsp;<a href=\"https://wordpress.org/news/2024/03/wordpress-6-5-release-candidate-2/\">WordPress 6.5&nbsp;<em><bdo lang=\"en\" dir=\"ltr\">Release Candidate</bdo></em>&nbsp;2</a>.&nbsp;Nous comptons sur vous pour vérifier que votre code fonctionne correctement avec le cœur du CMS, pour le bien des millions d’utilisateurs et utilisatrices de WordPress&nbsp;<img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\n\n\n<p class=\"has-small-font-size\">Ce guide a été traduit et réadapté à partir du <a href=\"https://make.wordpress.org/core/2024/03/15/wordpress-6-5-field-guide/\"><em><bdo lang=\"en\" dir=\"ltr\">Field Guide</bdo></em> de WP 6.5</a> par <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>.<br>Merci à <a href=\"https://profiles.wordpress.org/altitudedev/\">Florian Prache</a> et <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> pour leur relecture.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"2999\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"WordCamp Europe – Turin – Juin 2024\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://fr.wordpress.org/2023/12/26/wordcamp-europe-turin-juin-2024/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 26 Dec 2023 13:55:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Évènement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:4:\"wceu\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=2952\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:363:\"Le prochain WordCamp Europe aura lieu du 13 au 15 juin à Turin en Italie. Nous vous invitons à vous y rendre pour rencontrer d’autres personnes des communautés européennes et vivre une expérience intéressante et enrichissante. D’ailleurs, vous pouvez y participer de plusieurs manières, en tant que&#160;: Et si vous gérez un meetup local et [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Jenny Dupuy\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5851:\"\n<p>Le prochain <strong>WordCamp Europe</strong> aura lieu du <strong>13 au 15 juin à Turin en Italie</strong>. Nous vous invitons à vous y rendre pour rencontrer d’autres personnes des communautés européennes et vivre une expérience intéressante et enrichissante.</p>\n\n\n\n<div class=\"wp-block-group is-layout-constrained wp-block-group-is-layout-constrained\">\n<p>D’ailleurs, vous pouvez y participer de plusieurs manières, en tant que&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://europe.wordcamp.org/2024/volunteers/call-for-volunteers/\">bénévole</a> (date limite de candidature : 28 février 2024)&nbsp;;</li>\n\n\n\n<li>ou <a href=\"https://europe.wordcamp.org/2024/sponsors/call-for-sponsors/\">sponsor</a>&nbsp;;</li>\n\n\n\n<li>ou <a href=\"https://europe.wordcamp.org/2024/media-partners/call-for-media-partners/\">partenaire de communication</a> (postulez jusqu’au 9 février 2024)&nbsp;;</li>\n\n\n\n<li>ou encore comme <a href=\"https://europe.wordcamp.org/2024/speakers/call-for-speakers/\">orateur ou oratrice</a> (soumettez vos sujets de conférences jusqu’au 15 janvier 2024).</li>\n</ul>\n\n\n\n<figure class=\"wp-block-gallery has-nested-images columns-2 is-cropped wp-block-gallery-1 is-layout-flex wp-block-gallery-is-layout-flex\">\n<figure class=\"wp-block-image size-large is-style-default\"><a href=\"https://europe.wordcamp.org/2024/volunteers/call-for-volunteers/\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"538\" src=\"https://fr.wordpress.org/files/2023/12/Call-for-Volunteers-WC-Turin-1024x538.jpg\" alt=\"\" class=\"wp-image-2966\" srcset=\"https://fr.wordpress.org/files/2023/12/Call-for-Volunteers-WC-Turin-1024x538.jpg 1024w, https://fr.wordpress.org/files/2023/12/Call-for-Volunteers-WC-Turin-300x158.jpg 300w, https://fr.wordpress.org/files/2023/12/Call-for-Volunteers-WC-Turin-768x403.jpg 768w, https://fr.wordpress.org/files/2023/12/Call-for-Volunteers-WC-Turin.jpg 1200w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<figure class=\"wp-block-image size-large is-style-default\"><a href=\"https://europe.wordcamp.org/2024/sponsors/call-for-sponsors/\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"538\" src=\"https://fr.wordpress.org/files/2023/12/Call-for-Sponsors-WC-Turin-1024x538.png\" alt=\"\" class=\"wp-image-2964\" srcset=\"https://fr.wordpress.org/files/2023/12/Call-for-Sponsors-WC-Turin-1024x538.png 1024w, https://fr.wordpress.org/files/2023/12/Call-for-Sponsors-WC-Turin-300x158.png 300w, https://fr.wordpress.org/files/2023/12/Call-for-Sponsors-WC-Turin-768x403.png 768w, https://fr.wordpress.org/files/2023/12/Call-for-Sponsors-WC-Turin.png 1200w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<figure class=\"wp-block-image size-large is-style-default\"><a href=\"https://europe.wordcamp.org/2024/media-partners/call-for-media-partners/\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"538\" src=\"https://fr.wordpress.org/files/2023/12/Call-for-Media-Partners-WC-Turin-1024x538.jpg\" alt=\"\" class=\"wp-image-2963\" srcset=\"https://fr.wordpress.org/files/2023/12/Call-for-Media-Partners-WC-Turin-1024x538.jpg 1024w, https://fr.wordpress.org/files/2023/12/Call-for-Media-Partners-WC-Turin-300x158.jpg 300w, https://fr.wordpress.org/files/2023/12/Call-for-Media-Partners-WC-Turin-768x403.jpg 768w, https://fr.wordpress.org/files/2023/12/Call-for-Media-Partners-WC-Turin.jpg 1200w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<figure class=\"wp-block-image size-large is-style-default\"><a href=\"https://europe.wordcamp.org/2024/call-for-2025-host-city/\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"538\" src=\"https://fr.wordpress.org/files/2023/12/Call-for-Host-City-WC-Turin-1024x538.jpg\" alt=\"\" class=\"wp-image-2967\" srcset=\"https://fr.wordpress.org/files/2023/12/Call-for-Host-City-WC-Turin-1024x538.jpg 1024w, https://fr.wordpress.org/files/2023/12/Call-for-Host-City-WC-Turin-300x158.jpg 300w, https://fr.wordpress.org/files/2023/12/Call-for-Host-City-WC-Turin-768x403.jpg 768w, https://fr.wordpress.org/files/2023/12/Call-for-Host-City-WC-Turin.jpg 1200w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://europe.wordcamp.org/2024/speakers/call-for-speakers/\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"538\" src=\"https://fr.wordpress.org/files/2023/12/Call-for-Speakers-WC-Turin-1024x538.jpg\" alt=\"\" class=\"wp-image-2962\" srcset=\"https://fr.wordpress.org/files/2023/12/Call-for-Speakers-WC-Turin-1024x538.jpg 1024w, https://fr.wordpress.org/files/2023/12/Call-for-Speakers-WC-Turin-300x158.jpg 300w, https://fr.wordpress.org/files/2023/12/Call-for-Speakers-WC-Turin-768x403.jpg 768w, https://fr.wordpress.org/files/2023/12/Call-for-Speakers-WC-Turin.jpg 1200w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n</figure>\n\n\n\n<p>Et si vous gérez un meetup local et souhaitez proposer votre ville comme <a href=\"https://europe.wordcamp.org/2024/call-for-2025-host-city/\">prochaine ville hôte</a> pour le <strong>WordCamp Europe 2025</strong>, l’appel à candidature est ouvert jusqu’au 14 février 2024.</p>\n</div>\n\n\n\n<p>Concernant les conférences, <strong>l’équipe organisatrice souhaite recevoir une grande variété de candidatures</strong>, y compris de personnes issues de groupes habituellement sous-représentés, afin d’offrir aux participants un programme diversifié. Notez qu’un programme de mentorat est disponible pour les personnes sélectionnées qui le désirent. Donc n’hésitez pas à postuler&nbsp;!</p>\n\n\n\n<p>Au final, il vous suffit de choisir comment vous souhaitez participer à ce prochain WordCamp Europe via les liens proposés ci-dessus, et vous ne serez plus qu’à quelques clics de votre départ pour Turin ! Lancez-vous, vous ne le regretterez pas…</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"2952\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:35:\"https://fr.wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"13096031\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:11:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Mon, 25 Nov 2024 07:59:58 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Wed, 13 Nov 2024 19:36:21 GMT\";s:4:\"link\";s:61:\"<https://fr.wordpress.org/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"content-encoding\";s:4:\"gzip\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";s:4:\"x-nc\";s:9:\"HIT ord 2\";}}s:5:\"build\";i:1727736619;s:21:\"cache_expiration_time\";i:1732564799;s:23:\"__cache_expiration_time\";i:1732564799;}", "off");
INSERT INTO `wp_options` VALUES("450", "_transient_timeout_feed_mod_0d2db5fea5a8633b56992c916819b198", "1732564799", "off");
INSERT INTO `wp_options` VALUES("451", "_transient_feed_mod_0d2db5fea5a8633b56992c916819b198", "1732521599", "off");
INSERT INTO `wp_options` VALUES("452", "_transient_timeout_feed_48c2a7450ae14f12ef8a9b58ca9f0748", "1732564801", "off");
INSERT INTO `wp_options` VALUES("453", "_transient_feed_48c2a7450ae14f12ef8a9b58ca9f0748", "a:6:{s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"feed\";a:1:{i:0;a:6:{s:4:\"data\";s:126:\"\n    \n    \n    \n    \n    \n    \n\n        \n        \n        \n        \n        \n        \n        \n        \n        \n        \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Planet WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"subtitle\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Planet WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:36:\"https://rss.wpfr.net/feed/wp-planet/\";s:3:\"rel\";s:4:\"self\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"https://rss.wpfr.net/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2024-11-25T08:02:13+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"\n        WP RSS Aggregator\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"uri\";s:27:\"https://wprssaggregator.com\";s:7:\"version\";s:7:\"4.23.13\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"entry\";a:10:{i:0;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://kinsta.com/fr/blog/developpement-production-contenu/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"Développer la production de contenu et le marketing pour plusieurs sites\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:60:\"https://kinsta.com/fr/blog/developpement-production-contenu/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2024-11-21T09:01:47.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2024-11-21T09:01:47.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:269:\"Gérer le contenu d’un seul site web est déjà un défi. Mais imaginez que vous deviez jongler avec le contenu de plusieurs sites clients, chacun ayant ...\nThe post Développer la production de contenu et le marketing pour plusieurs sites appeared first on Kinsta®.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:443:\"\n        <p>Gérer le contenu d&#8217;un seul site web est déjà un défi. Mais imaginez que vous deviez jongler avec le contenu de plusieurs sites clients, chacun ayant ...</p>\n<p>The post <a rel=\"nofollow\" href=\"https://kinsta.com/fr/blog/developpement-production-contenu/\">Développer la production de contenu et le marketing pour plusieurs sites</a> appeared first on <a rel=\"nofollow\" href=\"https://kinsta.com/fr\">Kinsta®</a>.</p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Jeremy Holcombe\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://kinsta.com/fr/blog/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Kinsta\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:1;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://yesweblog.fr/usine-a-sites-wordpress-c-est-quoi/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"Une usine à sites WordPress c’est quoi ?\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:56:\"https://yesweblog.fr/usine-a-sites-wordpress-c-est-quoi/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2024-11-19T18:05:16.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2024-11-19T18:05:16.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:510:\"Nouvel Article\nDans l’univers du web, il arrive qu’on parle un jargon très particulier. Avec des termes comme : Breadbrumb, UX ou encore usine à sites. Hélas, ce jargon n’est pas forcément accessible ni compréhensible par tout le monde. Surtout pour des personnes qui ne sont pas familières de ce microcosme. Aussi découvrons aujourd’hui à quoi correspond […]\n- Yes We Blog ! - Créer un site web, le faire vivre et le faire connaître - Griselidis GAILLET - Webmaster Freelance - Webdesigner\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:601:\"\n        <p>Nouvel Article</p>\n<p>Dans l&#8217;univers du web, il arrive qu&#8217;on parle un jargon très particulier. Avec des termes comme : Breadbrumb, UX ou encore usine à sites. Hélas, ce jargon n&#8217;est pas forcément accessible ni compréhensible par tout le monde. Surtout pour des personnes qui ne sont pas familières de ce microcosme. Aussi découvrons aujourd&#8217;hui à quoi correspond [&#8230;]</p>\n<p>- <a href=\"https://yesweblog.fr\">Yes We Blog ! - Créer un site web, le faire vivre et le faire connaître - Griselidis GAILLET - Webmaster Freelance - Webdesigner</a></p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Griselidis\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://yesweblog.fr/category/wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Yes we blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:2;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://beapi.fr/blog/wordpress-est-il-toujours-le-bon-choix-retour-dexperience/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"WordPress est-il toujours le bon choix ? Retour d’expérience\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:80:\"https://beapi.fr/blog/wordpress-est-il-toujours-le-bon-choix-retour-dexperience/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2024-11-19T17:31:01.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2024-11-19T17:31:01.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:346:\"WordPress est-il toujours la solution idéale pour les projets digitaux ? Pour une agence spécialisée WordPress, qui se consacre entièrement au CMS depuis plus de quinze ans, la question peut sembler surprenante. Et pourtant, elle est essentielle !\nThe post WordPress est-il toujours le bon choix ? Retour d’expérience appeared first on .\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:6167:\"\n        \n<h2 class=\"wp-block-heading\">Contexte</h2>\n\n\n\n<p><strong>WordPress est-il toujours la solution idéale pour les projets digitaux ?</strong> Pour une <strong>agence spécialisée WordPress</strong>, qui se consacre entièrement au CMS depuis plus de quinze ans, la question peut sembler surprenante. Et pourtant, elle est essentielle !</p>\n\n\n\n<p>En tant qu&rsquo;experts WordPress, nous soulignons ses nombreux atouts : grande flexibilité, écosystème riche, compatibilité SEO, interface intuitive, et surtout, sa capacité à s’adapter à la croissance des entreprises.</p>\n\n\n\n<p><strong>Mais notre priorité reste d&rsquo;orienter nos prospects vers la meilleure solution technique.</strong> C’est pourquoi nous n’hésitons pas à refuser des projets quand WordPress n&rsquo;est pas le meilleur choix. Et cela arrive plus souvent que vous ne pourriez le penser !</p>\n\n\n\n<p>Et parfois, cette question se pose en cours de projet, nous poussant à y réfléchir à nouveau. Cela nous est arrivé récemment, et on vous explique tout.</p>\n\n\n\n<h2 class=\"wp-block-heading\">La réalité des projets : quand WordPress atteint ses limites</h2>\n\n\n\n<p>Ce fameux projet portait sur une refonte mêlant site éditorial classique et application complexe d’historique de ventes. Au départ, WordPress paraissait être une bonne option pour répondre à ces deux besoins, grâce à ses possibilités de gestion de contenu et sa flexibilité.</p>\n\n\n\n<p>Mais en avançant, un défi de taille est apparu : la gestion de l’historique des ventes impliquait de traiter un volume de données bien au-delà des capacités habituelles de WordPress. Même si le CMS est puissant, il n’est pas spécialement conçu pour manipuler de très grandes bases de données ou effectuer des traitements complexes sur des volumes importants.</p>\n\n\n\n<p>On peut alors se demander : <strong>jusqu’où peut-on adapter WordPress pour maintenir flexibilité et performance ?</strong></p>\n\n\n\n<h2 class=\"wp-block-heading\">Des solutions sur-mesure pour adapter WordPress </h2>\n\n\n\n<p>Face à ce défi technique, plusieurs options ont été envisagées, et nos experts ont finalement retenu les solutions suivantes :</p>\n\n\n\n<ul>\n<li><strong>Externalisation des images</strong> : Plutôt que de surcharger WordPress, nous avons choisi de stocker les images en dehors du CMS pour alléger la base de données.</li>\n</ul>\n\n\n\n<ul>\n<li><strong>Création de tables de données externes</strong> : L’historique des ventes a été géré dans des tables externes au lieu d’utiliser les tables natives de WordPress, permettant un traitement plus efficace des données.</li>\n</ul>\n\n\n\n<ul>\n<li><strong>Intégration d’Elasticsearch</strong> : Pour des recherches fluides dans de gros volumes de données, nous avons ajouté Elasticsearch, pour assurer une navigation rapide et un accès rapide aux informations.</li>\n</ul>\n\n\n\n<p>Ces ajustements ont permis de tirer parti des points forts de WordPress tout en y ajoutant des développements spécifiques pour répondre précisément aux besoins du projet et des métiers concernés. En somme, exactement ce qu’on aime proposer chez Be API : des solutions sur-mesure.</p>\n\n\n\n<p>Mais soyons honnêtes, chaque adaptation technique a un coût : <strong>plus de temps, plus de développement</strong>. Heureusement, le projet a été mis en ligne avec succès, mais pas sans causer quelques nœuds au cerveau de notre équipe technique.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Une démarche transparente </h2>\n\n\n\n<p>Comme mentionné plus tôt, même si nous sommes des experts passionnés de WordPress, notre priorité reste de trouver la solution la plus adaptée à chaque projet. </p>\n\n\n\n<figure class=\"wp-block-pullquote\"><blockquote><p> Forcer l’utilisation d’un outil inapproprié, c’est risquer de compromettre le projet, l’équipe cliente, notre propre équipe – un pari beaucoup trop risqué.</p></blockquote></figure>\n\n\n\n<p>Chez Be API, déterminer si un projet est fait pour WordPress (et pour nous) fait partie de notre quotidien. Cela passe par des échanges approfondis entre notre équipe commerciale, nos experts techniques et les prospects eux-mêmes. Nous prenons le temps de bien comprendre les enjeux, les besoins, mais aussi l&rsquo;organisation interne de l&rsquo;entreprise, pour penser la contribution du site.</p>\n\n\n\n<p>Ces discussions en toute transparence nous permettent d’exposer clairement les forces et les éventuelles limites de WordPress par rapport aux attentes. Si nécessaire, nous n’hésitons pas à orienter vers d’autres solutions plus adaptées.</p>\n\n\n\n<p><strong>Notre objectif n’est pas de prouver que WordPress peut tout faire, mais de garantir que chaque projet repose sur le meilleur choix technologique. </strong>En adoptant une analyse critique et en donnant des conseils adaptés, on favorise la transparence et la confiance dans nos collaborations.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Conclusion</h2>\n\n\n\n<p>Ce projet nous a montré, une fois de plus, <strong>l’importance de remettre en question le choix des outils</strong>, surtout lorsque les besoins évoluent ou que les configurations techniques deviennent plus complexes. Chaque projet est unique et mérite une analyse approfondie pour garantir que la solution choisie correspond parfaitement aux attentes et contraintes du client.</p>\n\n\n\n<p>Chez Be API, on s’efforce de poser les bonnes questions et de rester ouverts aux évolutions. <strong>WordPress est, sans aucun doute, une solution remarquable pour de nombreux projets</strong>. Mais chaque demande nécessite un examen attentif, pour assurer une solution adaptée sur le long terme.</p>\n\n\n\n<p>En fin de compte, notre expertise ne se limite pas WordPress : elle repose aussi sur notre capacité à évaluer les besoins, challenger les choix techniques, et recommander la technologie la plus pertinente pour chaque projet. </p>\n<p>The post <a href=\"https://beapi.fr/blog/wordpress-est-il-toujours-le-bon-choix-retour-dexperience/\">WordPress est-il toujours le bon choix ? Retour d&rsquo;expérience</a> appeared first on <a href=\"https://beapi.fr\"></a>.</p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Alizée Ragoin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://beapi.fr/blog/categories/wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BeAPI\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:3;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"https://wpchannel.com/wordpress/wordpress-6-7-rollins/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"WordPress 6.7 « Rollins »\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:54:\"https://wpchannel.com/wordpress/wordpress-6-7-rollins/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2024-11-17T14:37:24.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2024-11-17T14:37:24.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:404:\"Dénommée « Rollins » en l’honneur du légendaire saxophoniste de jazz Sonny Rollins, WordPress 6.7 est disponible au téléchargement. Elle embarque un nouveau thème par défaut – Twenty Twenty-Five, un meilleur contrôle des typographies, la possibilité de dézoomer pour obtenir une vue d’ensemble dans l’éditeur de blocs, la gestion des contenus dynamiques dans les blocs et des […]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:438:\"\n        Dénommée « Rollins » en l&#8217;honneur du légendaire saxophoniste de jazz Sonny Rollins, WordPress 6.7 est disponible au téléchargement. Elle embarque un nouveau thème par défaut &#8211; Twenty Twenty-Five, un meilleur contrôle des typographies, la possibilité de dézoomer pour obtenir une vue d&#8217;ensemble dans l&#8217;éditeur de blocs, la gestion des contenus dynamiques dans les blocs et des [&#8230;]\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Aurélien Denis\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wpchannel.com/feed\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"WP channel\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:4;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"https://www.seomix.fr/strategie-guide-seo-2025/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"Le guide SEO 2025 : quelles stratégies mettre en place ?\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:47:\"https://www.seomix.fr/strategie-guide-seo-2025/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2024-11-14T08:30:00.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2024-11-14T08:30:00.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:230:\"2025 est déjà là, mais comment optimiser sa visibilité dans les moteurs de recherche ? SeoMix vous dévoile les meilleures stratégies SEO pour 2025 !Lire la suite : Le guide SEO 2025 : quelles stratégies mettre en place ?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:335:\"\n        2025 est déjà là, mais comment optimiser sa visibilité dans les moteurs de recherche ? SeoMix vous dévoile les meilleures stratégies SEO pour 2025 !<br><strong>Lire la suite :</strong> <a href=\"https://www.seomix.fr/strategie-guide-seo-2025/\">Le guide SEO 2025&#160;: quelles stratégies mettre en place&#160;?</a>\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Daniel Roch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"https://www.seomix.fr/wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"SeoMix\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:5;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"https://promatec.digital/blog/2024/11/13/wordpress-6-7-la-nouvelle-version-rollins-est-disponible/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"WordPress 6.7 : La Nouvelle Version “Rollins” Est Disponible\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:98:\"https://promatec.digital/blog/2024/11/13/wordpress-6-7-la-nouvelle-version-rollins-est-disponible/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2024-11-13T10:11:43.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2024-11-13T10:11:43.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:502:\"Après un cycle de versions beta puis de version “Release Candidate“, WordPress a finalement annoncé ce 12 novembre 2024 sa dernière mise à jour majeure de l’année 2024, la version 6.7. Cette nouvelle version, surnommée “Rollins”, rend hommage au légendaire saxophoniste de jazz Sonny Rollins, reconnu comme l’un des plus grands improvisateurs du jazz ayant […]\nL’article WordPress 6.7 : La Nouvelle Version “Rollins” Est Disponible est apparu en premier sur Promatec Digital.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:719:\"\n        <p>Après un cycle de versions beta puis de version &#8220;Release Candidate&#8220;, WordPress a finalement annoncé ce 12 novembre 2024 sa dernière mise à jour majeure de l&#8217;année 2024, la version 6.7. Cette nouvelle version, surnommée &#8220;Rollins&#8221;, rend hommage au légendaire saxophoniste de jazz Sonny Rollins, reconnu comme l&#8217;un des plus grands improvisateurs du jazz ayant [&#8230;]</p>\n<p>L’article <a href=\"https://promatec.digital/blog/2024/11/13/wordpress-6-7-la-nouvelle-version-rollins-est-disponible/\">WordPress 6.7 : La Nouvelle Version &#8220;Rollins&#8221; Est Disponible</a> est apparu en premier sur <a href=\"https://promatec.digital\">Promatec Digital</a>.</p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Promatec Digital\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://promatec.digital/blog/tag/wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Promatec\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:6;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://www.wppodcast.fr/podcast/wordpress-6-7-rc3-rc4/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"53. WordPress 6.7 RC3 + RC4\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:55:\"https://www.wppodcast.fr/podcast/wordpress-6-7-rc3-rc4/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2024-11-12T01:00:00.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2024-11-12T01:00:00.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:378:\"Avant la sortie finale de WordPress 6.7, deux versions release candidates ont été lancées pour affiner les détails de la version finale. N’oubliez pas que vous pouvez écouter les épisodes sur Pocket Casts, Spotify, et Apple Podcasts ou vous abonner directement au flux. Transcript de l’épisode Bonjour, je suis Patricia, et vous écoutez WPpodcast, le résumé […]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:404:\"\n        Avant la sortie finale de WordPress 6.7, deux versions release candidates ont été lancées pour affiner les détails de la version finale. N&#8217;oubliez pas que vous pouvez écouter les épisodes sur Pocket Casts, Spotify, et Apple Podcasts ou vous abonner directement au flux. Transcript de l&#8217;épisode Bonjour, je suis Patricia, et vous écoutez WPpodcast, le résumé [&#8230;]\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Patricia BT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://www.wppodcast.fr/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"WP Podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:7;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://wpmarmite.com/changer-mot-passe-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"Comment changer votre mot de passe sur WordPress facilement\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:50:\"https://wpmarmite.com/changer-mot-passe-wordpress/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2024-11-05T09:00:00.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2024-11-05T09:00:00.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:399:\"La sécurité de votre site web est une priorité absolue. Que ce soit pour vous protéger contre les menaces potentielles, ou en cas d’oubli de votre mot de passe, modifier votre mot de passe WordPress (régulièrement) est indispensable. Dans cet...\nComment changer votre mot de passe sur WordPress facilement est un article de WPMarmite, le blog qui vous aide à tirer le meilleur de WordPress.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:722:\"\n        <p><img width=\"1500\" height=\"830\" src=\"https://wpmarmite.com/wp-content/uploads/2024/10/cover-changer-mot-de-passe-wordpress.jpg\" class=\"attachment-full size-full wp-post-image\" alt=\"\" //></p>\n<p>La sécurité de votre site web est une priorité absolue. Que ce soit pour vous protéger contre les menaces potentielles, ou en cas d’oubli de votre mot de passe, modifier votre mot de passe WordPress (régulièrement) est indispensable. Dans cet...</p>\n<p><a href=\"https://wpmarmite.com/changer-mot-passe-wordpress/\">Comment changer votre mot de passe sur WordPress facilement</a> est un article de <a href=\"https://wpmarmite.com\">WPMarmite</a>, le blog qui vous aide à tirer le meilleur de WordPress.</p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Équipe WPMarmite\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"http://feedpress.me/WPMarmite\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"WP Marmite\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:8;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://wpfr.net/nouvelle-identite-de-lassociation-5-questions-a-antoine/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"Nouvelle identité de l’association : 5 questions à Antoine\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:73:\"https://wpfr.net/nouvelle-identite-de-lassociation-5-questions-a-antoine/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2024-11-05T08:15:00.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2024-11-05T08:15:00.000+01:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:338:\"Après vous avoir révélé la nouvelle identité de l’association la semaine dernière, on ne pouvait pas décemment se dispenser d’une interview d’Antoine Paufichet, le directeur de création dont elle émane. C’est aussi ça, le rôle du blog de WPFR : donner la parole aux personnes qui animent et font vivre l’association.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:7751:\"\n        <p>Après vous avoir révélé <a href=\"https://wpfr.net/wpfr-revele-sa-nouvelle-identite-visuelle/\">la nouvelle identité de l’association</a> la semaine dernière, on ne pouvait pas décemment se dispenser d’une interview d’<strong>Antoine Paufichet</strong>, le directeur de création dont elle émane. C’est aussi ça, le rôle du blog de WPFR&nbsp;: donner la parole aux personnes qui animent et font vivre l’association.</p><p>Antoine s’est donc gentiment plié au jeu des 5 questions, <a href=\"https://wpfr.net/journee-de-contribution-7-questions-aux-organisateurs/\">comme l’avaient fait Valérie, Jenny et Éric</a> avant la dernière Journée de Contribution. Il vous raconte, mieux que personne, sa vision de l’association et les inspirations qui ont donné naissance à notre nouveau logo et son univers graphique.</p><p>Antoine, c’est à toi&nbsp;!</p><p><strong>WPFR : Salut Antoine, peux-tu te présenter en quelques lignes ?</strong></p><blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\"><p><strong>Antoine</strong> : Je suis designer de naissance ! J’ai commencé en tant que directeur artistique dans les agences de communication, puis indépendant pour accompagner les startups à trouver leur proposition de valeur et à la mettre en forme (du branding au sens large : logo, charte, app mobile, site web, communication, design de magasin, etc.). C’est ce qui m’a amené au design d’interface. Je suis d’ailleurs toujours coach dans le Startup LaunchPad d’HEC.<br>Depuis 7 ans maintenant, je suis le directeur de création de <a href=\"https://beapi.fr/\">l’agence Be API</a> et je m’occupe d’inspirer au mieux les DA/UI/UX designers de l’agence. J’ai découvert WordPress ici et j’ai très vite adhéré à cette idée d’open source et de redevabilité de <em>giving back</em>. C’est ce qu’on essaye de faire au sein de l’équipe design, même si nous ne sommes pas des techs purs et durs. Nous avons créé Johannes par exemple, premier UX kit open source (Figma) pour réaliser des wireframes Gutenberg friendly.<br>Il y a 1 an, avec Be API, nous avons monté <a href=\"https://be-beau.fr/\">le studio de design be-beau</a>, agence spécialisée dans le rebranding. Il faut croire que mes crayons de couleurs me manquaient <img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f609.png\" alt=\"😉\" class=\"wp-smiley\" style=\"height: 1em;max-height: 1em\" //></p></blockquote><p><strong>WPFR : Tu as supervisé la refonte de l’identité graphique de l’association. Quand arrive un chantier de ce type, quelles sont tes premiers réflexes, les premières choses que tu fais pour démarrer ce projet ?</strong></p><blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\"><p><strong>Antoine</strong> : Toujours commencer par une bonne sieste ! Plus sérieusement, il n’y a pas vraiment de “chantier de ce type”. Dans n’importe quel projet de rebranding, on commence par apprendre. Nous ne sommes pas là pour démontrer notre talent artistique mais pour mettre en forme et en lumière une identité, un message.<br>Ainsi, un designer, quel qu’il soit, ne peut se satisfaire d’un brief comme : “<em>On veut être plus moderne et créer une rupture</em>.” (n’est-ce pas Jason? <img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f60a.png\" alt=\"😊\" class=\"wp-smiley\" style=\"height: 1em;max-height: 1em\" //>) Une rupture, … OK mais pourquoi ? pour qui ? avec quelle histoire derrière ?<br>Apprendre, c’est comprendre. Comprendre le client, assimiler son projet. Et là, ceux qui ont travaillé sur cette nouvelle identité été beaucoup aidés car le nouveau projet de l’association porté par Jason et Amaury et clair, documenté, structuré.<br>Nous avons ensuite réalisé des workshops, ouverts aux volontaires, pour dégager une vraie proposition de valeur qui illustre ce projet. C’est de là qu’est né la nouvelle baseline: “<strong>Le point de rencontre de la communauté WordPress en France</strong>”</p>\n\n<p>Nous avions trouvé notre autoroute pour lancer le design.</p></blockquote><p><strong>WPFR : Quelles ont été les principales inspirations pour cette nouvelle identité ? Peux-tu nous expliquer le cheminement qui débouche sur cette identité ?</strong></p><blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\"><p><strong>Antoine</strong> : La principale source d’inspiration c’est la communauté elle-même. Un ensemble de professionnels hétérogène : des freelances, des agences de toutes tailles, des techs, des designers, des contributeurs, des chefs de projets, des commerciaux, des clients finaux, des experts du web, des professionnels du droit, etc. venant des quatre coins de la France… C’est ce qui m’a toujours frappé aux WordCamps ou journées de contribution. La disparité des profils, réunis autour d’un outil commun, avec passion.<br>Chacun d’eux, chacun de nous, est un pixel et ensemble, nous nous rassemblons et formons le nouveau logo et les éléments de la charte graphique. Le point de rencontre.<br>Et à l’instar de la communauté, nous avons voulu un logo modulaire qui s’adapte au format sur lequel il est posé. Le logo peut s’élargir, grandir, s’étirer comme pour symboliser que l’association est toujours en mouvement, en action et s’adapte aux besoins de la communauté WordPress.<br>La création de cette nouvelle identité a été collaborative, avec les membres du groupe de travail Design au CA de l’association.</p></blockquote><p><strong>WPFR : Cette nouvelle identité a été dévoilée à Rennes il y a un peu plus de deux semaines, lors du WordCamp Bretagne et de la Journée de Contribution qui l’a précédé. Quelles ont été les réactions sur place ?</strong></p><blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\"><p><strong>Antoine</strong> : Personne n’est venu me voir pour me dire qu’il détestait ! Par politesse et bienveillance sûrement … <img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f602.png\" alt=\"😂\" class=\"wp-smiley\" style=\"height: 1em;max-height: 1em\" //><br>Je crois que la nouvelle identité en a surpris plus d’un, tant mieux, et le parti pris a été plutôt bien accueilli. Ce qui m’a fait plaisir c’est quand un vieux de la vieille de la communauté (il se reconnaîtra !) m’a dit : “<em>Quand j’ai vu le logo tout seul j’ai pas trouvé ça top, mais en voyant la charte s’exprimer sur tous les supports (affiches, écrans, rollups, t-shirts, tote bags, etc.), ça a de la gueule et j’ai compris le sens.</em>”<br>C’est un excellent retour ! La preuve qu’un logo seul ne se suffit jamais. Une identité c’est un ensemble.</p></blockquote><p><strong>WPFR : Un dernier mot pour finir ?</strong></p><blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\"><p><strong>Antoine</strong> : J’ai hâte de voir la charte se déployer sur tous nos supports, comme le site web par exemple. Notre chantier pour 2025 <img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f609.png\" alt=\"😉\" class=\"wp-smiley\" style=\"height: 1em;max-height: 1em\" //> Vive le design <img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f4aa.png\" alt=\"💪\" class=\"wp-smiley\" style=\"height: 1em;max-height: 1em\" //></p></blockquote><p>Un grand merci à Antoine donc de s&rsquo;être prêté au jeu de l&rsquo;interview. Et un dernier rappel, si vous voulez en savoir plus sur la nouvelle identité graphique de l&rsquo;association, <a href=\"https://wpfr.net/wpfr-revele-sa-nouvelle-identite-visuelle/\">tout est décrit dans cet article</a> !</p><p></p>\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"François Houste\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://wpfr.net/actualites/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"WPFR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:9;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"https://21douze.fr/combien-plugins-wordpress-8075.html\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Évolution du nombre d’extensions WordPress : sur le dépôt officiel\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:54:\"https://21douze.fr/combien-plugins-wordpress-8075.html\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2024-10-16T10:35:00.000+02:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2024-10-16T10:35:00.000+02:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"Infographie du nombre de plugins WordPress depuis 2007 sur le repository.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"\n        Infographie du nombre de plugins WordPress depuis 2007 sur le repository.\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Julio Potier\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://21douze.fr/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"21douze\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:512;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:11:{s:6:\"server\";s:12:\"nginx/1.27.0\";s:4:\"date\";s:29:\"Mon, 25 Nov 2024 08:02:13 GMT\";s:12:\"content-type\";s:20:\"application/atom+xml\";s:12:\"x-powered-by\";s:10:\"PHP/8.0.30\";s:13:\"last-modified\";s:29:\"Fri, 01 Dec 2023 22:13:18 GMT\";s:4:\"etag\";s:34:\"\"c11b85e08f9a55c369b83cdc4e5e720f\"\";s:4:\"link\";s:57:\"<https://rss.wpfr.net/wp-json/>; rel=\"https://api.w.org/\"\";s:13:\"cache-control\";s:35:\"no-cache, no-store, must-revalidate\";s:6:\"pragma\";s:8:\"no-cache\";s:7:\"expires\";s:1:\"0\";s:25:\"strict-transport-security\";s:16:\"max-age=63072000\";}}s:5:\"build\";i:1727736619;s:21:\"cache_expiration_time\";i:1732564801;s:23:\"__cache_expiration_time\";i:1732564801;}", "off");
INSERT INTO `wp_options` VALUES("454", "_transient_timeout_feed_mod_48c2a7450ae14f12ef8a9b58ca9f0748", "1732564801", "off");
INSERT INTO `wp_options` VALUES("455", "_transient_feed_mod_48c2a7450ae14f12ef8a9b58ca9f0748", "1732521601", "off");
INSERT INTO `wp_options` VALUES("456", "_transient_timeout_dash_v2_bd94b8f41e74bae2f4dc72e9bd8379af", "1732564801", "off");
INSERT INTO `wp_options` VALUES("457", "_transient_dash_v2_bd94b8f41e74bae2f4dc72e9bd8379af", "<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://fr.wordpress.org/2024/11/12/wordpress-6-7-rollins/\'>WordPress 6.7 « Rollins »</a></li><li><a class=\'rsswidget\' href=\'https://fr.wordpress.org/2024/10/28/guide-des-changements-techniques-de-wordpress-6-7/\'>Guide des changements techniques de WordPress 6.7</a></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://kinsta.com/fr/blog/developpement-production-contenu/\'>Développer la production de contenu et le marketing pour plusieurs sites</a></li><li><a class=\'rsswidget\' href=\'https://yesweblog.fr/usine-a-sites-wordpress-c-est-quoi/\'>Une usine à sites WordPress c’est quoi ?</a></li><li><a class=\'rsswidget\' href=\'https://beapi.fr/blog/wordpress-est-il-toujours-le-bon-choix-retour-dexperience/\'>WordPress est-il toujours le bon choix ? Retour d’expérience</a></li></ul></div>", "off");
INSERT INTO `wp_options` VALUES("458", "_site_transient_wp_plugin_dependencies_plugin_data", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("459", "recently_activated", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("460", "_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a", "1732532484", "off");
INSERT INTO `wp_options` VALUES("461", "_site_transient_poptags_40cd750bba9870f18aada2478b24840a", "O:8:\"stdClass\":100:{s:11:\"woocommerce\";a:3:{s:4:\"name\";s:11:\"woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:5:\"count\";i:6631;}s:6:\"widget\";a:3:{s:4:\"name\";s:6:\"widget\";s:4:\"slug\";s:6:\"widget\";s:5:\"count\";i:4855;}s:4:\"post\";a:3:{s:4:\"name\";s:4:\"post\";s:4:\"slug\";s:4:\"post\";s:5:\"count\";i:2791;}s:5:\"admin\";a:3:{s:4:\"name\";s:5:\"admin\";s:4:\"slug\";s:5:\"admin\";s:5:\"count\";i:2682;}s:5:\"posts\";a:3:{s:4:\"name\";s:5:\"posts\";s:4:\"slug\";s:5:\"posts\";s:5:\"count\";i:2090;}s:9:\"shortcode\";a:3:{s:4:\"name\";s:9:\"shortcode\";s:4:\"slug\";s:9:\"shortcode\";s:5:\"count\";i:1985;}s:8:\"comments\";a:3:{s:4:\"name\";s:8:\"comments\";s:4:\"slug\";s:8:\"comments\";s:5:\"count\";i:1931;}s:3:\"seo\";a:3:{s:4:\"name\";s:3:\"seo\";s:4:\"slug\";s:3:\"seo\";s:5:\"count\";i:1778;}s:6:\"images\";a:3:{s:4:\"name\";s:6:\"images\";s:4:\"slug\";s:6:\"images\";s:5:\"count\";i:1589;}s:5:\"image\";a:3:{s:4:\"name\";s:5:\"image\";s:4:\"slug\";s:5:\"image\";s:5:\"count\";i:1587;}s:9:\"ecommerce\";a:3:{s:4:\"name\";s:9:\"ecommerce\";s:4:\"slug\";s:9:\"ecommerce\";s:5:\"count\";i:1558;}s:6:\"google\";a:3:{s:4:\"name\";s:6:\"google\";s:4:\"slug\";s:6:\"google\";s:5:\"count\";i:1547;}s:7:\"twitter\";a:3:{s:4:\"name\";s:7:\"twitter\";s:4:\"slug\";s:7:\"twitter\";s:5:\"count\";i:1512;}s:8:\"facebook\";a:3:{s:4:\"name\";s:8:\"facebook\";s:4:\"slug\";s:8:\"facebook\";s:5:\"count\";i:1503;}s:5:\"email\";a:3:{s:4:\"name\";s:5:\"email\";s:4:\"slug\";s:5:\"email\";s:5:\"count\";i:1440;}s:7:\"sidebar\";a:3:{s:4:\"name\";s:7:\"sidebar\";s:4:\"slug\";s:7:\"sidebar\";s:5:\"count\";i:1316;}s:7:\"gallery\";a:3:{s:4:\"name\";s:7:\"gallery\";s:4:\"slug\";s:7:\"gallery\";s:5:\"count\";i:1312;}s:5:\"login\";a:3:{s:4:\"name\";s:5:\"login\";s:4:\"slug\";s:5:\"login\";s:5:\"count\";i:1186;}s:6:\"social\";a:3:{s:4:\"name\";s:6:\"social\";s:4:\"slug\";s:6:\"social\";s:5:\"count\";i:1170;}s:4:\"page\";a:3:{s:4:\"name\";s:4:\"page\";s:4:\"slug\";s:4:\"page\";s:5:\"count\";i:1160;}s:8:\"security\";a:3:{s:4:\"name\";s:8:\"security\";s:4:\"slug\";s:8:\"security\";s:5:\"count\";i:1151;}s:10:\"e-commerce\";a:3:{s:4:\"name\";s:10:\"e-commerce\";s:4:\"slug\";s:10:\"e-commerce\";s:5:\"count\";i:1030;}s:5:\"video\";a:3:{s:4:\"name\";s:5:\"video\";s:4:\"slug\";s:5:\"video\";s:5:\"count\";i:1022;}s:7:\"widgets\";a:3:{s:4:\"name\";s:7:\"widgets\";s:4:\"slug\";s:7:\"widgets\";s:5:\"count\";i:991;}s:7:\"payment\";a:3:{s:4:\"name\";s:7:\"payment\";s:4:\"slug\";s:7:\"payment\";s:5:\"count\";i:989;}s:9:\"analytics\";a:3:{s:4:\"name\";s:9:\"analytics\";s:4:\"slug\";s:9:\"analytics\";s:5:\"count\";i:950;}s:5:\"block\";a:3:{s:4:\"name\";s:5:\"block\";s:4:\"slug\";s:5:\"block\";s:5:\"count\";i:941;}s:9:\"gutenberg\";a:3:{s:4:\"name\";s:9:\"gutenberg\";s:4:\"slug\";s:9:\"gutenberg\";s:5:\"count\";i:924;}s:5:\"links\";a:3:{s:4:\"name\";s:5:\"links\";s:4:\"slug\";s:5:\"links\";s:5:\"count\";i:907;}s:6:\"slider\";a:3:{s:4:\"name\";s:6:\"slider\";s:4:\"slug\";s:6:\"slider\";s:5:\"count\";i:900;}s:4:\"spam\";a:3:{s:4:\"name\";s:4:\"spam\";s:4:\"slug\";s:4:\"spam\";s:5:\"count\";i:899;}s:4:\"form\";a:3:{s:4:\"name\";s:4:\"form\";s:4:\"slug\";s:4:\"form\";s:5:\"count\";i:897;}s:7:\"content\";a:3:{s:4:\"name\";s:7:\"content\";s:4:\"slug\";s:7:\"content\";s:5:\"count\";i:896;}s:15:\"payment-gateway\";a:3:{s:4:\"name\";s:15:\"payment gateway\";s:4:\"slug\";s:15:\"payment-gateway\";s:5:\"count\";i:850;}s:9:\"elementor\";a:3:{s:4:\"name\";s:9:\"elementor\";s:4:\"slug\";s:9:\"elementor\";s:5:\"count\";i:832;}s:5:\"media\";a:3:{s:4:\"name\";s:5:\"media\";s:4:\"slug\";s:5:\"media\";s:5:\"count\";i:818;}s:6:\"search\";a:3:{s:4:\"name\";s:6:\"search\";s:4:\"slug\";s:6:\"search\";s:5:\"count\";i:810;}s:6:\"editor\";a:3:{s:4:\"name\";s:6:\"editor\";s:4:\"slug\";s:6:\"editor\";s:5:\"count\";i:782;}s:10:\"buddypress\";a:3:{s:4:\"name\";s:10:\"buddypress\";s:4:\"slug\";s:10:\"buddypress\";s:5:\"count\";i:779;}s:12:\"contact-form\";a:3:{s:4:\"name\";s:12:\"contact form\";s:4:\"slug\";s:12:\"contact-form\";s:5:\"count\";i:758;}s:4:\"menu\";a:3:{s:4:\"name\";s:4:\"menu\";s:4:\"slug\";s:4:\"menu\";s:5:\"count\";i:756;}s:3:\"rss\";a:3:{s:4:\"name\";s:3:\"rss\";s:4:\"slug\";s:3:\"rss\";s:5:\"count\";i:753;}s:5:\"pages\";a:3:{s:4:\"name\";s:5:\"pages\";s:4:\"slug\";s:5:\"pages\";s:5:\"count\";i:735;}s:5:\"embed\";a:3:{s:4:\"name\";s:5:\"embed\";s:4:\"slug\";s:5:\"embed\";s:5:\"count\";i:718;}s:8:\"category\";a:3:{s:4:\"name\";s:8:\"category\";s:4:\"slug\";s:8:\"category\";s:5:\"count\";i:703;}s:4:\"feed\";a:3:{s:4:\"name\";s:4:\"feed\";s:4:\"slug\";s:4:\"feed\";s:5:\"count\";i:700;}s:4:\"ajax\";a:3:{s:4:\"name\";s:4:\"ajax\";s:4:\"slug\";s:4:\"ajax\";s:5:\"count\";i:673;}s:6:\"jquery\";a:3:{s:4:\"name\";s:6:\"jquery\";s:4:\"slug\";s:6:\"jquery\";s:5:\"count\";i:662;}s:7:\"youtube\";a:3:{s:4:\"name\";s:7:\"youtube\";s:4:\"slug\";s:7:\"youtube\";s:5:\"count\";i:656;}s:3:\"api\";a:3:{s:4:\"name\";s:3:\"api\";s:4:\"slug\";s:3:\"api\";s:5:\"count\";i:635;}s:9:\"affiliate\";a:3:{s:4:\"name\";s:9:\"affiliate\";s:4:\"slug\";s:9:\"affiliate\";s:5:\"count\";i:634;}s:3:\"css\";a:3:{s:4:\"name\";s:3:\"css\";s:4:\"slug\";s:3:\"css\";s:5:\"count\";i:633;}s:4:\"link\";a:3:{s:4:\"name\";s:4:\"link\";s:4:\"slug\";s:4:\"link\";s:5:\"count\";i:615;}s:10:\"javascript\";a:3:{s:4:\"name\";s:10:\"javascript\";s:4:\"slug\";s:10:\"javascript\";s:5:\"count\";i:613;}s:9:\"dashboard\";a:3:{s:4:\"name\";s:9:\"dashboard\";s:4:\"slug\";s:9:\"dashboard\";s:5:\"count\";i:605;}s:8:\"shipping\";a:3:{s:4:\"name\";s:8:\"shipping\";s:4:\"slug\";s:8:\"shipping\";s:5:\"count\";i:604;}s:9:\"marketing\";a:3:{s:4:\"name\";s:9:\"marketing\";s:4:\"slug\";s:9:\"marketing\";s:5:\"count\";i:602;}s:5:\"share\";a:3:{s:4:\"name\";s:5:\"share\";s:4:\"slug\";s:5:\"share\";s:5:\"count\";i:601;}s:10:\"responsive\";a:3:{s:4:\"name\";s:10:\"responsive\";s:4:\"slug\";s:10:\"responsive\";s:5:\"count\";i:601;}s:4:\"chat\";a:3:{s:4:\"name\";s:4:\"chat\";s:4:\"slug\";s:4:\"chat\";s:5:\"count\";i:599;}s:7:\"contact\";a:3:{s:4:\"name\";s:7:\"contact\";s:4:\"slug\";s:7:\"contact\";s:5:\"count\";i:591;}s:3:\"ads\";a:3:{s:4:\"name\";s:3:\"ads\";s:4:\"slug\";s:3:\"ads\";s:5:\"count\";i:581;}s:14:\"contact-form-7\";a:3:{s:4:\"name\";s:14:\"contact form 7\";s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"count\";i:579;}s:7:\"comment\";a:3:{s:4:\"name\";s:7:\"comment\";s:4:\"slug\";s:7:\"comment\";s:5:\"count\";i:577;}s:5:\"theme\";a:3:{s:4:\"name\";s:5:\"theme\";s:4:\"slug\";s:5:\"theme\";s:5:\"count\";i:575;}s:6:\"custom\";a:3:{s:4:\"name\";s:6:\"custom\";s:4:\"slug\";s:6:\"custom\";s:5:\"count\";i:574;}s:11:\"performance\";a:3:{s:4:\"name\";s:11:\"performance\";s:4:\"slug\";s:11:\"performance\";s:5:\"count\";i:571;}s:6:\"events\";a:3:{s:4:\"name\";s:6:\"events\";s:4:\"slug\";s:6:\"events\";s:5:\"count\";i:570;}s:5:\"forms\";a:3:{s:4:\"name\";s:5:\"forms\";s:4:\"slug\";s:5:\"forms\";s:5:\"count\";i:556;}s:10:\"categories\";a:3:{s:4:\"name\";s:10:\"categories\";s:4:\"slug\";s:10:\"categories\";s:5:\"count\";i:553;}s:5:\"popup\";a:3:{s:4:\"name\";s:5:\"popup\";s:4:\"slug\";s:5:\"popup\";s:5:\"count\";i:543;}s:6:\"button\";a:3:{s:4:\"name\";s:6:\"button\";s:4:\"slug\";s:6:\"button\";s:5:\"count\";i:542;}s:6:\"blocks\";a:3:{s:4:\"name\";s:6:\"blocks\";s:4:\"slug\";s:6:\"blocks\";s:5:\"count\";i:536;}s:4:\"user\";a:3:{s:4:\"name\";s:4:\"user\";s:4:\"slug\";s:4:\"user\";s:5:\"count\";i:528;}s:8:\"calendar\";a:3:{s:4:\"name\";s:8:\"calendar\";s:4:\"slug\";s:8:\"calendar\";s:5:\"count\";i:524;}s:5:\"users\";a:3:{s:4:\"name\";s:5:\"users\";s:4:\"slug\";s:5:\"users\";s:5:\"count\";i:518;}s:4:\"tags\";a:3:{s:4:\"name\";s:4:\"tags\";s:4:\"slug\";s:4:\"tags\";s:5:\"count\";i:515;}s:6:\"mobile\";a:3:{s:4:\"name\";s:6:\"mobile\";s:4:\"slug\";s:6:\"mobile\";s:5:\"count\";i:503;}s:10:\"newsletter\";a:3:{s:4:\"name\";s:10:\"newsletter\";s:4:\"slug\";s:10:\"newsletter\";s:5:\"count\";i:501;}s:8:\"payments\";a:3:{s:4:\"name\";s:8:\"payments\";s:4:\"slug\";s:8:\"payments\";s:5:\"count\";i:493;}s:10:\"navigation\";a:3:{s:4:\"name\";s:10:\"navigation\";s:4:\"slug\";s:10:\"navigation\";s:5:\"count\";i:491;}s:12:\"social-media\";a:3:{s:4:\"name\";s:12:\"social media\";s:4:\"slug\";s:12:\"social-media\";s:5:\"count\";i:464;}s:5:\"stats\";a:3:{s:4:\"name\";s:5:\"stats\";s:4:\"slug\";s:5:\"stats\";s:5:\"count\";i:461;}s:7:\"gateway\";a:3:{s:4:\"name\";s:7:\"gateway\";s:4:\"slug\";s:7:\"gateway\";s:5:\"count\";i:455;}s:9:\"slideshow\";a:3:{s:4:\"name\";s:9:\"slideshow\";s:4:\"slug\";s:9:\"slideshow\";s:5:\"count\";i:454;}s:12:\"notification\";a:3:{s:4:\"name\";s:12:\"notification\";s:4:\"slug\";s:12:\"notification\";s:5:\"count\";i:451;}s:5:\"photo\";a:3:{s:4:\"name\";s:5:\"photo\";s:4:\"slug\";s:5:\"photo\";s:5:\"count\";i:449;}s:10:\"statistics\";a:3:{s:4:\"name\";s:10:\"statistics\";s:4:\"slug\";s:10:\"statistics\";s:5:\"count\";i:449;}s:8:\"tracking\";a:3:{s:4:\"name\";s:8:\"tracking\";s:4:\"slug\";s:8:\"tracking\";s:5:\"count\";i:446;}s:8:\"redirect\";a:3:{s:4:\"name\";s:8:\"redirect\";s:4:\"slug\";s:8:\"redirect\";s:5:\"count\";i:446;}s:8:\"checkout\";a:3:{s:4:\"name\";s:8:\"checkout\";s:4:\"slug\";s:8:\"checkout\";s:5:\"count\";i:441;}s:6:\"import\";a:3:{s:4:\"name\";s:6:\"import\";s:4:\"slug\";s:6:\"import\";s:5:\"count\";i:434;}s:6:\"photos\";a:3:{s:4:\"name\";s:6:\"photos\";s:4:\"slug\";s:6:\"photos\";s:5:\"count\";i:431;}s:4:\"news\";a:3:{s:4:\"name\";s:4:\"news\";s:4:\"slug\";s:4:\"news\";s:5:\"count\";i:429;}s:4:\"code\";a:3:{s:4:\"name\";s:4:\"code\";s:4:\"slug\";s:4:\"code\";s:5:\"count\";i:419;}s:5:\"cache\";a:3:{s:4:\"name\";s:5:\"cache\";s:4:\"slug\";s:5:\"cache\";s:5:\"count\";i:418;}s:10:\"shortcodes\";a:3:{s:4:\"name\";s:10:\"shortcodes\";s:4:\"slug\";s:10:\"shortcodes\";s:5:\"count\";i:416;}s:7:\"plugins\";a:3:{s:4:\"name\";s:7:\"plugins\";s:4:\"slug\";s:7:\"plugins\";s:5:\"count\";i:404;}s:9:\"multisite\";a:3:{s:4:\"name\";s:9:\"multisite\";s:4:\"slug\";s:9:\"multisite\";s:5:\"count\";i:398;}s:3:\"map\";a:3:{s:4:\"name\";s:3:\"map\";s:4:\"slug\";s:3:\"map\";s:5:\"count\";i:394;}}", "off");
INSERT INTO `wp_options` VALUES("463", "_site_transient_timeout_theme_roots", "1732523517", "off");
INSERT INTO `wp_options` VALUES("464", "_site_transient_theme_roots", "a:5:{s:16:\"twentytwentyfive\";s:7:\"/themes\";s:16:\"twentytwentyfour\";s:7:\"/themes\";s:17:\"twentytwentythree\";s:7:\"/themes\";s:16:\"valio-theme copy\";s:7:\"/themes\";s:11:\"valio-theme\";s:7:\"/themes\";}", "off");
INSERT INTO `wp_options` VALUES("465", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1732521721;s:8:\"response\";a:0:{}s:12:\"translations\";a:1:{i:0;a:7:{s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:10:\"duplicator\";s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:8:\"1.5.11.2\";s:7:\"updated\";s:19:\"2024-10-03 10:51:47\";s:7:\"package\";s:80:\"https://downloads.wordpress.org/translation/plugin/duplicator/1.5.11.2/fr_FR.zip\";s:10:\"autoupdate\";b:1;}}s:9:\"no_update\";a:1:{s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:8:\"1.5.11.2\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/duplicator.1.5.11.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=2906985\";s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=2906985\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/duplicator/assets/banner-1544x500.png?rev=2906985\";s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=2906985\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.9\";}}s:7:\"checked\";a:1:{s:25:\"duplicator/duplicator.php\";s:8:\"1.5.11.2\";}}", "off");
INSERT INTO `wp_options` VALUES("466", "duplicator_version_plugin", "1.5.11.2", "auto");
INSERT INTO `wp_options` VALUES("468", "duplicator_install_info", "a:3:{s:7:\"version\";s:8:\"1.5.11.2\";s:4:\"time\";i:1732521723;s:10:\"updateTime\";i:1732521723;}", "off");
INSERT INTO `wp_options` VALUES("469", "duplicator_uninstall_package", "1", "auto");
INSERT INTO `wp_options` VALUES("470", "duplicator_uninstall_settings", "1", "auto");
INSERT INTO `wp_options` VALUES("471", "duplicator_settings", "a:22:{s:7:\"version\";s:8:\"1.5.11.2\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:13:\"package_debug\";b:0;s:23:\"email_summary_frequency\";s:6:\"weekly\";s:9:\"amNotices\";b:1;s:17:\"package_mysqldump\";s:1:\"0\";s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";s:1:\"0\";s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"wpcont\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";s:1:\"2\";s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:2;s:14:\"usage_tracking\";b:0;i:0;b:0;s:12:\"last_updated\";s:19:\"2024-11-25-08-58-24\";s:18:\"package_ui_created\";s:1:\"1\";}", "auto");
INSERT INTO `wp_options` VALUES("472", "duplicator_plugin_data_stats", "{\n    \"lastSendTime\": 0,\n    \"identifier\": \"O36CcCw6z2FV1aEN1Scoz=Jm_Kf9=4i,h4AbKCE9WPuv\",\n    \"plugin\": \"dup-lite\",\n    \"pluginStatus\": \"active\",\n    \"buildCount\": 0,\n    \"buildLastDate\": 0,\n    \"buildFailedCount\": 1,\n    \"buildFailedLastDate\": 1732521762,\n    \"siteSizeMB\": 98.040000000000006,\n    \"siteNumFiles\": 5702,\n    \"siteDbSizeMB\": 3.25,\n    \"siteDbNumTables\": 13\n}", "auto");
INSERT INTO `wp_options` VALUES("473", "duplicator_notifications", "a:4:{s:6:\"update\";i:1732521723;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "auto");
INSERT INTO `wp_options` VALUES("474", "duplicator_ui_view_state", "a:3:{s:22:\"dup-pack-archive-panel\";s:1:\"0\";s:24:\"dup-pack-installer-panel\";s:1:\"0\";s:22:\"dup-pack-storage-panel\";s:1:\"1\";}", "auto");
INSERT INTO `wp_options` VALUES("475", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-11-25 08:58:38\";s:7:\"Version\";s:8:\"1.5.11.2\";s:9:\"VersionWP\";s:5:\"6.7.1\";s:9:\"VersionDB\";s:6:\"8.0.16\";s:10:\"VersionPHP\";s:6:\"8.2.23\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";N;s:4:\"Name\";s:21:\"20241125_puivaliotech\";s:4:\"Hash\";s:35:\"53cba3018d2a1fea7157_20241125085838\";s:8:\"NameHash\";s:57:\"20241125_puivaliotech_53cba3018d2a1fea7157_20241125085838\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:67:\"20241125_puivaliotech_53cba3018d2a1fea7157_20241125085838_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:49:\"/Users/admin/Local Sites/pui-valiotech/app/public\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:848;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:4854;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-11-25 08:58:38\";s:7:\"Version\";s:8:\"1.5.11.2\";s:9:\"VersionWP\";s:5:\"6.7.1\";s:9:\"VersionDB\";s:6:\"8.0.16\";s:10:\"VersionPHP\";s:6:\"8.2.23\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";N;s:4:\"Name\";s:21:\"20241125_puivaliotech\";s:4:\"Hash\";s:35:\"53cba3018d2a1fea7157_20241125085838\";s:8:\"NameHash\";s:57:\"20241125_puivaliotech_53cba3018d2a1fea7157_20241125085838\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:63:\"/Users/admin/Local Sites/pui-valiotech/app/public/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:19:\"sameNameTableExists\";N;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:65;s:24:\"\0DUP_Database\0tempDbPath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:58:\"/Users/admin/Local Sites/pui-valiotech/app/public/wp-admin\";i:1;s:61:\"/Users/admin/Local Sites/pui-valiotech/app/public/wp-includes\";i:2;s:70:\"/Users/admin/Local Sites/pui-valiotech/app/public/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:49:\"/Users/admin/Local Sites/pui-valiotech/app/public\";i:1;s:49:\"/Users/admin/Local Sites/pui-valiotech/app/public\";i:2;s:60:\"/Users/admin/Local Sites/pui-valiotech/app/public/wp-content\";i:3;s:68:\"/Users/admin/Local Sites/pui-valiotech/app/public/wp-content/uploads\";i:4;s:68:\"/Users/admin/Local Sites/pui-valiotech/app/public/wp-content/plugins\";i:5;s:71:\"/Users/admin/Local Sites/pui-valiotech/app/public/wp-content/mu-plugins\";i:6;s:67:\"/Users/admin/Local Sites/pui-valiotech/app/public/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:81:\"/Users/admin/Local Sites/pui-valiotech/app/public/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}", "auto");
INSERT INTO `wp_options` VALUES("476", "duplicator_email_summary_info", "{\"CL_-=_-=\":\"Duplicator\\\\Utils\\\\Email\\\\EmailSummary\",\"manualPackageIds\":[],\"failedPackageIds\":[1]}", "auto");
INSERT INTO `wp_options` VALUES("477", "_site_transient_timeout_wp_theme_files_patterns-01f0a8d65cbf353051ae6f586127e677", "1732526865", "off");
INSERT INTO `wp_options` VALUES("478", "_site_transient_wp_theme_files_patterns-01f0a8d65cbf353051ae6f586127e677", "a:2:{s:7:\"version\";s:3:\"1.0\";s:8:\"patterns\";a:0:{}}", "off");

/* INSERT TABLE DATA: wp_postmeta */
INSERT INTO `wp_postmeta` VALUES("1", "2", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("2", "3", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("5", "2", "_edit_lock", "1732279187:1");
INSERT INTO `wp_postmeta` VALUES("6", "7", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("7", "7", "_wp_trash_meta_time", "1732089690");
INSERT INTO `wp_postmeta` VALUES("8", "8", "_edit_lock", "1732090223:1");
INSERT INTO `wp_postmeta` VALUES("9", "9", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("10", "9", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("11", "9", "_menu_item_object_id", "2");
INSERT INTO `wp_postmeta` VALUES("12", "9", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("13", "9", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("14", "9", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("15", "9", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("16", "9", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("17", "9", "_menu_item_orphaned", "1732090523");
INSERT INTO `wp_postmeta` VALUES("18", "10", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("19", "10", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("20", "10", "_menu_item_object_id", "2");
INSERT INTO `wp_postmeta` VALUES("21", "10", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("22", "10", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("23", "10", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("24", "10", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("25", "10", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("26", "10", "_menu_item_orphaned", "1732090545");
INSERT INTO `wp_postmeta` VALUES("27", "11", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("28", "11", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("29", "11", "_menu_item_object_id", "2");
INSERT INTO `wp_postmeta` VALUES("30", "11", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("31", "11", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("32", "11", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("33", "11", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("34", "11", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("35", "11", "_menu_item_orphaned", "1732090615");
INSERT INTO `wp_postmeta` VALUES("36", "12", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("37", "12", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("38", "12", "_menu_item_object_id", "2");
INSERT INTO `wp_postmeta` VALUES("39", "12", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("40", "12", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("41", "12", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("42", "12", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("43", "12", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("44", "12", "_menu_item_orphaned", "1732090627");
INSERT INTO `wp_postmeta` VALUES("45", "2", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("47", "15", "_wp_attached_file", "2024/11/b532e4b30d1917574e9dbd8967d60662.jpeg");
INSERT INTO `wp_postmeta` VALUES("48", "15", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:480;s:6:\"height\";i:320;s:4:\"file\";s:45:\"2024/11/b532e4b30d1917574e9dbd8967d60662.jpeg\";s:8:\"filesize\";i:32714;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:45:\"b532e4b30d1917574e9dbd8967d60662-300x200.jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14043;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:45:\"b532e4b30d1917574e9dbd8967d60662-150x150.jpeg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8742;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("49", "16", "_wp_attached_file", "2024/11/ef701919e992624c1600580947f786fd.jpeg");
INSERT INTO `wp_postmeta` VALUES("50", "16", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:739;s:6:\"height\";i:493;s:4:\"file\";s:45:\"2024/11/ef701919e992624c1600580947f786fd.jpeg\";s:8:\"filesize\";i:75389;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:45:\"ef701919e992624c1600580947f786fd-300x200.jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15924;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:45:\"ef701919e992624c1600580947f786fd-150x150.jpeg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8328;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("51", "17", "_wp_attached_file", "2024/11/34ae07df518c66da70ea24c63c2e6f0c.jpeg");
INSERT INTO `wp_postmeta` VALUES("52", "17", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:740;s:6:\"height\";i:493;s:4:\"file\";s:45:\"2024/11/34ae07df518c66da70ea24c63c2e6f0c.jpeg\";s:8:\"filesize\";i:91868;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:45:\"34ae07df518c66da70ea24c63c2e6f0c-300x200.jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:19869;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:45:\"34ae07df518c66da70ea24c63c2e6f0c-150x150.jpeg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10470;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("53", "19", "_wp_attached_file", "2024/11/1264e6eb30c0ef78308d82d98aa8f086.jpeg");
INSERT INTO `wp_postmeta` VALUES("54", "20", "_wp_attached_file", "2024/11/724e2f98e73630980b049921e093e23a.png");
INSERT INTO `wp_postmeta` VALUES("55", "20", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:2193;s:6:\"height\";i:1427;s:4:\"file\";s:44:\"2024/11/724e2f98e73630980b049921e093e23a.png\";s:8:\"filesize\";i:192351;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:44:\"724e2f98e73630980b049921e093e23a-300x195.png\";s:5:\"width\";i:300;s:6:\"height\";i:195;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:18195;}s:5:\"large\";a:5:{s:4:\"file\";s:45:\"724e2f98e73630980b049921e093e23a-1024x666.png\";s:5:\"width\";i:1024;s:6:\"height\";i:666;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:88685;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:44:\"724e2f98e73630980b049921e093e23a-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:9779;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:44:\"724e2f98e73630980b049921e093e23a-768x500.png\";s:5:\"width\";i:768;s:6:\"height\";i:500;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:59943;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:45:\"724e2f98e73630980b049921e093e23a-1536x999.png\";s:5:\"width\";i:1536;s:6:\"height\";i:999;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:153821;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:46:\"724e2f98e73630980b049921e093e23a-2048x1333.png\";s:5:\"width\";i:2048;s:6:\"height\";i:1333;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:222919;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("56", "19", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1181;s:6:\"height\";i:394;s:4:\"file\";s:45:\"2024/11/1264e6eb30c0ef78308d82d98aa8f086.jpeg\";s:8:\"filesize\";i:81328;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:45:\"1264e6eb30c0ef78308d82d98aa8f086-300x100.jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:42130;}s:5:\"large\";a:5:{s:4:\"file\";s:46:\"1264e6eb30c0ef78308d82d98aa8f086-1024x342.jpeg\";s:5:\"width\";i:1024;s:6:\"height\";i:342;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:63469;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:45:\"1264e6eb30c0ef78308d82d98aa8f086-150x150.jpeg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:39254;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:45:\"1264e6eb30c0ef78308d82d98aa8f086-768x256.jpeg\";s:5:\"width\";i:768;s:6:\"height\";i:256;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:55153;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:10:\"Impression\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("57", "21", "_wp_attached_file", "2024/11/6306afbcf38f7060680d7b4089dfaabc.png");
INSERT INTO `wp_postmeta` VALUES("58", "21", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:300;s:6:\"height\";i:255;s:4:\"file\";s:44:\"2024/11/6306afbcf38f7060680d7b4089dfaabc.png\";s:8:\"filesize\";i:20385;s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:44:\"6306afbcf38f7060680d7b4089dfaabc-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:11421;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("59", "22", "_wp_attached_file", "2024/11/e959eab8fb6cc935aa083d3451a0affc.jpeg");
INSERT INTO `wp_postmeta` VALUES("60", "22", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1680;s:6:\"height\";i:486;s:4:\"file\";s:45:\"2024/11/e959eab8fb6cc935aa083d3451a0affc.jpeg\";s:8:\"filesize\";i:139324;s:5:\"sizes\";a:5:{s:6:\"medium\";a:5:{s:4:\"file\";s:44:\"e959eab8fb6cc935aa083d3451a0affc-300x87.jpeg\";s:5:\"width\";i:300;s:6:\"height\";i:87;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:23373;}s:5:\"large\";a:5:{s:4:\"file\";s:46:\"e959eab8fb6cc935aa083d3451a0affc-1024x296.jpeg\";s:5:\"width\";i:1024;s:6:\"height\";i:296;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:48549;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:45:\"e959eab8fb6cc935aa083d3451a0affc-150x150.jpeg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:22248;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:45:\"e959eab8fb6cc935aa083d3451a0affc-768x222.jpeg\";s:5:\"width\";i:768;s:6:\"height\";i:222;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:39283;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:46:\"e959eab8fb6cc935aa083d3451a0affc-1536x444.jpeg\";s:5:\"width\";i:1536;s:6:\"height\";i:444;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:67843;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("61", "23", "_wp_attached_file", "2024/11/Icone.png");
INSERT INTO `wp_postmeta` VALUES("62", "23", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:71;s:6:\"height\";i:71;s:4:\"file\";s:17:\"2024/11/Icone.png\";s:8:\"filesize\";i:1464;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("63", "24", "_wp_attached_file", "2024/11/image.png");
INSERT INTO `wp_postmeta` VALUES("64", "24", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1214;s:6:\"height\";i:817;s:4:\"file\";s:17:\"2024/11/image.png\";s:8:\"filesize\";i:804167;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:17:\"image-300x202.png\";s:5:\"width\";i:300;s:6:\"height\";i:202;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:75259;}s:5:\"large\";a:5:{s:4:\"file\";s:18:\"image-1024x689.png\";s:5:\"width\";i:1024;s:6:\"height\";i:689;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:561071;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:17:\"image-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:33671;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:17:\"image-768x517.png\";s:5:\"width\";i:768;s:6:\"height\";i:517;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:357016;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("65", "25", "_wp_attached_file", "2024/11/image-1.png");
INSERT INTO `wp_postmeta` VALUES("66", "25", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1440;s:6:\"height\";i:760;s:4:\"file\";s:19:\"2024/11/image-1.png\";s:8:\"filesize\";i:1264457;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:19:\"image-1-300x158.png\";s:5:\"width\";i:300;s:6:\"height\";i:158;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:70106;}s:5:\"large\";a:5:{s:4:\"file\";s:20:\"image-1-1024x540.png\";s:5:\"width\";i:1024;s:6:\"height\";i:540;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:616334;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:19:\"image-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:29074;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:19:\"image-1-768x405.png\";s:5:\"width\";i:768;s:6:\"height\";i:405;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:372087;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("67", "41", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("68", "41", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("69", "41", "_menu_item_object_id", "2");
INSERT INTO `wp_postmeta` VALUES("70", "41", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("71", "41", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("72", "41", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("73", "41", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("74", "41", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("75", "41", "_menu_item_orphaned", "1732172099");
INSERT INTO `wp_postmeta` VALUES("85", "43", "_wp_attached_file", "2024/11/Icone-1.png");
INSERT INTO `wp_postmeta` VALUES("86", "43", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:96;s:6:\"height\";i:96;s:4:\"file\";s:19:\"2024/11/Icone-1.png\";s:8:\"filesize\";i:7041;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("87", "44", "_wp_attached_file", "2024/11/cropped-Icone-1.png");
INSERT INTO `wp_postmeta` VALUES("88", "44", "_wp_attachment_context", "site-icon");
INSERT INTO `wp_postmeta` VALUES("89", "44", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"file\";s:27:\"2024/11/cropped-Icone-1.png\";s:8:\"filesize\";i:82331;s:5:\"sizes\";a:6:{s:6:\"medium\";a:5:{s:4:\"file\";s:27:\"cropped-Icone-1-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:43593;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:27:\"cropped-Icone-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:17470;}s:13:\"site_icon-270\";a:5:{s:4:\"file\";s:27:\"cropped-Icone-1-270x270.png\";s:5:\"width\";i:270;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:38146;}s:13:\"site_icon-192\";a:5:{s:4:\"file\";s:27:\"cropped-Icone-1-192x192.png\";s:5:\"width\";i:192;s:6:\"height\";i:192;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:23787;}s:13:\"site_icon-180\";a:5:{s:4:\"file\";s:27:\"cropped-Icone-1-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:22416;}s:12:\"site_icon-32\";a:5:{s:4:\"file\";s:25:\"cropped-Icone-1-32x32.png\";s:5:\"width\";i:32;s:6:\"height\";i:32;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1979;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("90", "45", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("91", "45", "_wp_trash_meta_time", "1732172384");
INSERT INTO `wp_postmeta` VALUES("92", "46", "_wp_attached_file", "2024/11/Logo.png");
INSERT INTO `wp_postmeta` VALUES("93", "46", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:86;s:6:\"height\";i:40;s:4:\"file\";s:16:\"2024/11/Logo.png\";s:8:\"filesize\";i:3307;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("94", "47", "_wp_attached_file", "2024/11/Logo-1.png");
INSERT INTO `wp_postmeta` VALUES("95", "47", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:209;s:6:\"height\";i:96;s:4:\"file\";s:18:\"2024/11/Logo-1.png\";s:8:\"filesize\";i:9716;s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:17:\"Logo-1-150x96.png\";s:5:\"width\";i:150;s:6:\"height\";i:96;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:8407;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("96", "48", "_wp_attached_file", "2024/11/cropped-Logo-1.png");
INSERT INTO `wp_postmeta` VALUES("97", "48", "_wp_attachment_context", "custom-logo");
INSERT INTO `wp_postmeta` VALUES("98", "48", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:209;s:6:\"height\";i:96;s:4:\"file\";s:26:\"2024/11/cropped-Logo-1.png\";s:8:\"filesize\";i:10554;s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:25:\"cropped-Logo-1-150x96.png\";s:5:\"width\";i:150;s:6:\"height\";i:96;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:8407;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("99", "49", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("100", "49", "_wp_trash_meta_time", "1732172618");
INSERT INTO `wp_postmeta` VALUES("101", "50", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("102", "50", "_wp_trash_meta_time", "1732173136");
INSERT INTO `wp_postmeta` VALUES("103", "54", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("104", "54", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("105", "54", "_menu_item_object_id", "2");
INSERT INTO `wp_postmeta` VALUES("106", "54", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("107", "54", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("108", "54", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("109", "54", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("110", "54", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("111", "54", "_menu_item_orphaned", "1732174554");
INSERT INTO `wp_postmeta` VALUES("112", "55", "_wp_attached_file", "2024/11/Group1.png");
INSERT INTO `wp_postmeta` VALUES("113", "55", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:179;s:6:\"height\";i:93;s:4:\"file\";s:18:\"2024/11/Group1.png\";s:8:\"filesize\";i:2212;s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:17:\"Group1-150x93.png\";s:5:\"width\";i:150;s:6:\"height\";i:93;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1730;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("114", "56", "_wp_attached_file", "2024/11/Group2.png");
INSERT INTO `wp_postmeta` VALUES("115", "56", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:56;s:6:\"height\";i:92;s:4:\"file\";s:18:\"2024/11/Group2.png\";s:8:\"filesize\";i:2312;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("116", "57", "_wp_attached_file", "2024/11/Group3.png");
INSERT INTO `wp_postmeta` VALUES("117", "57", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:79;s:6:\"height\";i:49;s:4:\"file\";s:18:\"2024/11/Group3.png\";s:8:\"filesize\";i:1321;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("118", "58", "_wp_attached_file", "2024/11/facebook.png");
INSERT INTO `wp_postmeta` VALUES("119", "58", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:21;s:6:\"height\";i:20;s:4:\"file\";s:20:\"2024/11/facebook.png\";s:8:\"filesize\";i:525;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("120", "59", "_wp_attached_file", "2024/11/instagram.png");
INSERT INTO `wp_postmeta` VALUES("121", "59", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:20;s:6:\"height\";i:20;s:4:\"file\";s:21:\"2024/11/instagram.png\";s:8:\"filesize\";i:608;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("122", "60", "_wp_attached_file", "2024/11/linkedin.png");
INSERT INTO `wp_postmeta` VALUES("123", "60", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:21;s:6:\"height\";i:20;s:4:\"file\";s:20:\"2024/11/linkedin.png\";s:8:\"filesize\";i:605;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("133", "62", "_edit_lock", "1732254496:1");
INSERT INTO `wp_postmeta` VALUES("134", "63", "_edit_lock", "1732254600:1");
INSERT INTO `wp_postmeta` VALUES("135", "64", "_edit_lock", "1732254788:1");
INSERT INTO `wp_postmeta` VALUES("136", "65", "_edit_lock", "1732257797:1");
INSERT INTO `wp_postmeta` VALUES("137", "65", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("138", "65", "valiotheme_event_link", "");
INSERT INTO `wp_postmeta` VALUES("139", "65", "valiotheme_event_date", "2024-11-25");
INSERT INTO `wp_postmeta` VALUES("140", "65", "valiotheme_event_textdate", "25 novembre 2024");
INSERT INTO `wp_postmeta` VALUES("142", "48", "_oembed_9ff2d8bfcaeacd27b3883d9f99854852", "{{unknown}}");
INSERT INTO `wp_postmeta` VALUES("144", "77", "_edit_lock", "1732257833:1");
INSERT INTO `wp_postmeta` VALUES("145", "77", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("146", "77", "valiotheme_event_link", "");
INSERT INTO `wp_postmeta` VALUES("147", "77", "valiotheme_event_date", "2024-11-26");
INSERT INTO `wp_postmeta` VALUES("148", "77", "valiotheme_event_textdate", "26 novembre 2024");
INSERT INTO `wp_postmeta` VALUES("149", "78", "_edit_lock", "1732257859:1");
INSERT INTO `wp_postmeta` VALUES("150", "78", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("151", "78", "valiotheme_event_link", "");
INSERT INTO `wp_postmeta` VALUES("152", "78", "valiotheme_event_date", "2024-11-28");
INSERT INTO `wp_postmeta` VALUES("153", "78", "valiotheme_event_textdate", "28 novembre 2024");
INSERT INTO `wp_postmeta` VALUES("154", "79", "_edit_lock", "1732258122:1");
INSERT INTO `wp_postmeta` VALUES("155", "79", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("156", "79", "valiotheme_event_link", "");
INSERT INTO `wp_postmeta` VALUES("157", "79", "valiotheme_event_date", "2024-11-30");
INSERT INTO `wp_postmeta` VALUES("158", "79", "valiotheme_event_textdate", "30 novembre 2024");
INSERT INTO `wp_postmeta` VALUES("159", "81", "_wp_attached_file", "2024/11/Hero_bg.jpg");
INSERT INTO `wp_postmeta` VALUES("160", "81", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1440;s:6:\"height\";i:936;s:4:\"file\";s:19:\"2024/11/Hero_bg.jpg\";s:8:\"filesize\";i:335811;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:19:\"Hero_bg-300x195.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:195;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2138;}s:5:\"large\";a:5:{s:4:\"file\";s:20:\"Hero_bg-1024x666.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:666;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12435;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:19:\"Hero_bg-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:1144;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:19:\"Hero_bg-768x499.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:499;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7856;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("161", "82", "_wp_attached_file", "2024/11/Hero_bg.png");
INSERT INTO `wp_postmeta` VALUES("162", "82", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1440;s:6:\"height\";i:977;s:4:\"file\";s:19:\"2024/11/Hero_bg.png\";s:8:\"filesize\";i:1248789;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:19:\"Hero_bg-300x204.png\";s:5:\"width\";i:300;s:6:\"height\";i:204;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:41056;}s:5:\"large\";a:5:{s:4:\"file\";s:20:\"Hero_bg-1024x695.png\";s:5:\"width\";i:1024;s:6:\"height\";i:695;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:473469;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:19:\"Hero_bg-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:17089;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:19:\"Hero_bg-768x521.png\";s:5:\"width\";i:768;s:6:\"height\";i:521;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:253870;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("163", "83", "_wp_attached_file", "2024/11/Hero_bg-1-e1732258614705.png");
INSERT INTO `wp_postmeta` VALUES("164", "83", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1440;s:6:\"height\";i:977;s:4:\"file\";s:36:\"2024/11/Hero_bg-1-e1732258614705.png\";s:8:\"filesize\";i:1088385;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:36:\"Hero_bg-1-e1732258614705-300x204.png\";s:5:\"width\";i:300;s:6:\"height\";i:204;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:41066;}s:5:\"large\";a:5:{s:4:\"file\";s:37:\"Hero_bg-1-e1732258614705-1024x695.png\";s:5:\"width\";i:1024;s:6:\"height\";i:695;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:473240;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:36:\"Hero_bg-1-e1732258614705-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:17438;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:36:\"Hero_bg-1-e1732258614705-768x521.png\";s:5:\"width\";i:768;s:6:\"height\";i:521;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:253736;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("165", "83", "_wp_attachment_backup_sizes", "a:5:{s:9:\"full-orig\";a:4:{s:5:\"width\";i:1440;s:6:\"height\";i:977;s:8:\"filesize\";i:1248789;s:4:\"file\";s:13:\"Hero_bg-1.png\";}s:14:\"thumbnail-orig\";a:5:{s:4:\"file\";s:21:\"Hero_bg-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:17089;}s:11:\"medium-orig\";a:5:{s:4:\"file\";s:21:\"Hero_bg-1-300x204.png\";s:5:\"width\";i:300;s:6:\"height\";i:204;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:41056;}s:17:\"medium_large-orig\";a:5:{s:4:\"file\";s:21:\"Hero_bg-1-768x521.png\";s:5:\"width\";i:768;s:6:\"height\";i:521;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:253870;}s:10:\"large-orig\";a:5:{s:4:\"file\";s:22:\"Hero_bg-1-1024x695.png\";s:5:\"width\";i:1024;s:6:\"height\";i:695;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:473469;}}");
INSERT INTO `wp_postmeta` VALUES("166", "89", "_wp_attached_file", "2024/11/ic.png");
INSERT INTO `wp_postmeta` VALUES("167", "89", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:80;s:6:\"height\";i:80;s:4:\"file\";s:14:\"2024/11/ic.png\";s:8:\"filesize\";i:1095;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("168", "90", "_wp_attached_file", "2024/11/ic2.png");
INSERT INTO `wp_postmeta` VALUES("169", "90", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:80;s:6:\"height\";i:80;s:4:\"file\";s:15:\"2024/11/ic2.png\";s:8:\"filesize\";i:1499;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("170", "91", "footnotes", "");
INSERT INTO `wp_postmeta` VALUES("171", "96", "_wp_attached_file", "2024/11/Group-42.png");
INSERT INTO `wp_postmeta` VALUES("172", "96", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1440;s:6:\"height\";i:1335;s:4:\"file\";s:20:\"2024/11/Group-42.png\";s:8:\"filesize\";i:14445;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:20:\"Group-42-300x278.png\";s:5:\"width\";i:300;s:6:\"height\";i:278;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1289;}s:5:\"large\";a:5:{s:4:\"file\";s:21:\"Group-42-1024x949.png\";s:5:\"width\";i:1024;s:6:\"height\";i:949;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:6965;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:20:\"Group-42-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:457;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:20:\"Group-42-768x712.png\";s:5:\"width\";i:768;s:6:\"height\";i:712;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:4174;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("173", "97", "_wp_attached_file", "2024/11/Logo-2.png");
INSERT INTO `wp_postmeta` VALUES("174", "97", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:209;s:6:\"height\";i:96;s:4:\"file\";s:18:\"2024/11/Logo-2.png\";s:8:\"filesize\";i:9716;s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:17:\"Logo-2-150x96.png\";s:5:\"width\";i:150;s:6:\"height\";i:96;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:8407;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("175", "99", "_wp_attached_file", "2024/11/Rectangle-39.png");
INSERT INTO `wp_postmeta` VALUES("176", "99", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1440;s:6:\"height\";i:723;s:4:\"file\";s:24:\"2024/11/Rectangle-39.png\";s:8:\"filesize\";i:6790;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:24:\"Rectangle-39-300x151.png\";s:5:\"width\";i:300;s:6:\"height\";i:151;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1272;}s:5:\"large\";a:5:{s:4:\"file\";s:25:\"Rectangle-39-1024x514.png\";s:5:\"width\";i:1024;s:6:\"height\";i:514;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:6095;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:24:\"Rectangle-39-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:702;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:24:\"Rectangle-39-768x386.png\";s:5:\"width\";i:768;s:6:\"height\";i:386;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:4149;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("177", "102", "_wp_attached_file", "2024/11/Rectangle-39.svg");
INSERT INTO `wp_postmeta` VALUES("178", "102", "_wp_attachment_metadata", "a:1:{s:8:\"filesize\";i:193;}");
INSERT INTO `wp_postmeta` VALUES("179", "103", "_edit_lock", "1732272952:1");
INSERT INTO `wp_postmeta` VALUES("180", "104", "_edit_lock", "1732273302:1");
INSERT INTO `wp_postmeta` VALUES("181", "105", "_edit_lock", "1732273337:1");
INSERT INTO `wp_postmeta` VALUES("182", "106", "_edit_lock", "1732273368:1");
INSERT INTO `wp_postmeta` VALUES("183", "107", "_edit_lock", "1732273402:1");
INSERT INTO `wp_postmeta` VALUES("184", "108", "_edit_lock", "1732273418:1");
INSERT INTO `wp_postmeta` VALUES("185", "109", "_edit_lock", "1732273487:1");
INSERT INTO `wp_postmeta` VALUES("186", "112", "_wp_attached_file", "2024/11/Line-2.png");
INSERT INTO `wp_postmeta` VALUES("187", "112", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:192;s:6:\"height\";i:516;s:4:\"file\";s:18:\"2024/11/Line-2.png\";s:8:\"filesize\";i:1887;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:18:\"Line-2-112x300.png\";s:5:\"width\";i:112;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:775;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:18:\"Line-2-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:351;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("188", "113", "_wp_attached_file", "2024/11/Line-3.png");
INSERT INTO `wp_postmeta` VALUES("189", "113", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:75;s:6:\"height\";i:169;s:4:\"file\";s:18:\"2024/11/Line-3.png\";s:8:\"filesize\";i:783;s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:17:\"Line-3-75x150.png\";s:5:\"width\";i:75;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:420;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("190", "114", "_wp_attached_file", "2024/11/Line-4.png");
INSERT INTO `wp_postmeta` VALUES("191", "114", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:62;s:6:\"height\";i:623;s:4:\"file\";s:18:\"2024/11/Line-4.png\";s:8:\"filesize\";i:1178;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:17:\"Line-4-30x300.png\";s:5:\"width\";i:30;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:452;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:17:\"Line-4-62x150.png\";s:5:\"width\";i:62;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:236;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("192", "115", "_wp_attached_file", "2024/11/Line-5.png");
INSERT INTO `wp_postmeta` VALUES("193", "115", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:192;s:6:\"height\";i:759;s:4:\"file\";s:18:\"2024/11/Line-5.png\";s:8:\"filesize\";i:2478;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:17:\"Line-5-76x300.png\";s:5:\"width\";i:76;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:623;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:18:\"Line-5-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:349;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("194", "116", "_wp_attached_file", "2024/11/Union.png");
INSERT INTO `wp_postmeta` VALUES("195", "116", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:57;s:6:\"height\";i:18;s:4:\"file\";s:17:\"2024/11/Union.png\";s:8:\"filesize\";i:465;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("196", "117", "_wp_attached_file", "2024/11/Union2.png");
INSERT INTO `wp_postmeta` VALUES("197", "117", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:57;s:6:\"height\";i:18;s:4:\"file\";s:18:\"2024/11/Union2.png\";s:8:\"filesize\";i:463;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("198", "118", "_wp_attached_file", "2024/11/Union3.png");
INSERT INTO `wp_postmeta` VALUES("199", "118", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:57;s:6:\"height\";i:18;s:4:\"file\";s:18:\"2024/11/Union3.png\";s:8:\"filesize\";i:444;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("200", "119", "_wp_attached_file", "2024/11/Union4.png");
INSERT INTO `wp_postmeta` VALUES("201", "119", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:57;s:6:\"height\";i:18;s:4:\"file\";s:18:\"2024/11/Union4.png\";s:8:\"filesize\";i:465;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("202", "120", "_wp_attached_file", "2024/11/Union5.png");
INSERT INTO `wp_postmeta` VALUES("203", "120", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:57;s:6:\"height\";i:18;s:4:\"file\";s:18:\"2024/11/Union5.png\";s:8:\"filesize\";i:469;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("204", "121", "_wp_attached_file", "2024/11/Union6.png");
INSERT INTO `wp_postmeta` VALUES("205", "121", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:57;s:6:\"height\";i:18;s:4:\"file\";s:18:\"2024/11/Union6.png\";s:8:\"filesize\";i:448;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");

/* INSERT TABLE DATA: wp_posts */
INSERT INTO `wp_posts` VALUES("1", "1", "2024-11-20 07:20:44", "2024-11-20 07:20:44", "<!-- wp:paragraph -->\n<p>Welcome to WordPress. This is your first post. Edit or delete it, then start writing!</p>\n<!-- /wp:paragraph -->", "Hello world!", "", "publish", "open", "open", "", "hello-world", "", "", "2024-11-20 07:20:44", "2024-11-20 07:20:44", "", "0", "http://pui-valiotech.local/?p=1", "0", "post", "", "1");
INSERT INTO `wp_posts` VALUES("2", "1", "2024-11-20 07:20:44", "2024-11-20 07:20:44", "<!-- wp:columns {\"className\":\"hero\"} -->\n<div class=\"wp-block-columns hero\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:columns {\"className\":\"hero-content large\"} -->\n<div class=\"wp-block-columns hero-content large\"><!-- wp:column {\"width\":\"66.66%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"><!-- wp:heading {\"level\":1} -->\n<h1 class=\"wp-block-heading\">Sensibiliser, <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">connecter</mark>, innover</h1>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Avec le PUI Valiotech, nous avons l\'ambition de renforcer l\'innovation locale en créant des synergies entre l’enseignement supérieur, la recherche et le monde socio-économique, pour répondre ensemble aux défis du territoire.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"className\":\"buttons\"} -->\n<div class=\"wp-block-buttons buttons\"><!-- wp:button -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Participer à un événement</a></div>\n<!-- /wp:button -->\n\n<!-- wp:button {\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link wp-element-button\">Nous rejoindre</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"33.33%\",\"className\":\"mobile-hidden\"} -->\n<div class=\"wp-block-column mobile-hidden\" style=\"flex-basis:33.33%\"><!-- wp:columns {\"className\":\"hero-images\"} -->\n<div class=\"wp-block-columns hero-images\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":15,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"square\"} -->\n<figure class=\"wp-block-image size-full square\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/b532e4b30d1917574e9dbd8967d60662.jpeg\" alt=\"\" class=\"wp-image-15\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph {\"className\":\"hero-label\"} -->\n<p class=\"hero-label\">Entrepreneurs</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {\"id\":16,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"vertical\"} -->\n<figure class=\"wp-block-image size-full vertical\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/ef701919e992624c1600580947f786fd.jpeg\" alt=\"\" class=\"wp-image-16\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph {\"className\":\"hero-label\"} -->\n<p class=\"hero-label\">Laboratoires</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":17,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"vertical\"} -->\n<figure class=\"wp-block-image size-full vertical\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/34ae07df518c66da70ea24c63c2e6f0c.jpeg\" alt=\"\" class=\"wp-image-17\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph {\"className\":\"hero-label\"} -->\n<p class=\"hero-label\">Entreprises</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"introduction small\"} -->\n<div class=\"wp-block-columns introduction small\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:gallery {\"columns\":4,\"imageCrop\":false,\"linkTo\":\"none\",\"sizeSlug\":\"full\",\"className\":\"stakeholders\"} -->\n<figure class=\"wp-block-gallery has-nested-images columns-4 stakeholders\"><!-- wp:image {\"id\":22,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/e959eab8fb6cc935aa083d3451a0affc.jpeg\" alt=\"\" class=\"wp-image-22\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":20,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/724e2f98e73630980b049921e093e23a.png\" alt=\"\" class=\"wp-image-20\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":19,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/1264e6eb30c0ef78308d82d98aa8f086.jpeg\" alt=\"\" class=\"wp-image-19\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":21,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/6306afbcf38f7060680d7b4089dfaabc.png\" alt=\"\" class=\"wp-image-21\"/></figure>\n<!-- /wp:image --></figure>\n<!-- /wp:gallery -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3 class=\"wp-block-heading\">C’est quoi un Pôle Universitaire d’Innovation (PUI) ?</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Un PUI est un dispositif national créé pour rapprocher l’université, la recherche et les entreprises, afin de transformer la science et les idées en solutions concrètes.<br>À travers des actions ciblées comme la formation, l’accompagnement des projets, et le transfert technologique, les PUIs accélèrent l’innovation et favorisent la création de start-ups.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"objectifs small\"} -->\n<div class=\"wp-block-columns objectifs small\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"textAlign\":\"center\"} -->\n<h2 class=\"wp-block-heading has-text-align-center\">Les <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">objectifs</mark> de la démarche</h2>\n<!-- /wp:heading -->\n\n<!-- wp:group {\"className\":\"liste-objectifs\",\"layout\":{\"type\":\"grid\",\"minimumColumnWidth\":\"390px\"}} -->\n<div class=\"wp-block-group liste-objectifs\"><!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Sensibiliser et former les futurs entrepreneurs</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Des programmes de formations et événements sont mis en place pour permettre aux jeunes talents de développer leurs compétences et leur esprit entrepreneurial.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Créer des synergies entre les acteurs de l\'innovation</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Nous rassemblons chercheurs, entreprises, étudiants, entrepreneurs et structures d’accompagnement pour encourager la collaboration et l\'échange d\'idées.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Soutenir la croissance des start-ups</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Nous accompagnons les porteurs de projets à chaque étape, de la sensibilisation à la mise en œuvre de leurs activités.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Valoriser les sujets de recherche</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>En favorisant le transfert de technologies et d\'idées entre les laboratoires de recherche et le secteur privé, nous contribuons à l\'application concrète des innovations.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"stats large\"} -->\n<div class=\"wp-block-columns stats large\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Quelques <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">chiffres</mark> pour comprendre</h2>\n<!-- /wp:heading -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"className\":\"stats-image\"} -->\n<div class=\"wp-block-column stats-image\"><!-- wp:image {\"id\":24,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/image-1024x689.png\" alt=\"\" class=\"wp-image-24\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"326px\",\"className\":\"stats-chiffres\",\"style\":{\"color\":{\"background\":\"#d2edf9\"}}} -->\n<div class=\"wp-block-column stats-chiffres has-background\" style=\"background-color:#d2edf9;flex-basis:326px\"><!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">4</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">membres fondateurs</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>l’Université de La Réunion, la Technopole, le CIRAD, et l’IRD, unis pour renforcer les synergies entre la recherche, l’enseignement supérieur et le monde socio-économique.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">22</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">unités de recherche</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>mobilisées pour valoriser les projets et renforcer les collaborations avec le monde socio-économique</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">4</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">axes stratégiques</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>pour transformer l’écosystème</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">500+</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">acteurs de l\'écosystème</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>(étudiants, chercheurs, entrepreneurs, entreprises) visés pour participer aux initiatives et synergies portées par le PUI.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">1er</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">PUI d\'Outre-mer</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>conçu pour dynamiser l’écosystème d’innovation réunionnais et positionner La Réunion comme un hub stratégique dans l’océan Indien.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"large\"} -->\n<div class=\"wp-block-columns large\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p>Le PUI Valiotech, soutenu par France 2030 grâce à l’ANR et BPI France, est l’unique PUI d’Outre-Mer. Il agit comme un levier pour maximiser l’impact des talents et des projets réunionnais, en répondant aux besoins économiques, sociaux et environnementaux du territoire.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"events full\"} -->\n<div class=\"wp-block-columns events full\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">évènements</mark> des acteurs du PUI</h2>\n<!-- /wp:heading -->\n\n<!-- wp:shortcode -->\n[events]\n<!-- /wp:shortcode -->\n\n<!-- wp:image {\"id\":25,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/image-1-1024x540.png\" alt=\"\" class=\"wp-image-25\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"axes full\"} -->\n<div class=\"wp-block-columns axes full\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"textAlign\":\"center\"} -->\n<h2 class=\"wp-block-heading has-text-align-center\">Les grands <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">axes</mark> de ce projet dynamique</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"className\":\"subtitle\"} -->\n<p class=\"has-text-align-center subtitle\">Le Pôle Universitaire d’Innovation Valiotech repose sur des missions claires et ambitieuses, qui sont au cœur de son action pour renforcer l’écosystème d’innovation à La Réunion.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:shortcode -->\n[axes]\n<!-- /wp:shortcode -->\n\n<!-- wp:paragraph {\"className\":\"highlight\"} -->\n<p class=\"highlight\">Ces missions s’articulent toutes autour d’une vision commune : faire de La Réunion un hub d’innovation dans l’océan Indien, en s’appuyant sur ses atouts uniques et ses acteurs engagés.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"partners full\"} -->\n<div class=\"wp-block-columns partners full\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"textAlign\":\"center\"} -->\n<h2 class=\"wp-block-heading has-text-align-center\">Nos <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">partenaires</mark> qui nous soutiennent</h2>\n<!-- /wp:heading -->\n\n<!-- wp:group {\"className\":\"partners-list\",\"layout\":{\"type\":\"grid\",\"minimumColumnWidth\":\"160px\"}} -->\n<div class=\"wp-block-group partners-list\"><!-- wp:image {\"id\":97,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Logo-2.png\" alt=\"\" class=\"wp-image-97\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":97,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Logo-2.png\" alt=\"\" class=\"wp-image-97\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":97,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Logo-2.png\" alt=\"\" class=\"wp-image-97\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":97,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Logo-2.png\" alt=\"\" class=\"wp-image-97\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":97,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Logo-2.png\" alt=\"\" class=\"wp-image-97\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":97,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Logo-2.png\" alt=\"\" class=\"wp-image-97\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":97,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Logo-2.png\" alt=\"\" class=\"wp-image-97\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":97,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Logo-2.png\" alt=\"\" class=\"wp-image-97\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":97,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Logo-2.png\" alt=\"\" class=\"wp-image-97\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":97,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Logo-2.png\" alt=\"\" class=\"wp-image-97\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"newsletter\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group newsletter\"><!-- wp:heading {\"textAlign\":\"center\"} -->\n<h2 class=\"wp-block-heading has-text-align-center\">Recevoir notre <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">newsletter</mark></h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"className\":\"subtitle\"} -->\n<p class=\"has-text-align-center subtitle\">Bientôt, vous pourrez vous inscrire à notre newsletter juste ici !</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->", "Accueil", "", "publish", "closed", "closed", "", "accueil", "", "", "2024-11-22 15:21:36", "2024-11-22 11:21:36", "", "0", "http://pui-valiotech.local/?page_id=2", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("3", "1", "2024-11-20 07:20:44", "2024-11-20 07:20:44", "<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Who we are</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>Our website address is: http://pui-valiotech.local.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Comments</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>When visitors leave comments on the site we collect the data shown in the comments form, and also the visitor&#8217;s IP address and browser user agent string to help spam detection.</p>\n<!-- /wp:paragraph -->\n<!-- wp:paragraph -->\n<p>An anonymized string created from your email address (also called a hash) may be provided to the Gravatar service to see if you are using it. The Gravatar service privacy policy is available here: https://automattic.com/privacy/. After approval of your comment, your profile picture is visible to the public in the context of your comment.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Media</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>If you upload images to the website, you should avoid uploading images with embedded location data (EXIF GPS) included. Visitors to the website can download and extract any location data from images on the website.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Cookies</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>If you leave a comment on our site you may opt-in to saving your name, email address and website in cookies. These are for your convenience so that you do not have to fill in your details again when you leave another comment. These cookies will last for one year.</p>\n<!-- /wp:paragraph -->\n<!-- wp:paragraph -->\n<p>If you visit our login page, we will set a temporary cookie to determine if your browser accepts cookies. This cookie contains no personal data and is discarded when you close your browser.</p>\n<!-- /wp:paragraph -->\n<!-- wp:paragraph -->\n<p>When you log in, we will also set up several cookies to save your login information and your screen display choices. Login cookies last for two days, and screen options cookies last for a year. If you select &quot;Remember Me&quot;, your login will persist for two weeks. If you log out of your account, the login cookies will be removed.</p>\n<!-- /wp:paragraph -->\n<!-- wp:paragraph -->\n<p>If you edit or publish an article, an additional cookie will be saved in your browser. This cookie includes no personal data and simply indicates the post ID of the article you just edited. It expires after 1 day.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Embedded content from other websites</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>Articles on this site may include embedded content (e.g. videos, images, articles, etc.). Embedded content from other websites behaves in the exact same way as if the visitor has visited the other website.</p>\n<!-- /wp:paragraph -->\n<!-- wp:paragraph -->\n<p>These websites may collect data about you, use cookies, embed additional third-party tracking, and monitor your interaction with that embedded content, including tracking your interaction with the embedded content if you have an account and are logged in to that website.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Who we share your data with</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>If you request a password reset, your IP address will be included in the reset email.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">How long we retain your data</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>If you leave a comment, the comment and its metadata are retained indefinitely. This is so we can recognize and approve any follow-up comments automatically instead of holding them in a moderation queue.</p>\n<!-- /wp:paragraph -->\n<!-- wp:paragraph -->\n<p>For users that register on our website (if any), we also store the personal information they provide in their user profile. All users can see, edit, or delete their personal information at any time (except they cannot change their username). Website administrators can also see and edit that information.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">What rights you have over your data</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>If you have an account on this site, or have left comments, you can request to receive an exported file of the personal data we hold about you, including any data you have provided to us. You can also request that we erase any personal data we hold about you. This does not include any data we are obliged to keep for administrative, legal, or security purposes.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Where your data is sent</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>Visitor comments may be checked through an automated spam detection service.</p>\n<!-- /wp:paragraph -->\n", "Privacy Policy", "", "draft", "closed", "open", "", "privacy-policy", "", "", "2024-11-20 07:20:44", "2024-11-20 07:20:44", "", "0", "http://pui-valiotech.local/?page_id=3", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("4", "0", "2024-11-20 07:21:07", "2024-11-20 07:21:07", "<!-- wp:page-list /-->", "Navigation", "", "publish", "closed", "closed", "", "navigation", "", "", "2024-11-20 07:21:07", "2024-11-20 07:21:07", "", "0", "http://pui-valiotech.local/navigation/", "0", "wp_navigation", "", "0");
INSERT INTO `wp_posts` VALUES("5", "1", "2024-11-20 07:21:50", "0000-00-00 00:00:00", "", "Auto Draft", "", "auto-draft", "open", "open", "", "", "", "", "2024-11-20 07:21:50", "0000-00-00 00:00:00", "", "0", "http://pui-valiotech.local/?p=5", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("7", "1", "2024-11-20 12:01:30", "2024-11-20 08:01:30", "{\n    \"show_on_front\": {\n        \"value\": \"page\",\n        \"type\": \"option\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2024-11-20 08:01:30\"\n    },\n    \"page_on_front\": {\n        \"value\": \"2\",\n        \"type\": \"option\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2024-11-20 08:01:30\"\n    }\n}", "", "", "trash", "closed", "closed", "", "bb766c68-79ff-427a-8989-d567dc48ad8e", "", "", "2024-11-20 12:01:30", "2024-11-20 08:01:30", "", "0", "http://pui-valiotech.local/bb766c68-79ff-427a-8989-d567dc48ad8e/", "0", "customize_changeset", "", "0");
INSERT INTO `wp_posts` VALUES("8", "1", "2024-11-20 12:12:44", "0000-00-00 00:00:00", "", "Brouillon auto", "", "auto-draft", "closed", "closed", "", "", "", "", "2024-11-20 12:12:44", "0000-00-00 00:00:00", "", "0", "http://pui-valiotech.local/?post_type=partner&p=8", "0", "partner", "", "0");
INSERT INTO `wp_posts` VALUES("9", "1", "2024-11-20 12:15:23", "0000-00-00 00:00:00", " ", "", "", "draft", "closed", "closed", "", "", "", "", "2024-11-20 12:15:23", "0000-00-00 00:00:00", "", "0", "http://pui-valiotech.local/?p=9", "1", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("10", "1", "2024-11-20 12:15:45", "0000-00-00 00:00:00", " ", "", "", "draft", "closed", "closed", "", "", "", "", "2024-11-20 12:15:45", "0000-00-00 00:00:00", "", "0", "http://pui-valiotech.local/?p=10", "1", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("11", "1", "2024-11-20 12:16:55", "0000-00-00 00:00:00", " ", "", "", "draft", "closed", "closed", "", "", "", "", "2024-11-20 12:16:55", "0000-00-00 00:00:00", "", "0", "http://pui-valiotech.local/?p=11", "1", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("12", "1", "2024-11-20 12:17:07", "0000-00-00 00:00:00", " ", "", "", "draft", "closed", "closed", "", "", "", "", "2024-11-20 12:17:07", "0000-00-00 00:00:00", "", "0", "http://pui-valiotech.local/?p=12", "1", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("13", "1", "2024-11-20 14:25:21", "2024-11-20 10:25:21", "<!-- wp:paragraph -->\n<p>This is an example page. It\'s different from a blog post because it will stay in one place and will show up in your site navigation (in most themes). Most people start with an About page that introduces them to potential site visitors. It might say something like this:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class=\"wp-block-quote\"><p>Hi there! I\'m a bike messenger by day, aspiring actor by night, and this is my website. I live in Los Angeles, have a great dog named Jack, and I like pi&#241;a coladas. (And gettin\' caught in the rain.)</p></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>...or something like this:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class=\"wp-block-quote\"><p>The XYZ Doohickey Company was founded in 1971, and has been providing quality doohickeys to the public ever since. Located in Gotham City, XYZ employs over 2,000 people and does all kinds of awesome things for the Gotham community.</p></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>As a new WordPress user, you should go to <a href=\"http://pui-valiotech.local/wp-admin/\">your dashboard</a> to delete this page and create new pages for your content. Have fun!</p>\n<!-- /wp:paragraph -->", "Accueil", "", "inherit", "closed", "closed", "", "2-revision-v1", "", "", "2024-11-20 14:25:21", "2024-11-20 10:25:21", "", "2", "http://pui-valiotech.local/?p=13", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("15", "1", "2024-11-20 14:30:25", "2024-11-20 10:30:25", "", "b532e4b30d1917574e9dbd8967d60662", "", "inherit", "open", "closed", "", "b532e4b30d1917574e9dbd8967d60662", "", "", "2024-11-20 14:30:25", "2024-11-20 10:30:25", "", "2", "http://pui-valiotech.local/wp-content/uploads/2024/11/b532e4b30d1917574e9dbd8967d60662.jpeg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("16", "1", "2024-11-20 14:30:39", "2024-11-20 10:30:39", "", "ef701919e992624c1600580947f786fd", "", "inherit", "open", "closed", "", "ef701919e992624c1600580947f786fd", "", "", "2024-11-20 14:30:39", "2024-11-20 10:30:39", "", "2", "http://pui-valiotech.local/wp-content/uploads/2024/11/ef701919e992624c1600580947f786fd.jpeg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("17", "1", "2024-11-20 14:30:48", "2024-11-20 10:30:48", "", "34ae07df518c66da70ea24c63c2e6f0c", "", "inherit", "open", "closed", "", "34ae07df518c66da70ea24c63c2e6f0c", "", "", "2024-11-20 14:30:48", "2024-11-20 10:30:48", "", "2", "http://pui-valiotech.local/wp-content/uploads/2024/11/34ae07df518c66da70ea24c63c2e6f0c.jpeg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("18", "1", "2024-11-20 14:30:50", "2024-11-20 10:30:50", "<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"66.66%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"><!-- wp:heading {\"level\":1} -->\n<h1 class=\"wp-block-heading\">Sensibiliser, connecter, innover</h1>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Avec le PUI Valiotech, nous avons l\'ambition de renforcer l\'innovation locale en créant des synergies entre l’enseignement supérieur, la recherche et le monde socio-économique, pour répondre ensemble aux défis du territoire.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Participer à un événement</a></div>\n<!-- /wp:button -->\n\n<!-- wp:button {\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link wp-element-button\">Nous rejoindre</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"33.33%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"><!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":15,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/b532e4b30d1917574e9dbd8967d60662.jpeg\" alt=\"\" class=\"wp-image-15\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":16,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/ef701919e992624c1600580947f786fd.jpeg\" alt=\"\" class=\"wp-image-16\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":17,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/34ae07df518c66da70ea24c63c2e6f0c.jpeg\" alt=\"\" class=\"wp-image-17\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->", "Accueil", "", "inherit", "closed", "closed", "", "2-revision-v1", "", "", "2024-11-20 14:30:50", "2024-11-20 10:30:50", "", "2", "http://pui-valiotech.local/?p=18", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("19", "1", "2024-11-20 14:38:53", "2024-11-20 10:38:53", "", "Impression", "", "inherit", "open", "closed", "", "impression", "", "", "2024-11-20 14:38:53", "2024-11-20 10:38:53", "", "2", "http://pui-valiotech.local/wp-content/uploads/2024/11/1264e6eb30c0ef78308d82d98aa8f086.jpeg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("20", "1", "2024-11-20 14:38:53", "2024-11-20 10:38:53", "", "724e2f98e73630980b049921e093e23a", "", "inherit", "open", "closed", "", "724e2f98e73630980b049921e093e23a", "", "", "2024-11-20 14:38:53", "2024-11-20 10:38:53", "", "2", "http://pui-valiotech.local/wp-content/uploads/2024/11/724e2f98e73630980b049921e093e23a.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("21", "1", "2024-11-20 14:38:54", "2024-11-20 10:38:54", "", "6306afbcf38f7060680d7b4089dfaabc", "", "inherit", "open", "closed", "", "6306afbcf38f7060680d7b4089dfaabc", "", "", "2024-11-20 14:38:54", "2024-11-20 10:38:54", "", "2", "http://pui-valiotech.local/wp-content/uploads/2024/11/6306afbcf38f7060680d7b4089dfaabc.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("22", "1", "2024-11-20 14:38:55", "2024-11-20 10:38:55", "", "e959eab8fb6cc935aa083d3451a0affc", "", "inherit", "open", "closed", "", "e959eab8fb6cc935aa083d3451a0affc", "", "", "2024-11-20 14:38:55", "2024-11-20 10:38:55", "", "2", "http://pui-valiotech.local/wp-content/uploads/2024/11/e959eab8fb6cc935aa083d3451a0affc.jpeg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("23", "1", "2024-11-20 14:47:05", "2024-11-20 10:47:05", "", "Icone", "", "inherit", "open", "closed", "", "icone", "", "", "2024-11-20 14:47:05", "2024-11-20 10:47:05", "", "2", "http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("24", "1", "2024-11-20 14:51:50", "2024-11-20 10:51:50", "", "image", "", "inherit", "open", "closed", "", "image", "", "", "2024-11-20 14:51:50", "2024-11-20 10:51:50", "", "2", "http://pui-valiotech.local/wp-content/uploads/2024/11/image.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("25", "1", "2024-11-20 15:04:48", "2024-11-20 11:04:48", "", "image", "", "inherit", "open", "closed", "", "image-2", "", "", "2024-11-20 15:04:48", "2024-11-20 11:04:48", "", "2", "http://pui-valiotech.local/wp-content/uploads/2024/11/image-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("26", "1", "2024-11-20 15:05:25", "2024-11-20 11:05:25", "<!-- wp:columns {\"isStackedOnMobile\":false,\"className\":\"hero\"} -->\n<div class=\"wp-block-columns is-not-stacked-on-mobile hero\"><!-- wp:column {\"width\":\"66.66%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"><!-- wp:heading {\"level\":1} -->\n<h1 class=\"wp-block-heading\">Sensibiliser, <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">connecter</mark>, innover</h1>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Avec le PUI Valiotech, nous avons l\'ambition de renforcer l\'innovation locale en créant des synergies entre l’enseignement supérieur, la recherche et le monde socio-économique, pour répondre ensemble aux défis du territoire.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"className\":\"buttons\"} -->\n<div class=\"wp-block-buttons buttons\"><!-- wp:button -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Participer à un événement</a></div>\n<!-- /wp:button -->\n\n<!-- wp:button {\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link wp-element-button\">Nous rejoindre</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"33.33%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"><!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":15,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/b532e4b30d1917574e9dbd8967d60662.jpeg\" alt=\"\" class=\"wp-image-15\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":16,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/ef701919e992624c1600580947f786fd.jpeg\" alt=\"\" class=\"wp-image-16\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":17,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/34ae07df518c66da70ea24c63c2e6f0c.jpeg\" alt=\"\" class=\"wp-image-17\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"introduction\"} -->\n<div class=\"wp-block-columns introduction\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:gallery {\"columns\":4,\"imageCrop\":false,\"linkTo\":\"none\",\"sizeSlug\":\"full\",\"className\":\"stakeholders\"} -->\n<figure class=\"wp-block-gallery has-nested-images columns-4 stakeholders\"><!-- wp:image {\"id\":20,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/724e2f98e73630980b049921e093e23a.png\" alt=\"\" class=\"wp-image-20\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":19,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/1264e6eb30c0ef78308d82d98aa8f086.jpeg\" alt=\"\" class=\"wp-image-19\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":21,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/6306afbcf38f7060680d7b4089dfaabc.png\" alt=\"\" class=\"wp-image-21\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":22,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/e959eab8fb6cc935aa083d3451a0affc.jpeg\" alt=\"\" class=\"wp-image-22\"/></figure>\n<!-- /wp:image --></figure>\n<!-- /wp:gallery -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3 class=\"wp-block-heading\">C’est quoi un Pôle Universitaire d’Innovation (PUI) ?</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Un PUI est un dispositif national créé pour rapprocher l’université, la recherche et les entreprises, afin de transformer la science et les idées en solutions concrètes. À travers des actions ciblées comme la formation, l’accompagnement des projets, et le transfert technologique, les PUIs accélèrent l’innovation et favorisent la création de start-ups.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"objectifs\"} -->\n<div class=\"wp-block-columns objectifs\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">objectifs</mark> de la démarche</h2>\n<!-- /wp:heading -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"layout\":{\"type\":\"grid\",\"minimumColumnWidth\":\"20rem\"}} -->\n<div class=\"wp-block-group\"><!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Sensibiliser et former les futurs entrepreneurs</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Des programmes de formations et événements sont mis en place pour permettre aux jeunes talents de développer leurs compétences et leur esprit entrepreneurial.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Créer des synergies entre les acteurs de l\'innovation</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Nous rassemblons chercheurs, entreprises, étudiants, entrepreneurs et structures d’accompagnement pour encourager la collaboration et l\'échange d\'idées.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Soutenir la croissance des start-ups</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Nous accompagnons les porteurs de projets à chaque étape, de la sensibilisation à la mise en œuvre de leurs activités.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Valoriser les sujets de recherche</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>En favorisant le transfert de technologies et d\'idées entre les laboratoires de recherche et le secteur privé, nous contribuons à l\'application concrète des innovations.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"stats\"} -->\n<div class=\"wp-block-columns stats\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Quelques <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">chiffres</mark> pour comprendre</h2>\n<!-- /wp:heading -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":24,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/image-1024x689.png\" alt=\"\" class=\"wp-image-24\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">4</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">membres fondateurs</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>l’Université de La Réunion, la Technopole, le CIRAD, et l’IRD, unis pour renforcer les synergies entre la recherche, l’enseignement supérieur et le monde socio-économique.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">22</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">unités de recherche</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>mobilisées pour valoriser les projets et renforcer les collaborations avec le monde socio-économique</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">4</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">axes stratégiques</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>pour transformer l’écosystème</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">500+</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">acteurs de l\'écosystème</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>(étudiants, chercheurs, entrepreneurs, entreprises) visés pour participer aux initiatives et synergies portées par le PUI.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">1er</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">PUI d\'Outre-mer</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>conçu pour dynamiser l’écosystème d’innovation réunionnais et positionner La Réunion comme un hub stratégique dans l’océan Indien.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p>Le PUI Valiotech, soutenu par France 2030 grâce à l’ANR et BPI France, est l’unique PUI d’Outre-Mer. Il agit comme un levier pour maximiser l’impact des talents et des projets réunionnais, en répondant aux besoins économiques, sociaux et environnementaux du territoire.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"events\"} -->\n<div class=\"wp-block-columns events\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">évènements</mark> des acteurs du PUI</h2>\n<!-- /wp:heading -->\n\n<!-- wp:query {\"queryId\":27,\"query\":{\"perPage\":10,\"pages\":0,\"offset\":0,\"postType\":\"event\",\"order\":\"desc\",\"orderBy\":\"date\",\"author\":\"\",\"search\":\"\",\"exclude\":[],\"sticky\":\"\",\"inherit\":false,\"parents\":[],\"format\":[]},\"className\":\"events-list\"} -->\n<div class=\"wp-block-query events-list\"><!-- wp:post-template {\"className\":\"event\"} -->\n<!-- wp:post-date /-->\n\n<!-- wp:post-title /-->\n\n<!-- wp:post-excerpt /-->\n<!-- /wp:post-template -->\n\n<!-- wp:query-no-results -->\n<!-- wp:paragraph {\"placeholder\":\"Ajouter un texte ou des blocs qui s’afficheront lorsqu’une requête ne renverra aucun résultat.\"} -->\n<p></p>\n<!-- /wp:paragraph -->\n<!-- /wp:query-no-results --></div>\n<!-- /wp:query -->\n\n<!-- wp:image {\"id\":25,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/image-1-1024x540.png\" alt=\"\" class=\"wp-image-25\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->", "Accueil", "", "inherit", "closed", "closed", "", "2-revision-v1", "", "", "2024-11-20 15:05:25", "2024-11-20 11:05:25", "", "2", "http://pui-valiotech.local/?p=26", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("27", "1", "2024-11-20 15:40:17", "2024-11-20 11:40:17", "<!-- wp:columns {\"isStackedOnMobile\":false,\"className\":\"hero large\"} -->\n<div class=\"wp-block-columns is-not-stacked-on-mobile hero large\"><!-- wp:column {\"width\":\"66.66%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"><!-- wp:heading {\"level\":1} -->\n<h1 class=\"wp-block-heading\">Sensibiliser, <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">connecter</mark>, innover</h1>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Avec le PUI Valiotech, nous avons l\'ambition de renforcer l\'innovation locale en créant des synergies entre l’enseignement supérieur, la recherche et le monde socio-économique, pour répondre ensemble aux défis du territoire.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"className\":\"buttons\"} -->\n<div class=\"wp-block-buttons buttons\"><!-- wp:button -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Participer à un événement</a></div>\n<!-- /wp:button -->\n\n<!-- wp:button {\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link wp-element-button\">Nous rejoindre</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"33.33%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"><!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":15,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/b532e4b30d1917574e9dbd8967d60662.jpeg\" alt=\"\" class=\"wp-image-15\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":16,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/ef701919e992624c1600580947f786fd.jpeg\" alt=\"\" class=\"wp-image-16\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":17,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/34ae07df518c66da70ea24c63c2e6f0c.jpeg\" alt=\"\" class=\"wp-image-17\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"introduction small\"} -->\n<div class=\"wp-block-columns introduction small\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:gallery {\"columns\":4,\"imageCrop\":false,\"linkTo\":\"none\",\"sizeSlug\":\"full\",\"className\":\"stakeholders\"} -->\n<figure class=\"wp-block-gallery has-nested-images columns-4 stakeholders\"><!-- wp:image {\"id\":20,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/724e2f98e73630980b049921e093e23a.png\" alt=\"\" class=\"wp-image-20\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":19,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/1264e6eb30c0ef78308d82d98aa8f086.jpeg\" alt=\"\" class=\"wp-image-19\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":21,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/6306afbcf38f7060680d7b4089dfaabc.png\" alt=\"\" class=\"wp-image-21\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":22,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/e959eab8fb6cc935aa083d3451a0affc.jpeg\" alt=\"\" class=\"wp-image-22\"/></figure>\n<!-- /wp:image --></figure>\n<!-- /wp:gallery -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3 class=\"wp-block-heading\">C’est quoi un Pôle Universitaire d’Innovation (PUI) ?</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Un PUI est un dispositif national créé pour rapprocher l’université, la recherche et les entreprises, afin de transformer la science et les idées en solutions concrètes. À travers des actions ciblées comme la formation, l’accompagnement des projets, et le transfert technologique, les PUIs accélèrent l’innovation et favorisent la création de start-ups.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"objectifs small\"} -->\n<div class=\"wp-block-columns objectifs small\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">objectifs</mark> de la démarche</h2>\n<!-- /wp:heading -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"layout\":{\"type\":\"grid\",\"minimumColumnWidth\":\"20rem\"}} -->\n<div class=\"wp-block-group\"><!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Sensibiliser et former les futurs entrepreneurs</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Des programmes de formations et événements sont mis en place pour permettre aux jeunes talents de développer leurs compétences et leur esprit entrepreneurial.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Créer des synergies entre les acteurs de l\'innovation</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Nous rassemblons chercheurs, entreprises, étudiants, entrepreneurs et structures d’accompagnement pour encourager la collaboration et l\'échange d\'idées.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Soutenir la croissance des start-ups</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Nous accompagnons les porteurs de projets à chaque étape, de la sensibilisation à la mise en œuvre de leurs activités.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Valoriser les sujets de recherche</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>En favorisant le transfert de technologies et d\'idées entre les laboratoires de recherche et le secteur privé, nous contribuons à l\'application concrète des innovations.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"stats large\"} -->\n<div class=\"wp-block-columns stats large\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Quelques <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">chiffres</mark> pour comprendre</h2>\n<!-- /wp:heading -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":24,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/image-1024x689.png\" alt=\"\" class=\"wp-image-24\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">4</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">membres fondateurs</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>l’Université de La Réunion, la Technopole, le CIRAD, et l’IRD, unis pour renforcer les synergies entre la recherche, l’enseignement supérieur et le monde socio-économique.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">22</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">unités de recherche</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>mobilisées pour valoriser les projets et renforcer les collaborations avec le monde socio-économique</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">4</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">axes stratégiques</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>pour transformer l’écosystème</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">500+</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">acteurs de l\'écosystème</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>(étudiants, chercheurs, entrepreneurs, entreprises) visés pour participer aux initiatives et synergies portées par le PUI.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">1er</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">PUI d\'Outre-mer</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>conçu pour dynamiser l’écosystème d’innovation réunionnais et positionner La Réunion comme un hub stratégique dans l’océan Indien.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p>Le PUI Valiotech, soutenu par France 2030 grâce à l’ANR et BPI France, est l’unique PUI d’Outre-Mer. Il agit comme un levier pour maximiser l’impact des talents et des projets réunionnais, en répondant aux besoins économiques, sociaux et environnementaux du territoire.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"events full\"} -->\n<div class=\"wp-block-columns events full\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">évènements</mark> des acteurs du PUI</h2>\n<!-- /wp:heading -->\n\n<!-- wp:query {\"queryId\":27,\"query\":{\"perPage\":10,\"pages\":0,\"offset\":0,\"postType\":\"event\",\"order\":\"desc\",\"orderBy\":\"date\",\"author\":\"\",\"search\":\"\",\"exclude\":[],\"sticky\":\"\",\"inherit\":false,\"parents\":[],\"format\":[]},\"className\":\"events-list\"} -->\n<div class=\"wp-block-query events-list\"><!-- wp:post-template {\"className\":\"event\"} -->\n<!-- wp:post-date /-->\n\n<!-- wp:post-title /-->\n\n<!-- wp:post-excerpt /-->\n<!-- /wp:post-template -->\n\n<!-- wp:query-no-results -->\n<!-- wp:paragraph {\"placeholder\":\"Ajouter un texte ou des blocs qui s’afficheront lorsqu’une requête ne renverra aucun résultat.\"} -->\n<p></p>\n<!-- /wp:paragraph -->\n<!-- /wp:query-no-results --></div>\n<!-- /wp:query -->\n\n<!-- wp:image {\"id\":25,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/image-1-1024x540.png\" alt=\"\" class=\"wp-image-25\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->", "Accueil", "", "inherit", "closed", "closed", "", "2-revision-v1", "", "", "2024-11-20 15:40:17", "2024-11-20 11:40:17", "", "2", "http://pui-valiotech.local/?p=27", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("28", "1", "2024-11-20 15:42:16", "2024-11-20 11:42:16", "<!-- wp:columns {\"className\":\"hero\"} -->\n<div class=\"wp-block-columns hero\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:columns {\"isStackedOnMobile\":false,\"className\":\"hero-content large\"} -->\n<div class=\"wp-block-columns is-not-stacked-on-mobile hero-content large\"><!-- wp:column {\"width\":\"66.66%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"><!-- wp:heading {\"level\":1} -->\n<h1 class=\"wp-block-heading\">Sensibiliser, <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">connecter</mark>, innover</h1>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Avec le PUI Valiotech, nous avons l\'ambition de renforcer l\'innovation locale en créant des synergies entre l’enseignement supérieur, la recherche et le monde socio-économique, pour répondre ensemble aux défis du territoire.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"className\":\"buttons\"} -->\n<div class=\"wp-block-buttons buttons\"><!-- wp:button -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Participer à un événement</a></div>\n<!-- /wp:button -->\n\n<!-- wp:button {\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link wp-element-button\">Nous rejoindre</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"33.33%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"><!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":15,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/b532e4b30d1917574e9dbd8967d60662.jpeg\" alt=\"\" class=\"wp-image-15\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":16,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/ef701919e992624c1600580947f786fd.jpeg\" alt=\"\" class=\"wp-image-16\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":17,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/34ae07df518c66da70ea24c63c2e6f0c.jpeg\" alt=\"\" class=\"wp-image-17\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"introduction small\"} -->\n<div class=\"wp-block-columns introduction small\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:gallery {\"columns\":4,\"imageCrop\":false,\"linkTo\":\"none\",\"sizeSlug\":\"full\",\"className\":\"stakeholders\"} -->\n<figure class=\"wp-block-gallery has-nested-images columns-4 stakeholders\"><!-- wp:image {\"id\":20,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/724e2f98e73630980b049921e093e23a.png\" alt=\"\" class=\"wp-image-20\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":19,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/1264e6eb30c0ef78308d82d98aa8f086.jpeg\" alt=\"\" class=\"wp-image-19\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":21,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/6306afbcf38f7060680d7b4089dfaabc.png\" alt=\"\" class=\"wp-image-21\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":22,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/e959eab8fb6cc935aa083d3451a0affc.jpeg\" alt=\"\" class=\"wp-image-22\"/></figure>\n<!-- /wp:image --></figure>\n<!-- /wp:gallery -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3 class=\"wp-block-heading\">C’est quoi un Pôle Universitaire d’Innovation (PUI) ?</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Un PUI est un dispositif national créé pour rapprocher l’université, la recherche et les entreprises, afin de transformer la science et les idées en solutions concrètes. À travers des actions ciblées comme la formation, l’accompagnement des projets, et le transfert technologique, les PUIs accélèrent l’innovation et favorisent la création de start-ups.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"objectifs small\"} -->\n<div class=\"wp-block-columns objectifs small\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">objectifs</mark> de la démarche</h2>\n<!-- /wp:heading -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"layout\":{\"type\":\"grid\",\"minimumColumnWidth\":\"20rem\"}} -->\n<div class=\"wp-block-group\"><!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Sensibiliser et former les futurs entrepreneurs</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Des programmes de formations et événements sont mis en place pour permettre aux jeunes talents de développer leurs compétences et leur esprit entrepreneurial.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Créer des synergies entre les acteurs de l\'innovation</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Nous rassemblons chercheurs, entreprises, étudiants, entrepreneurs et structures d’accompagnement pour encourager la collaboration et l\'échange d\'idées.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Soutenir la croissance des start-ups</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Nous accompagnons les porteurs de projets à chaque étape, de la sensibilisation à la mise en œuvre de leurs activités.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Valoriser les sujets de recherche</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>En favorisant le transfert de technologies et d\'idées entre les laboratoires de recherche et le secteur privé, nous contribuons à l\'application concrète des innovations.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"stats large\"} -->\n<div class=\"wp-block-columns stats large\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Quelques <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">chiffres</mark> pour comprendre</h2>\n<!-- /wp:heading -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":24,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/image-1024x689.png\" alt=\"\" class=\"wp-image-24\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">4</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">membres fondateurs</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>l’Université de La Réunion, la Technopole, le CIRAD, et l’IRD, unis pour renforcer les synergies entre la recherche, l’enseignement supérieur et le monde socio-économique.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">22</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">unités de recherche</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>mobilisées pour valoriser les projets et renforcer les collaborations avec le monde socio-économique</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">4</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">axes stratégiques</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>pour transformer l’écosystème</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">500+</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">acteurs de l\'écosystème</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>(étudiants, chercheurs, entrepreneurs, entreprises) visés pour participer aux initiatives et synergies portées par le PUI.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">1er</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">PUI d\'Outre-mer</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>conçu pour dynamiser l’écosystème d’innovation réunionnais et positionner La Réunion comme un hub stratégique dans l’océan Indien.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p>Le PUI Valiotech, soutenu par France 2030 grâce à l’ANR et BPI France, est l’unique PUI d’Outre-Mer. Il agit comme un levier pour maximiser l’impact des talents et des projets réunionnais, en répondant aux besoins économiques, sociaux et environnementaux du territoire.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"events full\"} -->\n<div class=\"wp-block-columns events full\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">évènements</mark> des acteurs du PUI</h2>\n<!-- /wp:heading -->\n\n<!-- wp:query {\"queryId\":27,\"query\":{\"perPage\":10,\"pages\":0,\"offset\":0,\"postType\":\"event\",\"order\":\"desc\",\"orderBy\":\"date\",\"author\":\"\",\"search\":\"\",\"exclude\":[],\"sticky\":\"\",\"inherit\":false,\"parents\":[],\"format\":[]},\"className\":\"events-list\"} -->\n<div class=\"wp-block-query events-list\"><!-- wp:post-template {\"className\":\"event\"} -->\n<!-- wp:post-date /-->\n\n<!-- wp:post-title /-->\n\n<!-- wp:post-excerpt /-->\n<!-- /wp:post-template -->\n\n<!-- wp:query-no-results -->\n<!-- wp:paragraph {\"placeholder\":\"Ajouter un texte ou des blocs qui s’afficheront lorsqu’une requête ne renverra aucun résultat.\"} -->\n<p></p>\n<!-- /wp:paragraph -->\n<!-- /wp:query-no-results --></div>\n<!-- /wp:query -->\n\n<!-- wp:image {\"id\":25,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/image-1-1024x540.png\" alt=\"\" class=\"wp-image-25\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->", "Accueil", "", "inherit", "closed", "closed", "", "2-revision-v1", "", "", "2024-11-20 15:42:16", "2024-11-20 11:42:16", "", "2", "http://pui-valiotech.local/?p=28", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("29", "1", "2024-11-20 21:29:08", "2024-11-20 17:29:08", "<!-- wp:columns {\"className\":\"hero\"} -->\n<div class=\"wp-block-columns hero\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:columns {\"isStackedOnMobile\":false,\"className\":\"hero-content large\"} -->\n<div class=\"wp-block-columns is-not-stacked-on-mobile hero-content large\"><!-- wp:column {\"width\":\"66.66%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"><!-- wp:heading {\"level\":1} -->\n<h1 class=\"wp-block-heading\">Sensibiliser, <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">connecter</mark>, innover</h1>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Avec le PUI Valiotech, nous avons l\'ambition de renforcer l\'innovation locale en créant des synergies entre l’enseignement supérieur, la recherche et le monde socio-économique, pour répondre ensemble aux défis du territoire.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"className\":\"buttons\"} -->\n<div class=\"wp-block-buttons buttons\"><!-- wp:button -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Participer à un événement</a></div>\n<!-- /wp:button -->\n\n<!-- wp:button {\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link wp-element-button\">Nous rejoindre</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"33.33%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"><!-- wp:columns {\"className\":\"hero-images\"} -->\n<div class=\"wp-block-columns hero-images\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":15,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/b532e4b30d1917574e9dbd8967d60662.jpeg\" alt=\"\" class=\"wp-image-15\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":16,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/ef701919e992624c1600580947f786fd.jpeg\" alt=\"\" class=\"wp-image-16\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":17,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/34ae07df518c66da70ea24c63c2e6f0c.jpeg\" alt=\"\" class=\"wp-image-17\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"introduction small\"} -->\n<div class=\"wp-block-columns introduction small\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:gallery {\"columns\":4,\"imageCrop\":false,\"linkTo\":\"none\",\"sizeSlug\":\"full\",\"className\":\"stakeholders\"} -->\n<figure class=\"wp-block-gallery has-nested-images columns-4 stakeholders\"><!-- wp:image {\"id\":20,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/724e2f98e73630980b049921e093e23a.png\" alt=\"\" class=\"wp-image-20\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":19,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/1264e6eb30c0ef78308d82d98aa8f086.jpeg\" alt=\"\" class=\"wp-image-19\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":21,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/6306afbcf38f7060680d7b4089dfaabc.png\" alt=\"\" class=\"wp-image-21\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":22,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/e959eab8fb6cc935aa083d3451a0affc.jpeg\" alt=\"\" class=\"wp-image-22\"/></figure>\n<!-- /wp:image --></figure>\n<!-- /wp:gallery -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3 class=\"wp-block-heading\">C’est quoi un Pôle Universitaire d’Innovation (PUI) ?</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Un PUI est un dispositif national créé pour rapprocher l’université, la recherche et les entreprises, afin de transformer la science et les idées en solutions concrètes. À travers des actions ciblées comme la formation, l’accompagnement des projets, et le transfert technologique, les PUIs accélèrent l’innovation et favorisent la création de start-ups.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"objectifs small\"} -->\n<div class=\"wp-block-columns objectifs small\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">objectifs</mark> de la démarche</h2>\n<!-- /wp:heading -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"layout\":{\"type\":\"grid\",\"minimumColumnWidth\":\"20rem\"}} -->\n<div class=\"wp-block-group\"><!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Sensibiliser et former les futurs entrepreneurs</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Des programmes de formations et événements sont mis en place pour permettre aux jeunes talents de développer leurs compétences et leur esprit entrepreneurial.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Créer des synergies entre les acteurs de l\'innovation</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Nous rassemblons chercheurs, entreprises, étudiants, entrepreneurs et structures d’accompagnement pour encourager la collaboration et l\'échange d\'idées.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Soutenir la croissance des start-ups</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Nous accompagnons les porteurs de projets à chaque étape, de la sensibilisation à la mise en œuvre de leurs activités.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Valoriser les sujets de recherche</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>En favorisant le transfert de technologies et d\'idées entre les laboratoires de recherche et le secteur privé, nous contribuons à l\'application concrète des innovations.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"stats large\"} -->\n<div class=\"wp-block-columns stats large\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Quelques <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">chiffres</mark> pour comprendre</h2>\n<!-- /wp:heading -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":24,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/image-1024x689.png\" alt=\"\" class=\"wp-image-24\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">4</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">membres fondateurs</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>l’Université de La Réunion, la Technopole, le CIRAD, et l’IRD, unis pour renforcer les synergies entre la recherche, l’enseignement supérieur et le monde socio-économique.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">22</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">unités de recherche</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>mobilisées pour valoriser les projets et renforcer les collaborations avec le monde socio-économique</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">4</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">axes stratégiques</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>pour transformer l’écosystème</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">500+</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">acteurs de l\'écosystème</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>(étudiants, chercheurs, entrepreneurs, entreprises) visés pour participer aux initiatives et synergies portées par le PUI.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">1er</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">PUI d\'Outre-mer</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>conçu pour dynamiser l’écosystème d’innovation réunionnais et positionner La Réunion comme un hub stratégique dans l’océan Indien.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p>Le PUI Valiotech, soutenu par France 2030 grâce à l’ANR et BPI France, est l’unique PUI d’Outre-Mer. Il agit comme un levier pour maximiser l’impact des talents et des projets réunionnais, en répondant aux besoins économiques, sociaux et environnementaux du territoire.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"events full\"} -->\n<div class=\"wp-block-columns events full\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">évènements</mark> des acteurs du PUI</h2>\n<!-- /wp:heading -->\n\n<!-- wp:query {\"queryId\":27,\"query\":{\"perPage\":10,\"pages\":0,\"offset\":0,\"postType\":\"event\",\"order\":\"desc\",\"orderBy\":\"date\",\"author\":\"\",\"search\":\"\",\"exclude\":[],\"sticky\":\"\",\"inherit\":false,\"parents\":[],\"format\":[]},\"className\":\"events-list\"} -->\n<div class=\"wp-block-query events-list\"><!-- wp:post-template {\"className\":\"event\"} -->\n<!-- wp:post-date /-->\n\n<!-- wp:post-title /-->\n\n<!-- wp:post-excerpt /-->\n<!-- /wp:post-template -->\n\n<!-- wp:query-no-results -->\n<!-- wp:paragraph {\"placeholder\":\"Ajouter un texte ou des blocs qui s’afficheront lorsqu’une requête ne renverra aucun résultat.\"} -->\n<p></p>\n<!-- /wp:paragraph -->\n<!-- /wp:query-no-results --></div>\n<!-- /wp:query -->\n\n<!-- wp:image {\"id\":25,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/image-1-1024x540.png\" alt=\"\" class=\"wp-image-25\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->", "Accueil", "", "inherit", "closed", "closed", "", "2-revision-v1", "", "", "2024-11-20 21:29:08", "2024-11-20 17:29:08", "", "2", "http://pui-valiotech.local/?p=29", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("30", "1", "2024-11-20 21:32:38", "2024-11-20 17:32:38", "<!-- wp:columns {\"className\":\"hero\"} -->\n<div class=\"wp-block-columns hero\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:columns {\"isStackedOnMobile\":false,\"className\":\"hero-content large\"} -->\n<div class=\"wp-block-columns is-not-stacked-on-mobile hero-content large\"><!-- wp:column {\"width\":\"66.66%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"><!-- wp:heading {\"level\":1} -->\n<h1 class=\"wp-block-heading\">Sensibiliser, <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">connecter</mark>, innover</h1>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Avec le PUI Valiotech, nous avons l\'ambition de renforcer l\'innovation locale en créant des synergies entre l’enseignement supérieur, la recherche et le monde socio-économique, pour répondre ensemble aux défis du territoire.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"className\":\"buttons\"} -->\n<div class=\"wp-block-buttons buttons\"><!-- wp:button -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Participer à un événement</a></div>\n<!-- /wp:button -->\n\n<!-- wp:button {\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link wp-element-button\">Nous rejoindre</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"33.33%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"><!-- wp:columns {\"className\":\"hero-images\"} -->\n<div class=\"wp-block-columns hero-images\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":15,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"square\"} -->\n<figure class=\"wp-block-image size-full square\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/b532e4b30d1917574e9dbd8967d60662.jpeg\" alt=\"\" class=\"wp-image-15\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":16,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"vertical\"} -->\n<figure class=\"wp-block-image size-full vertical\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/ef701919e992624c1600580947f786fd.jpeg\" alt=\"\" class=\"wp-image-16\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":17,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"vertical\"} -->\n<figure class=\"wp-block-image size-full vertical\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/34ae07df518c66da70ea24c63c2e6f0c.jpeg\" alt=\"\" class=\"wp-image-17\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"introduction small\"} -->\n<div class=\"wp-block-columns introduction small\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:gallery {\"columns\":4,\"imageCrop\":false,\"linkTo\":\"none\",\"sizeSlug\":\"full\",\"className\":\"stakeholders\"} -->\n<figure class=\"wp-block-gallery has-nested-images columns-4 stakeholders\"><!-- wp:image {\"id\":20,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/724e2f98e73630980b049921e093e23a.png\" alt=\"\" class=\"wp-image-20\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":19,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/1264e6eb30c0ef78308d82d98aa8f086.jpeg\" alt=\"\" class=\"wp-image-19\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":21,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/6306afbcf38f7060680d7b4089dfaabc.png\" alt=\"\" class=\"wp-image-21\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":22,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/e959eab8fb6cc935aa083d3451a0affc.jpeg\" alt=\"\" class=\"wp-image-22\"/></figure>\n<!-- /wp:image --></figure>\n<!-- /wp:gallery -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3 class=\"wp-block-heading\">C’est quoi un Pôle Universitaire d’Innovation (PUI) ?</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Un PUI est un dispositif national créé pour rapprocher l’université, la recherche et les entreprises, afin de transformer la science et les idées en solutions concrètes. À travers des actions ciblées comme la formation, l’accompagnement des projets, et le transfert technologique, les PUIs accélèrent l’innovation et favorisent la création de start-ups.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"objectifs small\"} -->\n<div class=\"wp-block-columns objectifs small\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">objectifs</mark> de la démarche</h2>\n<!-- /wp:heading -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"layout\":{\"type\":\"grid\",\"minimumColumnWidth\":\"20rem\"}} -->\n<div class=\"wp-block-group\"><!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Sensibiliser et former les futurs entrepreneurs</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Des programmes de formations et événements sont mis en place pour permettre aux jeunes talents de développer leurs compétences et leur esprit entrepreneurial.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Créer des synergies entre les acteurs de l\'innovation</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Nous rassemblons chercheurs, entreprises, étudiants, entrepreneurs et structures d’accompagnement pour encourager la collaboration et l\'échange d\'idées.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Soutenir la croissance des start-ups</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Nous accompagnons les porteurs de projets à chaque étape, de la sensibilisation à la mise en œuvre de leurs activités.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Valoriser les sujets de recherche</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>En favorisant le transfert de technologies et d\'idées entre les laboratoires de recherche et le secteur privé, nous contribuons à l\'application concrète des innovations.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"stats large\"} -->\n<div class=\"wp-block-columns stats large\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Quelques <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">chiffres</mark> pour comprendre</h2>\n<!-- /wp:heading -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":24,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/image-1024x689.png\" alt=\"\" class=\"wp-image-24\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">4</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">membres fondateurs</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>l’Université de La Réunion, la Technopole, le CIRAD, et l’IRD, unis pour renforcer les synergies entre la recherche, l’enseignement supérieur et le monde socio-économique.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">22</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">unités de recherche</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>mobilisées pour valoriser les projets et renforcer les collaborations avec le monde socio-économique</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">4</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">axes stratégiques</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>pour transformer l’écosystème</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">500+</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">acteurs de l\'écosystème</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>(étudiants, chercheurs, entrepreneurs, entreprises) visés pour participer aux initiatives et synergies portées par le PUI.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">1er</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">PUI d\'Outre-mer</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>conçu pour dynamiser l’écosystème d’innovation réunionnais et positionner La Réunion comme un hub stratégique dans l’océan Indien.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p>Le PUI Valiotech, soutenu par France 2030 grâce à l’ANR et BPI France, est l’unique PUI d’Outre-Mer. Il agit comme un levier pour maximiser l’impact des talents et des projets réunionnais, en répondant aux besoins économiques, sociaux et environnementaux du territoire.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"events full\"} -->\n<div class=\"wp-block-columns events full\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">évènements</mark> des acteurs du PUI</h2>\n<!-- /wp:heading -->\n\n<!-- wp:query {\"queryId\":27,\"query\":{\"perPage\":10,\"pages\":0,\"offset\":0,\"postType\":\"event\",\"order\":\"desc\",\"orderBy\":\"date\",\"author\":\"\",\"search\":\"\",\"exclude\":[],\"sticky\":\"\",\"inherit\":false,\"parents\":[],\"format\":[]},\"className\":\"events-list\"} -->\n<div class=\"wp-block-query events-list\"><!-- wp:post-template {\"className\":\"event\"} -->\n<!-- wp:post-date /-->\n\n<!-- wp:post-title /-->\n\n<!-- wp:post-excerpt /-->\n<!-- /wp:post-template -->\n\n<!-- wp:query-no-results -->\n<!-- wp:paragraph {\"placeholder\":\"Ajouter un texte ou des blocs qui s’afficheront lorsqu’une requête ne renverra aucun résultat.\"} -->\n<p></p>\n<!-- /wp:paragraph -->\n<!-- /wp:query-no-results --></div>\n<!-- /wp:query -->\n\n<!-- wp:image {\"id\":25,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/image-1-1024x540.png\" alt=\"\" class=\"wp-image-25\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->", "Accueil", "", "inherit", "closed", "closed", "", "2-revision-v1", "", "", "2024-11-20 21:32:38", "2024-11-20 17:32:38", "", "2", "http://pui-valiotech.local/?p=30", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("31", "1", "2024-11-20 21:46:18", "2024-11-20 17:46:18", "<!-- wp:columns {\"className\":\"hero\"} -->\n<div class=\"wp-block-columns hero\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:columns {\"isStackedOnMobile\":false,\"className\":\"hero-content large\"} -->\n<div class=\"wp-block-columns is-not-stacked-on-mobile hero-content large\"><!-- wp:column {\"width\":\"66.66%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"><!-- wp:heading {\"level\":1} -->\n<h1 class=\"wp-block-heading\">Sensibiliser, <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">connecter</mark>, innover</h1>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Avec le PUI Valiotech, nous avons l\'ambition de renforcer l\'innovation locale en créant des synergies entre l’enseignement supérieur, la recherche et le monde socio-économique, pour répondre ensemble aux défis du territoire.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"className\":\"buttons\"} -->\n<div class=\"wp-block-buttons buttons\"><!-- wp:button -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Participer à un événement</a></div>\n<!-- /wp:button -->\n\n<!-- wp:button {\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link wp-element-button\">Nous rejoindre</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"33.33%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"><!-- wp:columns {\"className\":\"hero-images\"} -->\n<div class=\"wp-block-columns hero-images\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":15,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"square\"} -->\n<figure class=\"wp-block-image size-full square\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/b532e4b30d1917574e9dbd8967d60662.jpeg\" alt=\"\" class=\"wp-image-15\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":16,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"vertical\"} -->\n<figure class=\"wp-block-image size-full vertical\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/ef701919e992624c1600580947f786fd.jpeg\" alt=\"\" class=\"wp-image-16\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":17,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"vertical\"} -->\n<figure class=\"wp-block-image size-full vertical\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/34ae07df518c66da70ea24c63c2e6f0c.jpeg\" alt=\"\" class=\"wp-image-17\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"introduction small\"} -->\n<div class=\"wp-block-columns introduction small\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:gallery {\"columns\":4,\"imageCrop\":false,\"linkTo\":\"none\",\"sizeSlug\":\"full\",\"className\":\"stakeholders\"} -->\n<figure class=\"wp-block-gallery has-nested-images columns-4 stakeholders\"><!-- wp:image {\"id\":22,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/e959eab8fb6cc935aa083d3451a0affc.jpeg\" alt=\"\" class=\"wp-image-22\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":20,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/724e2f98e73630980b049921e093e23a.png\" alt=\"\" class=\"wp-image-20\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":19,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/1264e6eb30c0ef78308d82d98aa8f086.jpeg\" alt=\"\" class=\"wp-image-19\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":21,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/6306afbcf38f7060680d7b4089dfaabc.png\" alt=\"\" class=\"wp-image-21\"/></figure>\n<!-- /wp:image --></figure>\n<!-- /wp:gallery -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3 class=\"wp-block-heading\">C’est quoi un Pôle Universitaire d’Innovation (PUI) ?</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Un PUI est un dispositif national créé pour rapprocher l’université, la recherche et les entreprises, afin de transformer la science et les idées en solutions concrètes. À travers des actions ciblées comme la formation, l’accompagnement des projets, et le transfert technologique, les PUIs accélèrent l’innovation et favorisent la création de start-ups.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"objectifs small\"} -->\n<div class=\"wp-block-columns objectifs small\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">objectifs</mark> de la démarche</h2>\n<!-- /wp:heading -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"layout\":{\"type\":\"grid\",\"minimumColumnWidth\":\"20rem\"}} -->\n<div class=\"wp-block-group\"><!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Sensibiliser et former les futurs entrepreneurs</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Des programmes de formations et événements sont mis en place pour permettre aux jeunes talents de développer leurs compétences et leur esprit entrepreneurial.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Créer des synergies entre les acteurs de l\'innovation</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Nous rassemblons chercheurs, entreprises, étudiants, entrepreneurs et structures d’accompagnement pour encourager la collaboration et l\'échange d\'idées.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Soutenir la croissance des start-ups</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Nous accompagnons les porteurs de projets à chaque étape, de la sensibilisation à la mise en œuvre de leurs activités.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Valoriser les sujets de recherche</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>En favorisant le transfert de technologies et d\'idées entre les laboratoires de recherche et le secteur privé, nous contribuons à l\'application concrète des innovations.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"stats large\"} -->\n<div class=\"wp-block-columns stats large\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Quelques <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">chiffres</mark> pour comprendre</h2>\n<!-- /wp:heading -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":24,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/image-1024x689.png\" alt=\"\" class=\"wp-image-24\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">4</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">membres fondateurs</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>l’Université de La Réunion, la Technopole, le CIRAD, et l’IRD, unis pour renforcer les synergies entre la recherche, l’enseignement supérieur et le monde socio-économique.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">22</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">unités de recherche</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>mobilisées pour valoriser les projets et renforcer les collaborations avec le monde socio-économique</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">4</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">axes stratégiques</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>pour transformer l’écosystème</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">500+</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">acteurs de l\'écosystème</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>(étudiants, chercheurs, entrepreneurs, entreprises) visés pour participer aux initiatives et synergies portées par le PUI.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">1er</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">PUI d\'Outre-mer</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>conçu pour dynamiser l’écosystème d’innovation réunionnais et positionner La Réunion comme un hub stratégique dans l’océan Indien.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p>Le PUI Valiotech, soutenu par France 2030 grâce à l’ANR et BPI France, est l’unique PUI d’Outre-Mer. Il agit comme un levier pour maximiser l’impact des talents et des projets réunionnais, en répondant aux besoins économiques, sociaux et environnementaux du territoire.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"events full\"} -->\n<div class=\"wp-block-columns events full\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">évènements</mark> des acteurs du PUI</h2>\n<!-- /wp:heading -->\n\n<!-- wp:query {\"queryId\":27,\"query\":{\"perPage\":10,\"pages\":0,\"offset\":0,\"postType\":\"event\",\"order\":\"desc\",\"orderBy\":\"date\",\"author\":\"\",\"search\":\"\",\"exclude\":[],\"sticky\":\"\",\"inherit\":false,\"parents\":[],\"format\":[]},\"className\":\"events-list\"} -->\n<div class=\"wp-block-query events-list\"><!-- wp:post-template {\"className\":\"event\"} -->\n<!-- wp:post-date /-->\n\n<!-- wp:post-title /-->\n\n<!-- wp:post-excerpt /-->\n<!-- /wp:post-template -->\n\n<!-- wp:query-no-results -->\n<!-- wp:paragraph {\"placeholder\":\"Ajouter un texte ou des blocs qui s’afficheront lorsqu’une requête ne renverra aucun résultat.\"} -->\n<p></p>\n<!-- /wp:paragraph -->\n<!-- /wp:query-no-results --></div>\n<!-- /wp:query -->\n\n<!-- wp:image {\"id\":25,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/image-1-1024x540.png\" alt=\"\" class=\"wp-image-25\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->", "Accueil", "", "inherit", "closed", "closed", "", "2-revision-v1", "", "", "2024-11-20 21:46:18", "2024-11-20 17:46:18", "", "2", "http://pui-valiotech.local/?p=31", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("32", "1", "2024-11-20 21:52:45", "2024-11-20 17:52:45", "<!-- wp:columns {\"className\":\"hero\"} -->\n<div class=\"wp-block-columns hero\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:columns {\"isStackedOnMobile\":false,\"className\":\"hero-content large\"} -->\n<div class=\"wp-block-columns is-not-stacked-on-mobile hero-content large\"><!-- wp:column {\"width\":\"66.66%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"><!-- wp:heading {\"level\":1} -->\n<h1 class=\"wp-block-heading\">Sensibiliser, <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">connecter</mark>, innover</h1>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Avec le PUI Valiotech, nous avons l\'ambition de renforcer l\'innovation locale en créant des synergies entre l’enseignement supérieur, la recherche et le monde socio-économique, pour répondre ensemble aux défis du territoire.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"className\":\"buttons\"} -->\n<div class=\"wp-block-buttons buttons\"><!-- wp:button -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Participer à un événement</a></div>\n<!-- /wp:button -->\n\n<!-- wp:button {\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link wp-element-button\">Nous rejoindre</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"33.33%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"><!-- wp:columns {\"className\":\"hero-images\"} -->\n<div class=\"wp-block-columns hero-images\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":15,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"square\"} -->\n<figure class=\"wp-block-image size-full square\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/b532e4b30d1917574e9dbd8967d60662.jpeg\" alt=\"\" class=\"wp-image-15\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":16,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"vertical\"} -->\n<figure class=\"wp-block-image size-full vertical\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/ef701919e992624c1600580947f786fd.jpeg\" alt=\"\" class=\"wp-image-16\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":17,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"vertical\"} -->\n<figure class=\"wp-block-image size-full vertical\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/34ae07df518c66da70ea24c63c2e6f0c.jpeg\" alt=\"\" class=\"wp-image-17\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"introduction small\"} -->\n<div class=\"wp-block-columns introduction small\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:gallery {\"columns\":4,\"imageCrop\":false,\"linkTo\":\"none\",\"sizeSlug\":\"full\",\"className\":\"stakeholders\"} -->\n<figure class=\"wp-block-gallery has-nested-images columns-4 stakeholders\"><!-- wp:image {\"id\":22,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/e959eab8fb6cc935aa083d3451a0affc.jpeg\" alt=\"\" class=\"wp-image-22\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":20,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/724e2f98e73630980b049921e093e23a.png\" alt=\"\" class=\"wp-image-20\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":19,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/1264e6eb30c0ef78308d82d98aa8f086.jpeg\" alt=\"\" class=\"wp-image-19\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":21,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/6306afbcf38f7060680d7b4089dfaabc.png\" alt=\"\" class=\"wp-image-21\"/></figure>\n<!-- /wp:image --></figure>\n<!-- /wp:gallery -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3 class=\"wp-block-heading\">C’est quoi un Pôle Universitaire d’Innovation (PUI) ?</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Un PUI est un dispositif national créé pour rapprocher l’université, la recherche et les entreprises, afin de transformer la science et les idées en solutions concrètes.<br>À travers des actions ciblées comme la formation, l’accompagnement des projets, et le transfert technologique, les PUIs accélèrent l’innovation et favorisent la création de start-ups.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"objectifs small\"} -->\n<div class=\"wp-block-columns objectifs small\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">objectifs</mark> de la démarche</h2>\n<!-- /wp:heading -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"layout\":{\"type\":\"grid\",\"minimumColumnWidth\":\"20rem\"}} -->\n<div class=\"wp-block-group\"><!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Sensibiliser et former les futurs entrepreneurs</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Des programmes de formations et événements sont mis en place pour permettre aux jeunes talents de développer leurs compétences et leur esprit entrepreneurial.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Créer des synergies entre les acteurs de l\'innovation</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Nous rassemblons chercheurs, entreprises, étudiants, entrepreneurs et structures d’accompagnement pour encourager la collaboration et l\'échange d\'idées.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Soutenir la croissance des start-ups</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Nous accompagnons les porteurs de projets à chaque étape, de la sensibilisation à la mise en œuvre de leurs activités.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Valoriser les sujets de recherche</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>En favorisant le transfert de technologies et d\'idées entre les laboratoires de recherche et le secteur privé, nous contribuons à l\'application concrète des innovations.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"stats large\"} -->\n<div class=\"wp-block-columns stats large\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Quelques <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">chiffres</mark> pour comprendre</h2>\n<!-- /wp:heading -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":24,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/image-1024x689.png\" alt=\"\" class=\"wp-image-24\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">4</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">membres fondateurs</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>l’Université de La Réunion, la Technopole, le CIRAD, et l’IRD, unis pour renforcer les synergies entre la recherche, l’enseignement supérieur et le monde socio-économique.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">22</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">unités de recherche</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>mobilisées pour valoriser les projets et renforcer les collaborations avec le monde socio-économique</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">4</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">axes stratégiques</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>pour transformer l’écosystème</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">500+</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">acteurs de l\'écosystème</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>(étudiants, chercheurs, entrepreneurs, entreprises) visés pour participer aux initiatives et synergies portées par le PUI.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">1er</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">PUI d\'Outre-mer</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>conçu pour dynamiser l’écosystème d’innovation réunionnais et positionner La Réunion comme un hub stratégique dans l’océan Indien.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p>Le PUI Valiotech, soutenu par France 2030 grâce à l’ANR et BPI France, est l’unique PUI d’Outre-Mer. Il agit comme un levier pour maximiser l’impact des talents et des projets réunionnais, en répondant aux besoins économiques, sociaux et environnementaux du territoire.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"events full\"} -->\n<div class=\"wp-block-columns events full\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">évènements</mark> des acteurs du PUI</h2>\n<!-- /wp:heading -->\n\n<!-- wp:query {\"queryId\":27,\"query\":{\"perPage\":10,\"pages\":0,\"offset\":0,\"postType\":\"event\",\"order\":\"desc\",\"orderBy\":\"date\",\"author\":\"\",\"search\":\"\",\"exclude\":[],\"sticky\":\"\",\"inherit\":false,\"parents\":[],\"format\":[]},\"className\":\"events-list\"} -->\n<div class=\"wp-block-query events-list\"><!-- wp:post-template {\"className\":\"event\"} -->\n<!-- wp:post-date /-->\n\n<!-- wp:post-title /-->\n\n<!-- wp:post-excerpt /-->\n<!-- /wp:post-template -->\n\n<!-- wp:query-no-results -->\n<!-- wp:paragraph {\"placeholder\":\"Ajouter un texte ou des blocs qui s’afficheront lorsqu’une requête ne renverra aucun résultat.\"} -->\n<p></p>\n<!-- /wp:paragraph -->\n<!-- /wp:query-no-results --></div>\n<!-- /wp:query -->\n\n<!-- wp:image {\"id\":25,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/image-1-1024x540.png\" alt=\"\" class=\"wp-image-25\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->", "Accueil", "", "inherit", "closed", "closed", "", "2-revision-v1", "", "", "2024-11-20 21:52:45", "2024-11-20 17:52:45", "", "2", "http://pui-valiotech.local/?p=32", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("33", "1", "2024-11-20 21:57:52", "2024-11-20 17:57:52", "<!-- wp:columns {\"className\":\"hero\"} -->\n<div class=\"wp-block-columns hero\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:columns {\"isStackedOnMobile\":false,\"className\":\"hero-content large\"} -->\n<div class=\"wp-block-columns is-not-stacked-on-mobile hero-content large\"><!-- wp:column {\"width\":\"66.66%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"><!-- wp:heading {\"level\":1} -->\n<h1 class=\"wp-block-heading\">Sensibiliser, <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">connecter</mark>, innover</h1>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Avec le PUI Valiotech, nous avons l\'ambition de renforcer l\'innovation locale en créant des synergies entre l’enseignement supérieur, la recherche et le monde socio-économique, pour répondre ensemble aux défis du territoire.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"className\":\"buttons\"} -->\n<div class=\"wp-block-buttons buttons\"><!-- wp:button -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Participer à un événement</a></div>\n<!-- /wp:button -->\n\n<!-- wp:button {\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link wp-element-button\">Nous rejoindre</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"33.33%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"><!-- wp:columns {\"className\":\"hero-images\"} -->\n<div class=\"wp-block-columns hero-images\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":15,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"square\"} -->\n<figure class=\"wp-block-image size-full square\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/b532e4b30d1917574e9dbd8967d60662.jpeg\" alt=\"\" class=\"wp-image-15\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":16,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"vertical\"} -->\n<figure class=\"wp-block-image size-full vertical\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/ef701919e992624c1600580947f786fd.jpeg\" alt=\"\" class=\"wp-image-16\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":17,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"vertical\"} -->\n<figure class=\"wp-block-image size-full vertical\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/34ae07df518c66da70ea24c63c2e6f0c.jpeg\" alt=\"\" class=\"wp-image-17\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"introduction small\"} -->\n<div class=\"wp-block-columns introduction small\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:gallery {\"columns\":4,\"imageCrop\":false,\"linkTo\":\"none\",\"sizeSlug\":\"full\",\"className\":\"stakeholders\"} -->\n<figure class=\"wp-block-gallery has-nested-images columns-4 stakeholders\"><!-- wp:image {\"id\":22,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/e959eab8fb6cc935aa083d3451a0affc.jpeg\" alt=\"\" class=\"wp-image-22\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":20,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/724e2f98e73630980b049921e093e23a.png\" alt=\"\" class=\"wp-image-20\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":19,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/1264e6eb30c0ef78308d82d98aa8f086.jpeg\" alt=\"\" class=\"wp-image-19\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":21,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/6306afbcf38f7060680d7b4089dfaabc.png\" alt=\"\" class=\"wp-image-21\"/></figure>\n<!-- /wp:image --></figure>\n<!-- /wp:gallery -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3 class=\"wp-block-heading\">C’est quoi un Pôle Universitaire d’Innovation (PUI) ?</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Un PUI est un dispositif national créé pour rapprocher l’université, la recherche et les entreprises, afin de transformer la science et les idées en solutions concrètes.<br>À travers des actions ciblées comme la formation, l’accompagnement des projets, et le transfert technologique, les PUIs accélèrent l’innovation et favorisent la création de start-ups.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"objectifs small\"} -->\n<div class=\"wp-block-columns objectifs small\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">objectifs</mark> de la démarche</h2>\n<!-- /wp:heading -->\n\n<!-- wp:group {\"className\":\"objectifs-liste\",\"layout\":{\"type\":\"grid\",\"minimumColumnWidth\":\"20rem\"}} -->\n<div class=\"wp-block-group objectifs-liste\"><!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Sensibiliser et former les futurs entrepreneurs</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Des programmes de formations et événements sont mis en place pour permettre aux jeunes talents de développer leurs compétences et leur esprit entrepreneurial.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Créer des synergies entre les acteurs de l\'innovation</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Nous rassemblons chercheurs, entreprises, étudiants, entrepreneurs et structures d’accompagnement pour encourager la collaboration et l\'échange d\'idées.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Soutenir la croissance des start-ups</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Nous accompagnons les porteurs de projets à chaque étape, de la sensibilisation à la mise en œuvre de leurs activités.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Valoriser les sujets de recherche</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>En favorisant le transfert de technologies et d\'idées entre les laboratoires de recherche et le secteur privé, nous contribuons à l\'application concrète des innovations.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"stats large\"} -->\n<div class=\"wp-block-columns stats large\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Quelques <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">chiffres</mark> pour comprendre</h2>\n<!-- /wp:heading -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":24,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/image-1024x689.png\" alt=\"\" class=\"wp-image-24\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">4</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">membres fondateurs</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>l’Université de La Réunion, la Technopole, le CIRAD, et l’IRD, unis pour renforcer les synergies entre la recherche, l’enseignement supérieur et le monde socio-économique.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">22</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">unités de recherche</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>mobilisées pour valoriser les projets et renforcer les collaborations avec le monde socio-économique</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">4</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">axes stratégiques</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>pour transformer l’écosystème</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">500+</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">acteurs de l\'écosystème</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>(étudiants, chercheurs, entrepreneurs, entreprises) visés pour participer aux initiatives et synergies portées par le PUI.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">1er</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">PUI d\'Outre-mer</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>conçu pour dynamiser l’écosystème d’innovation réunionnais et positionner La Réunion comme un hub stratégique dans l’océan Indien.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p>Le PUI Valiotech, soutenu par France 2030 grâce à l’ANR et BPI France, est l’unique PUI d’Outre-Mer. Il agit comme un levier pour maximiser l’impact des talents et des projets réunionnais, en répondant aux besoins économiques, sociaux et environnementaux du territoire.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"events full\"} -->\n<div class=\"wp-block-columns events full\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">évènements</mark> des acteurs du PUI</h2>\n<!-- /wp:heading -->\n\n<!-- wp:query {\"queryId\":27,\"query\":{\"perPage\":10,\"pages\":0,\"offset\":0,\"postType\":\"event\",\"order\":\"desc\",\"orderBy\":\"date\",\"author\":\"\",\"search\":\"\",\"exclude\":[],\"sticky\":\"\",\"inherit\":false,\"parents\":[],\"format\":[]},\"className\":\"events-list\"} -->\n<div class=\"wp-block-query events-list\"><!-- wp:post-template {\"className\":\"event\"} -->\n<!-- wp:post-date /-->\n\n<!-- wp:post-title /-->\n\n<!-- wp:post-excerpt /-->\n<!-- /wp:post-template -->\n\n<!-- wp:query-no-results -->\n<!-- wp:paragraph {\"placeholder\":\"Ajouter un texte ou des blocs qui s’afficheront lorsqu’une requête ne renverra aucun résultat.\"} -->\n<p></p>\n<!-- /wp:paragraph -->\n<!-- /wp:query-no-results --></div>\n<!-- /wp:query -->\n\n<!-- wp:image {\"id\":25,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/image-1-1024x540.png\" alt=\"\" class=\"wp-image-25\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->", "Accueil", "", "inherit", "closed", "closed", "", "2-revision-v1", "", "", "2024-11-20 21:57:52", "2024-11-20 17:57:52", "", "2", "http://pui-valiotech.local/?p=33", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("34", "1", "2024-11-20 21:58:04", "2024-11-20 17:58:04", "<!-- wp:columns {\"className\":\"hero\"} -->\n<div class=\"wp-block-columns hero\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:columns {\"isStackedOnMobile\":false,\"className\":\"hero-content large\"} -->\n<div class=\"wp-block-columns is-not-stacked-on-mobile hero-content large\"><!-- wp:column {\"width\":\"66.66%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"><!-- wp:heading {\"level\":1} -->\n<h1 class=\"wp-block-heading\">Sensibiliser, <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">connecter</mark>, innover</h1>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Avec le PUI Valiotech, nous avons l\'ambition de renforcer l\'innovation locale en créant des synergies entre l’enseignement supérieur, la recherche et le monde socio-économique, pour répondre ensemble aux défis du territoire.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"className\":\"buttons\"} -->\n<div class=\"wp-block-buttons buttons\"><!-- wp:button -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Participer à un événement</a></div>\n<!-- /wp:button -->\n\n<!-- wp:button {\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link wp-element-button\">Nous rejoindre</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"33.33%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"><!-- wp:columns {\"className\":\"hero-images\"} -->\n<div class=\"wp-block-columns hero-images\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":15,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"square\"} -->\n<figure class=\"wp-block-image size-full square\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/b532e4b30d1917574e9dbd8967d60662.jpeg\" alt=\"\" class=\"wp-image-15\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":16,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"vertical\"} -->\n<figure class=\"wp-block-image size-full vertical\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/ef701919e992624c1600580947f786fd.jpeg\" alt=\"\" class=\"wp-image-16\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":17,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"vertical\"} -->\n<figure class=\"wp-block-image size-full vertical\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/34ae07df518c66da70ea24c63c2e6f0c.jpeg\" alt=\"\" class=\"wp-image-17\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"introduction small\"} -->\n<div class=\"wp-block-columns introduction small\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:gallery {\"columns\":4,\"imageCrop\":false,\"linkTo\":\"none\",\"sizeSlug\":\"full\",\"className\":\"stakeholders\"} -->\n<figure class=\"wp-block-gallery has-nested-images columns-4 stakeholders\"><!-- wp:image {\"id\":22,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/e959eab8fb6cc935aa083d3451a0affc.jpeg\" alt=\"\" class=\"wp-image-22\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":20,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/724e2f98e73630980b049921e093e23a.png\" alt=\"\" class=\"wp-image-20\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":19,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/1264e6eb30c0ef78308d82d98aa8f086.jpeg\" alt=\"\" class=\"wp-image-19\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":21,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/6306afbcf38f7060680d7b4089dfaabc.png\" alt=\"\" class=\"wp-image-21\"/></figure>\n<!-- /wp:image --></figure>\n<!-- /wp:gallery -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3 class=\"wp-block-heading\">C’est quoi un Pôle Universitaire d’Innovation (PUI) ?</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Un PUI est un dispositif national créé pour rapprocher l’université, la recherche et les entreprises, afin de transformer la science et les idées en solutions concrètes.<br>À travers des actions ciblées comme la formation, l’accompagnement des projets, et le transfert technologique, les PUIs accélèrent l’innovation et favorisent la création de start-ups.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"objectifs small\"} -->\n<div class=\"wp-block-columns objectifs small\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">objectifs</mark> de la démarche</h2>\n<!-- /wp:heading -->\n\n<!-- wp:group {\"className\":\"liste-objectifs\",\"layout\":{\"type\":\"grid\",\"minimumColumnWidth\":\"20rem\"}} -->\n<div class=\"wp-block-group liste-objectifs\"><!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Sensibiliser et former les futurs entrepreneurs</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Des programmes de formations et événements sont mis en place pour permettre aux jeunes talents de développer leurs compétences et leur esprit entrepreneurial.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Créer des synergies entre les acteurs de l\'innovation</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Nous rassemblons chercheurs, entreprises, étudiants, entrepreneurs et structures d’accompagnement pour encourager la collaboration et l\'échange d\'idées.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Soutenir la croissance des start-ups</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Nous accompagnons les porteurs de projets à chaque étape, de la sensibilisation à la mise en œuvre de leurs activités.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Valoriser les sujets de recherche</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>En favorisant le transfert de technologies et d\'idées entre les laboratoires de recherche et le secteur privé, nous contribuons à l\'application concrète des innovations.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"stats large\"} -->\n<div class=\"wp-block-columns stats large\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Quelques <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">chiffres</mark> pour comprendre</h2>\n<!-- /wp:heading -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":24,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/image-1024x689.png\" alt=\"\" class=\"wp-image-24\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">4</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">membres fondateurs</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>l’Université de La Réunion, la Technopole, le CIRAD, et l’IRD, unis pour renforcer les synergies entre la recherche, l’enseignement supérieur et le monde socio-économique.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">22</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">unités de recherche</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>mobilisées pour valoriser les projets et renforcer les collaborations avec le monde socio-économique</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">4</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">axes stratégiques</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>pour transformer l’écosystème</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">500+</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">acteurs de l\'écosystème</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>(étudiants, chercheurs, entrepreneurs, entreprises) visés pour participer aux initiatives et synergies portées par le PUI.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">1er</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">PUI d\'Outre-mer</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>conçu pour dynamiser l’écosystème d’innovation réunionnais et positionner La Réunion comme un hub stratégique dans l’océan Indien.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p>Le PUI Valiotech, soutenu par France 2030 grâce à l’ANR et BPI France, est l’unique PUI d’Outre-Mer. Il agit comme un levier pour maximiser l’impact des talents et des projets réunionnais, en répondant aux besoins économiques, sociaux et environnementaux du territoire.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"events full\"} -->\n<div class=\"wp-block-columns events full\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">évènements</mark> des acteurs du PUI</h2>\n<!-- /wp:heading -->\n\n<!-- wp:query {\"queryId\":27,\"query\":{\"perPage\":10,\"pages\":0,\"offset\":0,\"postType\":\"event\",\"order\":\"desc\",\"orderBy\":\"date\",\"author\":\"\",\"search\":\"\",\"exclude\":[],\"sticky\":\"\",\"inherit\":false,\"parents\":[],\"format\":[]},\"className\":\"events-list\"} -->\n<div class=\"wp-block-query events-list\"><!-- wp:post-template {\"className\":\"event\"} -->\n<!-- wp:post-date /-->\n\n<!-- wp:post-title /-->\n\n<!-- wp:post-excerpt /-->\n<!-- /wp:post-template -->\n\n<!-- wp:query-no-results -->\n<!-- wp:paragraph {\"placeholder\":\"Ajouter un texte ou des blocs qui s’afficheront lorsqu’une requête ne renverra aucun résultat.\"} -->\n<p></p>\n<!-- /wp:paragraph -->\n<!-- /wp:query-no-results --></div>\n<!-- /wp:query -->\n\n<!-- wp:image {\"id\":25,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/image-1-1024x540.png\" alt=\"\" class=\"wp-image-25\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->", "Accueil", "", "inherit", "closed", "closed", "", "2-revision-v1", "", "", "2024-11-20 21:58:04", "2024-11-20 17:58:04", "", "2", "http://pui-valiotech.local/?p=34", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("35", "1", "2024-11-21 10:32:20", "2024-11-21 06:32:20", "<!-- wp:columns {\"className\":\"hero\"} -->\n<div class=\"wp-block-columns hero\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:columns {\"isStackedOnMobile\":false,\"className\":\"hero-content large\"} -->\n<div class=\"wp-block-columns is-not-stacked-on-mobile hero-content large\"><!-- wp:column {\"width\":\"66.66%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"><!-- wp:heading {\"level\":1} -->\n<h1 class=\"wp-block-heading\">Sensibiliser, <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">connecter</mark>, innover</h1>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Avec le PUI Valiotech, nous avons l\'ambition de renforcer l\'innovation locale en créant des synergies entre l’enseignement supérieur, la recherche et le monde socio-économique, pour répondre ensemble aux défis du territoire.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"className\":\"buttons\"} -->\n<div class=\"wp-block-buttons buttons\"><!-- wp:button -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Participer à un événement</a></div>\n<!-- /wp:button -->\n\n<!-- wp:button {\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link wp-element-button\">Nous rejoindre</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"33.33%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"><!-- wp:columns {\"className\":\"hero-images\"} -->\n<div class=\"wp-block-columns hero-images\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":15,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"square\"} -->\n<figure class=\"wp-block-image size-full square\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/b532e4b30d1917574e9dbd8967d60662.jpeg\" alt=\"\" class=\"wp-image-15\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":16,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"vertical\"} -->\n<figure class=\"wp-block-image size-full vertical\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/ef701919e992624c1600580947f786fd.jpeg\" alt=\"\" class=\"wp-image-16\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":17,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"vertical\"} -->\n<figure class=\"wp-block-image size-full vertical\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/34ae07df518c66da70ea24c63c2e6f0c.jpeg\" alt=\"\" class=\"wp-image-17\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"introduction small\"} -->\n<div class=\"wp-block-columns introduction small\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:gallery {\"columns\":4,\"imageCrop\":false,\"linkTo\":\"none\",\"sizeSlug\":\"full\",\"className\":\"stakeholders\"} -->\n<figure class=\"wp-block-gallery has-nested-images columns-4 stakeholders\"><!-- wp:image {\"id\":22,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/e959eab8fb6cc935aa083d3451a0affc.jpeg\" alt=\"\" class=\"wp-image-22\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":20,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/724e2f98e73630980b049921e093e23a.png\" alt=\"\" class=\"wp-image-20\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":19,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/1264e6eb30c0ef78308d82d98aa8f086.jpeg\" alt=\"\" class=\"wp-image-19\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":21,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/6306afbcf38f7060680d7b4089dfaabc.png\" alt=\"\" class=\"wp-image-21\"/></figure>\n<!-- /wp:image --></figure>\n<!-- /wp:gallery -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3 class=\"wp-block-heading\">C’est quoi un Pôle Universitaire d’Innovation (PUI) ?</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Un PUI est un dispositif national créé pour rapprocher l’université, la recherche et les entreprises, afin de transformer la science et les idées en solutions concrètes.<br>À travers des actions ciblées comme la formation, l’accompagnement des projets, et le transfert technologique, les PUIs accélèrent l’innovation et favorisent la création de start-ups.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"objectifs small\"} -->\n<div class=\"wp-block-columns objectifs small\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">objectifs</mark> de la démarche</h2>\n<!-- /wp:heading -->\n\n<!-- wp:group {\"className\":\"liste-objectifs\",\"layout\":{\"type\":\"grid\",\"minimumColumnWidth\":\"20rem\"}} -->\n<div class=\"wp-block-group liste-objectifs\"><!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Sensibiliser et former les futurs entrepreneurs</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Des programmes de formations et événements sont mis en place pour permettre aux jeunes talents de développer leurs compétences et leur esprit entrepreneurial.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Créer des synergies entre les acteurs de l\'innovation</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Nous rassemblons chercheurs, entreprises, étudiants, entrepreneurs et structures d’accompagnement pour encourager la collaboration et l\'échange d\'idées.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Soutenir la croissance des start-ups</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Nous accompagnons les porteurs de projets à chaque étape, de la sensibilisation à la mise en œuvre de leurs activités.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Valoriser les sujets de recherche</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>En favorisant le transfert de technologies et d\'idées entre les laboratoires de recherche et le secteur privé, nous contribuons à l\'application concrète des innovations.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"stats large\"} -->\n<div class=\"wp-block-columns stats large\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Quelques <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">chiffres</mark> pour comprendre</h2>\n<!-- /wp:heading -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":24,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/image-1024x689.png\" alt=\"\" class=\"wp-image-24\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"326px\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:326px\"><!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">4</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">membres fondateurs</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>l’Université de La Réunion, la Technopole, le CIRAD, et l’IRD, unis pour renforcer les synergies entre la recherche, l’enseignement supérieur et le monde socio-économique.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">22</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">unités de recherche</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>mobilisées pour valoriser les projets et renforcer les collaborations avec le monde socio-économique</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">4</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">axes stratégiques</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>pour transformer l’écosystème</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">500+</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">acteurs de l\'écosystème</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>(étudiants, chercheurs, entrepreneurs, entreprises) visés pour participer aux initiatives et synergies portées par le PUI.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">1er</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">PUI d\'Outre-mer</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>conçu pour dynamiser l’écosystème d’innovation réunionnais et positionner La Réunion comme un hub stratégique dans l’océan Indien.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p>Le PUI Valiotech, soutenu par France 2030 grâce à l’ANR et BPI France, est l’unique PUI d’Outre-Mer. Il agit comme un levier pour maximiser l’impact des talents et des projets réunionnais, en répondant aux besoins économiques, sociaux et environnementaux du territoire.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"events full\"} -->\n<div class=\"wp-block-columns events full\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">évènements</mark> des acteurs du PUI</h2>\n<!-- /wp:heading -->\n\n<!-- wp:query {\"queryId\":27,\"query\":{\"perPage\":10,\"pages\":0,\"offset\":0,\"postType\":\"event\",\"order\":\"desc\",\"orderBy\":\"date\",\"author\":\"\",\"search\":\"\",\"exclude\":[],\"sticky\":\"\",\"inherit\":false,\"parents\":[],\"format\":[]},\"className\":\"events-list\"} -->\n<div class=\"wp-block-query events-list\"><!-- wp:post-template {\"className\":\"event\"} -->\n<!-- wp:post-date /-->\n\n<!-- wp:post-title /-->\n\n<!-- wp:post-excerpt /-->\n<!-- /wp:post-template -->\n\n<!-- wp:query-no-results -->\n<!-- wp:paragraph {\"placeholder\":\"Ajouter un texte ou des blocs qui s’afficheront lorsqu’une requête ne renverra aucun résultat.\"} -->\n<p></p>\n<!-- /wp:paragraph -->\n<!-- /wp:query-no-results --></div>\n<!-- /wp:query -->\n\n<!-- wp:image {\"id\":25,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/image-1-1024x540.png\" alt=\"\" class=\"wp-image-25\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->", "Accueil", "", "inherit", "closed", "closed", "", "2-revision-v1", "", "", "2024-11-21 10:32:20", "2024-11-21 06:32:20", "", "2", "http://pui-valiotech.local/?p=35", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("36", "1", "2024-11-21 10:32:57", "2024-11-21 06:32:57", "<!-- wp:columns {\"className\":\"hero\"} -->\n<div class=\"wp-block-columns hero\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:columns {\"isStackedOnMobile\":false,\"className\":\"hero-content large\"} -->\n<div class=\"wp-block-columns is-not-stacked-on-mobile hero-content large\"><!-- wp:column {\"width\":\"66.66%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"><!-- wp:heading {\"level\":1} -->\n<h1 class=\"wp-block-heading\">Sensibiliser, <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">connecter</mark>, innover</h1>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Avec le PUI Valiotech, nous avons l\'ambition de renforcer l\'innovation locale en créant des synergies entre l’enseignement supérieur, la recherche et le monde socio-économique, pour répondre ensemble aux défis du territoire.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"className\":\"buttons\"} -->\n<div class=\"wp-block-buttons buttons\"><!-- wp:button -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Participer à un événement</a></div>\n<!-- /wp:button -->\n\n<!-- wp:button {\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link wp-element-button\">Nous rejoindre</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"33.33%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"><!-- wp:columns {\"className\":\"hero-images\"} -->\n<div class=\"wp-block-columns hero-images\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":15,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"square\"} -->\n<figure class=\"wp-block-image size-full square\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/b532e4b30d1917574e9dbd8967d60662.jpeg\" alt=\"\" class=\"wp-image-15\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":16,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"vertical\"} -->\n<figure class=\"wp-block-image size-full vertical\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/ef701919e992624c1600580947f786fd.jpeg\" alt=\"\" class=\"wp-image-16\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":17,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"vertical\"} -->\n<figure class=\"wp-block-image size-full vertical\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/34ae07df518c66da70ea24c63c2e6f0c.jpeg\" alt=\"\" class=\"wp-image-17\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"introduction small\"} -->\n<div class=\"wp-block-columns introduction small\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:gallery {\"columns\":4,\"imageCrop\":false,\"linkTo\":\"none\",\"sizeSlug\":\"full\",\"className\":\"stakeholders\"} -->\n<figure class=\"wp-block-gallery has-nested-images columns-4 stakeholders\"><!-- wp:image {\"id\":22,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/e959eab8fb6cc935aa083d3451a0affc.jpeg\" alt=\"\" class=\"wp-image-22\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":20,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/724e2f98e73630980b049921e093e23a.png\" alt=\"\" class=\"wp-image-20\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":19,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/1264e6eb30c0ef78308d82d98aa8f086.jpeg\" alt=\"\" class=\"wp-image-19\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":21,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/6306afbcf38f7060680d7b4089dfaabc.png\" alt=\"\" class=\"wp-image-21\"/></figure>\n<!-- /wp:image --></figure>\n<!-- /wp:gallery -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3 class=\"wp-block-heading\">C’est quoi un Pôle Universitaire d’Innovation (PUI) ?</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Un PUI est un dispositif national créé pour rapprocher l’université, la recherche et les entreprises, afin de transformer la science et les idées en solutions concrètes.<br>À travers des actions ciblées comme la formation, l’accompagnement des projets, et le transfert technologique, les PUIs accélèrent l’innovation et favorisent la création de start-ups.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"objectifs small\"} -->\n<div class=\"wp-block-columns objectifs small\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">objectifs</mark> de la démarche</h2>\n<!-- /wp:heading -->\n\n<!-- wp:group {\"className\":\"liste-objectifs\",\"layout\":{\"type\":\"grid\",\"minimumColumnWidth\":\"20rem\"}} -->\n<div class=\"wp-block-group liste-objectifs\"><!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Sensibiliser et former les futurs entrepreneurs</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Des programmes de formations et événements sont mis en place pour permettre aux jeunes talents de développer leurs compétences et leur esprit entrepreneurial.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Créer des synergies entre les acteurs de l\'innovation</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Nous rassemblons chercheurs, entreprises, étudiants, entrepreneurs et structures d’accompagnement pour encourager la collaboration et l\'échange d\'idées.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Soutenir la croissance des start-ups</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Nous accompagnons les porteurs de projets à chaque étape, de la sensibilisation à la mise en œuvre de leurs activités.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Valoriser les sujets de recherche</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>En favorisant le transfert de technologies et d\'idées entre les laboratoires de recherche et le secteur privé, nous contribuons à l\'application concrète des innovations.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"stats large\"} -->\n<div class=\"wp-block-columns stats large\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Quelques <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">chiffres</mark> pour comprendre</h2>\n<!-- /wp:heading -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":24,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/image-1024x689.png\" alt=\"\" class=\"wp-image-24\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"326px\",\"className\":\"stats-chiffres\"} -->\n<div class=\"wp-block-column stats-chiffres\" style=\"flex-basis:326px\"><!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">4</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">membres fondateurs</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>l’Université de La Réunion, la Technopole, le CIRAD, et l’IRD, unis pour renforcer les synergies entre la recherche, l’enseignement supérieur et le monde socio-économique.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">22</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">unités de recherche</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>mobilisées pour valoriser les projets et renforcer les collaborations avec le monde socio-économique</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">4</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">axes stratégiques</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>pour transformer l’écosystème</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">500+</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">acteurs de l\'écosystème</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>(étudiants, chercheurs, entrepreneurs, entreprises) visés pour participer aux initiatives et synergies portées par le PUI.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">1er</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">PUI d\'Outre-mer</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>conçu pour dynamiser l’écosystème d’innovation réunionnais et positionner La Réunion comme un hub stratégique dans l’océan Indien.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p>Le PUI Valiotech, soutenu par France 2030 grâce à l’ANR et BPI France, est l’unique PUI d’Outre-Mer. Il agit comme un levier pour maximiser l’impact des talents et des projets réunionnais, en répondant aux besoins économiques, sociaux et environnementaux du territoire.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"events full\"} -->\n<div class=\"wp-block-columns events full\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">évènements</mark> des acteurs du PUI</h2>\n<!-- /wp:heading -->\n\n<!-- wp:query {\"queryId\":27,\"query\":{\"perPage\":10,\"pages\":0,\"offset\":0,\"postType\":\"event\",\"order\":\"desc\",\"orderBy\":\"date\",\"author\":\"\",\"search\":\"\",\"exclude\":[],\"sticky\":\"\",\"inherit\":false,\"parents\":[],\"format\":[]},\"className\":\"events-list\"} -->\n<div class=\"wp-block-query events-list\"><!-- wp:post-template {\"className\":\"event\"} -->\n<!-- wp:post-date /-->\n\n<!-- wp:post-title /-->\n\n<!-- wp:post-excerpt /-->\n<!-- /wp:post-template -->\n\n<!-- wp:query-no-results -->\n<!-- wp:paragraph {\"placeholder\":\"Ajouter un texte ou des blocs qui s’afficheront lorsqu’une requête ne renverra aucun résultat.\"} -->\n<p></p>\n<!-- /wp:paragraph -->\n<!-- /wp:query-no-results --></div>\n<!-- /wp:query -->\n\n<!-- wp:image {\"id\":25,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/image-1-1024x540.png\" alt=\"\" class=\"wp-image-25\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->", "Accueil", "", "inherit", "closed", "closed", "", "2-revision-v1", "", "", "2024-11-21 10:32:57", "2024-11-21 06:32:57", "", "2", "http://pui-valiotech.local/?p=36", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("37", "1", "2024-11-21 10:35:04", "2024-11-21 06:35:04", "<!-- wp:columns {\"className\":\"hero\"} -->\n<div class=\"wp-block-columns hero\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:columns {\"isStackedOnMobile\":false,\"className\":\"hero-content large\"} -->\n<div class=\"wp-block-columns is-not-stacked-on-mobile hero-content large\"><!-- wp:column {\"width\":\"66.66%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"><!-- wp:heading {\"level\":1} -->\n<h1 class=\"wp-block-heading\">Sensibiliser, <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">connecter</mark>, innover</h1>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Avec le PUI Valiotech, nous avons l\'ambition de renforcer l\'innovation locale en créant des synergies entre l’enseignement supérieur, la recherche et le monde socio-économique, pour répondre ensemble aux défis du territoire.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"className\":\"buttons\"} -->\n<div class=\"wp-block-buttons buttons\"><!-- wp:button -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Participer à un événement</a></div>\n<!-- /wp:button -->\n\n<!-- wp:button {\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link wp-element-button\">Nous rejoindre</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"33.33%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"><!-- wp:columns {\"className\":\"hero-images\"} -->\n<div class=\"wp-block-columns hero-images\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":15,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"square\"} -->\n<figure class=\"wp-block-image size-full square\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/b532e4b30d1917574e9dbd8967d60662.jpeg\" alt=\"\" class=\"wp-image-15\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":16,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"vertical\"} -->\n<figure class=\"wp-block-image size-full vertical\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/ef701919e992624c1600580947f786fd.jpeg\" alt=\"\" class=\"wp-image-16\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":17,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"vertical\"} -->\n<figure class=\"wp-block-image size-full vertical\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/34ae07df518c66da70ea24c63c2e6f0c.jpeg\" alt=\"\" class=\"wp-image-17\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"introduction small\"} -->\n<div class=\"wp-block-columns introduction small\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:gallery {\"columns\":4,\"imageCrop\":false,\"linkTo\":\"none\",\"sizeSlug\":\"full\",\"className\":\"stakeholders\"} -->\n<figure class=\"wp-block-gallery has-nested-images columns-4 stakeholders\"><!-- wp:image {\"id\":22,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/e959eab8fb6cc935aa083d3451a0affc.jpeg\" alt=\"\" class=\"wp-image-22\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":20,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/724e2f98e73630980b049921e093e23a.png\" alt=\"\" class=\"wp-image-20\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":19,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/1264e6eb30c0ef78308d82d98aa8f086.jpeg\" alt=\"\" class=\"wp-image-19\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":21,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/6306afbcf38f7060680d7b4089dfaabc.png\" alt=\"\" class=\"wp-image-21\"/></figure>\n<!-- /wp:image --></figure>\n<!-- /wp:gallery -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3 class=\"wp-block-heading\">C’est quoi un Pôle Universitaire d’Innovation (PUI) ?</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Un PUI est un dispositif national créé pour rapprocher l’université, la recherche et les entreprises, afin de transformer la science et les idées en solutions concrètes.<br>À travers des actions ciblées comme la formation, l’accompagnement des projets, et le transfert technologique, les PUIs accélèrent l’innovation et favorisent la création de start-ups.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"objectifs small\"} -->\n<div class=\"wp-block-columns objectifs small\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">objectifs</mark> de la démarche</h2>\n<!-- /wp:heading -->\n\n<!-- wp:group {\"className\":\"liste-objectifs\",\"layout\":{\"type\":\"grid\",\"minimumColumnWidth\":\"20rem\"}} -->\n<div class=\"wp-block-group liste-objectifs\"><!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Sensibiliser et former les futurs entrepreneurs</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Des programmes de formations et événements sont mis en place pour permettre aux jeunes talents de développer leurs compétences et leur esprit entrepreneurial.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Créer des synergies entre les acteurs de l\'innovation</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Nous rassemblons chercheurs, entreprises, étudiants, entrepreneurs et structures d’accompagnement pour encourager la collaboration et l\'échange d\'idées.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Soutenir la croissance des start-ups</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Nous accompagnons les porteurs de projets à chaque étape, de la sensibilisation à la mise en œuvre de leurs activités.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Valoriser les sujets de recherche</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>En favorisant le transfert de technologies et d\'idées entre les laboratoires de recherche et le secteur privé, nous contribuons à l\'application concrète des innovations.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"stats large\"} -->\n<div class=\"wp-block-columns stats large\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Quelques <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">chiffres</mark> pour comprendre</h2>\n<!-- /wp:heading -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"className\":\"stats-image\"} -->\n<div class=\"wp-block-column stats-image\"><!-- wp:image {\"id\":24,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/image-1024x689.png\" alt=\"\" class=\"wp-image-24\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"326px\",\"className\":\"stats-chiffres\"} -->\n<div class=\"wp-block-column stats-chiffres\" style=\"flex-basis:326px\"><!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">4</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">membres fondateurs</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>l’Université de La Réunion, la Technopole, le CIRAD, et l’IRD, unis pour renforcer les synergies entre la recherche, l’enseignement supérieur et le monde socio-économique.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">22</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">unités de recherche</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>mobilisées pour valoriser les projets et renforcer les collaborations avec le monde socio-économique</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">4</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">axes stratégiques</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>pour transformer l’écosystème</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">500+</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">acteurs de l\'écosystème</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>(étudiants, chercheurs, entrepreneurs, entreprises) visés pour participer aux initiatives et synergies portées par le PUI.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">1er</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">PUI d\'Outre-mer</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>conçu pour dynamiser l’écosystème d’innovation réunionnais et positionner La Réunion comme un hub stratégique dans l’océan Indien.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p>Le PUI Valiotech, soutenu par France 2030 grâce à l’ANR et BPI France, est l’unique PUI d’Outre-Mer. Il agit comme un levier pour maximiser l’impact des talents et des projets réunionnais, en répondant aux besoins économiques, sociaux et environnementaux du territoire.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"events full\"} -->\n<div class=\"wp-block-columns events full\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">évènements</mark> des acteurs du PUI</h2>\n<!-- /wp:heading -->\n\n<!-- wp:query {\"queryId\":27,\"query\":{\"perPage\":10,\"pages\":0,\"offset\":0,\"postType\":\"event\",\"order\":\"desc\",\"orderBy\":\"date\",\"author\":\"\",\"search\":\"\",\"exclude\":[],\"sticky\":\"\",\"inherit\":false,\"parents\":[],\"format\":[]},\"className\":\"events-list\"} -->\n<div class=\"wp-block-query events-list\"><!-- wp:post-template {\"className\":\"event\"} -->\n<!-- wp:post-date /-->\n\n<!-- wp:post-title /-->\n\n<!-- wp:post-excerpt /-->\n<!-- /wp:post-template -->\n\n<!-- wp:query-no-results -->\n<!-- wp:paragraph {\"placeholder\":\"Ajouter un texte ou des blocs qui s’afficheront lorsqu’une requête ne renverra aucun résultat.\"} -->\n<p></p>\n<!-- /wp:paragraph -->\n<!-- /wp:query-no-results --></div>\n<!-- /wp:query -->\n\n<!-- wp:image {\"id\":25,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/image-1-1024x540.png\" alt=\"\" class=\"wp-image-25\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->", "Accueil", "", "inherit", "closed", "closed", "", "2-revision-v1", "", "", "2024-11-21 10:35:04", "2024-11-21 06:35:04", "", "2", "http://pui-valiotech.local/?p=37", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("38", "1", "2024-11-21 10:36:54", "2024-11-21 06:36:54", "<!-- wp:columns {\"className\":\"hero\"} -->\n<div class=\"wp-block-columns hero\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:columns {\"isStackedOnMobile\":false,\"className\":\"hero-content large\"} -->\n<div class=\"wp-block-columns is-not-stacked-on-mobile hero-content large\"><!-- wp:column {\"width\":\"66.66%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"><!-- wp:heading {\"level\":1} -->\n<h1 class=\"wp-block-heading\">Sensibiliser, <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">connecter</mark>, innover</h1>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Avec le PUI Valiotech, nous avons l\'ambition de renforcer l\'innovation locale en créant des synergies entre l’enseignement supérieur, la recherche et le monde socio-économique, pour répondre ensemble aux défis du territoire.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"className\":\"buttons\"} -->\n<div class=\"wp-block-buttons buttons\"><!-- wp:button -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Participer à un événement</a></div>\n<!-- /wp:button -->\n\n<!-- wp:button {\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link wp-element-button\">Nous rejoindre</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"33.33%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"><!-- wp:columns {\"className\":\"hero-images\"} -->\n<div class=\"wp-block-columns hero-images\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":15,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"square\"} -->\n<figure class=\"wp-block-image size-full square\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/b532e4b30d1917574e9dbd8967d60662.jpeg\" alt=\"\" class=\"wp-image-15\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":16,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"vertical\"} -->\n<figure class=\"wp-block-image size-full vertical\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/ef701919e992624c1600580947f786fd.jpeg\" alt=\"\" class=\"wp-image-16\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":17,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"vertical\"} -->\n<figure class=\"wp-block-image size-full vertical\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/34ae07df518c66da70ea24c63c2e6f0c.jpeg\" alt=\"\" class=\"wp-image-17\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"introduction small\"} -->\n<div class=\"wp-block-columns introduction small\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:gallery {\"columns\":4,\"imageCrop\":false,\"linkTo\":\"none\",\"sizeSlug\":\"full\",\"className\":\"stakeholders\"} -->\n<figure class=\"wp-block-gallery has-nested-images columns-4 stakeholders\"><!-- wp:image {\"id\":22,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/e959eab8fb6cc935aa083d3451a0affc.jpeg\" alt=\"\" class=\"wp-image-22\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":20,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/724e2f98e73630980b049921e093e23a.png\" alt=\"\" class=\"wp-image-20\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":19,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/1264e6eb30c0ef78308d82d98aa8f086.jpeg\" alt=\"\" class=\"wp-image-19\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":21,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/6306afbcf38f7060680d7b4089dfaabc.png\" alt=\"\" class=\"wp-image-21\"/></figure>\n<!-- /wp:image --></figure>\n<!-- /wp:gallery -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3 class=\"wp-block-heading\">C’est quoi un Pôle Universitaire d’Innovation (PUI) ?</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Un PUI est un dispositif national créé pour rapprocher l’université, la recherche et les entreprises, afin de transformer la science et les idées en solutions concrètes.<br>À travers des actions ciblées comme la formation, l’accompagnement des projets, et le transfert technologique, les PUIs accélèrent l’innovation et favorisent la création de start-ups.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"objectifs small\"} -->\n<div class=\"wp-block-columns objectifs small\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">objectifs</mark> de la démarche</h2>\n<!-- /wp:heading -->\n\n<!-- wp:group {\"className\":\"liste-objectifs\",\"layout\":{\"type\":\"grid\",\"minimumColumnWidth\":\"20rem\"}} -->\n<div class=\"wp-block-group liste-objectifs\"><!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Sensibiliser et former les futurs entrepreneurs</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Des programmes de formations et événements sont mis en place pour permettre aux jeunes talents de développer leurs compétences et leur esprit entrepreneurial.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Créer des synergies entre les acteurs de l\'innovation</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Nous rassemblons chercheurs, entreprises, étudiants, entrepreneurs et structures d’accompagnement pour encourager la collaboration et l\'échange d\'idées.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Soutenir la croissance des start-ups</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Nous accompagnons les porteurs de projets à chaque étape, de la sensibilisation à la mise en œuvre de leurs activités.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Valoriser les sujets de recherche</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>En favorisant le transfert de technologies et d\'idées entre les laboratoires de recherche et le secteur privé, nous contribuons à l\'application concrète des innovations.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"stats large\"} -->\n<div class=\"wp-block-columns stats large\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Quelques <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">chiffres</mark> pour comprendre</h2>\n<!-- /wp:heading -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"className\":\"stats-image\"} -->\n<div class=\"wp-block-column stats-image\"><!-- wp:image {\"id\":24,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/image-1024x689.png\" alt=\"\" class=\"wp-image-24\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"326px\",\"className\":\"stats-chiffres\",\"style\":{\"color\":{\"background\":\"#d2edf9\"}}} -->\n<div class=\"wp-block-column stats-chiffres has-background\" style=\"background-color:#d2edf9;flex-basis:326px\"><!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">4</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">membres fondateurs</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>l’Université de La Réunion, la Technopole, le CIRAD, et l’IRD, unis pour renforcer les synergies entre la recherche, l’enseignement supérieur et le monde socio-économique.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">22</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">unités de recherche</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>mobilisées pour valoriser les projets et renforcer les collaborations avec le monde socio-économique</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">4</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">axes stratégiques</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>pour transformer l’écosystème</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">500+</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">acteurs de l\'écosystème</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>(étudiants, chercheurs, entrepreneurs, entreprises) visés pour participer aux initiatives et synergies portées par le PUI.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">1er</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">PUI d\'Outre-mer</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>conçu pour dynamiser l’écosystème d’innovation réunionnais et positionner La Réunion comme un hub stratégique dans l’océan Indien.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p>Le PUI Valiotech, soutenu par France 2030 grâce à l’ANR et BPI France, est l’unique PUI d’Outre-Mer. Il agit comme un levier pour maximiser l’impact des talents et des projets réunionnais, en répondant aux besoins économiques, sociaux et environnementaux du territoire.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"events full\"} -->\n<div class=\"wp-block-columns events full\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">évènements</mark> des acteurs du PUI</h2>\n<!-- /wp:heading -->\n\n<!-- wp:query {\"queryId\":27,\"query\":{\"perPage\":10,\"pages\":0,\"offset\":0,\"postType\":\"event\",\"order\":\"desc\",\"orderBy\":\"date\",\"author\":\"\",\"search\":\"\",\"exclude\":[],\"sticky\":\"\",\"inherit\":false,\"parents\":[],\"format\":[]},\"className\":\"events-list\"} -->\n<div class=\"wp-block-query events-list\"><!-- wp:post-template {\"className\":\"event\"} -->\n<!-- wp:post-date /-->\n\n<!-- wp:post-title /-->\n\n<!-- wp:post-excerpt /-->\n<!-- /wp:post-template -->\n\n<!-- wp:query-no-results -->\n<!-- wp:paragraph {\"placeholder\":\"Ajouter un texte ou des blocs qui s’afficheront lorsqu’une requête ne renverra aucun résultat.\"} -->\n<p></p>\n<!-- /wp:paragraph -->\n<!-- /wp:query-no-results --></div>\n<!-- /wp:query -->\n\n<!-- wp:image {\"id\":25,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/image-1-1024x540.png\" alt=\"\" class=\"wp-image-25\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->", "Accueil", "", "inherit", "closed", "closed", "", "2-revision-v1", "", "", "2024-11-21 10:36:54", "2024-11-21 06:36:54", "", "2", "http://pui-valiotech.local/?p=38", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("39", "1", "2024-11-21 10:48:44", "2024-11-21 06:48:44", "<!-- wp:columns {\"className\":\"hero\"} -->\n<div class=\"wp-block-columns hero\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:columns {\"isStackedOnMobile\":false,\"className\":\"hero-content large\"} -->\n<div class=\"wp-block-columns is-not-stacked-on-mobile hero-content large\"><!-- wp:column {\"width\":\"66.66%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"><!-- wp:heading {\"level\":1} -->\n<h1 class=\"wp-block-heading\">Sensibiliser, <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">connecter</mark>, innover</h1>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Avec le PUI Valiotech, nous avons l\'ambition de renforcer l\'innovation locale en créant des synergies entre l’enseignement supérieur, la recherche et le monde socio-économique, pour répondre ensemble aux défis du territoire.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"className\":\"buttons\"} -->\n<div class=\"wp-block-buttons buttons\"><!-- wp:button -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Participer à un événement</a></div>\n<!-- /wp:button -->\n\n<!-- wp:button {\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link wp-element-button\">Nous rejoindre</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"33.33%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"><!-- wp:columns {\"className\":\"hero-images\"} -->\n<div class=\"wp-block-columns hero-images\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":15,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"square\"} -->\n<figure class=\"wp-block-image size-full square\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/b532e4b30d1917574e9dbd8967d60662.jpeg\" alt=\"\" class=\"wp-image-15\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":16,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"vertical\"} -->\n<figure class=\"wp-block-image size-full vertical\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/ef701919e992624c1600580947f786fd.jpeg\" alt=\"\" class=\"wp-image-16\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":17,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"vertical\"} -->\n<figure class=\"wp-block-image size-full vertical\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/34ae07df518c66da70ea24c63c2e6f0c.jpeg\" alt=\"\" class=\"wp-image-17\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"introduction small\"} -->\n<div class=\"wp-block-columns introduction small\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:gallery {\"columns\":4,\"imageCrop\":false,\"linkTo\":\"none\",\"sizeSlug\":\"full\",\"className\":\"stakeholders\"} -->\n<figure class=\"wp-block-gallery has-nested-images columns-4 stakeholders\"><!-- wp:image {\"id\":22,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/e959eab8fb6cc935aa083d3451a0affc.jpeg\" alt=\"\" class=\"wp-image-22\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":20,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/724e2f98e73630980b049921e093e23a.png\" alt=\"\" class=\"wp-image-20\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":19,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/1264e6eb30c0ef78308d82d98aa8f086.jpeg\" alt=\"\" class=\"wp-image-19\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":21,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/6306afbcf38f7060680d7b4089dfaabc.png\" alt=\"\" class=\"wp-image-21\"/></figure>\n<!-- /wp:image --></figure>\n<!-- /wp:gallery -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3 class=\"wp-block-heading\">C’est quoi un Pôle Universitaire d’Innovation (PUI) ?</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Un PUI est un dispositif national créé pour rapprocher l’université, la recherche et les entreprises, afin de transformer la science et les idées en solutions concrètes.<br>À travers des actions ciblées comme la formation, l’accompagnement des projets, et le transfert technologique, les PUIs accélèrent l’innovation et favorisent la création de start-ups.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"objectifs small\"} -->\n<div class=\"wp-block-columns objectifs small\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">objectifs</mark> de la démarche</h2>\n<!-- /wp:heading -->\n\n<!-- wp:group {\"className\":\"liste-objectifs\",\"layout\":{\"type\":\"grid\",\"minimumColumnWidth\":\"20rem\"}} -->\n<div class=\"wp-block-group liste-objectifs\"><!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Sensibiliser et former les futurs entrepreneurs</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Des programmes de formations et événements sont mis en place pour permettre aux jeunes talents de développer leurs compétences et leur esprit entrepreneurial.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Créer des synergies entre les acteurs de l\'innovation</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Nous rassemblons chercheurs, entreprises, étudiants, entrepreneurs et structures d’accompagnement pour encourager la collaboration et l\'échange d\'idées.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Soutenir la croissance des start-ups</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Nous accompagnons les porteurs de projets à chaque étape, de la sensibilisation à la mise en œuvre de leurs activités.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Valoriser les sujets de recherche</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>En favorisant le transfert de technologies et d\'idées entre les laboratoires de recherche et le secteur privé, nous contribuons à l\'application concrète des innovations.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"stats large\"} -->\n<div class=\"wp-block-columns stats large\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Quelques <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">chiffres</mark> pour comprendre</h2>\n<!-- /wp:heading -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"className\":\"stats-image\"} -->\n<div class=\"wp-block-column stats-image\"><!-- wp:image {\"id\":24,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/image-1024x689.png\" alt=\"\" class=\"wp-image-24\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"326px\",\"className\":\"stats-chiffres\",\"style\":{\"color\":{\"background\":\"#d2edf9\"}}} -->\n<div class=\"wp-block-column stats-chiffres has-background\" style=\"background-color:#d2edf9;flex-basis:326px\"><!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">4</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">membres fondateurs</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>l’Université de La Réunion, la Technopole, le CIRAD, et l’IRD, unis pour renforcer les synergies entre la recherche, l’enseignement supérieur et le monde socio-économique.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">22</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">unités de recherche</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>mobilisées pour valoriser les projets et renforcer les collaborations avec le monde socio-économique</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">4</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">axes stratégiques</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>pour transformer l’écosystème</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">500+</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">acteurs de l\'écosystème</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>(étudiants, chercheurs, entrepreneurs, entreprises) visés pour participer aux initiatives et synergies portées par le PUI.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">1er</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">PUI d\'Outre-mer</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>conçu pour dynamiser l’écosystème d’innovation réunionnais et positionner La Réunion comme un hub stratégique dans l’océan Indien.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"stats large\"} -->\n<div class=\"wp-block-columns stats large\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p>Le PUI Valiotech, soutenu par France 2030 grâce à l’ANR et BPI France, est l’unique PUI d’Outre-Mer. Il agit comme un levier pour maximiser l’impact des talents et des projets réunionnais, en répondant aux besoins économiques, sociaux et environnementaux du territoire.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"events full\"} -->\n<div class=\"wp-block-columns events full\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">évènements</mark> des acteurs du PUI</h2>\n<!-- /wp:heading -->\n\n<!-- wp:query {\"queryId\":27,\"query\":{\"perPage\":10,\"pages\":0,\"offset\":0,\"postType\":\"event\",\"order\":\"desc\",\"orderBy\":\"date\",\"author\":\"\",\"search\":\"\",\"exclude\":[],\"sticky\":\"\",\"inherit\":false,\"parents\":[],\"format\":[]},\"className\":\"events-list\"} -->\n<div class=\"wp-block-query events-list\"><!-- wp:post-template {\"className\":\"event\"} -->\n<!-- wp:post-date /-->\n\n<!-- wp:post-title /-->\n\n<!-- wp:post-excerpt /-->\n<!-- /wp:post-template -->\n\n<!-- wp:query-no-results -->\n<!-- wp:paragraph {\"placeholder\":\"Ajouter un texte ou des blocs qui s’afficheront lorsqu’une requête ne renverra aucun résultat.\"} -->\n<p></p>\n<!-- /wp:paragraph -->\n<!-- /wp:query-no-results --></div>\n<!-- /wp:query -->\n\n<!-- wp:image {\"id\":25,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/image-1-1024x540.png\" alt=\"\" class=\"wp-image-25\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->", "Accueil", "", "inherit", "closed", "closed", "", "2-revision-v1", "", "", "2024-11-21 10:48:44", "2024-11-21 06:48:44", "", "2", "http://pui-valiotech.local/?p=39", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("40", "1", "2024-11-21 10:50:20", "2024-11-21 06:50:20", "<!-- wp:columns {\"className\":\"hero\"} -->\n<div class=\"wp-block-columns hero\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:columns {\"isStackedOnMobile\":false,\"className\":\"hero-content large\"} -->\n<div class=\"wp-block-columns is-not-stacked-on-mobile hero-content large\"><!-- wp:column {\"width\":\"66.66%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"><!-- wp:heading {\"level\":1} -->\n<h1 class=\"wp-block-heading\">Sensibiliser, <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">connecter</mark>, innover</h1>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Avec le PUI Valiotech, nous avons l\'ambition de renforcer l\'innovation locale en créant des synergies entre l’enseignement supérieur, la recherche et le monde socio-économique, pour répondre ensemble aux défis du territoire.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"className\":\"buttons\"} -->\n<div class=\"wp-block-buttons buttons\"><!-- wp:button -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Participer à un événement</a></div>\n<!-- /wp:button -->\n\n<!-- wp:button {\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link wp-element-button\">Nous rejoindre</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"33.33%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"><!-- wp:columns {\"className\":\"hero-images\"} -->\n<div class=\"wp-block-columns hero-images\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":15,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"square\"} -->\n<figure class=\"wp-block-image size-full square\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/b532e4b30d1917574e9dbd8967d60662.jpeg\" alt=\"\" class=\"wp-image-15\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":16,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"vertical\"} -->\n<figure class=\"wp-block-image size-full vertical\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/ef701919e992624c1600580947f786fd.jpeg\" alt=\"\" class=\"wp-image-16\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":17,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"vertical\"} -->\n<figure class=\"wp-block-image size-full vertical\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/34ae07df518c66da70ea24c63c2e6f0c.jpeg\" alt=\"\" class=\"wp-image-17\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"introduction small\"} -->\n<div class=\"wp-block-columns introduction small\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:gallery {\"columns\":4,\"imageCrop\":false,\"linkTo\":\"none\",\"sizeSlug\":\"full\",\"className\":\"stakeholders\"} -->\n<figure class=\"wp-block-gallery has-nested-images columns-4 stakeholders\"><!-- wp:image {\"id\":22,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/e959eab8fb6cc935aa083d3451a0affc.jpeg\" alt=\"\" class=\"wp-image-22\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":20,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/724e2f98e73630980b049921e093e23a.png\" alt=\"\" class=\"wp-image-20\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":19,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/1264e6eb30c0ef78308d82d98aa8f086.jpeg\" alt=\"\" class=\"wp-image-19\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":21,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/6306afbcf38f7060680d7b4089dfaabc.png\" alt=\"\" class=\"wp-image-21\"/></figure>\n<!-- /wp:image --></figure>\n<!-- /wp:gallery -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3 class=\"wp-block-heading\">C’est quoi un Pôle Universitaire d’Innovation (PUI) ?</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Un PUI est un dispositif national créé pour rapprocher l’université, la recherche et les entreprises, afin de transformer la science et les idées en solutions concrètes.<br>À travers des actions ciblées comme la formation, l’accompagnement des projets, et le transfert technologique, les PUIs accélèrent l’innovation et favorisent la création de start-ups.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"objectifs small\"} -->\n<div class=\"wp-block-columns objectifs small\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">objectifs</mark> de la démarche</h2>\n<!-- /wp:heading -->\n\n<!-- wp:group {\"className\":\"liste-objectifs\",\"layout\":{\"type\":\"grid\",\"minimumColumnWidth\":\"20rem\"}} -->\n<div class=\"wp-block-group liste-objectifs\"><!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Sensibiliser et former les futurs entrepreneurs</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Des programmes de formations et événements sont mis en place pour permettre aux jeunes talents de développer leurs compétences et leur esprit entrepreneurial.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Créer des synergies entre les acteurs de l\'innovation</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Nous rassemblons chercheurs, entreprises, étudiants, entrepreneurs et structures d’accompagnement pour encourager la collaboration et l\'échange d\'idées.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Soutenir la croissance des start-ups</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Nous accompagnons les porteurs de projets à chaque étape, de la sensibilisation à la mise en œuvre de leurs activités.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Valoriser les sujets de recherche</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>En favorisant le transfert de technologies et d\'idées entre les laboratoires de recherche et le secteur privé, nous contribuons à l\'application concrète des innovations.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"stats large\"} -->\n<div class=\"wp-block-columns stats large\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Quelques <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">chiffres</mark> pour comprendre</h2>\n<!-- /wp:heading -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"className\":\"stats-image\"} -->\n<div class=\"wp-block-column stats-image\"><!-- wp:image {\"id\":24,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/image-1024x689.png\" alt=\"\" class=\"wp-image-24\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"326px\",\"className\":\"stats-chiffres\",\"style\":{\"color\":{\"background\":\"#d2edf9\"}}} -->\n<div class=\"wp-block-column stats-chiffres has-background\" style=\"background-color:#d2edf9;flex-basis:326px\"><!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">4</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">membres fondateurs</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>l’Université de La Réunion, la Technopole, le CIRAD, et l’IRD, unis pour renforcer les synergies entre la recherche, l’enseignement supérieur et le monde socio-économique.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">22</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">unités de recherche</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>mobilisées pour valoriser les projets et renforcer les collaborations avec le monde socio-économique</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">4</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">axes stratégiques</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>pour transformer l’écosystème</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">500+</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">acteurs de l\'écosystème</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>(étudiants, chercheurs, entrepreneurs, entreprises) visés pour participer aux initiatives et synergies portées par le PUI.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">1er</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">PUI d\'Outre-mer</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>conçu pour dynamiser l’écosystème d’innovation réunionnais et positionner La Réunion comme un hub stratégique dans l’océan Indien.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"large\"} -->\n<div class=\"wp-block-columns large\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p>Le PUI Valiotech, soutenu par France 2030 grâce à l’ANR et BPI France, est l’unique PUI d’Outre-Mer. Il agit comme un levier pour maximiser l’impact des talents et des projets réunionnais, en répondant aux besoins économiques, sociaux et environnementaux du territoire.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"events full\"} -->\n<div class=\"wp-block-columns events full\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">évènements</mark> des acteurs du PUI</h2>\n<!-- /wp:heading -->\n\n<!-- wp:query {\"queryId\":27,\"query\":{\"perPage\":10,\"pages\":0,\"offset\":0,\"postType\":\"event\",\"order\":\"desc\",\"orderBy\":\"date\",\"author\":\"\",\"search\":\"\",\"exclude\":[],\"sticky\":\"\",\"inherit\":false,\"parents\":[],\"format\":[]},\"className\":\"events-list\"} -->\n<div class=\"wp-block-query events-list\"><!-- wp:post-template {\"className\":\"event\"} -->\n<!-- wp:post-date /-->\n\n<!-- wp:post-title /-->\n\n<!-- wp:post-excerpt /-->\n<!-- /wp:post-template -->\n\n<!-- wp:query-no-results -->\n<!-- wp:paragraph {\"placeholder\":\"Ajouter un texte ou des blocs qui s’afficheront lorsqu’une requête ne renverra aucun résultat.\"} -->\n<p></p>\n<!-- /wp:paragraph -->\n<!-- /wp:query-no-results --></div>\n<!-- /wp:query -->\n\n<!-- wp:image {\"id\":25,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/image-1-1024x540.png\" alt=\"\" class=\"wp-image-25\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->", "Accueil", "", "inherit", "closed", "closed", "", "2-revision-v1", "", "", "2024-11-21 10:50:20", "2024-11-21 06:50:20", "", "2", "http://pui-valiotech.local/?p=40", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("41", "1", "2024-11-21 10:54:59", "0000-00-00 00:00:00", " ", "", "", "draft", "closed", "closed", "", "", "", "", "2024-11-21 10:54:59", "0000-00-00 00:00:00", "", "0", "http://pui-valiotech.local/?p=41", "1", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("43", "1", "2024-11-21 10:59:31", "2024-11-21 06:59:31", "", "Icone", "", "inherit", "open", "closed", "", "icone-2", "", "", "2024-11-21 10:59:31", "2024-11-21 06:59:31", "", "0", "http://pui-valiotech.local/wp-content/uploads/2024/11/Icone-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("44", "1", "2024-11-21 10:59:39", "2024-11-21 06:59:39", "http://pui-valiotech.local/wp-content/uploads/2024/11/cropped-Icone-1.png", "Icone", "", "inherit", "open", "closed", "", "icone-3", "", "", "2024-11-21 10:59:39", "2024-11-21 06:59:39", "", "43", "http://pui-valiotech.local/wp-content/uploads/2024/11/cropped-Icone-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("45", "1", "2024-11-21 10:59:44", "2024-11-21 06:59:44", "{\n    \"site_icon\": {\n        \"value\": 44,\n        \"type\": \"option\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2024-11-21 06:59:44\"\n    }\n}", "", "", "trash", "closed", "closed", "", "b40eb0d7-1ded-4483-90a5-df6663a516a3", "", "", "2024-11-21 10:59:44", "2024-11-21 06:59:44", "", "0", "http://pui-valiotech.local/b40eb0d7-1ded-4483-90a5-df6663a516a3/", "0", "customize_changeset", "", "0");
INSERT INTO `wp_posts` VALUES("46", "1", "2024-11-21 11:02:54", "2024-11-21 07:02:54", "", "Logo", "", "inherit", "open", "closed", "", "logo", "", "", "2024-11-21 11:02:54", "2024-11-21 07:02:54", "", "0", "http://pui-valiotech.local/wp-content/uploads/2024/11/Logo.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("47", "1", "2024-11-21 11:03:21", "2024-11-21 07:03:21", "", "Logo", "", "inherit", "open", "closed", "", "logo-2", "", "", "2024-11-21 11:03:21", "2024-11-21 07:03:21", "", "0", "http://pui-valiotech.local/wp-content/uploads/2024/11/Logo-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("48", "1", "2024-11-21 11:03:33", "2024-11-21 07:03:33", "http://pui-valiotech.local/wp-content/uploads/2024/11/cropped-Logo-1.png", "Logo", "", "inherit", "open", "closed", "", "logo-3", "", "", "2024-11-21 11:03:33", "2024-11-21 07:03:33", "", "47", "http://pui-valiotech.local/wp-content/uploads/2024/11/cropped-Logo-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("49", "1", "2024-11-21 11:03:37", "2024-11-21 07:03:37", "{\n    \"valio-theme::custom_logo\": {\n        \"value\": 48,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2024-11-21 07:03:37\"\n    }\n}", "", "", "trash", "closed", "closed", "", "d9681d5a-e219-40f3-b754-0e3519469bd6", "", "", "2024-11-21 11:03:37", "2024-11-21 07:03:37", "", "0", "http://pui-valiotech.local/d9681d5a-e219-40f3-b754-0e3519469bd6/", "0", "customize_changeset", "", "0");
INSERT INTO `wp_posts` VALUES("50", "1", "2024-11-21 11:12:16", "2024-11-21 07:12:16", "{\n    \"valio-theme::nav_menu_locations[main-menu]\": {\n        \"value\": 0,\n        \"type\": \"theme_mod\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2024-11-21 07:12:16\"\n    },\n    \"nav_menu[2]\": {\n        \"value\": false,\n        \"type\": \"nav_menu\",\n        \"user_id\": 1,\n        \"date_modified_gmt\": \"2024-11-21 07:12:16\"\n    }\n}", "", "", "trash", "closed", "closed", "", "3a7f9934-bf63-41b0-9641-cad9ade6a45e", "", "", "2024-11-21 11:12:16", "2024-11-21 07:12:16", "", "0", "http://pui-valiotech.local/3a7f9934-bf63-41b0-9641-cad9ade6a45e/", "0", "customize_changeset", "", "0");
INSERT INTO `wp_posts` VALUES("51", "1", "2024-11-21 11:24:19", "2024-11-21 07:24:19", "<!-- wp:columns {\"className\":\"hero\"} -->\n<div class=\"wp-block-columns hero\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:columns {\"isStackedOnMobile\":false,\"className\":\"hero-content large\"} -->\n<div class=\"wp-block-columns is-not-stacked-on-mobile hero-content large\"><!-- wp:column {\"width\":\"66.66%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"><!-- wp:heading {\"level\":1} -->\n<h1 class=\"wp-block-heading\">Sensibiliser, <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">connecter</mark>, innover</h1>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Avec le PUI Valiotech, nous avons l\'ambition de renforcer l\'innovation locale en créant des synergies entre l’enseignement supérieur, la recherche et le monde socio-économique, pour répondre ensemble aux défis du territoire.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"className\":\"buttons\"} -->\n<div class=\"wp-block-buttons buttons\"><!-- wp:button -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Participer à un événement</a></div>\n<!-- /wp:button -->\n\n<!-- wp:button {\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link wp-element-button\">Nous rejoindre</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"33.33%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"><!-- wp:columns {\"className\":\"hero-images\"} -->\n<div class=\"wp-block-columns hero-images\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":15,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"square\"} -->\n<figure class=\"wp-block-image size-full square\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/b532e4b30d1917574e9dbd8967d60662.jpeg\" alt=\"\" class=\"wp-image-15\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p>Entrepreneurs</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {\"id\":16,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"vertical\"} -->\n<figure class=\"wp-block-image size-full vertical\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/ef701919e992624c1600580947f786fd.jpeg\" alt=\"\" class=\"wp-image-16\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p>Laboratoires</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":17,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"vertical\"} -->\n<figure class=\"wp-block-image size-full vertical\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/34ae07df518c66da70ea24c63c2e6f0c.jpeg\" alt=\"\" class=\"wp-image-17\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p>Entreprises</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"introduction small\"} -->\n<div class=\"wp-block-columns introduction small\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:gallery {\"columns\":4,\"imageCrop\":false,\"linkTo\":\"none\",\"sizeSlug\":\"full\",\"className\":\"stakeholders\"} -->\n<figure class=\"wp-block-gallery has-nested-images columns-4 stakeholders\"><!-- wp:image {\"id\":22,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/e959eab8fb6cc935aa083d3451a0affc.jpeg\" alt=\"\" class=\"wp-image-22\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":20,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/724e2f98e73630980b049921e093e23a.png\" alt=\"\" class=\"wp-image-20\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":19,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/1264e6eb30c0ef78308d82d98aa8f086.jpeg\" alt=\"\" class=\"wp-image-19\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":21,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/6306afbcf38f7060680d7b4089dfaabc.png\" alt=\"\" class=\"wp-image-21\"/></figure>\n<!-- /wp:image --></figure>\n<!-- /wp:gallery -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3 class=\"wp-block-heading\">C’est quoi un Pôle Universitaire d’Innovation (PUI) ?</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Un PUI est un dispositif national créé pour rapprocher l’université, la recherche et les entreprises, afin de transformer la science et les idées en solutions concrètes.<br>À travers des actions ciblées comme la formation, l’accompagnement des projets, et le transfert technologique, les PUIs accélèrent l’innovation et favorisent la création de start-ups.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"objectifs small\"} -->\n<div class=\"wp-block-columns objectifs small\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">objectifs</mark> de la démarche</h2>\n<!-- /wp:heading -->\n\n<!-- wp:group {\"className\":\"liste-objectifs\",\"layout\":{\"type\":\"grid\",\"minimumColumnWidth\":\"20rem\"}} -->\n<div class=\"wp-block-group liste-objectifs\"><!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Sensibiliser et former les futurs entrepreneurs</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Des programmes de formations et événements sont mis en place pour permettre aux jeunes talents de développer leurs compétences et leur esprit entrepreneurial.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Créer des synergies entre les acteurs de l\'innovation</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Nous rassemblons chercheurs, entreprises, étudiants, entrepreneurs et structures d’accompagnement pour encourager la collaboration et l\'échange d\'idées.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Soutenir la croissance des start-ups</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Nous accompagnons les porteurs de projets à chaque étape, de la sensibilisation à la mise en œuvre de leurs activités.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Valoriser les sujets de recherche</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>En favorisant le transfert de technologies et d\'idées entre les laboratoires de recherche et le secteur privé, nous contribuons à l\'application concrète des innovations.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"stats large\"} -->\n<div class=\"wp-block-columns stats large\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Quelques <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">chiffres</mark> pour comprendre</h2>\n<!-- /wp:heading -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"className\":\"stats-image\"} -->\n<div class=\"wp-block-column stats-image\"><!-- wp:image {\"id\":24,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/image-1024x689.png\" alt=\"\" class=\"wp-image-24\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"326px\",\"className\":\"stats-chiffres\",\"style\":{\"color\":{\"background\":\"#d2edf9\"}}} -->\n<div class=\"wp-block-column stats-chiffres has-background\" style=\"background-color:#d2edf9;flex-basis:326px\"><!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">4</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">membres fondateurs</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>l’Université de La Réunion, la Technopole, le CIRAD, et l’IRD, unis pour renforcer les synergies entre la recherche, l’enseignement supérieur et le monde socio-économique.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">22</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">unités de recherche</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>mobilisées pour valoriser les projets et renforcer les collaborations avec le monde socio-économique</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">4</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">axes stratégiques</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>pour transformer l’écosystème</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">500+</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">acteurs de l\'écosystème</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>(étudiants, chercheurs, entrepreneurs, entreprises) visés pour participer aux initiatives et synergies portées par le PUI.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">1er</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">PUI d\'Outre-mer</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>conçu pour dynamiser l’écosystème d’innovation réunionnais et positionner La Réunion comme un hub stratégique dans l’océan Indien.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"large\"} -->\n<div class=\"wp-block-columns large\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p>Le PUI Valiotech, soutenu par France 2030 grâce à l’ANR et BPI France, est l’unique PUI d’Outre-Mer. Il agit comme un levier pour maximiser l’impact des talents et des projets réunionnais, en répondant aux besoins économiques, sociaux et environnementaux du territoire.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"events full\"} -->\n<div class=\"wp-block-columns events full\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">évènements</mark> des acteurs du PUI</h2>\n<!-- /wp:heading -->\n\n<!-- wp:query {\"queryId\":27,\"query\":{\"perPage\":10,\"pages\":0,\"offset\":0,\"postType\":\"event\",\"order\":\"desc\",\"orderBy\":\"date\",\"author\":\"\",\"search\":\"\",\"exclude\":[],\"sticky\":\"\",\"inherit\":false,\"parents\":[],\"format\":[]},\"className\":\"events-list\"} -->\n<div class=\"wp-block-query events-list\"><!-- wp:post-template {\"className\":\"event\"} -->\n<!-- wp:post-date /-->\n\n<!-- wp:post-title /-->\n\n<!-- wp:post-excerpt /-->\n<!-- /wp:post-template -->\n\n<!-- wp:query-no-results -->\n<!-- wp:paragraph {\"placeholder\":\"Ajouter un texte ou des blocs qui s’afficheront lorsqu’une requête ne renverra aucun résultat.\"} -->\n<p></p>\n<!-- /wp:paragraph -->\n<!-- /wp:query-no-results --></div>\n<!-- /wp:query -->\n\n<!-- wp:image {\"id\":25,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/image-1-1024x540.png\" alt=\"\" class=\"wp-image-25\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->", "Accueil", "", "inherit", "closed", "closed", "", "2-revision-v1", "", "", "2024-11-21 11:24:19", "2024-11-21 07:24:19", "", "2", "http://pui-valiotech.local/?p=51", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("52", "1", "2024-11-21 11:24:48", "2024-11-21 07:24:48", "<!-- wp:columns {\"className\":\"hero\"} -->\n<div class=\"wp-block-columns hero\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:columns {\"isStackedOnMobile\":false,\"className\":\"hero-content large\"} -->\n<div class=\"wp-block-columns is-not-stacked-on-mobile hero-content large\"><!-- wp:column {\"width\":\"66.66%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"><!-- wp:heading {\"level\":1} -->\n<h1 class=\"wp-block-heading\">Sensibiliser, <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">connecter</mark>, innover</h1>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Avec le PUI Valiotech, nous avons l\'ambition de renforcer l\'innovation locale en créant des synergies entre l’enseignement supérieur, la recherche et le monde socio-économique, pour répondre ensemble aux défis du territoire.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"className\":\"buttons\"} -->\n<div class=\"wp-block-buttons buttons\"><!-- wp:button -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Participer à un événement</a></div>\n<!-- /wp:button -->\n\n<!-- wp:button {\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link wp-element-button\">Nous rejoindre</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"33.33%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"><!-- wp:columns {\"className\":\"hero-images\"} -->\n<div class=\"wp-block-columns hero-images\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":15,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"square\"} -->\n<figure class=\"wp-block-image size-full square\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/b532e4b30d1917574e9dbd8967d60662.jpeg\" alt=\"\" class=\"wp-image-15\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph {\"className\":\"hero-label\"} -->\n<p class=\"hero-label\">Entrepreneurs</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {\"id\":16,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"vertical\"} -->\n<figure class=\"wp-block-image size-full vertical\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/ef701919e992624c1600580947f786fd.jpeg\" alt=\"\" class=\"wp-image-16\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph {\"className\":\"hero-label\"} -->\n<p class=\"hero-label\">Laboratoires</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":17,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"vertical\"} -->\n<figure class=\"wp-block-image size-full vertical\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/34ae07df518c66da70ea24c63c2e6f0c.jpeg\" alt=\"\" class=\"wp-image-17\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph {\"className\":\"hero-label\"} -->\n<p class=\"hero-label\">Entreprises</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"introduction small\"} -->\n<div class=\"wp-block-columns introduction small\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:gallery {\"columns\":4,\"imageCrop\":false,\"linkTo\":\"none\",\"sizeSlug\":\"full\",\"className\":\"stakeholders\"} -->\n<figure class=\"wp-block-gallery has-nested-images columns-4 stakeholders\"><!-- wp:image {\"id\":22,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/e959eab8fb6cc935aa083d3451a0affc.jpeg\" alt=\"\" class=\"wp-image-22\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":20,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/724e2f98e73630980b049921e093e23a.png\" alt=\"\" class=\"wp-image-20\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":19,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/1264e6eb30c0ef78308d82d98aa8f086.jpeg\" alt=\"\" class=\"wp-image-19\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":21,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/6306afbcf38f7060680d7b4089dfaabc.png\" alt=\"\" class=\"wp-image-21\"/></figure>\n<!-- /wp:image --></figure>\n<!-- /wp:gallery -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3 class=\"wp-block-heading\">C’est quoi un Pôle Universitaire d’Innovation (PUI) ?</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Un PUI est un dispositif national créé pour rapprocher l’université, la recherche et les entreprises, afin de transformer la science et les idées en solutions concrètes.<br>À travers des actions ciblées comme la formation, l’accompagnement des projets, et le transfert technologique, les PUIs accélèrent l’innovation et favorisent la création de start-ups.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"objectifs small\"} -->\n<div class=\"wp-block-columns objectifs small\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">objectifs</mark> de la démarche</h2>\n<!-- /wp:heading -->\n\n<!-- wp:group {\"className\":\"liste-objectifs\",\"layout\":{\"type\":\"grid\",\"minimumColumnWidth\":\"20rem\"}} -->\n<div class=\"wp-block-group liste-objectifs\"><!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Sensibiliser et former les futurs entrepreneurs</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Des programmes de formations et événements sont mis en place pour permettre aux jeunes talents de développer leurs compétences et leur esprit entrepreneurial.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Créer des synergies entre les acteurs de l\'innovation</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Nous rassemblons chercheurs, entreprises, étudiants, entrepreneurs et structures d’accompagnement pour encourager la collaboration et l\'échange d\'idées.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Soutenir la croissance des start-ups</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Nous accompagnons les porteurs de projets à chaque étape, de la sensibilisation à la mise en œuvre de leurs activités.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Valoriser les sujets de recherche</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>En favorisant le transfert de technologies et d\'idées entre les laboratoires de recherche et le secteur privé, nous contribuons à l\'application concrète des innovations.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"stats large\"} -->\n<div class=\"wp-block-columns stats large\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Quelques <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">chiffres</mark> pour comprendre</h2>\n<!-- /wp:heading -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"className\":\"stats-image\"} -->\n<div class=\"wp-block-column stats-image\"><!-- wp:image {\"id\":24,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/image-1024x689.png\" alt=\"\" class=\"wp-image-24\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"326px\",\"className\":\"stats-chiffres\",\"style\":{\"color\":{\"background\":\"#d2edf9\"}}} -->\n<div class=\"wp-block-column stats-chiffres has-background\" style=\"background-color:#d2edf9;flex-basis:326px\"><!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">4</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">membres fondateurs</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>l’Université de La Réunion, la Technopole, le CIRAD, et l’IRD, unis pour renforcer les synergies entre la recherche, l’enseignement supérieur et le monde socio-économique.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">22</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">unités de recherche</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>mobilisées pour valoriser les projets et renforcer les collaborations avec le monde socio-économique</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">4</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">axes stratégiques</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>pour transformer l’écosystème</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">500+</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">acteurs de l\'écosystème</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>(étudiants, chercheurs, entrepreneurs, entreprises) visés pour participer aux initiatives et synergies portées par le PUI.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">1er</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">PUI d\'Outre-mer</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>conçu pour dynamiser l’écosystème d’innovation réunionnais et positionner La Réunion comme un hub stratégique dans l’océan Indien.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"large\"} -->\n<div class=\"wp-block-columns large\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p>Le PUI Valiotech, soutenu par France 2030 grâce à l’ANR et BPI France, est l’unique PUI d’Outre-Mer. Il agit comme un levier pour maximiser l’impact des talents et des projets réunionnais, en répondant aux besoins économiques, sociaux et environnementaux du territoire.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"events full\"} -->\n<div class=\"wp-block-columns events full\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">évènements</mark> des acteurs du PUI</h2>\n<!-- /wp:heading -->\n\n<!-- wp:query {\"queryId\":27,\"query\":{\"perPage\":10,\"pages\":0,\"offset\":0,\"postType\":\"event\",\"order\":\"desc\",\"orderBy\":\"date\",\"author\":\"\",\"search\":\"\",\"exclude\":[],\"sticky\":\"\",\"inherit\":false,\"parents\":[],\"format\":[]},\"className\":\"events-list\"} -->\n<div class=\"wp-block-query events-list\"><!-- wp:post-template {\"className\":\"event\"} -->\n<!-- wp:post-date /-->\n\n<!-- wp:post-title /-->\n\n<!-- wp:post-excerpt /-->\n<!-- /wp:post-template -->\n\n<!-- wp:query-no-results -->\n<!-- wp:paragraph {\"placeholder\":\"Ajouter un texte ou des blocs qui s’afficheront lorsqu’une requête ne renverra aucun résultat.\"} -->\n<p></p>\n<!-- /wp:paragraph -->\n<!-- /wp:query-no-results --></div>\n<!-- /wp:query -->\n\n<!-- wp:image {\"id\":25,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/image-1-1024x540.png\" alt=\"\" class=\"wp-image-25\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->", "Accueil", "", "inherit", "closed", "closed", "", "2-revision-v1", "", "", "2024-11-21 11:24:48", "2024-11-21 07:24:48", "", "2", "http://pui-valiotech.local/?p=52", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("53", "1", "2024-11-21 11:34:03", "2024-11-21 07:34:03", "<!-- wp:columns {\"className\":\"hero\"} -->\n<div class=\"wp-block-columns hero\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:columns {\"isStackedOnMobile\":false,\"className\":\"hero-content large\"} -->\n<div class=\"wp-block-columns is-not-stacked-on-mobile hero-content large\"><!-- wp:column {\"width\":\"66.66%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"><!-- wp:heading {\"level\":1} -->\n<h1 class=\"wp-block-heading\">Sensibiliser, <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">connecter</mark>, innover</h1>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Avec le PUI Valiotech, nous avons l\'ambition de renforcer l\'innovation locale en créant des synergies entre l’enseignement supérieur, la recherche et le monde socio-économique, pour répondre ensemble aux défis du territoire.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"className\":\"buttons\"} -->\n<div class=\"wp-block-buttons buttons\"><!-- wp:button -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Participer à un événement</a></div>\n<!-- /wp:button -->\n\n<!-- wp:button {\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link wp-element-button\">Nous rejoindre</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"33.33%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"><!-- wp:columns {\"className\":\"hero-images\"} -->\n<div class=\"wp-block-columns hero-images\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":15,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"square\"} -->\n<figure class=\"wp-block-image size-full square\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/b532e4b30d1917574e9dbd8967d60662.jpeg\" alt=\"\" class=\"wp-image-15\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph {\"className\":\"hero-label\"} -->\n<p class=\"hero-label\">Entrepreneurs</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {\"id\":16,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"vertical\"} -->\n<figure class=\"wp-block-image size-full vertical\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/ef701919e992624c1600580947f786fd.jpeg\" alt=\"\" class=\"wp-image-16\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph {\"className\":\"hero-label\"} -->\n<p class=\"hero-label\">Laboratoires</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":17,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"vertical\"} -->\n<figure class=\"wp-block-image size-full vertical\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/34ae07df518c66da70ea24c63c2e6f0c.jpeg\" alt=\"\" class=\"wp-image-17\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph {\"className\":\"hero-label\"} -->\n<p class=\"hero-label\">Entreprises</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"introduction small\"} -->\n<div class=\"wp-block-columns introduction small\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:gallery {\"columns\":4,\"imageCrop\":false,\"linkTo\":\"none\",\"sizeSlug\":\"full\",\"className\":\"stakeholders\"} -->\n<figure class=\"wp-block-gallery has-nested-images columns-4 stakeholders\"><!-- wp:image {\"id\":22,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/e959eab8fb6cc935aa083d3451a0affc.jpeg\" alt=\"\" class=\"wp-image-22\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":20,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/724e2f98e73630980b049921e093e23a.png\" alt=\"\" class=\"wp-image-20\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":19,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/1264e6eb30c0ef78308d82d98aa8f086.jpeg\" alt=\"\" class=\"wp-image-19\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":21,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/6306afbcf38f7060680d7b4089dfaabc.png\" alt=\"\" class=\"wp-image-21\"/></figure>\n<!-- /wp:image --></figure>\n<!-- /wp:gallery -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3 class=\"wp-block-heading\">C’est quoi un Pôle Universitaire d’Innovation (PUI) ?</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Un PUI est un dispositif national créé pour rapprocher l’université, la recherche et les entreprises, afin de transformer la science et les idées en solutions concrètes.<br>À travers des actions ciblées comme la formation, l’accompagnement des projets, et le transfert technologique, les PUIs accélèrent l’innovation et favorisent la création de start-ups.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"objectifs small\"} -->\n<div class=\"wp-block-columns objectifs small\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">objectifs</mark> de la démarche</h2>\n<!-- /wp:heading -->\n\n<!-- wp:group {\"className\":\"liste-objectifs\",\"layout\":{\"type\":\"grid\",\"minimumColumnWidth\":\"20rem\"}} -->\n<div class=\"wp-block-group liste-objectifs\"><!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Sensibiliser et former les futurs entrepreneurs</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Des programmes de formations et événements sont mis en place pour permettre aux jeunes talents de développer leurs compétences et leur esprit entrepreneurial.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Créer des synergies entre les acteurs de l\'innovation</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Nous rassemblons chercheurs, entreprises, étudiants, entrepreneurs et structures d’accompagnement pour encourager la collaboration et l\'échange d\'idées.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Soutenir la croissance des start-ups</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Nous accompagnons les porteurs de projets à chaque étape, de la sensibilisation à la mise en œuvre de leurs activités.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Valoriser les sujets de recherche</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>En favorisant le transfert de technologies et d\'idées entre les laboratoires de recherche et le secteur privé, nous contribuons à l\'application concrète des innovations.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"stats large\"} -->\n<div class=\"wp-block-columns stats large\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Quelques <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">chiffres</mark> pour comprendre</h2>\n<!-- /wp:heading -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"className\":\"stats-image\"} -->\n<div class=\"wp-block-column stats-image\"><!-- wp:image {\"id\":24,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/image-1024x689.png\" alt=\"\" class=\"wp-image-24\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"326px\",\"className\":\"stats-chiffres\",\"style\":{\"color\":{\"background\":\"#d2edf9\"}}} -->\n<div class=\"wp-block-column stats-chiffres has-background\" style=\"background-color:#d2edf9;flex-basis:326px\"><!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">4</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">membres fondateurs</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>l’Université de La Réunion, la Technopole, le CIRAD, et l’IRD, unis pour renforcer les synergies entre la recherche, l’enseignement supérieur et le monde socio-économique.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">22</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">unités de recherche</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>mobilisées pour valoriser les projets et renforcer les collaborations avec le monde socio-économique</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">4</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">axes stratégiques</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>pour transformer l’écosystème</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">500+</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">acteurs de l\'écosystème</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>(étudiants, chercheurs, entrepreneurs, entreprises) visés pour participer aux initiatives et synergies portées par le PUI.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">1er</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">PUI d\'Outre-mer</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>conçu pour dynamiser l’écosystème d’innovation réunionnais et positionner La Réunion comme un hub stratégique dans l’océan Indien.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"large\"} -->\n<div class=\"wp-block-columns large\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p>Le PUI Valiotech, soutenu par France 2030 grâce à l’ANR et BPI France, est l’unique PUI d’Outre-Mer. Il agit comme un levier pour maximiser l’impact des talents et des projets réunionnais, en répondant aux besoins économiques, sociaux et environnementaux du territoire.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"events full hidden\"} -->\n<div class=\"wp-block-columns events full hidden\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">évènements</mark> des acteurs du PUI</h2>\n<!-- /wp:heading -->\n\n<!-- wp:query {\"queryId\":27,\"query\":{\"perPage\":10,\"pages\":0,\"offset\":0,\"postType\":\"event\",\"order\":\"desc\",\"orderBy\":\"date\",\"author\":\"\",\"search\":\"\",\"exclude\":[],\"sticky\":\"\",\"inherit\":false,\"parents\":[],\"format\":[]},\"className\":\"events-list\"} -->\n<div class=\"wp-block-query events-list\"><!-- wp:post-template {\"className\":\"event\"} -->\n<!-- wp:post-date /-->\n\n<!-- wp:post-title /-->\n\n<!-- wp:post-excerpt /-->\n<!-- /wp:post-template -->\n\n<!-- wp:query-no-results -->\n<!-- wp:paragraph {\"placeholder\":\"Ajouter un texte ou des blocs qui s’afficheront lorsqu’une requête ne renverra aucun résultat.\"} -->\n<p></p>\n<!-- /wp:paragraph -->\n<!-- /wp:query-no-results --></div>\n<!-- /wp:query -->\n\n<!-- wp:image {\"id\":25,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/image-1-1024x540.png\" alt=\"\" class=\"wp-image-25\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->", "Accueil", "", "inherit", "closed", "closed", "", "2-revision-v1", "", "", "2024-11-21 11:34:03", "2024-11-21 07:34:03", "", "2", "http://pui-valiotech.local/?p=53", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("54", "1", "2024-11-21 11:35:54", "0000-00-00 00:00:00", " ", "", "", "draft", "closed", "closed", "", "", "", "", "2024-11-21 11:35:54", "0000-00-00 00:00:00", "", "0", "http://pui-valiotech.local/?p=54", "1", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("55", "1", "2024-11-21 11:36:06", "2024-11-21 07:36:06", "", "Group1", "", "inherit", "open", "closed", "", "group1", "", "", "2024-11-21 11:36:06", "2024-11-21 07:36:06", "", "0", "http://pui-valiotech.local/wp-content/uploads/2024/11/Group1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("56", "1", "2024-11-21 11:36:06", "2024-11-21 07:36:06", "", "Group2", "", "inherit", "open", "closed", "", "group2", "", "", "2024-11-21 11:36:06", "2024-11-21 07:36:06", "", "0", "http://pui-valiotech.local/wp-content/uploads/2024/11/Group2.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("57", "1", "2024-11-21 11:36:06", "2024-11-21 07:36:06", "", "Group3", "", "inherit", "open", "closed", "", "group3", "", "", "2024-11-21 11:36:06", "2024-11-21 07:36:06", "", "0", "http://pui-valiotech.local/wp-content/uploads/2024/11/Group3.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("58", "1", "2024-11-21 14:03:50", "2024-11-21 10:03:50", "", "facebook", "", "inherit", "open", "closed", "", "facebook", "", "", "2024-11-21 14:03:50", "2024-11-21 10:03:50", "", "0", "http://pui-valiotech.local/wp-content/uploads/2024/11/facebook.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("59", "1", "2024-11-21 14:03:50", "2024-11-21 10:03:50", "", "instagram", "", "inherit", "open", "closed", "", "instagram", "", "", "2024-11-21 14:03:50", "2024-11-21 10:03:50", "", "0", "http://pui-valiotech.local/wp-content/uploads/2024/11/instagram.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("60", "1", "2024-11-21 14:03:50", "2024-11-21 10:03:50", "", "linkedin", "", "inherit", "open", "closed", "", "linkedin", "", "", "2024-11-21 14:03:50", "2024-11-21 10:03:50", "", "0", "http://pui-valiotech.local/wp-content/uploads/2024/11/linkedin.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("62", "1", "2024-11-22 09:43:00", "0000-00-00 00:00:00", "", "Brouillon auto", "", "auto-draft", "closed", "closed", "", "", "", "", "2024-11-22 09:43:00", "0000-00-00 00:00:00", "", "0", "http://pui-valiotech.local/?post_type=event&p=62", "0", "event", "", "0");
INSERT INTO `wp_posts` VALUES("63", "1", "2024-11-22 09:48:16", "0000-00-00 00:00:00", "", "Brouillon auto", "", "auto-draft", "closed", "closed", "", "", "", "", "2024-11-22 09:48:16", "0000-00-00 00:00:00", "", "0", "http://pui-valiotech.local/?post_type=event&p=63", "0", "event", "", "0");
INSERT INTO `wp_posts` VALUES("64", "1", "2024-11-22 09:50:01", "0000-00-00 00:00:00", "", "Brouillon auto", "", "auto-draft", "closed", "closed", "", "", "", "", "2024-11-22 09:50:01", "0000-00-00 00:00:00", "", "0", "http://pui-valiotech.local/?post_type=event&p=64", "0", "event", "", "0");
INSERT INTO `wp_posts` VALUES("65", "1", "2024-11-22 09:54:10", "2024-11-22 05:54:10", "<!-- wp:paragraph -->\n<p>Des programmes de formations et événements sont mis en place pour permettre aux jeunes talents de développer leurs compétences et leur esprit entrepreneurial.</p>\n<!-- /wp:paragraph -->", "Séminaire de lancement PUI Valiotech", "Des programmes de formations et événements sont mis en place pour permettre aux jeunes talents de développer leurs compétences et leur esprit entrepreneurial.", "publish", "closed", "closed", "", "seminaire-de-lancement-pui-valiotech", "", "", "2024-11-22 09:54:10", "2024-11-22 05:54:10", "", "0", "http://pui-valiotech.local/?post_type=event&#038;p=65", "0", "event", "", "0");
INSERT INTO `wp_posts` VALUES("66", "1", "2024-11-22 09:54:26", "2024-11-22 05:54:26", "<!-- wp:columns {\"className\":\"hero\"} -->\n<div class=\"wp-block-columns hero\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:columns {\"isStackedOnMobile\":false,\"className\":\"hero-content large\"} -->\n<div class=\"wp-block-columns is-not-stacked-on-mobile hero-content large\"><!-- wp:column {\"width\":\"66.66%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"><!-- wp:heading {\"level\":1} -->\n<h1 class=\"wp-block-heading\">Sensibiliser, <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">connecter</mark>, innover</h1>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Avec le PUI Valiotech, nous avons l\'ambition de renforcer l\'innovation locale en créant des synergies entre l’enseignement supérieur, la recherche et le monde socio-économique, pour répondre ensemble aux défis du territoire.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"className\":\"buttons\"} -->\n<div class=\"wp-block-buttons buttons\"><!-- wp:button -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Participer à un événement</a></div>\n<!-- /wp:button -->\n\n<!-- wp:button {\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link wp-element-button\">Nous rejoindre</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"33.33%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"><!-- wp:columns {\"className\":\"hero-images\"} -->\n<div class=\"wp-block-columns hero-images\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":15,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"square\"} -->\n<figure class=\"wp-block-image size-full square\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/b532e4b30d1917574e9dbd8967d60662.jpeg\" alt=\"\" class=\"wp-image-15\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph {\"className\":\"hero-label\"} -->\n<p class=\"hero-label\">Entrepreneurs</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {\"id\":16,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"vertical\"} -->\n<figure class=\"wp-block-image size-full vertical\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/ef701919e992624c1600580947f786fd.jpeg\" alt=\"\" class=\"wp-image-16\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph {\"className\":\"hero-label\"} -->\n<p class=\"hero-label\">Laboratoires</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":17,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"vertical\"} -->\n<figure class=\"wp-block-image size-full vertical\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/34ae07df518c66da70ea24c63c2e6f0c.jpeg\" alt=\"\" class=\"wp-image-17\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph {\"className\":\"hero-label\"} -->\n<p class=\"hero-label\">Entreprises</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"introduction small\"} -->\n<div class=\"wp-block-columns introduction small\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:gallery {\"columns\":4,\"imageCrop\":false,\"linkTo\":\"none\",\"sizeSlug\":\"full\",\"className\":\"stakeholders\"} -->\n<figure class=\"wp-block-gallery has-nested-images columns-4 stakeholders\"><!-- wp:image {\"id\":22,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/e959eab8fb6cc935aa083d3451a0affc.jpeg\" alt=\"\" class=\"wp-image-22\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":20,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/724e2f98e73630980b049921e093e23a.png\" alt=\"\" class=\"wp-image-20\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":19,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/1264e6eb30c0ef78308d82d98aa8f086.jpeg\" alt=\"\" class=\"wp-image-19\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":21,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/6306afbcf38f7060680d7b4089dfaabc.png\" alt=\"\" class=\"wp-image-21\"/></figure>\n<!-- /wp:image --></figure>\n<!-- /wp:gallery -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3 class=\"wp-block-heading\">C’est quoi un Pôle Universitaire d’Innovation (PUI) ?</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Un PUI est un dispositif national créé pour rapprocher l’université, la recherche et les entreprises, afin de transformer la science et les idées en solutions concrètes.<br>À travers des actions ciblées comme la formation, l’accompagnement des projets, et le transfert technologique, les PUIs accélèrent l’innovation et favorisent la création de start-ups.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"objectifs small\"} -->\n<div class=\"wp-block-columns objectifs small\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">objectifs</mark> de la démarche</h2>\n<!-- /wp:heading -->\n\n<!-- wp:group {\"className\":\"liste-objectifs\",\"layout\":{\"type\":\"grid\",\"minimumColumnWidth\":\"20rem\"}} -->\n<div class=\"wp-block-group liste-objectifs\"><!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Sensibiliser et former les futurs entrepreneurs</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Des programmes de formations et événements sont mis en place pour permettre aux jeunes talents de développer leurs compétences et leur esprit entrepreneurial.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Créer des synergies entre les acteurs de l\'innovation</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Nous rassemblons chercheurs, entreprises, étudiants, entrepreneurs et structures d’accompagnement pour encourager la collaboration et l\'échange d\'idées.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Soutenir la croissance des start-ups</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Nous accompagnons les porteurs de projets à chaque étape, de la sensibilisation à la mise en œuvre de leurs activités.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Valoriser les sujets de recherche</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>En favorisant le transfert de technologies et d\'idées entre les laboratoires de recherche et le secteur privé, nous contribuons à l\'application concrète des innovations.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"stats large\"} -->\n<div class=\"wp-block-columns stats large\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Quelques <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">chiffres</mark> pour comprendre</h2>\n<!-- /wp:heading -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"className\":\"stats-image\"} -->\n<div class=\"wp-block-column stats-image\"><!-- wp:image {\"id\":24,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/image-1024x689.png\" alt=\"\" class=\"wp-image-24\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"326px\",\"className\":\"stats-chiffres\",\"style\":{\"color\":{\"background\":\"#d2edf9\"}}} -->\n<div class=\"wp-block-column stats-chiffres has-background\" style=\"background-color:#d2edf9;flex-basis:326px\"><!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">4</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">membres fondateurs</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>l’Université de La Réunion, la Technopole, le CIRAD, et l’IRD, unis pour renforcer les synergies entre la recherche, l’enseignement supérieur et le monde socio-économique.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">22</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">unités de recherche</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>mobilisées pour valoriser les projets et renforcer les collaborations avec le monde socio-économique</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">4</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">axes stratégiques</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>pour transformer l’écosystème</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">500+</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">acteurs de l\'écosystème</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>(étudiants, chercheurs, entrepreneurs, entreprises) visés pour participer aux initiatives et synergies portées par le PUI.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">1er</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">PUI d\'Outre-mer</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>conçu pour dynamiser l’écosystème d’innovation réunionnais et positionner La Réunion comme un hub stratégique dans l’océan Indien.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"large\"} -->\n<div class=\"wp-block-columns large\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p>Le PUI Valiotech, soutenu par France 2030 grâce à l’ANR et BPI France, est l’unique PUI d’Outre-Mer. Il agit comme un levier pour maximiser l’impact des talents et des projets réunionnais, en répondant aux besoins économiques, sociaux et environnementaux du territoire.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"events full\"} -->\n<div class=\"wp-block-columns events full\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">évènements</mark> des acteurs du PUI</h2>\n<!-- /wp:heading -->\n\n<!-- wp:query {\"queryId\":27,\"query\":{\"perPage\":10,\"pages\":0,\"offset\":0,\"postType\":\"event\",\"order\":\"desc\",\"orderBy\":\"date\",\"author\":\"\",\"search\":\"\",\"exclude\":[],\"sticky\":\"\",\"inherit\":false,\"parents\":[],\"format\":[]},\"className\":\"events-list\"} -->\n<div class=\"wp-block-query events-list\"><!-- wp:post-template {\"className\":\"event\"} -->\n<!-- wp:post-date /-->\n\n<!-- wp:post-title /-->\n\n<!-- wp:post-excerpt /-->\n<!-- /wp:post-template -->\n\n<!-- wp:query-no-results -->\n<!-- wp:paragraph {\"placeholder\":\"Ajouter un texte ou des blocs qui s’afficheront lorsqu’une requête ne renverra aucun résultat.\"} -->\n<p></p>\n<!-- /wp:paragraph -->\n<!-- /wp:query-no-results --></div>\n<!-- /wp:query -->\n\n<!-- wp:image {\"id\":25,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/image-1-1024x540.png\" alt=\"\" class=\"wp-image-25\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->", "Accueil", "", "inherit", "closed", "closed", "", "2-revision-v1", "", "", "2024-11-22 09:54:26", "2024-11-22 05:54:26", "", "2", "http://pui-valiotech.local/?p=66", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("68", "1", "2024-11-22 10:05:21", "2024-11-22 06:05:21", "<!-- wp:columns {\"className\":\"hero\"} -->\n<div class=\"wp-block-columns hero\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:columns {\"isStackedOnMobile\":false,\"className\":\"hero-content large\"} -->\n<div class=\"wp-block-columns is-not-stacked-on-mobile hero-content large\"><!-- wp:column {\"width\":\"66.66%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"><!-- wp:heading {\"level\":1} -->\n<h1 class=\"wp-block-heading\">Sensibiliser, <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">connecter</mark>, innover</h1>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Avec le PUI Valiotech, nous avons l\'ambition de renforcer l\'innovation locale en créant des synergies entre l’enseignement supérieur, la recherche et le monde socio-économique, pour répondre ensemble aux défis du territoire.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"className\":\"buttons\"} -->\n<div class=\"wp-block-buttons buttons\"><!-- wp:button -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Participer à un événement</a></div>\n<!-- /wp:button -->\n\n<!-- wp:button {\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link wp-element-button\">Nous rejoindre</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"33.33%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"><!-- wp:columns {\"className\":\"hero-images\"} -->\n<div class=\"wp-block-columns hero-images\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":15,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"square\"} -->\n<figure class=\"wp-block-image size-full square\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/b532e4b30d1917574e9dbd8967d60662.jpeg\" alt=\"\" class=\"wp-image-15\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph {\"className\":\"hero-label\"} -->\n<p class=\"hero-label\">Entrepreneurs</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {\"id\":16,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"vertical\"} -->\n<figure class=\"wp-block-image size-full vertical\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/ef701919e992624c1600580947f786fd.jpeg\" alt=\"\" class=\"wp-image-16\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph {\"className\":\"hero-label\"} -->\n<p class=\"hero-label\">Laboratoires</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":17,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"vertical\"} -->\n<figure class=\"wp-block-image size-full vertical\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/34ae07df518c66da70ea24c63c2e6f0c.jpeg\" alt=\"\" class=\"wp-image-17\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph {\"className\":\"hero-label\"} -->\n<p class=\"hero-label\">Entreprises</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"introduction small\"} -->\n<div class=\"wp-block-columns introduction small\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:gallery {\"columns\":4,\"imageCrop\":false,\"linkTo\":\"none\",\"sizeSlug\":\"full\",\"className\":\"stakeholders\"} -->\n<figure class=\"wp-block-gallery has-nested-images columns-4 stakeholders\"><!-- wp:image {\"id\":22,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/e959eab8fb6cc935aa083d3451a0affc.jpeg\" alt=\"\" class=\"wp-image-22\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":20,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/724e2f98e73630980b049921e093e23a.png\" alt=\"\" class=\"wp-image-20\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":19,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/1264e6eb30c0ef78308d82d98aa8f086.jpeg\" alt=\"\" class=\"wp-image-19\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":21,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/6306afbcf38f7060680d7b4089dfaabc.png\" alt=\"\" class=\"wp-image-21\"/></figure>\n<!-- /wp:image --></figure>\n<!-- /wp:gallery -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3 class=\"wp-block-heading\">C’est quoi un Pôle Universitaire d’Innovation (PUI) ?</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Un PUI est un dispositif national créé pour rapprocher l’université, la recherche et les entreprises, afin de transformer la science et les idées en solutions concrètes.<br>À travers des actions ciblées comme la formation, l’accompagnement des projets, et le transfert technologique, les PUIs accélèrent l’innovation et favorisent la création de start-ups.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"objectifs small\"} -->\n<div class=\"wp-block-columns objectifs small\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">objectifs</mark> de la démarche</h2>\n<!-- /wp:heading -->\n\n<!-- wp:group {\"className\":\"liste-objectifs\",\"layout\":{\"type\":\"grid\",\"minimumColumnWidth\":\"20rem\"}} -->\n<div class=\"wp-block-group liste-objectifs\"><!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Sensibiliser et former les futurs entrepreneurs</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Des programmes de formations et événements sont mis en place pour permettre aux jeunes talents de développer leurs compétences et leur esprit entrepreneurial.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Créer des synergies entre les acteurs de l\'innovation</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Nous rassemblons chercheurs, entreprises, étudiants, entrepreneurs et structures d’accompagnement pour encourager la collaboration et l\'échange d\'idées.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Soutenir la croissance des start-ups</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Nous accompagnons les porteurs de projets à chaque étape, de la sensibilisation à la mise en œuvre de leurs activités.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Valoriser les sujets de recherche</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>En favorisant le transfert de technologies et d\'idées entre les laboratoires de recherche et le secteur privé, nous contribuons à l\'application concrète des innovations.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"stats large\"} -->\n<div class=\"wp-block-columns stats large\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Quelques <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">chiffres</mark> pour comprendre</h2>\n<!-- /wp:heading -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"className\":\"stats-image\"} -->\n<div class=\"wp-block-column stats-image\"><!-- wp:image {\"id\":24,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/image-1024x689.png\" alt=\"\" class=\"wp-image-24\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"326px\",\"className\":\"stats-chiffres\",\"style\":{\"color\":{\"background\":\"#d2edf9\"}}} -->\n<div class=\"wp-block-column stats-chiffres has-background\" style=\"background-color:#d2edf9;flex-basis:326px\"><!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">4</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">membres fondateurs</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>l’Université de La Réunion, la Technopole, le CIRAD, et l’IRD, unis pour renforcer les synergies entre la recherche, l’enseignement supérieur et le monde socio-économique.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">22</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">unités de recherche</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>mobilisées pour valoriser les projets et renforcer les collaborations avec le monde socio-économique</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">4</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">axes stratégiques</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>pour transformer l’écosystème</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">500+</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">acteurs de l\'écosystème</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>(étudiants, chercheurs, entrepreneurs, entreprises) visés pour participer aux initiatives et synergies portées par le PUI.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">1er</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">PUI d\'Outre-mer</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>conçu pour dynamiser l’écosystème d’innovation réunionnais et positionner La Réunion comme un hub stratégique dans l’océan Indien.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"large\"} -->\n<div class=\"wp-block-columns large\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p>Le PUI Valiotech, soutenu par France 2030 grâce à l’ANR et BPI France, est l’unique PUI d’Outre-Mer. Il agit comme un levier pour maximiser l’impact des talents et des projets réunionnais, en répondant aux besoins économiques, sociaux et environnementaux du territoire.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"events full\"} -->\n<div class=\"wp-block-columns events full\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">évènements</mark> des acteurs du PUI</h2>\n<!-- /wp:heading -->\n\n<!-- wp:shortcode -->\n[shortcode_events]\n<!-- /wp:shortcode -->\n\n<!-- wp:query {\"queryId\":27,\"query\":{\"perPage\":10,\"pages\":0,\"offset\":0,\"postType\":\"event\",\"order\":\"desc\",\"orderBy\":\"date\",\"author\":\"\",\"search\":\"\",\"exclude\":[],\"sticky\":\"\",\"inherit\":false,\"parents\":[],\"format\":[]},\"className\":\"events-list\"} -->\n<div class=\"wp-block-query events-list\"><!-- wp:post-template {\"className\":\"event\",\"layout\":{\"type\":\"grid\",\"columnCount\":null,\"minimumColumnWidth\":\"12rem\"}} -->\n<!-- wp:post-date /-->\n\n<!-- wp:post-title /-->\n\n<!-- wp:post-excerpt /-->\n<!-- /wp:post-template -->\n\n<!-- wp:query-no-results -->\n<!-- wp:paragraph {\"placeholder\":\"Ajouter un texte ou des blocs qui s’afficheront lorsqu’une requête ne renverra aucun résultat.\"} -->\n<p></p>\n<!-- /wp:paragraph -->\n<!-- /wp:query-no-results --></div>\n<!-- /wp:query -->\n\n<!-- wp:image {\"id\":25,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/image-1-1024x540.png\" alt=\"\" class=\"wp-image-25\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->", "Accueil", "", "inherit", "closed", "closed", "", "2-revision-v1", "", "", "2024-11-22 10:05:21", "2024-11-22 06:05:21", "", "2", "http://pui-valiotech.local/?p=68", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("69", "1", "2024-11-22 10:05:33", "2024-11-22 06:05:33", "<!-- wp:columns {\"className\":\"hero\"} -->\n<div class=\"wp-block-columns hero\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:columns {\"isStackedOnMobile\":false,\"className\":\"hero-content large\"} -->\n<div class=\"wp-block-columns is-not-stacked-on-mobile hero-content large\"><!-- wp:column {\"width\":\"66.66%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"><!-- wp:heading {\"level\":1} -->\n<h1 class=\"wp-block-heading\">Sensibiliser, <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">connecter</mark>, innover</h1>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Avec le PUI Valiotech, nous avons l\'ambition de renforcer l\'innovation locale en créant des synergies entre l’enseignement supérieur, la recherche et le monde socio-économique, pour répondre ensemble aux défis du territoire.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"className\":\"buttons\"} -->\n<div class=\"wp-block-buttons buttons\"><!-- wp:button -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Participer à un événement</a></div>\n<!-- /wp:button -->\n\n<!-- wp:button {\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link wp-element-button\">Nous rejoindre</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"33.33%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"><!-- wp:columns {\"className\":\"hero-images\"} -->\n<div class=\"wp-block-columns hero-images\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":15,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"square\"} -->\n<figure class=\"wp-block-image size-full square\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/b532e4b30d1917574e9dbd8967d60662.jpeg\" alt=\"\" class=\"wp-image-15\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph {\"className\":\"hero-label\"} -->\n<p class=\"hero-label\">Entrepreneurs</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {\"id\":16,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"vertical\"} -->\n<figure class=\"wp-block-image size-full vertical\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/ef701919e992624c1600580947f786fd.jpeg\" alt=\"\" class=\"wp-image-16\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph {\"className\":\"hero-label\"} -->\n<p class=\"hero-label\">Laboratoires</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":17,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"vertical\"} -->\n<figure class=\"wp-block-image size-full vertical\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/34ae07df518c66da70ea24c63c2e6f0c.jpeg\" alt=\"\" class=\"wp-image-17\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph {\"className\":\"hero-label\"} -->\n<p class=\"hero-label\">Entreprises</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"introduction small\"} -->\n<div class=\"wp-block-columns introduction small\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:gallery {\"columns\":4,\"imageCrop\":false,\"linkTo\":\"none\",\"sizeSlug\":\"full\",\"className\":\"stakeholders\"} -->\n<figure class=\"wp-block-gallery has-nested-images columns-4 stakeholders\"><!-- wp:image {\"id\":22,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/e959eab8fb6cc935aa083d3451a0affc.jpeg\" alt=\"\" class=\"wp-image-22\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":20,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/724e2f98e73630980b049921e093e23a.png\" alt=\"\" class=\"wp-image-20\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":19,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/1264e6eb30c0ef78308d82d98aa8f086.jpeg\" alt=\"\" class=\"wp-image-19\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":21,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/6306afbcf38f7060680d7b4089dfaabc.png\" alt=\"\" class=\"wp-image-21\"/></figure>\n<!-- /wp:image --></figure>\n<!-- /wp:gallery -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3 class=\"wp-block-heading\">C’est quoi un Pôle Universitaire d’Innovation (PUI) ?</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Un PUI est un dispositif national créé pour rapprocher l’université, la recherche et les entreprises, afin de transformer la science et les idées en solutions concrètes.<br>À travers des actions ciblées comme la formation, l’accompagnement des projets, et le transfert technologique, les PUIs accélèrent l’innovation et favorisent la création de start-ups.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"objectifs small\"} -->\n<div class=\"wp-block-columns objectifs small\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">objectifs</mark> de la démarche</h2>\n<!-- /wp:heading -->\n\n<!-- wp:group {\"className\":\"liste-objectifs\",\"layout\":{\"type\":\"grid\",\"minimumColumnWidth\":\"20rem\"}} -->\n<div class=\"wp-block-group liste-objectifs\"><!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Sensibiliser et former les futurs entrepreneurs</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Des programmes de formations et événements sont mis en place pour permettre aux jeunes talents de développer leurs compétences et leur esprit entrepreneurial.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Créer des synergies entre les acteurs de l\'innovation</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Nous rassemblons chercheurs, entreprises, étudiants, entrepreneurs et structures d’accompagnement pour encourager la collaboration et l\'échange d\'idées.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Soutenir la croissance des start-ups</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Nous accompagnons les porteurs de projets à chaque étape, de la sensibilisation à la mise en œuvre de leurs activités.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Valoriser les sujets de recherche</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>En favorisant le transfert de technologies et d\'idées entre les laboratoires de recherche et le secteur privé, nous contribuons à l\'application concrète des innovations.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"stats large\"} -->\n<div class=\"wp-block-columns stats large\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Quelques <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">chiffres</mark> pour comprendre</h2>\n<!-- /wp:heading -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"className\":\"stats-image\"} -->\n<div class=\"wp-block-column stats-image\"><!-- wp:image {\"id\":24,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/image-1024x689.png\" alt=\"\" class=\"wp-image-24\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"326px\",\"className\":\"stats-chiffres\",\"style\":{\"color\":{\"background\":\"#d2edf9\"}}} -->\n<div class=\"wp-block-column stats-chiffres has-background\" style=\"background-color:#d2edf9;flex-basis:326px\"><!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">4</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">membres fondateurs</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>l’Université de La Réunion, la Technopole, le CIRAD, et l’IRD, unis pour renforcer les synergies entre la recherche, l’enseignement supérieur et le monde socio-économique.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">22</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">unités de recherche</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>mobilisées pour valoriser les projets et renforcer les collaborations avec le monde socio-économique</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">4</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">axes stratégiques</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>pour transformer l’écosystème</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">500+</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">acteurs de l\'écosystème</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>(étudiants, chercheurs, entrepreneurs, entreprises) visés pour participer aux initiatives et synergies portées par le PUI.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">1er</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">PUI d\'Outre-mer</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>conçu pour dynamiser l’écosystème d’innovation réunionnais et positionner La Réunion comme un hub stratégique dans l’océan Indien.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"large\"} -->\n<div class=\"wp-block-columns large\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p>Le PUI Valiotech, soutenu par France 2030 grâce à l’ANR et BPI France, est l’unique PUI d’Outre-Mer. Il agit comme un levier pour maximiser l’impact des talents et des projets réunionnais, en répondant aux besoins économiques, sociaux et environnementaux du territoire.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"events full\"} -->\n<div class=\"wp-block-columns events full\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">évènements</mark> des acteurs du PUI</h2>\n<!-- /wp:heading -->\n\n<!-- wp:shortcode -->\nshortcode_events\n<!-- /wp:shortcode -->\n\n<!-- wp:query {\"queryId\":27,\"query\":{\"perPage\":10,\"pages\":0,\"offset\":0,\"postType\":\"event\",\"order\":\"desc\",\"orderBy\":\"date\",\"author\":\"\",\"search\":\"\",\"exclude\":[],\"sticky\":\"\",\"inherit\":false,\"parents\":[],\"format\":[]},\"className\":\"events-list\"} -->\n<div class=\"wp-block-query events-list\"><!-- wp:post-template {\"className\":\"event\",\"layout\":{\"type\":\"grid\",\"columnCount\":null,\"minimumColumnWidth\":\"12rem\"}} -->\n<!-- wp:post-date /-->\n\n<!-- wp:post-title /-->\n\n<!-- wp:post-excerpt /-->\n<!-- /wp:post-template -->\n\n<!-- wp:query-no-results -->\n<!-- wp:paragraph {\"placeholder\":\"Ajouter un texte ou des blocs qui s’afficheront lorsqu’une requête ne renverra aucun résultat.\"} -->\n<p></p>\n<!-- /wp:paragraph -->\n<!-- /wp:query-no-results --></div>\n<!-- /wp:query -->\n\n<!-- wp:image {\"id\":25,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/image-1-1024x540.png\" alt=\"\" class=\"wp-image-25\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->", "Accueil", "", "inherit", "closed", "closed", "", "2-revision-v1", "", "", "2024-11-22 10:05:33", "2024-11-22 06:05:33", "", "2", "http://pui-valiotech.local/?p=69", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("70", "1", "2024-11-22 10:05:49", "2024-11-22 06:05:49", "<!-- wp:columns {\"className\":\"hero\"} -->\n<div class=\"wp-block-columns hero\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:columns {\"isStackedOnMobile\":false,\"className\":\"hero-content large\"} -->\n<div class=\"wp-block-columns is-not-stacked-on-mobile hero-content large\"><!-- wp:column {\"width\":\"66.66%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"><!-- wp:heading {\"level\":1} -->\n<h1 class=\"wp-block-heading\">Sensibiliser, <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">connecter</mark>, innover</h1>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Avec le PUI Valiotech, nous avons l\'ambition de renforcer l\'innovation locale en créant des synergies entre l’enseignement supérieur, la recherche et le monde socio-économique, pour répondre ensemble aux défis du territoire.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"className\":\"buttons\"} -->\n<div class=\"wp-block-buttons buttons\"><!-- wp:button -->\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Participer à un événement</a></div>\n<!-- /wp:button -->\n\n<!-- wp:button {\"className\":\"is-style-outline\"} -->\n<div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link wp-element-button\">Nous rejoindre</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"33.33%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"><!-- wp:columns {\"className\":\"hero-images\"} -->\n<div class=\"wp-block-columns hero-images\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":15,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"square\"} -->\n<figure class=\"wp-block-image size-full square\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/b532e4b30d1917574e9dbd8967d60662.jpeg\" alt=\"\" class=\"wp-image-15\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph {\"className\":\"hero-label\"} -->\n<p class=\"hero-label\">Entrepreneurs</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:image {\"id\":16,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"vertical\"} -->\n<figure class=\"wp-block-image size-full vertical\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/ef701919e992624c1600580947f786fd.jpeg\" alt=\"\" class=\"wp-image-16\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph {\"className\":\"hero-label\"} -->\n<p class=\"hero-label\">Laboratoires</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":17,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"vertical\"} -->\n<figure class=\"wp-block-image size-full vertical\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/34ae07df518c66da70ea24c63c2e6f0c.jpeg\" alt=\"\" class=\"wp-image-17\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph {\"className\":\"hero-label\"} -->\n<p class=\"hero-label\">Entreprises</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"introduction small\"} -->\n<div class=\"wp-block-columns introduction small\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:gallery {\"columns\":4,\"imageCrop\":false,\"linkTo\":\"none\",\"sizeSlug\":\"full\",\"className\":\"stakeholders\"} -->\n<figure class=\"wp-block-gallery has-nested-images columns-4 stakeholders\"><!-- wp:image {\"id\":22,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/e959eab8fb6cc935aa083d3451a0affc.jpeg\" alt=\"\" class=\"wp-image-22\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":20,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/724e2f98e73630980b049921e093e23a.png\" alt=\"\" class=\"wp-image-20\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":19,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/1264e6eb30c0ef78308d82d98aa8f086.jpeg\" alt=\"\" class=\"wp-image-19\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":21,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/6306afbcf38f7060680d7b4089dfaabc.png\" alt=\"\" class=\"wp-image-21\"/></figure>\n<!-- /wp:image --></figure>\n<!-- /wp:gallery -->\n\n<!-- wp:heading {\"level\":3} -->\n<h3 class=\"wp-block-heading\">C’est quoi un Pôle Universitaire d’Innovation (PUI) ?</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Un PUI est un dispositif national créé pour rapprocher l’université, la recherche et les entreprises, afin de transformer la science et les idées en solutions concrètes.<br>À travers des actions ciblées comme la formation, l’accompagnement des projets, et le transfert technologique, les PUIs accélèrent l’innovation et favorisent la création de start-ups.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"objectifs small\"} -->\n<div class=\"wp-block-columns objectifs small\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">objectifs</mark> de la démarche</h2>\n<!-- /wp:heading -->\n\n<!-- wp:group {\"className\":\"liste-objectifs\",\"layout\":{\"type\":\"grid\",\"minimumColumnWidth\":\"20rem\"}} -->\n<div class=\"wp-block-group liste-objectifs\"><!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Sensibiliser et former les futurs entrepreneurs</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Des programmes de formations et événements sont mis en place pour permettre aux jeunes talents de développer leurs compétences et leur esprit entrepreneurial.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Créer des synergies entre les acteurs de l\'innovation</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Nous rassemblons chercheurs, entreprises, étudiants, entrepreneurs et structures d’accompagnement pour encourager la collaboration et l\'échange d\'idées.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Soutenir la croissance des start-ups</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Nous accompagnons les porteurs de projets à chaque étape, de la sensibilisation à la mise en œuvre de leurs activités.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text -->\n\n<!-- wp:media-text {\"mediaId\":23,\"mediaLink\":\"http://pui-valiotech.local/accueil/icone/\",\"mediaType\":\"image\",\"mediaWidth\":15,\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-media-text\" style=\"grid-template-columns:15% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/Icone.png\" alt=\"\" class=\"wp-image-23 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">Valoriser les sujets de recherche</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>En favorisant le transfert de technologies et d\'idées entre les laboratoires de recherche et le secteur privé, nous contribuons à l\'application concrète des innovations.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:media-text --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"stats large\"} -->\n<div class=\"wp-block-columns stats large\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Quelques <mark style=\"background-color:rgba(0, 0, 0, 0)\" class=\"has-inline-color has-vivid-red-color\">chiffres</mark> pour comprendre</h2>\n<!-- /wp:heading -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"className\":\"stats-image\"} -->\n<div class=\"wp-block-column stats-image\"><!-- wp:image {\"id\":24,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"http://pui-valiotech.local/wp-content/uploads/2024/11/image-1024x689.png\" alt=\"\" class=\"wp-image-24\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"326px\",\"className\":\"stats-chiffres\",\"style\":{\"color\":{\"background\":\"#d2edf9\"}}} -->\n<div class=\"wp-block-column stats-chiffres has-background\" style=\"background-color:#d2edf9;flex-basis:326px\"><!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">4</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">membres fondateurs</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>l’Université de La Réunion, la Technopole, le CIRAD, et l’IRD, unis pour renforcer les synergies entre la recherche, l’enseignement supérieur et le monde socio-économique.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">22</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">unités de recherche</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>mobilisées pour valoriser les projets et renforcer les collaborations avec le monde socio-économique</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">4</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">axes stratégiques</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>pour transformer l’écosystème</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">500+</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">acteurs de l\'écosystème</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>(étudiants, chercheurs, entrepreneurs, entreprises) visés pour participer aux initiatives et synergies portées par le PUI.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"className\":\"stat\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group stat\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\">1er</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">PUI d\'Outre-mer</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>conçu pour dynamiser l’écosystème d’innovation réunionnais et positionner La Réunion comme un hub stratégique dans l’océan Indien.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"large\"} -->\n<div class=\"wp-block-columns large\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p>Le PUI Valiotech, soutenu par France 2030 grâce à l’ANR et BPI France, est l’unique PUI d’Outre-Mer. Il agit comme un levier pour maximiser l’impact des talents et des projets réunionnais, en répondant aux besoins économiques, sociaux et environnementaux du territoire.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"className\":\"events full\"} -->\n<div class=\"wp-block-columns events full\"><!-- wp:column -->\n<div class=\"wp-block-col